#include "ptc.h"
#include "fmod.h"
#include "gfx/head/sound.h"
#include "gfx/head/buf.h"
#include "gfx/head/video.h"
#include "gfx/head/map.h"
#include "world/head/world.h"
#include "gfx/head/sprite.h"
#include "world/head/effect.h"
#include "world/head/blood.h"
#include "world/head/weapon.h"
#include "world/head/entity.h"
#include "world/head/bot.h"



Weapons *Weaps;



Weapons::Weapons(char filename[])
{
	sprite = new Sprite(20, 10, filename);
	Proj = new proj[1000];
	num = 0;
	
	weaps[0].wname = "gun";
	weaps[0].ammotype = SHELLS;
	weaps[0].treload = 50;
	weaps[0].speed = 5;
	weaps[0].mun = 1;
	weaps[1].wname = "shotgun";
	weaps[1].ammotype = SHELLS;
	weaps[1].treload = 200;
	weaps[1].speed = 5;
	weaps[1].mun = 2;
	weaps[2].wname = "digigun";
	weaps[2].ammotype = DIGIS;
	weaps[2].treload = 300;
	weaps[2].speed = 3;
	weaps[2].mun = 1;
	weaps[3].wname = "plasmagun";
	weaps[3].ammotype = DIGIS;
	weaps[3].treload = 50;
	weaps[3].speed = 6;
	weaps[3].mun = 1;
	weaps[4].wname = "mini launcher";
	weaps[4].ammotype = ROCKETS;
	weaps[4].treload = 300;
	weaps[4].speed = 3;
	weaps[4].mun = 1;
	weaps[5].wname = "acidgun";
	weaps[5].ammotype = NAILS;
	weaps[5].treload = 300;
	weaps[5].speed = 3;
	weaps[5].mun = 1;
	weaps[6].wname = "railgun";
	weaps[6].ammotype = RAILS;
	weaps[6].treload = 250;
	weaps[6].speed = 4;
	weaps[6].mun = 1;
	weaps[7].wname = "bomb launcher";
	weaps[7].ammotype = NAILS;
	weaps[7].treload = 200;
	weaps[7].speed = 4;
	weaps[7].mun = 2;
	weaps[8].wname = "rocket launcher";
	weaps[8].ammotype = ROCKETS;
	weaps[8].treload = 200;
	weaps[8].speed = 4;
	weaps[8].mun = 2;
	weaps[9].wname = "lazer gun";
	weaps[9].ammotype = RAILS;
	weaps[9].treload = 15;
	weaps[9].speed = 5;
	weaps[9].mun = 4;
	
	ammos[0].aname = "shells";
	ammos[0].pck   = 60;
	ammos[0].dam   = 10;
	ammos[1].aname = "digis";
	ammos[1].pck   = 40;
	ammos[1].dam   = 20;
	ammos[2].aname = "nails";
	ammos[2].pck   = 20;
	ammos[2].dam   = 30;
	ammos[3].aname = "rockets";
	ammos[3].pck   = 15;
	ammos[3].dam   = 40;
	ammos[4].aname = "rails";	
	ammos[4].pck   = 10;
	ammos[4].dam   = 50;
}


Weapons::DelProj(int n)
{
	num--;
	for(int k=n ; k<num ; k++)
		Proj[k] = Proj[k+1];
}



Weapons::Explosion(int n)
{
	if(Proj[n].atype==SHELLS)
	{
		Effects->Add((int)(Proj[n].x), (int)(Proj[n].y), LITTLE_EXP);
		BSounds->Add((int)(Proj[n].x), (int)(Proj[n].y), SND_EXPLOSE1);
		Make_Hole((int)(Proj[n].x), (int)(Proj[n].y), 10);
	}
	if(Proj[n].atype==DIGIS)
	{
		Effects->Add((int)(Proj[n].x), (int)(Proj[n].y), GREEN_EXP);
		BSounds->Add((int)(Proj[n].x), (int)(Proj[n].y), SND_EXPLOSE2);
		Make_Hole((int)(Proj[n].x), (int)(Proj[n].y), 20);
	}
	if(Proj[n].atype==NAILS)
	{	
		Effects->Add((int)(Proj[n].x), (int)(Proj[n].y), YELLOW_EXP);
		BSounds->Add((int)(Proj[n].x), (int)(Proj[n].y), SND_EXPLOSE3);
		Make_Hole((int)(Proj[n].x), (int)(Proj[n].y), 30);
	}
	if(Proj[n].atype==ROCKETS)
	{
		Effects->Add((int)(Proj[n].x), (int)(Proj[n].y), CLASSICAL_EXP);
		BSounds->Add((int)(Proj[n].x), (int)(Proj[n].y), SND_EXPLOSE4);
		Make_Hole((int)(Proj[n].x), (int)(Proj[n].y), 40);
	}
	if(Proj[n].atype==RAILS)
	{
		Effects->Add((int)(Proj[n].x), (int)(Proj[n].y), EXP_3D);
		BSounds->Add((int)(Proj[n].x), (int)(Proj[n].y), SND_EXPLOSE5);
		Make_Hole((int)(Proj[n].x), (int)(Proj[n].y), 30);
	}
}




Weapons::UpdateMap()
{
	for(int b=0 ; b<num ; b++)
	{
		Proj[b].x += Proj[b].ax*world_speed;
		Proj[b].y += Proj[b].ay*world_speed;
		sprite->xs = (int)(Proj[b].x);
		sprite->ys = (int)(Proj[b].y);
		
		if((Proj[b].atype==ROCKETS || Proj[b].atype==NAILS) && rnd(100)>80-world_speed*5) Explosion(b);

		if(sprite->Contact(0)==TRUE || sprite->Contact(1)==TRUE || sprite->Contact(2)==TRUE || sprite->Contact(3)==TRUE)
		{
			Explosion(b);
			DelProj(b);
			b--;
		}
	}
}



Weapons::UpdateEnt(Entity *Enti)
{
	for(int b=0 ; b<num ; b++)
	{
		if(Enti->xe+20>=Proj[b].x && Enti->xe<=Proj[b].x+5)
		if(Enti->ye+5>=Proj[b].y && Enti->ye<=Proj[b].y+40)
		{
			Enti->pack->health-=Weaps->ammos[Proj[b].atype].dam;
			blood->Add((int)(Proj[b].x),(int)(Proj[b].y),1+rnd(4),Weaps->ammos[Proj[b].atype].dam*3);
			
			if(rnd(10)>2)
				BSounds->Add((int)(Proj[b].x), (int)(Proj[b].y), SND_PAIN);
			else BSounds->Add((int)(Proj[b].x), (int)(Proj[b].y), SND_BIGPAIN);

			if(Enti->pack->health<=0)
			{
				BSounds->Add((int)(Proj[b].x), (int)(Proj[b].y), SND_FRAG);

				if(Enti->nume==Proj[b].ent)
				{
					Enti->pack->frags--;
					scores->Update(Enti->nume, -1);
				}
				else
				{
					if(Proj[b].ent==0)
						Player->pack->frags++;
					else	if(dplayer==1)
							{
								if(Proj[b].ent==1)
									Player2->pack->frags++;
								else bots->bot[Proj[b].ent-2].ent->pack->frags++;
							}
							else bots->bot[Proj[b].ent-1].ent->pack->frags++;
					
					scores->Update(Proj[b].ent, 1);
				}
				
				blood->Add((int)(Proj[b].x),(int)(Proj[b].y),2,400);

				Enti->Start();
			}
			
			Explosion(b);
		
			if(Proj[b].atype==ROCKETS || Proj[b].atype==NAILS)
			{
				if(SKILL!=NIGHTMARE)
				if(Enti->xe+20.>=Proj[b].x && Enti->xe<=Proj[b].x+5.)
				if(Enti->ye+5.>=Proj[b].y && Enti->ye<=Proj[b].y+25.)
				{
					DelProj(b);
					b--;
				}
			}
			else
			{
				DelProj(b);
				b--;
			}
		}
	}
}



Weapons::Show()
{
	for(int b=0 ; b<num ; b++)
	{
		sprite->xs = (int)(Proj[b].x)-map->xm;
		sprite->ys = (int)(Proj[b].y)-map->ym;
		if(Proj[b].ax<0.) sprite->framey = 0;
		else sprite->framey = 1;
		sprite->framex = Proj[b].atype;
		sprite->Show();
	}
}



Weapons::~Weapons()
{
	sprite->~Sprite();
	delete[] Proj;
}