#include "ptc.h"
#include "fmod.h"
#include "gfx/head/sound.h"
#include "gfx/head/video.h"
#include "gfx/head/buf.h"
#include "gfx/head/map.h"
#include "world/head/world.h"
#include "gfx/head/sprite.h"
#include "world/head/effect.h"
#include "world/head/weapon.h"
#include "world/head/item.h"
#include "world/head/entity.h"
#include "world/head/player.h"


items *Items;


items::items(char filename[])
{
	sprite = new Sprite(20, 40, filename);
	Item = new item[200];
	num = 0;
	nsp = 0;
}


items::~items()
{
	sprite->~Sprite();
	delete[] Item;
}


items::Update(Entity *Ent)
{
	for(int b=0 ; b<num ; b++)
	{
		if(Item[b].treap<=0.)
		if(Ent->xe+20>=Item[b].x && Ent->xe<=Item[b].x+20)
		if(Ent->ye>=Item[b].y-40 && Ent->ye<=Item[b].y+40)
		{
			if(Item[b].type==START_PLACE)
			if(Ent->pack->health<200 && rnd(200)>(int)(198.-world_speed*2.))
			{
				Ent->pack->health++;
				BSounds->Add((int)(Ent->xe), (int)(Ent->ye), SND_HEALTH);
			}

			if(Item[b].type==TELEPORT)
			if(Ent->state->telep<=0)
			{
				Ent->xe = (float)(Item[Item[b].y1].x);
				Ent->ye = (float)(Item[Item[b].y1].y);
				Ent->state->telep = 200;
				BSounds->Add((int)(Ent->xe), (int)(Ent->ye), SND_TELEPORT);
			}

			
			if(Item[b].type>=WEAP_GUN && Item[b].type<=WEAP_LIGHTNING_GUN)
			{
				if(Ent->pack->_weapon[Item[b].type-WEAP_GUN]==FALSE)
				{
					Ent->pack->_weapon[Item[b].type-WEAP_GUN] = TRUE;
					Item[b].treap = Item[b].ttreap;
					BSounds->Add((int)(Ent->xe), (int)(Ent->ye), SND_WEAPON);
				}
			}	
				
			if(Item[b].type>=AMMO_SHELLS && Item[b].type<=AMMO_RAILS)
			{
				if(Ent->pack->_ammo[Item[b].type-AMMO_SHELLS]<200)
				{
					Ent->pack->_ammo[Item[b].type-AMMO_SHELLS]+=Weaps->ammos[Item[b].type-AMMO_SHELLS].pck;
					if(Ent->pack->_ammo[Item[b].type-AMMO_SHELLS] > 200)
						Ent->pack->_ammo[Item[b].type-AMMO_SHELLS] = 200;
					Item[b].treap = Item[b].ttreap;
					BSounds->Add((int)(Ent->xe), (int)(Ent->ye), SND_AMMO);
				}
			}
		}
	}	
}


items::Show()
{
	for(int b=0 ; b<num ; b++)
	{
		if(Item[b].treap<=0.)
		{
			sprite->xs = Item[b].x-map->xm;
			sprite->ys = Item[b].y-map->ym;

			if(Item[b].type==START_PLACE)
				Effect_Foudre(sprite->xs, Item[b].y1-map->ym, sprite->ys, Item[b].y2, 0, 0, 100, 200);
			if(Item[b].type==TELEPORT)
			{
				sprite->framex = 0;
				sprite->Show();
			}
			if(Item[b].type>=WEAP_GUN && Item[b].type<=AMMO_RAILS)
			{
				sprite->framex = Item[b].type - 1;
				sprite->Show();
			}
		}
		else 
		{	
			Item[b].treap-=world_speed;
		}
	}

	if(sprite->anim<3.7) sprite->anim+=.1*world_speed;
	else sprite->anim=0.;
	sprite->framey = (int)(sprite->anim);
	if(sprite->framey>4) sprite->framey=0;
}


items::Add(int x, int y, int type, int other)
{
	int d;
	int pos;

	Item[num].x = x;
	Item[num].y = y;
	Item[num].type = type;

	sprite->xs = Item[num].x;
	sprite->ys = Item[num].y;
	while(!sprite->Contact(2))
	{
		Item[num].y++;
		sprite->ys = Item[num].y;
	}

	
	Item[num].treap  = 0;
	Item[num].ttreap = 1000;

	if(type==START_PLACE)
	{
		Item[num].y1 = Item[num].y;
		Item[num].y2 = other;
		d=0;
		pos = (Item[num].y*1536+Item[num].x)*3;
		while(d==0)
		{
			Item[num].y1--;
			pos-=1536*3;
			if(map->bufm->dat[pos+RED]+map->bufm->dat[pos+GREEN]+map->bufm->dat[pos+BLUE]>100)
				d=1;
		}
		nsp++;
		Item[num].ttreap = 0;
	}

	if(type==TELEPORT)
	{
		Item[num].y1 = other;
		Item[num].ttreap = 0;
	}
	
	num++;
}

