#include "ptc.h"
#include "gfx/head/video.h"
#include "gfx/head/buf.h"
#include "gfx/head/map.h"
#include "world/head/world.h"
#include "gfx/head/sprite.h"
#include "world/head/effect.h"


Effect *Effects;


// dir : 0 vertical  1 horizontal
void Effect_Foudre(int pos, int start, int stop, int lenght, int dir, int r, int g, int b)
{
	int j, k;
	int p;

	k = pos;

	if(start<stop)
		for(j=start ; j<stop ; j++)
		{
			k+=lenght/2-rnd(1+lenght);
		
			if(dir==0)
			{
				if(k>=0 && k<320 && j>=0 && j<200)
				{
					p=PAdr(k, j);
					screen->dat[p+RED]   = r;
					screen->dat[p+GREEN] = g;
					screen->dat[p+BLUE]  = b;
				}
			}
			else	if(j>=0 && j<320 && k>=0 && k<200)
				{
					p=PAdr(j, k);
					screen->dat[p+RED]   = r;
					screen->dat[p+GREEN] = g;
					screen->dat[p+BLUE]  = b;
				}
		}
	else
		for(j=start ; j>stop ; j--)
		{
			k+=lenght/2-rnd(1+lenght);
		
			if(dir==0)
			{
				if(k>=0 && k<320 && j>=0 && j<200)
				{
					p=PAdr(k, j);
					screen->dat[p+RED]   = r;
					screen->dat[p+GREEN] = g;
					screen->dat[p+BLUE]  = b;
				}
			}
			else	if(j>=0 && j<320 && k>=0 && k<200)
				{
					p=PAdr(j, k);
					screen->dat[p+RED]   = r;
					screen->dat[p+GREEN] = g;
					screen->dat[p+BLUE]  = b;
				}
		}

}



Effect::Effect(char filename[])
{
	num = 0;
	sprite = new Sprite(40, 40, filename);
	Explose = new Explode[1000];
}


Effect::~Effect()
{
	sprite->~Sprite();
	delete[] Explose;
}


Effect::Add(int x, int y, int typ)
{
	if(num<1000)
	{
		Explose[num].xep = x;
		Explose[num].yep = y;
		Explose[num].extype = typ;
		Explose[num].ani = 0.;
		num++;
	}
}


Effect::Del(int n)
{
	num--;
	for(int k=n ; k<num ; k++)
		Explose[k] = Explose[k+1];
}




Effect::Show()
{
	for(int b=0 ; b<num ; b++)
	{
		sprite->xs = Explose[b].xep-map->xm-10;
		sprite->ys = Explose[b].yep-map->ym+20;
		sprite->framex = (int)(Explose[b].ani);
		sprite->framey = Explose[b].extype;
		
		if(Explose[b].extype==LITTLE_EXP)	 sprite->alpha=-1;
		if(Explose[b].extype==GREEN_EXP)	 sprite->alpha=-1;
		if(Explose[b].extype==YELLOW_EXP)	 sprite->alpha=-1;
		if(Explose[b].extype==CLASSICAL_EXP) sprite->alpha=-1;
		if(Explose[b].extype==EXP_3D)		 sprite->alpha=-1;

		sprite->Show();
	}
}


Effect::Update()
{
	for(int b=0 ; b<num ; b++)
	{
		if(Explose[b].ani<8.)
			Explose[b].ani+=.1*world_speed;
		if((int)(Explose[b].ani)>7)
		{
			Del(b);
			b--;
		}
	}
}



void Make_Hole(int xh, int yh, int size)
{
	int i,j;
	int p;
	
	if(EBexplose==1)
	{
		xh = xh + 10;
		for(j=yh-size/2 ; j<yh+size/2 ; j++)
		for(i=xh-size/2 ; i<xh+size/2 ; i++)
			if(i>20 && i<512*3-20 && j>10 && j<384*3-20)
			{
				p = (j*512*3+i)*3;
				if(map->bufm->dat[p+RED]+map->bufm->dat[p+GREEN]+map->bufm->dat[p+BLUE]>100)
				{
					map->bufm->dat[p+RED] /= 6;
					map->bufm->dat[p+GREEN] /= 6;
					map->bufm->dat[p+BLUE] /= 6;
				}
			}
	}
}



