#include "ptc.h"
#include "fstream.h"
#include "gfx/head/video.h"
#include "gfx/head/buf.h"



inline int PAdr(int x, int y)
{
	return (Smu[Sln[y]+x]);
}


Buf::Buf(int width, int height)
{
	w = width;
	h = height;
	dat = new char8 [w*h*3];
	for(int i=0 ; i<w*h*3 ; i++)
		dat[i]=0;
}

Buf::Buf(int width, int height, char filename[])
{
	w = width;
	h = height;
	dat = new char8 [w*h*3];
	Bmp(filename);
}

Buf::~Buf()
{
	delete []dat;
}



Buf::Blit()
{
	Surface surface(WIDTH,HEIGHT,format);
	Area area(0,0,WIDTH,HEIGHT);
	char8 *pixels = (char8*) surface.lock();
	memcpy(pixels, dat, WIDTH*HEIGHT*3);
	surface.unlock();
	surface.copy(console,area,area);
	console.update();
}



Buf::Cpy(Buf & b)
{
	memcpy(b.dat, dat, w*h*3);
}


Buf::Bmp(char filename[])
{
    ifstream is(filename,ios::in|ios::binary|ios::nocreate);
    if (!is) throw Error("could not load image");
    is.seekg(54);
    for (int y=h-1; y>=0; y--) is.read((char*)&dat[w*y*3],w*3);
	is.close();
}



Buf::Bump(Buf & buf, int x, int y, int c)
{
	int lx, ly;
	int prx, pry;
	int crx, cry;
	int cr;
	int i, j;
	int pont;
	int m = w*3;
	int is,ie;
	int js, je;

	
	is = x-300;
	if(is<1) is=1;
	ie = x+300;
	if(ie>w-1) ie=w-1;
	js = y-300;
	if(js<1) js=1;
	je = y+300;
	if(je>h-1) je=h-1;
	
	pont = PAdr(is,js);
	int Y = w*3 - (ie-is)*3;
	
	for(j=js ; j<je ; j++)
		{
		for(i=is ; i<ie ; i++)
		{
			lx = i - x;   
			ly = j - y;
			prx = dat[pont+3+c] - dat[pont-m+c]; 
			pry = dat[pont+m+c] - dat[pont-m+c];	
			crx = 127 - abs(prx - lx);
			if(crx<0) crx = 0;
			cry = 127 - abs(pry - ly);
			if(cry<0) cry = 0;
			cr = (crx * cry) / 64;
		
			buf.dat[pont+RED] = (int)(dat[pont+RED]*DvCol[cr]);
			buf.dat[pont+GREEN] = (int)(dat[pont+GREEN]*DvCol[cr]);
			buf.dat[pont+BLUE] = (int)(dat[pont+BLUE]*DvCol[cr]); 
			pont+=3;
		}
		pont+=Y;
	}
}