#include "ptc.h"
#include "fmod.h"
#include "math.h"
#include "gfx/head/sound.h"


FSOUND_STREAM *Stream;
FSOUND_DSPUNIT *DspUnit;
Sounds *BSounds;


void Play_Mp3(char name[])
{
	Stream = FSOUND_Stream_OpenFile(name, FSOUND_2D | FSOUND_LOOP_NORMAL, 0);
	FSOUND_Stream_Play(0, Stream);
	FSOUND_SetVolume(0, 100);
}



void Stop_Mp3()
{
	FSOUND_Stream_Stop(Stream);
}



void Init_Sound()
{
	FSOUND_Init(44100, 32, 0);
}



void Close_Sound()
{
	FSOUND_Close();
}



Sounds::Sounds()
{
	smpls = new Smpl[50];
	samps = new Samp[50];
	n   = 0;
	max = 49;

	smpls[SND_BIGPAIN].snd			= FSOUND_Sample_Load(FSOUND_UNMANAGED, "base/sounds/pain/bpain.wav", FSOUND_NORMAL, 0);	
	smpls[SND_PAIN].snd				= FSOUND_Sample_Load(FSOUND_UNMANAGED, "base/sounds/pain/pain.wav", FSOUND_NORMAL, 0);	
	smpls[SND_FRAG].snd				= FSOUND_Sample_Load(FSOUND_UNMANAGED, "base/sounds/pain/frag.wav", FSOUND_NORMAL, 0);	
	smpls[SND_GUN].snd				= FSOUND_Sample_Load(FSOUND_UNMANAGED, "base/sounds/weap/gun.wav", FSOUND_NORMAL, 0);	
	smpls[SND_SHOTGUN].snd			= FSOUND_Sample_Load(FSOUND_UNMANAGED, "base/sounds/weap/shotgun.wav", FSOUND_NORMAL, 0);	
	smpls[SND_DIGIGUN].snd			= FSOUND_Sample_Load(FSOUND_UNMANAGED, "base/sounds/weap/digigun.wav", FSOUND_NORMAL, 0);	
	smpls[SND_PLASMAGUN].snd		= FSOUND_Sample_Load(FSOUND_UNMANAGED, "base/sounds/weap/plasmagun.wav", FSOUND_NORMAL, 0);	
	smpls[SND_GRENADE_LAUNCHER].snd = FSOUND_Sample_Load(FSOUND_UNMANAGED, "base/sounds/weap/glaunch.wav", FSOUND_NORMAL, 0);	
	smpls[SND_NAILGUN].snd			= FSOUND_Sample_Load(FSOUND_UNMANAGED, "base/sounds/weap/nailgun.wav", FSOUND_NORMAL, 0);	
	smpls[SND_RAILGUN].snd			= FSOUND_Sample_Load(FSOUND_UNMANAGED, "base/sounds/weap/railgun.wav", FSOUND_NORMAL, 0);	
	smpls[SND_BOMB_LAUNCHER].snd	= FSOUND_Sample_Load(FSOUND_UNMANAGED, "base/sounds/weap/blaunch.wav", FSOUND_NORMAL, 0);	
	smpls[SND_ROCKET_LAUNCHER].snd	= FSOUND_Sample_Load(FSOUND_UNMANAGED, "base/sounds/weap/rlaunch.wav", FSOUND_NORMAL, 0);	
	smpls[SND_LIGHTNING_GUN].snd	= FSOUND_Sample_Load(FSOUND_UNMANAGED, "base/sounds/weap/lightgun.wav", FSOUND_NORMAL, 0);	
	smpls[SND_WEAPON].snd			= FSOUND_Sample_Load(FSOUND_UNMANAGED, "base/sounds/misc/weapon.wav", FSOUND_NORMAL, 0);	
	smpls[SND_AMMO].snd				= FSOUND_Sample_Load(FSOUND_UNMANAGED, "base/sounds/misc/ammo.wav", FSOUND_NORMAL, 0);	
	smpls[SND_TELEPORT].snd			= FSOUND_Sample_Load(FSOUND_UNMANAGED, "base/sounds/misc/teleport.wav", FSOUND_NORMAL, 0);	
	smpls[SND_START].snd			= FSOUND_Sample_Load(FSOUND_UNMANAGED, "base/sounds/misc/start.wav", FSOUND_NORMAL, 0);	
	smpls[SND_EXPLOSE1].snd			= FSOUND_Sample_Load(FSOUND_UNMANAGED, "base/sounds/exp/exp1.wav", FSOUND_NORMAL, 0);	
	smpls[SND_EXPLOSE2].snd			= FSOUND_Sample_Load(FSOUND_UNMANAGED, "base/sounds/exp/exp2.wav", FSOUND_NORMAL, 0);	
	smpls[SND_EXPLOSE3].snd			= FSOUND_Sample_Load(FSOUND_UNMANAGED, "base/sounds/exp/exp3.wav", FSOUND_NORMAL, 0);	
	smpls[SND_EXPLOSE4].snd			= FSOUND_Sample_Load(FSOUND_UNMANAGED, "base/sounds/exp/exp4.wav", FSOUND_NORMAL, 0);	
	smpls[SND_EXPLOSE5].snd			= FSOUND_Sample_Load(FSOUND_UNMANAGED, "base/sounds/exp/exp5.wav", FSOUND_NORMAL, 0);	
	smpls[SND_HEALTH].snd			= FSOUND_Sample_Load(FSOUND_UNMANAGED, "base/sounds/misc/health.wav", FSOUND_NORMAL, 0);	
	smpls[SND_CHANGE].snd			= FSOUND_Sample_Load(FSOUND_UNMANAGED, "base/sounds/misc/change.wav", FSOUND_NORMAL, 0);	
	smpls[SND_NOAMMO].snd			= FSOUND_Sample_Load(FSOUND_UNMANAGED, "base/sounds/misc/noammo.wav", FSOUND_NORMAL, 0);	
	smpls[SND_ONEFRAG].snd			= FSOUND_Sample_Load(FSOUND_UNMANAGED, "base/sounds/misc/1_frag.wav", FSOUND_NORMAL, 0);	
	smpls[SND_TWOFRAGS].snd			= FSOUND_Sample_Load(FSOUND_UNMANAGED, "base/sounds/misc/2_frags.wav", FSOUND_NORMAL, 0);	
	smpls[SND_THREFRAGS].snd		= FSOUND_Sample_Load(FSOUND_UNMANAGED, "base/sounds/misc/3_frags.wav", FSOUND_NORMAL, 0);	
	smpls[SND_TAKELEAD].snd			= FSOUND_Sample_Load(FSOUND_UNMANAGED, "base/sounds/misc/takenlead.wav", FSOUND_NORMAL, 0);	
	smpls[SND_LOSTLEAD].snd			= FSOUND_Sample_Load(FSOUND_UNMANAGED, "base/sounds/misc/lostlead.wav", FSOUND_NORMAL, 0);	
	smpls[SND_PERFECT].snd			= FSOUND_Sample_Load(FSOUND_UNMANAGED, "base/sounds/misc/perfect.wav", FSOUND_NORMAL, 0);	

	n_snd = 31;
}



Sounds::~Sounds()
{
	for(int i=0 ; i<n ; i++)
		FSOUND_Sample_Free(smpls[i].snd);

	delete[] smpls;
	delete[] samps;
	n   = 0;
	max = 0;
}


Sounds::Add(int xa, int ya, int k)
{
	if(n<max)
	{
		samps[n].type = k;
		samps[n].x = xa;
		samps[n].y = ya;
		n++;
	}
}


Sounds::Del(int k)
{
	n--;
	for(int j=k ; j<n ; j++)
		samps[j] = samps[j+1];
}


Sounds::Play(int xp, int yp)
{
	int channel;
	int pan;
	int vol;

	for(int p=0 ; p<n ; p++)
	{
		if(samps[p].x>-1 && samps[p].y>-1)
		{
			vol = (int)(255 - sqrt((samps[p].x-xp)*(samps[p].x-xp)+(samps[p].y-yp)*(samps[p].y-yp)));
			if(vol<0) vol=0;
			if(samps[p].x>xp)
				pan = 128+(128-vol/2);
			else pan = 128-(128-vol/2);
			if(pan>255) pan=255;
			if(pan<0) pan=0;
		
			if(vol>0)
			{
				channel = FSOUND_PlaySound(FSOUND_FREE, smpls[samps[p].type].snd);
				FSOUND_SetVolume(channel, vol);
				FSOUND_SetPan(channel, pan);
			}
		}
		else FSOUND_PlaySound(1, smpls[samps[p].type].snd);
	}
}



