#if 0
The MIT License (MIT)

Copyright (c) 2014 inmensabolademanteca@gmail.com

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
#endif

; ----------------------------------------------------------------------------
; CIDLESA's Altair arcade (1981) port to the ZX Spectrum.
;
; Image data, animations, master sprites and objects.
; ----------------------------------------------------------------------------

; Shot.

shot00	.db 1, 4
	.db %11000000
	.db %11000000
	.db %11000000
	.db %11000000

shot01	.db 1, 4
	.db %01100000
	.db %01100000
	.db %01100000
	.db %01100000

shot02	.db 1, 4
	.db %00110000
	.db %00110000
	.db %00110000
	.db %00110000

shot03	.db 1, 4
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00011000

shot04	.db 1, 4
	.db %00001100
	.db %00001100
	.db %00001100
	.db %00001100

shot05	.db 1, 4
	.db %00000110
	.db %00000110
	.db %00000110
	.db %00000110

shot06	.db 1, 4
	.db %00000011
	.db %00000011
	.db %00000011
	.db %00000011

shot07	.db 2, 4
	.db %00000001, %10000000
	.db %00000001, %10000000
	.db %00000001, %10000000
	.db %00000001, %10000000

shot10	.db 1, 4
	.db %11000000
	.db %11000000
	.db %11000000
	.db %11000000

shot11	.db 1, 4
	.db %00000000
	.db %01100000
	.db %01100000
	.db %00000000

shot12	.db 1, 4
	.db %00000000
	.db %00110000
	.db %00110000
	.db %00000000

shot13	.db 1, 4
	.db %00000000
	.db %00011000
	.db %00011000
	.db %00000000

shot14	.db 1, 4
	.db %00000000
	.db %00001100
	.db %00001100
	.db %00000000

shot15	.db 1, 4
	.db %00000000
	.db %00000110
	.db %00000110
	.db %00000000

shot16	.db 1, 4
	.db %00000000
	.db %00000011
	.db %00000011
	.db %00000000

shot17	.db 2, 4
	.db %00000000, %00000000
	.db %00000001, %10000000
	.db %00000001, %10000000
	.db %00000000, %00000000

shot_it0
	.dw shot00
	.dw shot01
	.dw shot02
	.dw shot03
	.dw shot04
	.dw shot05
	.dw shot06
	.dw shot07
shot_it1
	.dw shot10
	.dw shot11
	.dw shot12
	.dw shot13
	.dw shot14
	.dw shot15
	.dw shot16
	.dw shot17

ashot_am	.db 2
		.dw shot_it0, WHITE
		.dw shot_it1, WHITE

cross_shot_im
	.db 1, 8
	.db %00000000
	.db %01000010
	.db %00100100
	.db %00011000
	.db %00011000
	.db %00100100
	.db %01000010
	.db %00000000

cross_shot_it
	.dw cross_shot_im

; Fire.

fire_im	.db 1, 8
	.db %00000000
	.db %00011000
	.db %10101010
	.db %01010101
	.db %10101010
	.db %10101010
	.db %01010101
	.db %00011000

fire_it	.dw fire_im

fire_am	.db 2
	.dw fire_it, RED
	.dw fire_it, YELLOW

; Left wing.
lwng_im	.db 1, 8
	.db %00000000
	.db %00000000
	.db %00110000
	.db %00110001
	.db %00111011
	.db %00111110
	.db %00111111
	.db %00110000

; Right wing.
rwng_im	.db 1, 8
	.db %00000000
	.db %00000000
	.db %00001100
	.db %10001100
	.db %11011100
	.db %01111100
	.db %11111100
	.db %00001100

wing_co	.db 1, 1
	.db RED

; Body.
ship_im	.db 1, 8
	.db %00100100
	.db %01100110
	.db %11111111
	.db %11011011
	.db %00011000
	.db %01111110
	.db %11111111
	.db %11100111

ship_co	.db 1, 1
	.db WHITE

; Cannon.
cnon_im	.db 1, 8
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00000000
	.db %00011000
	.db %00011000
	.db %00011000
	.db %00100100

cnon_co	.db 1, 1
	.db YELLOW

ship_it	.dw ship_im
lwng_it	.dw lwng_im
rwng_it	.dw rwng_im
cnon_it	.dw cnon_im
	
house_im_0
	.db HOUSE_IM_WC, 8
	.db 0, 0, 0
	.db %00111100, %00000000, %00111100
	.db %01111110, %01111110, %01111110
	.db %11111111, %11000011, %11111111
	.db %11111111, %11000011, %11111111
	.db %01111110, %01111110, %01111110
	.db %00111100, %00000000, %00111100
	.db 0, 0, 0

house_co_0
	.db HOUSE_IM_WC, 1
	.db GREEN, RED, GREEN

house_im_1
	.db HOUSE_IM_WC, 8
	.db 0, 0, 0
	.db %00000000, %00111100, %00000000
	.db %01111110, %01111110, %01111110
	.db %11000011, %11111111, %11000011
	.db %11000011, %11111111, %11000011
	.db %01111110, %01111110, %01111110
	.db %00000000, %00111100, %00000000
	.db 0, 0, 0

house_co_1
	.db HOUSE_IM_WC, 1
	.db RED, GREEN, RED

house_it_0	.dw house_im_0
house_it_1	.dw house_im_1

; alimNF: N number of alien, F frame of alien.

alim00	.db 2, ALIEN_IM_H
	.db %11110000, 0
	.db %11001011, 0
	.db %00000100, 0
	.db %00000111, 0
	.db %11001011, 0
	.db %11110000, 0

alim01	.db 2, ALIEN_IM_H
	.db %00110000, 0
	.db %00001011, 0
	.db %00000111, 0
	.db %00000111, 0
	.db %00001011, 0
	.db %00110000, 0

alim10	.db 2, ALIEN_IM_H
	.db %11100100, 0
	.db %01000110, 0
	.db %11101011, 0
	.db %01111110, 0
	.db %01000110, 0
	.db %11110011, 0

alim11	.db 2, ALIEN_IM_H
	.db %01100100, 0
	.db %01000110, 0
	.db %01101011, 0
	.db %01111110, 0
	.db %01000110, 0
	.db %01110011, 0

alim20	.db 2, ALIEN_IM_H
	.db %11000001, 0
	.db %11101011, 0
	.db %11111110, 0
	.db %11111110, 0
	.db %11101011, 0
	.db %11000001, 0

alim21	.db 2, ALIEN_IM_H
	.db %11000001, 0
	.db %11101011, 0
	.db %11111111, 0
	.db %11111111, 0
	.db %11101011, 0
	.db %11000001, 0

; This one does not have 2 frames, only changes color.

alim30	.db 2, ALIEN_IM_H
	.db %10000110, 0
	.db %10011110, 0
	.db %11111011, 0
	.db %11111111, 0
	.db %10111110, 0
	.db %10000110, 0

alim40	.db 2, ALIEN_IM_H
	.db %11100001, 0
	.db %00111011, 0
	.db %00011111, 0
	.db %00011111, 0
	.db %00111011, 0
	.db %11100001, 0

alim41	.db 2, ALIEN_IM_H
	.db %00100001, 0
	.db %11111011, 0
	.db %00011111, 0
	.db %00011111, 0
	.db %11111011, 0
	.db %00100001, 0

alim50	.db 2, ALIEN_IM_H
	.db %00110010, 0
	.db %11111110, 0
	.db %11111110, 0
	.db %11101111, 0
	.db %11001111, 0
	.db %10000001, 0

alim51	.db 2, ALIEN_IM_H
	.db %00110010, 0
	.db %11111110, 0
	.db %11111110, 0
	.db %11101111, 0
	.db %01101111, 0
	.db %00100001, 0

; This one does not have 2 frames.

alim60	.db 2, ALIEN_IM_H
	.db %11000001, 0
	.db %11100111, 0
	.db %01111101, 0
	.db %00111111, 0
	.db %01110110, 0
	.db %11100010, 0

alien01	.db 3, ALIEN_IM_H
	.fill 3*ALIEN_IM_H
alien02	.db 3, ALIEN_IM_H
	.fill 3*ALIEN_IM_H
alien03	.db 3, ALIEN_IM_H
	.fill 3*ALIEN_IM_H
alien04	.db 3, ALIEN_IM_H
	.fill 3*ALIEN_IM_H
alien05	.db 3, ALIEN_IM_H
	.fill 3*ALIEN_IM_H
alien06	.db 3, ALIEN_IM_H
	.fill 3*ALIEN_IM_H
alien07	.db 3, ALIEN_IM_H
	.fill 3*ALIEN_IM_H

alien11	.db 3, ALIEN_IM_H
	.fill 3*ALIEN_IM_H
alien12	.db 3, ALIEN_IM_H
	.fill 3*ALIEN_IM_H
alien13	.db 3, ALIEN_IM_H
	.fill 3*ALIEN_IM_H
alien14	.db 3, ALIEN_IM_H
	.fill 3*ALIEN_IM_H
alien15	.db 3, ALIEN_IM_H
	.fill 3*ALIEN_IM_H
alien16	.db 3, ALIEN_IM_H
	.fill 3*ALIEN_IM_H
alien17	.db 3, ALIEN_IM_H
	.fill 3*ALIEN_IM_H

alient0	.dw alim00
	.dw alien01
	.dw alien02
	.dw alien03
	.dw alien04
	.dw alien05
	.dw alien06
	.dw alien07

alient1	.dw alim01
	.dw alien11
	.dw alien12
	.dw alien13
	.dw alien14
	.dw alien15
	.dw alien16
	.dw alien17

alien_am0	.db 2
		.dw alient0, YELLOW 
		.dw alient1, YELLOW
alien_am1	.db 2
		.dw alient0, CYAN 
		.dw alient1, CYAN
alien_am2	.db 2
		.dw alient0, MAGENT 
		.dw alient1, MAGENT
alien_am3	.db 2
		.dw alient0, WHITE  
		.dw alient0, GREEN
alien_am4	.db 2
		.dw alient0, YELLOW
		.dw alient1, YELLOW
alien_am5	.db 2
		.dw alient0, RED  
		.dw alient1, RED
alien_am6	.db 2
		.dw alient0, YELLOW 
		.dw alient0, GREEN

explosion_im0
	.db 2, 11
	.db %00000010, %00000100
	.db %00100011, %00011100
	.db %00011111, %11111000
	.db %10111001, %00110000
	.db %11111100, %01100000
	.db %01110000, %00111000
	.db %00100010, %00110000
	.db %11110111, %10111100
	.db %00111110, %11010000
	.db %00011000, %10010000
	.db %00010000, %00000000

explosion_im1
	.db 2, 10
	.db %00000000, %00000000
	.db %00001100, %00100000
	.db %00000001, %00000000
	.db %00000111, %11000000
	.db %00010111, %10010000
	.db %00001111, %11000000
	.db %00011111, %11000000
	.db %00001010, %01000000
	.db %00000000, %00010000
	.db %00010010, %00000000

explosion_im2
	.db 2, 12
	.db %10000000, %10000000
	.db %01100001, %10000001
	.db %00111001, %11000011
	.db %00011111, %01111111
	.db %00001100, %00001100
	.db %00000100, %00011000
	.db %00011000, %00001100
	.db %01110000, %00001110
	.db %00011101, %01101111
	.db %00011111, %11111011
	.db %00111000, %01100001
	.db %01000000, %01000000

explosion_it0	.dw explosion_im0
explosion_it1	.dw explosion_im1
explosion_it2	.dw explosion_im2

explosion_am	.db 5
		.dw explosion_it0, RED
		.dw explosion_it1, YELLOW
		.dw explosion_it2, RED
		.dw explosion_it1, YELLOW
		.dw explosion_it0, RED

mine_im	.db 1, 7
	.db %00000000
	.db %01000010
	.db %01100110
	.db %10111101
	.db %11100111
	.db %01100110
	.db %00111100

mine_it	.dw mine_im

bird_up	.db 6, 8
	.db %00000000, %00000000, %00000000, 0, 0, 0
	.db %00000000, %00000000, %00001100, 0, 0, 0
	.db %00000000, %00000000, %00001100, 0, 0, 0
	.db %00000001, %11111000, %01111100, 0, 0, 0
	.db %00000001, %11111000, %01111100, 0, 0, 0
	.db %00000001, %11111111, %11111100, 0, 0, 0
	.db %00000001, %11111111, %11111100, 0, 0, 0
	.db %00000001, %11111111, %11111111, 0, 0, 0

bird_grid0	.db 1, 8
		.db %01100110
		.db %01100110
		.db %01100110
		.db %01100110
		.db %01100110
		.db %01100110
		.db %01100110
		.db %01100110

bird_grid1	.db 1, 8
		.db %00110011
		.db %00110011
		.db %00110011
		.db %00110011
		.db %00110011
		.db %00110011
		.db %00110011
		.db %00110011

bird_grid2	.db 1, 8
		.db %10011001
		.db %10011001
		.db %10011001
		.db %10011001
		.db %10011001
		.db %10011001
		.db %10011001
		.db %10011001

bird_grid3	.db 1, 8
		.db %11001100
		.db %11001100
		.db %11001100
		.db %11001100
		.db %11001100
		.db %11001100
		.db %11001100
		.db %11001100

bird_center	.db 2, 24
		.db %00000001, 0
		.db %00111101, 0
		.db %00111101, 0
		.db %00110001, 0
		.db %11111100, 0
		.db %10000100, 0
		.db %10110101, 0
		.db %10000101, 0

		.db %11111101, 0
		.db %00100001, 0
		.db %00100001, 0
		.db %00100011, 0
		.db %00100011, 0
		.db %00100000, 0
		.db %00111001, 0
		.db %00111011, 0

		.db %00111011, 0
		.db %00111011, 0
		.db %00111011, 0
		.db %00000011, 0
		.db %00001111, 0
		.db %01111111, 0
		.db %01111100, 0
		.db %00000000, 0

bird_left	.db 1, 40
		.db %00000001
		.db %00000001
		.db %00000001
		.db %00000001
		.db %00000001
		.db %00000001
		.db %00000001
		.db %00000111

		.db %00000111
		.db %00000111
		.db %00000111
		.db %00000111
		.db %00000111
		.db %00000111
		.db %00000111
		.db %00000111

		.db %00011111
		.db %00011111
		.db %00011111
		.db %00011111
		.db %00011111
		.db %00011111
		.db %00011111
		.db %00011111

		.db %00011111
		.db %00011111
		.db %00011111
		.db %00011111
		.db %00011111
		.db %00011111
		.db %00011111
		.db %00011111

		.db %11111111
		.db %11111111
		.db %11111111
		.db %11111111
		.db %11111111
		.db %11111111
		.db %11111111
		.db %11111111

bird_right	.db 1, 40
		.db %10000000
		.db %10000000
		.db %10000000
		.db %10000000
		.db %10000000
		.db %10000000
		.db %10000000
		.db %11100000

		.db %11100000
		.db %11100000
		.db %11100000
		.db %11100000
		.db %11100000
		.db %11100000
		.db %11100000
		.db %11100000

		.db %11111000
		.db %11111000
		.db %11111000
		.db %11111000
		.db %11111000
		.db %11111000
		.db %11111000
		.db %11111000

		.db %11111000
		.db %11111000
		.db %11111000
		.db %11111000
		.db %11111000
		.db %11111000
		.db %11111000
		.db %11111000

		.db %11111111
		.db %11111111
		.db %11111111
		.db %11111111
		.db %11111111
		.db %11111111
		.db %11111111
		.db %11111111

bird_bleft	.db 1, 12
		.db %11111111
		.db %11111111
		.db %11111111
		.db %11111111
		.db %11111111
		.db %11111111
		.db %11111111
		.db %11111111

		.db %00001111
		.db %00001111
		.db %00001111
		.db %00001111

bird_bright	.db 1, 12
		.db %11111111
		.db %11111111
		.db %11111111
		.db %11111111
		.db %11111111
		.db %11111111
		.db %11111111
		.db %11111111

		.db %11110000
		.db %11110000
		.db %11110000
		.db %11110000

bird_lwing0	.db 1, 24
		.db %00000000
		.db %00000000
		.db %01110000
		.db %01110000
		.db %00110000
		.db %00111000
		.db %00011000
		.db %00011100

		.db %00111111
		.db %01101111
		.db %01000111
		.db %00000001
		.db %00000000
		.db %00000000
		.db %00000000
		.db %00000011

		.db %00000011
		.db %00000011
		.db %00000011
		.db %00000000
		.db %00000000
		.db %00000000
		.db %11111111
		.db %11111111

bird_lwing1	.db 1, 24
		.db %00000000
		.db %00000000
		.db %00000000
		.db %00000000
		.db %00000000
		.db %00000000
		.db %00000000
		.db %00000000

		.db %01000001
		.db %01100111
		.db %00101111
		.db %00011111
		.db %00011100
		.db %00011000
		.db %00110000
		.db %00110011

		.db %00110011
		.db %01110011
		.db %01110011
		.db %00000000
		.db %00000000
		.db %00000000
		.db %11111111
		.db %11111111

bird_rwing0	.db 1, 24
		.db %00000000
		.db %00000000
		.db %00001110
		.db %00001110
		.db %00001100
		.db %00011100
		.db %00011000
		.db %00111000

		.db %11111100
		.db %11110110
		.db %11100010
		.db %10000000
		.db %00000000
		.db %00000000
		.db %00000000
		.db %11000000

		.db %11000000
		.db %11000000
		.db %11000000
		.db %00000000
		.db %00000000
		.db %00000000
		.db %11111111
		.db %11111111

bird_rwing1	.db 1, 24
		.db %00000000
		.db %00000000
		.db %00000000
		.db %00000000
		.db %00000000
		.db %00000000
		.db %00000000
		.db %00000000

		.db %10000010
		.db %11100110
		.db %11110100
		.db %11111000
		.db %00111000
		.db %00011000
		.db %00001100
		.db %11001100

		.db %11001100
		.db %11001110
		.db %11001110
		.db %00000000
		.db %00000000
		.db %00000000
		.db %11111111
		.db %11111111

bird_up_it	.dw bird_up
bird_grid_it0	.dw bird_grid0
bird_grid_it1	.dw bird_grid1
bird_grid_it2	.dw bird_grid2
bird_grid_it3	.dw bird_grid3
bird_center_it	.dw bird_center
bird_left_it	.dw bird_left
bird_right_it	.dw bird_right
bird_bleft_it	.dw bird_bleft
bird_bright_it	.dw bird_bright
bird_lwing0_it	.dw bird_lwing0
bird_lwing1_it	.dw bird_lwing1
bird_rwing0_it	.dw bird_rwing0
bird_rwing1_it	.dw bird_rwing1

bird_center_co	.db 2, 3
		.db CYAN, CYAN 
		.db CYAN, CYAN
		.db YELLOW, YELLOW

bird_wing_co	.db 1, 3
		.db GREEN, GREEN, RED

bird_grid_am	.db 4
		.dw bird_grid_it0, WHITE
		.dw bird_grid_it1, WHITE
		.dw bird_grid_it2, WHITE
		.dw bird_grid_it3, WHITE

bird_lwing_am	.db 2
		.dw bird_lwing0_it, bird_wing_co
		.dw bird_lwing1_it, bird_wing_co

bird_rwing_am	.db 2
		.dw bird_rwing0_it, bird_wing_co
		.dw bird_rwing1_it, bird_wing_co

bird_lshield_im
	.db 1
bird_lshield_h
	.db 16
	.db 0, 0, 0, 0, 0, 0, 0, 0
	.db 0, 0, 0, 0, 0, 0, 0, 0

bird_lshield_it
	.dw bird_lshield_im

bird_rshield_im
	.db 1
bird_rshield_h
	.db 16
	.db 0, 0, 0, 0, 0, 0, 0, 0
	.db 0, 0, 0, 0, 0, 0, 0, 0

bird_rshield_it
	.dw bird_rshield_im

; Player life.

hudlife	.db %00000000
	.db %00001000
	.db %00011100
	.db %01011101
	.db %01111111
	.db %01111111
	.db %01010101
	.db %00000000

; Masters.

mstr_bird_sp
	; 1
	.dw bird_up_it
	.db 0, 0
	.dw RED
	.dw 0, 0, 0

	; 2
	.dw bird_grid_it0
	.db 8, 8
	.dw WHITE
	.dw bird_grid_am
	.db 2, 2
	.db 0, 1

	; 3
	.dw bird_grid_it0
	.db 16, 8
	.dw WHITE
	.dw bird_grid_am
	.db 2, 2
	.db 0, 1

	; 4
	.dw bird_grid_it0
	.db 24, 8
	.dw WHITE
	.dw bird_grid_am
	.db 2, 2
	.db 0, 1

	; 5
	.dw bird_grid_it0
	.db 32, 8
	.dw WHITE
	.dw bird_grid_am
	.db 2, 2
	.db 0, 1

	; 6
	.dw bird_center_it
	.db 16, 16
	.dw bird_center_co
	.dw 0, 0, 0

	; 7
	.dw bird_left_it
	.db 0, 8
	.dw RED
	.dw 0, 0, 0

	; 8
	.dw bird_right_it
	.db 40, 8
	.dw RED
	.dw 0, 0, 0

	; 9
	.dw bird_bleft_it
	.db 8, 40
	.dw RED
	.dw 0, 0, 0

	; 10
	.dw bird_bright_it
	.db 32, 40
	.dw RED
	.dw 0, 0, 0

	; 11
	.dw bird_lwing0_it
	.db 8, 16
	.dw 0
	.dw bird_lwing_am
	.db 2, 2
	.db 0, 1

	; 12
	.dw bird_rwing0_it
	.db 32, 16
	.dw 0
	.dw bird_rwing_am
	.db 2, 2
	.db 0, 1

	; 13
	.dw bird_lshield_it
	.db 16, 40
	.dw WHITE
	.dw 0, 0, 0

	; 14
	.dw bird_rshield_it
	.db 24, 40
	.dw WHITE
	.dw 0, 0, 0

mstr_bird_ob	.dw birdf
		.dw bird_sp
		.dw 0

mstr_house_sp
	.dw house_it_0
	.db 0, 0
	.dw house_co_0
	.dw 0, 0, 0
	.dw house_it_1
	.db 0, HOUSE_YPOS
	.dw house_co_1
	.dw 0, 0, 0

mstr_house_ob
	.dw housef
	.dw house_sp_0
	.dw house_sp_1

mstr_ship_sp
	.dw ship_it
	.db 8, BBUFH-16
	.dw ship_co
	.dw 0, 0, 0
	.dw cnon_it
	.db 8, BBUFH-24
	.dw cnon_co
	.dw 0, 0, 0
	.dw lwng_it
	.db 0, BBUFH-16
	.dw wing_co
	.dw 0, 0, 0
	.dw rwng_it
	.db 16, BBUFH-16
	.dw wing_co
	.dw 0, 0, 0
	.dw fire_it
	.db 8, BBUFH-8
	.dw RED
	.dw fire_am,
	.db 2, 2
	.db 0, 1

mstr_ship_ob
	.dw shipf
	.dw ship_sp
	.dw 0

mstr_mine_sp
	.dw mine_it
	.db 0, 0
	.dw YELLOW
	.dw 0, 0, 0

mstr_ashot_sp
	.dw shot_it0
	.db 0, 0
	.dw WHITE
	.dw 0
	.db 0, 0
	.db 0, 0

mstr_cross_ashot_sp
	.dw cross_shot_it
	.db 0, 0
	.dw YELLOW
	.dw 0
	.db 0, 0
	.db 0, 0

mstr_explosion_sp
	.dw 0
	.db 0, 0
	.dw 0
	.dw explosion_am,
	.db 4, 4
	.db 0, 0

mstr_explosion_ob
	.dw explof
	.dw mstr_explosion_sp
	.dw 0

mstr_post_ob
	.dw postf
	.dw 0
	.dw 0
