unit dmntn2;
interface
uses crt,graph,dos,fonts;

const
    C = 523;
    D = 587;
    E = 659;
    F = 699;
    G = 784;
    A = 880;
    B = 988;
    whol = 320;
    half = 160;
    qart = 80;
    eigh = 40;
    sixt = 20;
    thrt = 10;
    inserton  =$80;
    capslockon=$40;
    numlockon =$20;
    scrolllockon=$10;
    oldkeyhand= 103;
var
   keyflag1     : byte absolute $0040:$0017;
   bufferhead   : byte absolute $0040:$001A;
   buffertail   : byte absolute $0040:$001C;
   textinfo     : textsettingstype;
   move,
   npcxmov,
   npcymov,
   npcx,
   npcy,
   loop,
   loop2       : integer;
   file1,
   file2,
   file3       : text;
   graphdriver,
   graphmode,
   fileposx,
   fileposy    : integer;
   key,
   delaykey,
   square,
   defaultsquare,
   choice,
   pause       : char;
   sailing,
   dead,
   ext,
   fight,
   createdchar,
   charexists,
   enemysleep,
   condition,
   condition2,
   condition3  : boolean;
   cputype,
   whichmap,
   maxXX,
   maxYY,
   direction,
   direction2,
   direction3,
   scrollon,
   soundon,
   fighton,
   gotprincess,
   returnedprincess,
   gotking,
   agility,
   enmagil,
   mana,
   enmmana,
   stamina,
   enmstam,
   strength,
   enmstrn,
   newpow,
   weaponpower,
   enemynum,
   level       : byte;
   alignment,
   cursorY,
   newac,
   ac,
   fightac     : shortint;
   posY,
   posX,
   posYY,
   posXX,
   maxX,
   maxY,
   newstats,
   hp,
   enmhp,
   mp,
   maxhp,
   enmmaxhp,
   maxmp,
   xp,
   maxxp,
   enmxp,
   gold,
   enmgold,
   price,
   damage      : integer;
   heading,
   sellprice   : string[ 4 ];
   numstr      : string[ 11 ];
   name        : string[ 10 ];
   race,
   buyweapon,
   weapon,
   buyarmor,
   enmname,
   armor       : string[ 13 ];
   off9,
   seg9,
   posi,
   npcoffset,
   horiz,
   vert,
   horizoffs,
   storage,
   hits,
   dodges,
   wounds,
   spells      : word;
   palette     : palettetype;
   ovrwrld     : array [ 1..100, 1..100 ] of char;
{   ovrwrld     : array [ 1..150, 1..150 ] of char;}
   cave1map    : array [ 1..42, 1..35 ] of char;
   cave2map1   : array [ 1..34, 1..28 ] of char;
   cave2map2   : array [ 1..34, 1..28 ] of char;
   cave3map    : array [ 1..22, 1..18 ] of char;
   cave4map1   : array [ 1..44, 1..36 ] of char;
   cave4map2   : array [ 1..44, 1..36 ] of char;
   thronemap   : array [ 1..15, 1..10 ] of char;
{   castlemap   : array [ 1..60, 1..35 ] of char;}
   castlemap   : array [ 1..31, 1..20 ] of char;
   smallmap    : array [ 1..17, 1..11 ] of char;
   block       : array [ 1..24, 1..25 ] of char;
   new09handlerptr,
   old09handler,
   mapptr,
   picture1,
   picture2,
   picture3,
   picture4,
   picture5,
   picture6,
   picture7,
   picture8,
   picture9,
   picture10,
   picture11,
   picture12,
   picture13,
   picture14,
   picture15,
   picture,
   heroup,
   herodown,
   heroleft,
   heroright,
   princessup,
   princessdown,
   princessleft,
   princessright,
   kingup,
   kingdown,
   kingleft,
   kingright,
   shipup,
   shipdown,
   shipleft,
   shipright,
   invheroup,
   invherodown,
   invheroleft,
   invheroright,
   invprincessup,
   invprincessdown,
   invprincessleft,
   invprincessright,
   invkingup,
   invkingdown,
   invkingleft,
   invkingright,
   invshipup,
   invshipdown,
   invshipleft,
   invshipright,
   page11,
   page12       :pointer;

procedure restorekeyhand;
function  inttostr( I : Longint ) : string;
function  halfx : word;
function  halfy : word;
procedure GoToGraph;
procedure clearnumlock;
procedure setnumlock;
procedure clearcapslock;
procedure fastkey;
procedure detectcpu;
procedure mydelay( duration : word );
function  mydelaykey( duration : word ) : char;
procedure askcont;
procedure music( note, length : integer );
procedure bump;
procedure setblit;
procedure clearblit;
procedure copyblit;
procedure blit;
procedure myputimage( coly,colx,imagenum:integer );
procedure myputimage2( coly,colx,imagenum:integer );
procedure getblock( y, x :word );
procedure getsmallmap;
procedure askslot( heading : string );
procedure putpic( x, y : word );
procedure putpicinv( x, y : word );
procedure setscreen;
procedure Showfiles;
procedure PrintStatus;
procedure putchar;
procedure putchar2;
procedure putnpc;
procedure putnpc2( x,y:word);
procedure putnpc3( x,y:word);
procedure erasechar;
procedure erasechar2;
procedure erasenpc;
procedure erasenpc2;
procedure saveundernpc;
procedure saveundernpc2;
procedure saveunder;
procedure saveunder2;
procedure restoreunder;
procedure restoreunder2;
procedure restoreundernpc;
procedure restoreundernpc2;
procedure Status;
procedure enmstatus;
procedure switchpic;
procedure movenpc;
procedure F1message;
procedure stop;

implementation

procedure restorekeyhand;
var oldv:pointer;
begin
     inline($FA);
     getintvec(oldkeyhand,oldv);
     setintvec(9,oldv);
     inline($FB);
end;

function inttostr;
var
   s : string[ 11 ];
begin
     str( i, s );
     inttostr := s;
end;

function halfx;
begin
     halfx:=(maxXX div 2)+1;
end;

function halfy;
begin
     halfy:=(maxYY div 2)+1;
end;

procedure GoToGraph;
begin
     initgraph( graphdriver,graphmode,'' );
end;

procedure clearnumlock;
begin
     keyflag1:=keyflag1 and (not numlockon );
end;

procedure setnumlock;
begin
     keyflag1:=keyflag1 or numlockon;
end;

procedure clearcapslock;
begin
     keyflag1:=keyflag1 and (not capslockon);
end;

procedure fastkey;
var       speed:byte;
begin
     case cputype of
          0 : speed:=15;
          1 : speed:=10;
          2 : speed:=5;
          3 : speed:=0;
     end;
     asm
        mov     ax,0305h
        mov     bh,0
        mov     bl,speed
        int     16h
     end;
end;

procedure detectcpu;
label done,less286,det386,is86;
begin
     asm
        pushf
        pop     ax
        and     ax,7fffh
        push    ax
        popf
        pushf
        pop     ax
        shl     ah,1
        jc      less286

        pushf
        pop     ax
        or      ah,40h
        push    ax
        popf
        pushf
        pop     ax
        and     ah,40h
        jnz     det386

        mov     cputype,2
        jmp     done

det386: mov     cputype,3
        jmp     done

less286:mov     ax,1
        mov     cx,32
        shl     ax,cl
        jz      is86
        mov     cputype,1
        jmp     done

is86:   mov     cputype,0

done:
     end;
end;

procedure mydelay;
label     cycle;
begin
     asm
        in      al,61h
        mov     cl,al
        or      al,1
        out     61h,al
        mov     al,0b6h
        out     43h,al

        mov     bx,duration
        mov     ax,91
        mul     bx
        mov     bx,500
        div     bx
        mov     bx,ax
        mov     ah,0
        int     1ah
        add     dx,bx
        mov     bx,dx
cycle:  int     1ah
        cmp     dx,bx
        jne     cycle
        in      al,61h
        mov     al,cl
        and     al,0fch
        out     61h,al
     end;
end;

function mydelaykey;
label     cycle,exit;
var       key : char;
begin
     asm
        in      al,61h
        mov     cl,al
        or      al,1
        out     61h,al
        mov     al,0b6h
        out     43h,al

        mov     bx,duration
        mov     ax,91
        mul     bx
        mov     bx,500
        div     bx
        mov     bx,ax
        mov     ah,0
        int     1ah
        add     dx,bx
        mov     bx,dx
cycle:
        mov     ah,1
        int     16h
        jnz     exit
        mov     ah,0
        int     1ah
        cmp     dx,bx
        jne     cycle
exit:
        in      al,61h
        mov     al,cl
        and     al,0fch
        out     61h,al
        mov     ah,0
     end;
     if keypressed then mydelaykey:=readkey else mydelaykey:='~';
end;

procedure askcont;
label     line1;
begin
     writeln( 'An EGA card is required for this game.' );
     writeln( 'Would you like to continue anyway? (Y/N)' );
Line1:
     choice := readkey;
     if choice = #110 then stop;
     if choice <> #121 then goto Line1;
end;

procedure music;
label     cycle,
          inter;
begin
     if soundon=0 then exit;
{     sound( note );
     mydelay( length );
     NoSound;}
     asm
        mov     di,note
        in      al,61h
        mov     cl,al
        or      al,3
        out     61h,al
        mov     al,0b6h
        out     43h,al
        mov     dx,14h
        mov     ax,4f38h
        div     di
        out     42h,al
        mov     al,ah
        out     42h,al

        mov     bx,length
        mov     ax,91
        mul     bx
        mov     bx,500
        div     bx
        mov     bx,ax
        mov     ah,0
        int     1ah
        add     dx,bx
        mov     bx,dx
cycle:
        end;
        if bufferhead<>buffertail then goto inter;
        asm
        int     1ah
        cmp     dx,bx
        jne     cycle
inter:
        in      al,61h
        mov     al,cl
        and     al,0fch
        out     61h,al
     end;
end;

procedure bump;
label cycle;
begin
     if soundon=0 then exit;
     music( C div 4, 15 );
end;

procedure setblit;
begin
     setactivepage(1);
end;

procedure clearblit;
begin
     setactivepage(1);
     cleardevice;
end;

procedure copyblit;
begin
     asm
        push     ds              {must preserve ds       }

        mov      dx,3ceh         {graphics control regs  }
        mov      ax,5            {mode reg               }
        out      dx,ax
        mov      dx,3cfh         {graphics control regs  }
        mov      ax,1            {write mode 1           }
        out      dx,ax           {write mode reg         }

        mov      ax,0a000h
        mov      ds,ax           {screen 1               }
        mov      si,0            {offset into screen     }

        mov      ax,0a800h
        mov      es,ax           {destination screen 0   }
        mov      di,0            {clear offset           }

        mov      cx,28000        {screen in bytes        }
        rep      movsb           {copy screen            }


        mov      dx,3ceh         {graphics control regs  }
        mov      ax,5            {get original reg value }
        out      dx,ax           {write mode reg         }
        mov      dx,3cfh         {graphics control regs  }
        mov      ax,0
        out      dx,ax           {write mode reg         }

        pop      ds
     end;
     setactivepage(1);
end;

procedure blit;
begin
     setvisualpage(1);
     asm
        push     ds              {must preserve ds       }

        mov      dx,3ceh         {graphics control regs  }
        mov      ax,5            {mode reg               }
        out      dx,ax
        mov      dx,3cfh         {graphics control regs  }
        mov      ax,1            {write mode 1           }
        out      dx,ax           {write mode reg         }

        mov      ax,0a800h
        mov      ds,ax           {screen 1               }
        mov      si,0            {offset into screen     }

        mov      ax,0a000h
        mov      es,ax           {destination screen 0   }
        mov      di,0            {clear offset           }

        mov      cx,28000        {screen in bytes        }
        rep      movsb           {copy screen            }


        mov      dx,3ceh         {graphics control regs  }
        mov      ax,5            {mode reg               }
        out      dx,ax
        mov      dx,3cfh         {graphics control regs  }
        mov      ax,0
        out      dx,ax           {write mode reg         }

        pop      ds
     end;
     setactivepage(0);
     setvisualpage(0);
end;

procedure myputimage;
label
     nextline;
var
   imageoffset   : integer;
begin
     coly:=(coly*3);
     colx:=(colx*(25*80));
     imageoffset:=coly+colx;
     imagenum:=((imagenum-1)*3);
     asm
        push     ds              {must preserve ds       }

        mov      dx,3ceh         {graphics control regs  }
        mov      ax,5            {mode reg               }
        out      dx,ax
        mov      dx,3cfh         {graphics control regs  }
        mov      ax,1            {write mode 1           }
        out      dx,ax           {write mode reg         }

        mov      ax,0a87dh       {destination seg        }
        mov      es,ax
        mov      di,imageoffset  {actual offset into screen}

        mov      ax,0a800h       {off-screen buffer      }
        mov      ds,ax
        mov      si,imagenum     {offset into buffer     }

        mov      cx,25
nextline:
        push     cx
        mov      cx,3
        rep      movsb
        add      di,77
        add      si,77
        pop      cx
        loop     nextline

        mov      dx,3ceh         {graphics control regs  }
        mov      ax,5            {get original reg value }
        out      dx,ax           {write mode reg         }
        mov      dx,3cfh         {graphics control regs  }
        mov      ax,0
        out      dx,ax           {write mode reg         }

        pop      ds
     end;
end;

procedure myputimage2;
label
     nextline;
var
   imageoffset   : integer;
begin
     coly:=(coly*3);
     colx:=(colx*(25*80));
     imageoffset:=coly+colx;
     imagenum:=((imagenum-1)*3);
     asm
        push     ds              {must preserve ds       }

        mov      dx,3ceh         {graphics control regs  }
        mov      ax,5            {mode reg               }
        out      dx,ax
        mov      dx,3cfh         {graphics control regs  }
        mov      ax,1            {write mode 1           }
        out      dx,ax           {write mode reg         }

        mov      ax,0a000h       {destination seg        }
        mov      es,ax
        mov      di,imageoffset  {actual offset into screen}

        mov      ax,0a800h       {off-screen buffer      }
        mov      ds,ax
        mov      si,imagenum     {offset into buffer     }

        mov      cx,25
nextline:
        push     cx
        mov      cx,3
        rep      movsb
        add      di,77
        add      si,77
        pop      cx
        loop     nextline

        mov      dx,3ceh         {graphics control regs  }
        mov      ax,5            {get original reg value }
        out      dx,ax           {write mode reg         }
        mov      dx,3cfh         {graphics control regs  }
        mov      ax,0
        out      dx,ax           {write mode reg         }

        pop      ds
     end;
end;

procedure getblock;
begin
     case whichmap of
          0 : square:=ovrwrld[ y, x ];
          1 : square:=cave1map[ y, x ];
          2 : square:=cave2map1[ y, x ];
          3 : square:=cave2map2[ y, x ];
          4 : square:=cave3map[ y, x ];
          5 : square:=cave4map1[ y, x ];
          6 : square:=cave4map2[ y, x ];
          7 : square:=thronemap[ y, x ];
     end;
end;

procedure getsmallmap;
begin
     if whichmap = 0 then begin
        for loop:=1 to maxYY+1 do begin
            for loop2 :=1 to maxXX+1 do begin
                if ((posx-halfx+loop2<=0)or(posy-halfy+loop<=0)or(posx-halfx+loop2>=maxX)or(posy-halfy+loop>=maxY))then
                   smallmap[ loop, loop2]:=defaultsquare else
                   begin
                        smallmap[ loop, loop2 ]:=ovrwrld[ (posY-halfy+loop),(posX-halfx+loop2)];
                   end;
            end;
        end;
     end else
     if whichmap = 1 then begin
        for loop:=1 to maxYY+1 do begin
            for loop2 :=1 to maxXX+1 do begin
                if ((posx-halfx+loop2<=0)or(posy-halfy+loop<=0)or(posx-halfx+loop2>=maxX)or(posy-halfy+loop>=maxY))then
                   smallmap[ loop, loop2]:=defaultsquare else
                   begin
                        smallmap[ loop, loop2 ]:=cave1map[ (posY-halfy+loop),(posX-halfx+loop2)];
                   end;
            end;
        end;
     end;
     if whichmap = 2 then begin
        for loop:=1 to maxYY+1 do begin
            for loop2 :=1 to maxXX+1 do begin
                if ((posx-halfx+loop2<=0)or(posy-halfy+loop<=0)or(posx-halfx+loop2>=maxX)or(posy-halfy+loop>=maxY))then
                   smallmap[ loop, loop2]:=defaultsquare else
                   begin
                        smallmap[ loop, loop2 ]:=cave2map1[ (posY-halfy+loop),(posX-halfx+loop2)];
                   end;
            end;
        end;
     end;
     if whichmap = 3 then begin
        for loop:=1 to maxYY+1 do begin
            for loop2 :=1 to maxXX+1 do begin
                if ((posx-halfx+loop2<=0)or(posy-halfy+loop<=0)or(posx-halfx+loop2>=maxX)or(posy-halfy+loop>=maxY))then
                   smallmap[ loop, loop2]:=defaultsquare else
                   begin
                        smallmap[ loop, loop2 ]:=cave2map2[ (posY-halfy+loop),(posX-halfx+loop2)];
                   end;
            end;
        end;
     end;
     if whichmap = 4 then begin
        for loop:=1 to maxYY+1 do begin
            for loop2 :=1 to maxXX+1 do begin
                if ((posx-halfx+loop2<=0)or(posy-halfy+loop<=0)or(posx-halfx+loop2>=maxX)or(posy-halfy+loop>=maxY))then
                   smallmap[ loop, loop2]:=defaultsquare else
                   begin
                        smallmap[ loop, loop2 ]:=cave3map[ (posY-halfy+loop),(posX-halfx+loop2)];
                   end;
            end;
        end;
     end;
     if whichmap = 5 then begin
        for loop:=1 to maxYY+1 do begin
            for loop2 :=1 to maxXX+1 do begin
                if ((posx-halfx+loop2<=0)or(posy-halfy+loop<=0)or(posx-halfx+loop2>=maxX)or(posy-halfy+loop>=maxY))then
                   smallmap[ loop, loop2]:=defaultsquare else
                   begin
                        smallmap[ loop, loop2 ]:=cave4map1[ (posY-halfy+loop),(posX-halfx+loop2)];
                   end;
            end;
        end;
     end;
     if whichmap = 6 then begin
        for loop:=1 to maxYY+1 do begin
            for loop2 :=1 to maxXX+1 do begin
                if ((posx-halfx+loop2<=0)or(posy-halfy+loop<=0)or(posx-halfx+loop2>=maxX)or(posy-halfy+loop>=maxY))then
                   smallmap[ loop, loop2]:=defaultsquare else
                   begin
                        smallmap[ loop, loop2 ]:=cave4map2[ (posY-halfy+loop),(posX-halfx+loop2)];
                   end;
            end;
        end;
     end;
     if whichmap = 7 then begin
        for loop:=1 to maxYY+1 do begin
            for loop2 :=1 to maxXX+1 do begin
                if ((posx-halfx+loop2<=0)or(posy-halfy+loop<=0)or(posx-halfx+loop2>=maxX)or(posy-halfy+loop>=maxY))then
                   smallmap[ loop, loop2]:=defaultsquare else
                   begin
                        smallmap[ loop, loop2 ]:=thronemap[ (posY-halfy+loop),(posX-halfx+loop2)];
                   end;
            end;
        end;
     end;
     if whichmap = 8 then begin
        for loop:=1 to maxYY+1 do begin
            for loop2 :=1 to maxXX+1 do begin
                if ((posx-halfx+loop2<=0)or(posy-halfy+loop<=0)or(posx-halfx+loop2>=maxX)or(posy-halfy+loop>=maxY))then
                   smallmap[ loop, loop2]:=defaultsquare else
                   begin
                        smallmap[ loop, loop2 ]:=castlemap[ (posY-halfy+loop),(posX-halfx+loop2)];
                   end;
            end;
        end;
     end;
end;

procedure askslot;
begin
     clearblit;
     settextstyle( 1, 0, 6 );
     OutTextXY( 240, 0, heading );
     OutTextXY( 75, 100, 'Which saved game?' );
     OutTextXY( 230, 160, '(1-9)' );
     showfiles;
     blit;
     choice:= readkey;
     if choice in [ #49..#57 ] then begin
          case choice of
               '1' : assign( file1, 'savegame.001' );
               '2' : assign( file1, 'savegame.002' );
               '3' : assign( file1, 'savegame.003' );
               '4' : assign( file1, 'savegame.004' );
               '5' : assign( file1, 'savegame.005' );
               '6' : assign( file1, 'savegame.006' );
               '7' : assign( file1, 'savegame.007' );
               '8' : assign( file1, 'savegame.008' );
               '9' : assign( file1, 'savegame.009' );
          end;
     end else choice := ' ';
end;

procedure putpic;
var
   color        : word;
begin
     for fileposX := 0 to 24 do begin
         for fileposY := 0 to 23 do begin
             case block[ fileposY+1,fileposX+1 ] of
                  ')' : color := 0;
                  '!' : color := 1;
                  '@' : color := 2;
                  '#' : color := 3;
                  '$' : color := 4;
                  '%' : color := 5;
                  '^' : color := 6;
                  '&' : color := 7;
                  '*' : color := 8;
                  '(' : color := 9;
                  '-' : color := 10;
                  '_' : color := 11;
                  '=' : color := 12;
                  '+' : color := 13;
                  '`' : color := 14;
                  '~' : color := 15;
             end;
             putpixel( fileposY + Y, fileposX + X, color );
         end;
     end;
end;

procedure putpicinv;
var
   color        : word;
begin
     setactivepage(1);
     for fileposX := 0 to 24 do begin
         for fileposY := 0 to 23 do begin
             case block[ fileposY+1,fileposX+1 ] of
                  ')' : color := 0;
                  '!' : color := 1;
                  '@' : color := 2;
                  '#' : color := 3;
                  '$' : color := 4;
                  '%' : color := 5;
                  '^' : color := 6;
                  '&' : color := 7;
                  '*' : color := 8;
                  '(' : color := 9;
                  '-' : color := 10;
                  '_' : color := 11;
                  '=' : color := 12;
                  '+' : color := 13;
                  '`' : color := 14;
                  '~' : color := 15;
             end;
             if (color>0)or
                (((fileposY>0 ) and (block[fileposY  ,fileposX+1]<>')'))or
                 ((fileposY<23) and (block[fileposY+2,fileposX+1]<>')'))or
                 ((fileposX>0 ) and (block[fileposY+1,fileposX  ]<>')'))or
                 ((fileposX<24) and (block[fileposY+1,fileposX+2]<>')')))
                then putpixel( fileposY + Y, fileposX + X, color );
         end;
     end;
end;

procedure setscreen;
begin
     clrscr;
     writeln( 'STATUSͻ ENEMYͻ' );
     for loop := 1 to 8 do begin
          writeln( '                                                                         ' );
     end;
     writeln( 'ͼ ͼ' );
     writeln( 'ͻ ͻ' );
     for loop := 1 to 12 do begin
          writeln( '                                                                         ' );
     end;
     writeln( 'ͼ ͼ' );
     cursorY := 0;
     status;
end;

procedure Showfiles;
begin
     setcolor( 14 );
     settextstyle( 2, 0, 5 );
     loop := 0;
     Outtextxy( 250, 241, '1:' );
     Outtextxy( 250, 252, '2:' );
     Outtextxy( 250, 263, '3:' );
     Outtextxy( 250, 274, '4:' );
     Outtextxy( 250, 285, '5:' );
     Outtextxy( 250, 296, '6:' );
     Outtextxy( 250, 307, '7:' );
     Outtextxy( 250, 318, '8:' );
     Outtextxy( 250, 329, '9:' );
     outtextxy( 278, 230, 'NAME' );
     outtextxy( 332, 230, 'LEVEL' );
{$I-}
     for loop := 1 to 9 do begin
          case loop of
                1 : assign( file1, 'savegame.001' );
                2 : assign( file1, 'savegame.002' );
                3 : assign( file1, 'savegame.003' );
                4 : assign( file1, 'savegame.004' );
                5 : assign( file1, 'savegame.005' );
                6 : assign( file1, 'savegame.006' );
                7 : assign( file1, 'savegame.007' );
                8 : assign( file1, 'savegame.008' );
                9 : assign( file1, 'savegame.009' );
          end;
          reset( file1 );
          if IOresult = 0 then begin
             readln( file1, enmname );
             outtextxy( 270, 230 + ( loop * 11 ), enmname );
             for loop2 := 1 to 2 do begin
                readln( file1, enmname );
             end;
             for loop2 := 1 to 14 do begin
                readln( file1, price );
             end;
             numstr:=inttostr( price );
             outtextxy( 350, 230 + ( loop * 11 ), numstr );
             close( file1 );
          end else begin
              outtextxy( 270,230 + ( loop * 11 ), 'E  M  P  T  Y' );
          end;
     end;
{$I+}
end;

procedure PrintStatus;
begin
     SetTextStyle( 2, 0, 6 );
     OutTextXY( 430, 50,  'Name:' );
     OutTextXY( 430, 65,  'Armor:' );
     OutTextXY( 430, 80,  'Weapon:' );
     OutTextXY( 430, 95,  'HP:' );
     OutTextXY( 430, 110, 'MP:' );
     OutTextXY( 430, 125, 'XP:' );
     OutTextXY( 430, 140, 'Gold:' );
     OutTextXY( 430, 155, 'Level:' );
     if charexists = false then exit else
     begin
          OutTextXY( 478, 50, name );
          OutTextXY( 488, 65, armor );
          OutTextXY( 497, 80, weapon );

          numstr:=inttostr(hp) + '/' + inttostr(maxhp);
          OutTextXY( 460, 95, numstr);
          if hp < (maxhp div 10)+1 then begin
             setcolor( red );
             numstr:=inttostr(hp);
             outtextXY( 460, 95, numstr );
             setcolor( white );
          end;

          numstr:=inttostr(mp) + '/' + inttostr(maxmp);
          OutTextXY( 460, 110, numstr);
          numstr:=inttostr(xp) + '/' + inttostr(maxxp);
          OutTextXY( 460, 125, numstr);
          numstr:=inttostr(gold);
          OutTextXY( 478, 140, numstr);
          numstr:=inttostr(level);
          OutTextXY( 487, 155, numstr);
     end;
end;

procedure putchar;
begin
     if sailing=false then begin
     setactivepage(1);
     if direction=1 then begin
        putimage( ( ( halfy * 24 ) - 24 ), ( ( halfx * 25 ) ), invheroup^, andput );
        putimage( ( ( halfy * 24 ) - 24 ), ( ( halfx * 25 ) ), heroup^, orput );
     end;
     if direction=2 then begin
        putimage( ( ( halfy * 24 ) - 24 ), ( ( halfx * 25 ) ), invheroleft^, andput );
        putimage( ( ( halfy * 24 ) - 24 ), ( ( halfx * 25 ) ), heroleft^, orput );
     end;
     if direction=3 then begin
        putimage( ( ( halfy * 24 ) - 24 ), ( ( halfx * 25 ) ), invheroright^, andput );
        putimage( ( ( halfy * 24 ) - 24 ), ( ( halfx * 25 ) ), heroright^, orput );
     end;
     if direction=4 then begin
        putimage( ( ( halfy * 24 ) - 24 ), ( ( halfx * 25 ) ), invherodown^, andput );
        putimage( ( ( halfy * 24 ) - 24 ), ( ( halfx * 25 ) ), herodown^, orput );
     end;
     setactivepage(0);
     end else begin
     setactivepage(1);
     if direction=1 then begin
        putimage( ( ( halfy * 24 ) - 24 ), ( ( halfx * 25 ) ), invshipup^, andput );
        putimage( ( ( halfy * 24 ) - 24 ), ( ( halfx * 25 ) ), shipup^, orput );
     end;
     if direction=2 then begin
        putimage( ( ( halfy * 24 ) - 24 ), ( ( halfx * 25 ) ), invshipleft^, andput );
        putimage( ( ( halfy * 24 ) - 24 ), ( ( halfx * 25 ) ), shipleft^, orput );
     end;
     if direction=3 then begin
        putimage( ( ( halfy * 24 ) - 24 ), ( ( halfx * 25 ) ), invshipright^, andput );
        putimage( ( ( halfy * 24 ) - 24 ), ( ( halfx * 25 ) ), shipright^, orput );
     end;
     if direction=4 then begin
        putimage( ( ( halfy * 24 ) - 24 ), ( ( halfx * 25 ) ), invshipdown^, andput );
        putimage( ( ( halfy * 24 ) - 24 ), ( ( halfx * 25 ) ), shipdown^, orput );
     end;
     setactivepage(0);
     end;
end;

procedure putchar2;
begin
     if direction=1 then begin
        putimage( ( ( halfy * 24 ) - 24 ), ( ( halfx * 25 ) - 25 ), invheroup^, andput );
        putimage( ( ( halfy * 24 ) - 24 ), ( ( halfx * 25 ) - 25 ), heroup^, orput );
     end;
     if direction=2 then begin
        putimage( ( ( halfy * 24 ) - 24 ), ( ( halfx * 25 ) - 25 ), invheroleft^, andput );
        putimage( ( ( halfy * 24 ) - 24 ), ( ( halfx * 25 ) - 25 ), heroleft^, orput );
     end;
     if direction=3 then begin
        putimage( ( ( halfy * 24 ) - 24 ), ( ( halfx * 25 ) - 25 ), invheroright^, andput );
        putimage( ( ( halfy * 24 ) - 24 ), ( ( halfx * 25 ) - 25 ), heroright^, orput );
     end;
     if direction=4 then begin
        putimage( ( ( halfy * 24 ) - 24 ), ( ( halfx * 25 ) - 25 ), invherodown^, andput );
        putimage( ( ( halfy * 24 ) - 24 ), ( ( halfx * 25 ) - 25 ), herodown^, orput );
     end;
end;

procedure putnpc;
begin
     if sailing then exit;
     if (posXX=halfx)and(posYY=halfy) then exit;
     setactivepage(1);
     if (gotprincess = 1)and(returnedprincess=0) then begin
        if direction2=1 then begin
           putimage(((posYY*24)-24),(posXX*25),invprincessup^,andput);
           putimage(((posYY*24)-24),(posXX*25),princessup^,orput);
        end;
        if direction2=2 then begin
           putimage(((posYY*24)-24),(posXX*25),invprincessleft^,andput);
           putimage(((posYY*24)-24),(posXX*25),princessleft^,orput);
        end;
        if direction2=3 then begin
           putimage(((posYY*24)-24),(posXX*25),invprincessright^,andput);
           putimage(((posYY*24)-24),(posXX*25),princessright^,orput);
        end;
        if direction2=4 then begin
           putimage(((posYY*24)-24),(posXX*25),invprincessdown^,andput);
           putimage(((posYY*24)-24),(posXX*25),princessdown^,orput);
        end;
     end;
     if gotking = 1 then begin
        if direction2=1 then begin
           putimage(((posYY*24)-24),(posXX*25),invkingup^,andput);
           putimage(((posYY*24)-24),(posXX*25),kingup^,orput);
        end;
        if direction2=2 then begin
           putimage(((posYY*24)-24),(posXX*25),invkingleft^,andput);
           putimage(((posYY*24)-24),(posXX*25),kingleft^,orput);
        end;
        if direction2=3 then begin
           putimage(((posYY*24)-24),(posXX*25),invkingright^,andput);
           putimage(((posYY*24)-24),(posXX*25),kingright^,orput);
        end;
        if direction2=4 then begin
           putimage(((posYY*24)-24),(posXX*25),invkingdown^,andput);
           putimage(((posYY*24)-24),(posXX*25),kingdown^,orput);
        end;
     end;
     setactivepage(0);
end;

procedure putnpc2;
begin
     if sailing then exit;
{     if (posXX=halfx)and(posYY=halfy) then exit;}
     setactivepage(1);
     if (gotprincess = 1)and(returnedprincess=0) then begin
        if direction2=1 then begin
           putimage(Y,X,invprincessup^,andput);
           putimage(Y,X,princessup^,orput);
        end;
        if direction2=2 then begin
           putimage(Y,X,invprincessleft^,andput);
           putimage(Y,X,princessleft^,orput);
        end;
        if direction2=3 then begin
           putimage(Y,X,invprincessright^,andput);
           putimage(Y,X,princessright^,orput);
        end;
        if direction2=4 then begin
           putimage(Y,X,invprincessdown^,andput);
           putimage(Y,X,princessdown^,orput);
        end;
     end;
     if gotking = 1 then begin
        if direction2=1 then begin
           putimage(Y,X,invkingup^,andput);
           putimage(Y,X,kingup^,orput);
        end;
        if direction2=2 then begin
           putimage(Y,X,invkingleft^,andput);
           putimage(Y,X,kingleft^,orput);
        end;
        if direction2=3 then begin
           putimage(Y,X,invkingright^,andput);
           putimage(Y,X,kingright^,orput);
        end;
        if direction2=4 then begin
           putimage(Y,X,invkingdown^,andput);
           putimage(Y,X,kingdown^,orput);
        end;
     end;
     npcx:=npcx+npcxmov;
     npcy:=npcy+npcymov;
     setactivepage(0);
end;

procedure putnpc3;
begin
     if sailing then exit;
{     if (posXX=halfx)and(posYY=halfy) then exit;}
     if (gotprincess = 1)and(returnedprincess=0) then begin
        if direction2=1 then begin
           putimage(Y,X,invprincessup^,andput);
           putimage(Y,X,princessup^,orput);
        end;
        if direction2=2 then begin
           putimage(Y,X,invprincessleft^,andput);
           putimage(Y,X,princessleft^,orput);
        end;
        if direction2=3 then begin
           putimage(Y,X,invprincessright^,andput);
           putimage(Y,X,princessright^,orput);
        end;
        if direction2=4 then begin
           putimage(Y,X,invprincessdown^,andput);
           putimage(Y,X,princessdown^,orput);
        end;
     end;
     if gotking = 1 then begin
        if direction2=1 then begin
           putimage(Y,X,invkingup^,andput);
           putimage(Y,X,kingup^,orput);
        end;
        if direction2=2 then begin
           putimage(Y,X,invkingleft^,andput);
           putimage(Y,X,kingleft^,orput);
        end;
        if direction2=3 then begin
           putimage(Y,X,invkingright^,andput);
           putimage(Y,X,kingright^,orput);
        end;
        if direction2=4 then begin
           putimage(Y,X,invkingdown^,andput);
           putimage(Y,X,kingdown^,orput);
        end;
     end;
     npcx:=npcx+npcxmov;
     npcy:=npcy+npcymov;
end;

procedure erasechar;
begin
     square := smallmap[ halfY, halfX ];
     case square of
          '!' : myputimage( halfy-1, halfx-1, 1 );
          '@' : myputimage( halfy-1, halfx-1, 2 );
          '#' : myputimage( halfy-1, halfx-1, 3 );
          '$' : myputimage( halfy-1, halfx-1, 4 );
          '%' : myputimage( halfy-1, halfx-1, 5 );
          '^' : myputimage( halfy-1, halfx-1, 6 );
          '&' : myputimage( halfy-1, halfx-1, 7 );
          '*' : myputimage( halfy-1, halfx-1, 8 );
          '(' : myputimage( halfy-1, halfx-1, 9 );
          '-' : myputimage( halfy-1, halfx-1, 10 );
          '_' : myputimage( halfy-1, halfx-1, 11 );
          '=' : myputimage( halfy-1, halfx-1, 12 );
          '+' : myputimage( halfy-1, halfx-1, 13 );
          '`' : myputimage( halfy-1, halfx-1, 14 );
          '~' : myputimage( halfy-1, halfx-1, 15 );
     end;
end;

procedure erasechar2;
begin
     square := smallmap[ halfY, halfX ];
     case square of
          '!' : myputimage2( halfy-1, halfx-1, 1 );
          '@' : myputimage2( halfy-1, halfx-1, 2 );
          '#' : myputimage2( halfy-1, halfx-1, 3 );
          '$' : myputimage2( halfy-1, halfx-1, 4 );
          '%' : myputimage2( halfy-1, halfx-1, 5 );
          '^' : myputimage2( halfy-1, halfx-1, 6 );
          '&' : myputimage2( halfy-1, halfx-1, 7 );
          '*' : myputimage2( halfy-1, halfx-1, 8 );
          '(' : myputimage2( halfy-1, halfx-1, 9 );
          '-' : myputimage2( halfy-1, halfx-1, 10 );
          '_' : myputimage2( halfy-1, halfx-1, 11 );
          '=' : myputimage2( halfy-1, halfx-1, 12 );
          '+' : myputimage2( halfy-1, halfx-1, 13 );
          '`' : myputimage2( halfy-1, halfx-1, 14 );
          '~' : myputimage2( halfy-1, halfx-1, 15 );
     end;
end;

procedure erasenpc;
begin
     if sailing then exit;
     square := smallmap[ posYY, posXX ];
     case square of
          '!' : myputimage( posYY-1, posXX-1, 1 );
          '@' : myputimage( posYY-1, posXX-1, 2 );
          '#' : myputimage( posYY-1, posXX-1, 3 );
          '$' : myputimage( posYY-1, posXX-1, 4 );
          '%' : myputimage( posYY-1, posXX-1, 5 );
          '^' : myputimage( posYY-1, posXX-1, 6 );
          '&' : myputimage( posYY-1, posXX-1, 7 );
          '*' : myputimage( posYY-1, posXX-1, 8 );
          '(' : myputimage( posYY-1, posXX-1, 9 );
          '-' : myputimage( posYY-1, posXX-1, 10 );
          '_' : myputimage( posYY-1, posXX-1, 11 );
          '=' : myputimage( posYY-1, posXX-1, 12 );
          '+' : myputimage( posYY-1, posXX-1, 13 );
          '`' : myputimage( posYY-1, posXX-1, 14 );
          '~' : myputimage( posYY-1, posXX-1, 15 );
     end;
end;

procedure erasenpc2;
begin
     if sailing then exit;
     square := smallmap[ posYY, posXX ];
     case square of
          '!' : myputimage2( posYY-1, posXX-1, 1 );
          '@' : myputimage2( posYY-1, posXX-1, 2 );
          '#' : myputimage2( posYY-1, posXX-1, 3 );
          '$' : myputimage2( posYY-1, posXX-1, 4 );
          '%' : myputimage2( posYY-1, posXX-1, 5 );
          '^' : myputimage2( posYY-1, posXX-1, 6 );
          '&' : myputimage2( posYY-1, posXX-1, 7 );
          '*' : myputimage2( posYY-1, posXX-1, 8 );
          '(' : myputimage2( posYY-1, posXX-1, 9 );
          '-' : myputimage2( posYY-1, posXX-1, 10 );
          '_' : myputimage2( posYY-1, posXX-1, 11 );
          '=' : myputimage2( posYY-1, posXX-1, 12 );
          '+' : myputimage2( posYY-1, posXX-1, 13 );
          '`' : myputimage2( posYY-1, posXX-1, 14 );
          '~' : myputimage2( posYY-1, posXX-1, 15 );
     end;
end;

procedure saveunder;
label     boogie;
var       saveoffset : word;
begin
     saveoffset:=((halfx-1)*25*80)+((halfy-1)*3);
     asm
        push ds

        mov      dx,3ceh         {graphics control regs  }
        mov      ax,5            {mode reg               }
        out      dx,ax
        mov      dx,3cfh         {graphics control regs  }
        mov      ax,1            {write mode 1           }
        out      dx,ax           {write mode reg         }

        mov      si,saveoffset
        mov      ax,0a87dh
        mov      ds,ax

        mov      ax,0a800h
        mov      es,ax
        mov      di,2051

        mov      cx,25
boogie:
        push     cx

        mov      cx,3
        rep      movsb
        add      si,77
        add      di,77

        pop      cx
        loop     boogie

        mov      dx,3ceh         {graphics control regs  }
        mov      ax,5            {get original reg value }
        out      dx,ax           {write mode reg         }
        mov      dx,3cfh         {graphics control regs  }
        mov      ax,0
        out      dx,ax           {write mode reg         }

        pop  ds
     end;
end;

procedure saveunder2;
label     boogie;
var       saveoffset : word;
begin
     saveoffset:=((halfx-1)*25*80)+((halfy-1)*3);
     asm
        push ds

        mov      dx,3ceh         {graphics control regs  }
        mov      ax,5            {mode reg               }
        out      dx,ax
        mov      dx,3cfh         {graphics control regs  }
        mov      ax,1            {write mode 1           }
        out      dx,ax           {write mode reg         }

        mov      si,saveoffset
        mov      ax,0a000h
        mov      ds,ax

        mov      ax,0a800h
        mov      es,ax
        mov      di,2051

        mov      cx,25
boogie:
        push     cx

        mov      cx,3
        rep      movsb
        add      si,77
        add      di,77

        pop      cx
        loop     boogie

        mov      dx,3ceh         {graphics control regs  }
        mov      ax,5            {get original reg value }
        out      dx,ax           {write mode reg         }
        mov      dx,3cfh         {graphics control regs  }
        mov      ax,0
        out      dx,ax           {write mode reg         }

        pop  ds
     end;
end;

procedure saveundernpc;
label     boogie;
begin
     if sailing then exit;
     if (((gotprincess=1) and (returnedprincess=0))or(gotking=1)) then begin
        asm
           push ds

        mov      dx,3ceh         {graphics control regs  }
        mov      ax,5            {mode reg               }
        out      dx,ax
        mov      dx,3cfh         {graphics control regs  }
        mov      ax,1            {write mode 1           }
        out      dx,ax           {write mode reg         }

           mov      si,npcoffset
           mov      ax,0a87dh
           mov      ds,ax

           mov      ax,0a800h
           mov      es,ax
           mov      di,2054

           mov      cx,25
boogie:
           push     cx

           mov      cx,5
           rep      movsb
           add      si,75
           add      di,75

           pop      cx
           loop     boogie

           mov      dx,3ceh         {graphics control regs  }
           mov      ax,5            {get original reg value }
           out      dx,ax           {write mode reg         }
           mov      dx,3cfh         {graphics control regs  }
           mov      ax,0
           out      dx,ax           {write mode reg         }

           pop  ds
        end;
     end;
end;

procedure saveundernpc2;
label     boogie;
begin
     if sailing then exit;
     if (((gotprincess=1) and (returnedprincess=0))or(gotking=1)) then begin
        asm
           push ds

        mov      dx,3ceh         {graphics control regs  }
        mov      ax,5            {mode reg               }
        out      dx,ax
        mov      dx,3cfh         {graphics control regs  }
        mov      ax,1            {write mode 1           }
        out      dx,ax           {write mode reg         }

           mov      si,npcoffset
           mov      ax,0a000h
           mov      ds,ax

           mov      ax,0a800h
           mov      es,ax
           mov      di,2054

           mov      cx,25
boogie:
           push     cx

           mov      cx,5
           rep      movsb
           add      si,75
           add      di,75

           pop      cx
           loop     boogie

           mov      dx,3ceh         {graphics control regs  }
           mov      ax,5            {get original reg value }
           out      dx,ax           {write mode reg         }
           mov      dx,3cfh         {graphics control regs  }
           mov      ax,0
           out      dx,ax           {write mode reg         }

           pop  ds
        end;
     end;
end;

procedure restoreunder;
label     boogie;
var       saveoffset: word;
begin
     saveoffset:=((halfx-1)*25*80)+((halfy-1)*3);
     asm
        push ds

        mov      dx,3ceh         {graphics control regs  }
        mov      ax,5            {mode reg               }
        out      dx,ax
        mov      dx,3cfh         {graphics control regs  }
        mov      ax,1            {write mode 1           }
        out      dx,ax           {write mode reg         }

        mov      di,saveoffset
        mov      ax,0a87dh
        mov      es,ax

        mov      ax,0a800h
        mov      ds,ax
        mov      si,2051

        mov      cx,25
boogie:
        push     cx

        mov      cx,3
        rep      movsb
        add      si,77
        add      di,77

        pop      cx
        loop     boogie

        mov      dx,3ceh         {graphics control regs  }
        mov      ax,5            {get original reg value }
        out      dx,ax           {write mode reg         }
        mov      dx,3cfh         {graphics control regs  }
        mov      ax,0
        out      dx,ax           {write mode reg         }

        pop  ds
     end;
end;

procedure restoreunder2;
label     boogie;
var       saveoffset: word;
begin
     saveoffset:=((halfx-1)*25*80)+((halfy-1)*3);
     asm
        push ds

        mov      dx,3ceh         {graphics control regs  }
        mov      ax,5            {mode reg               }
        out      dx,ax
        mov      dx,3cfh         {graphics control regs  }
        mov      ax,1            {write mode 1           }
        out      dx,ax           {write mode reg         }

        mov      di,saveoffset
        mov      ax,0a000h
        mov      es,ax

        mov      ax,0a800h
        mov      ds,ax
        mov      si,2051

        mov      cx,25
boogie:
        push     cx

        mov      cx,3
        rep      movsb
        add      si,77
        add      di,77

        pop      cx
        loop     boogie

        mov      dx,3ceh         {graphics control regs  }
        mov      ax,5            {get original reg value }
        out      dx,ax           {write mode reg         }
        mov      dx,3cfh         {graphics control regs  }
        mov      ax,0
        out      dx,ax           {write mode reg         }

        pop  ds
     end;
end;

procedure restoreundernpc;
label     boogie;
var       saveoffset: word;
begin
     if sailing then exit;
     if (((gotprincess=1) and (returnedprincess=0))or(gotking=1)) then begin
     asm
        push ds

        mov      dx,3ceh         {graphics control regs  }
        mov      ax,5            {mode reg               }
        out      dx,ax
        mov      dx,3cfh         {graphics control regs  }
        mov      ax,1            {write mode 1           }
        out      dx,ax           {write mode reg         }

        mov      di,npcoffset
        mov      ax,0a87dh
        mov      es,ax

        mov      ax,0a800h
        mov      ds,ax
        mov      si,2054

        mov      cx,25
boogie:
        push     cx

        mov      cx,5
        rep      movsb
        add      si,75
        add      di,75

        pop      cx
        loop     boogie

        mov      dx,3ceh         {graphics control regs  }
        mov      ax,5            {get original reg value }
        out      dx,ax           {write mode reg         }
        mov      dx,3cfh         {graphics control regs  }
        mov      ax,0
        out      dx,ax           {write mode reg         }

        pop  ds
     end;
     npcoffset:=npcoffset+move;
     end;
end;

procedure restoreundernpc2;
label     boogie;
var       saveoffset: word;
begin
     if sailing then exit;
     if (((gotprincess=1) and (returnedprincess=0))or(gotking=1)) then begin
     asm
        push ds

        mov      dx,3ceh         {graphics control regs  }
        mov      ax,5            {mode reg               }
        out      dx,ax
        mov      dx,3cfh         {graphics control regs  }
        mov      ax,1            {write mode 1           }
        out      dx,ax           {write mode reg         }

        mov      di,npcoffset
        mov      ax,0a000h
        mov      es,ax

        mov      ax,0a800h
        mov      ds,ax
        mov      si,2054

        mov      cx,25
boogie:
        push     cx

        mov      cx,5
        rep      movsb
        add      si,75
        add      di,75

        pop      cx
        loop     boogie

        mov      dx,3ceh         {graphics control regs  }
        mov      ax,5            {get original reg value }
        out      dx,ax           {write mode reg         }
        mov      dx,3cfh         {graphics control regs  }
        mov      ax,0
        out      dx,ax           {write mode reg         }

        pop  ds
     end;
     npcoffset:=npcoffset+move;
     end;
end;

procedure Status;
begin
     window( 3, 2, 37, 9 );
     writeln( 'Name : ', name );
{     writeln( 'Race : ', race );}
     writeln( 'Armor : ', armor );
     writeln( 'Weapon : ', weapon );
{     if fight = true then writeln( 'AC : ', fightac )
          else writeln( 'AC : ', ac );}
     write( 'HP : ' );
     if hp < (maxhp div 10)+1 then textcolor( red );
     write( hp );
     textcolor( lightgray );
     writeln( '/', maxhp, '  ' );
     writeln( 'MP : ', mp, '/', maxmp, '  ' );
     writeln( 'XP : ', xp, '/', maxxp, ' ' );
     write( 'Gold : ', gold );
     window( 25, 1, 37, 9 );
     gotoXY( 1, 2 );
{     writeln( 'XP : ', xp, '/', maxxp, ' ' );}
     if fight = true then writeln( 'AC : ', fightac )
          else writeln( 'AC : ', ac );
     writeln( 'Agil : ', agility );
     writeln( 'Mana : ', mana );
     writeln( 'Stam : ', stamina );
     writeln( 'Strn : ', strength );
{     writeln( 'Gold : ', gold );}
     write( 'Level : ', level );
     window( 1, 1, 80, 25 );
end;

procedure enmstatus;
begin
     window( 42, 3, 75, 9 );
     writeln( 'Name : ', enmname );
     writeln( 'HP   : ', enmhp, '/', enmmaxhp, '  ' );
     writeln( 'Stam : ', enmstam );
     writeln( 'Agil : ', enmagil );
     window( 61, 3, 75, 9 );
     gotoXY( 1, 1 );
     writeln( 'Strn : ', enmstrn );
     writeln( 'Mana : ', enmmana );
     writeln( 'Gold : ', enmgold );
     writeln( 'XP   : ', enmxp );
end;

procedure switchpic;
var
   loop1,loop2  : byte;
begin
     storage := imagesize( 1, 1, 24, 25 );
     freemem( picture1, storage );
     freemem( picture2, storage );
     freemem( picture3, storage );
     freemem( picture4, storage );
     freemem( picture5, storage );
     freemem( picture6, storage );
     freemem( picture7, storage );
     freemem( picture8, storage );
     freemem( picture9, storage );
     freemem( picture10, storage );
     freemem( picture11, storage );
     freemem( picture12, storage );
     freemem( picture13, storage );
     freemem( picture14, storage );
     freemem( picture15, storage );
     getmem( picture1, storage );
     getmem( picture2, storage );
     getmem( picture3, storage );
     getmem( picture4, storage );
     getmem( picture5, storage );
     getmem( picture6, storage );
     getmem( picture7, storage );
     getmem( picture8, storage );
     getmem( picture9, storage );
     getmem( picture10, storage );
     getmem( picture11, storage );
     getmem( picture12, storage );
     getmem( picture13, storage );
     getmem( picture14, storage );
     getmem( picture15, storage );
     getimage( 0, 0, 23, 24, picture1^ );
     getimage( 24, 0, 47, 24, picture2^ );
     getimage( 48, 0, 71, 24, picture3^ );
     getimage( 72, 0, 95, 24, picture4^ );
     getimage( 96, 0, 119, 24, picture5^ );
     getimage( 120, 0, 143, 24, picture6^ );
     getimage( 144, 0, 167, 24, picture7^ );
     getimage( 168, 0, 191, 24, picture8^ );
     getimage( 192, 0, 215, 24, picture9^ );
     getimage( 216, 0, 239, 24, picture10^ );
     getimage( 240, 0, 263, 24, picture11^ );
     getimage( 264, 0, 287, 24, picture12^ );
     getimage( 288, 0, 311, 24, picture13^ );
     getimage( 312, 0, 335, 24, picture14^ );
     getimage( 336, 0, 359, 24, picture15^ );
         pause:=readkey;
         for loop:= 0 to maxXX do begin
             for loop2:= 0 to maxYY do begin
                 case smallmap[ loop2+1, loop+1 ] of
                      '!' : myputimage( loop2, loop, 1 );
                      '@' : myputimage( loop2, loop, 2 );
                      '#' : myputimage( loop2, loop, 3 );
                      '$' : myputimage( loop2, loop, 4 );
                      '%' : myputimage( loop2, loop, 5 );
                      '^' : myputimage( loop2, loop, 6 );
                      '&' : myputimage( loop2, loop, 7 );
                      '*' : myputimage( loop2, loop, 8 );
                      '(' : myputimage( loop2, loop, 9 );
                      '-' : myputimage( loop2, loop, 10 );
                      '_' : myputimage( loop2, loop, 11 );
                      '=' : myputimage( loop2, loop, 12 );
                      '+' : myputimage( loop2, loop, 13 );
                      '`' : myputimage( loop2, loop, 14 );
                      '~' : myputimage( loop2, loop, 15 );
                 end;
             end;
         end;
         pause:=readkey;
         cleardevice;
         pause:=readkey;
end;

procedure asmstore;
label     loo,lop;
begin
     asm
        push     ds              {must preserve ds       }

        mov      dx,3ceh         {graphics control regs  }
        mov      ax,5            {mode reg               }
        out      dx,ax
        mov      dx,3cfh         {graphics control regs  }
        mov      al,1
        out      dx,ax           {write mode reg         }

        mov      bx,0

        mov      ax,0a800h
        mov      ds,ax           {screen                 }
        mov      si,bx           {offset into screen     }

        mov      ax,0a7d0h
        mov      es,ax           {destination screen 0   }
        mov      di,0            {clear offset           }

        mov      cx,9            {9 images               }
lop:
        push     cx
        mov      cx,25
loo:
        push     cx
        mov      cx,3            {image width in bytes   }
        rep      movsb           {copy screen            }
        add      si,77
        pop      cx
        loop     loo

        pop      cx
        add      bx,3
        mov      si,bx
        loop     lop


        mov      dx,3ceh         {graphics control regs  }
        mov      ax,5            {get original reg value }
        out      dx,ax           {write mode reg         }
        mov      dx,3cfh         {graphics control regs  }
        xor      ax,0
        out      dx,ax           {write mode reg         }

        pop      ds
     end;
end;

procedure movenpc;
begin
     if sailing then exit;
     setactivepage(1);
     if gotprincess = 1 then begin
        if direction2=1 then begin
           putimage(((posY*24)-24),((posX*25)-25),invprincessup^,andput);
           putimage(((posY*24)-24),((posX*25)-25),princessup^,orput);
        end;
        if direction2=2 then begin
           putimage(((posY*24)-24),((posX*25)-25),invprincessleft^,andput);
           putimage(((posY*24)-24),((posX*25)-25),princessleft^,orput);
        end;
        if direction2=3 then begin
           putimage(((posY*24)-24),((posX*25)-25),invprincessright^,andput);
           putimage(((posY*24)-24),((posX*25)-25),princessright^,orput);
        end;
        if direction2=4 then begin
           putimage(((posY*24)-24),((posX*25)-25),invprincessdown^,andput);
           putimage(((posY*24)-24),((posX*25)-25),princessdown^,orput);
        end;
     end;
     if gotking = 1 then begin
        if direction2=1 then begin
           putimage(((posY*24)-24),((posX*25)-25),invkingup^,andput);
           putimage(((posY*24)-24),((posX*25)-25),kingup^,orput);
        end;
        if direction2=2 then begin
           putimage(((posY*24)-24),((posX*25)-25),invkingleft^,andput);
           putimage(((posY*24)-24),((posX*25)-25),kingleft^,orput);
        end;
        if direction2=3 then begin
           putimage(((posY*24)-24),((posX*25)-25),invkingright^,andput);
           putimage(((posY*24)-24),((posX*25)-25),kingright^,orput);
        end;
        if direction2=4 then begin
           putimage(((posY*24)-24),((posX*25)-25),invkingdown^,andput);
           putimage(((posY*24)-24),((posX*25)-25),kingdown^,orput);
        end;
     end;
     setactivepage(0);
     square := smallmap[ posYY, posXX ];
end;

{procedure erasenpc;
begin
     if ((halfy=posyy)and(halfx=posxx)and(direction<>1)) then exit;
     square:=smallmap[posYY,posXX];
     case square of
          '!' : myputimage( posYY-1, posXX-1, 1 );
          '@' : myputimage( posYY-1, posXX-1, 2 );
          '#' : myputimage( posYY-1, posXX-1, 3 );
          '$' : myputimage( posYY-1, posXX-1, 4 );
          '%' : myputimage( posYY-1, posXX-1, 5 );
          '^' : myputimage( posYY-1, posXX-1, 6 );
          '&' : myputimage( posYY-1, posXX-1, 7 );
          '*' : myputimage( posYY-1, posXX-1, 8 );
          '(' : myputimage( posYY-1, posXX-1, 9 );
          '-' : myputimage( posYY-1, posXX-1, 10 );
          '_' : myputimage( posYY-1, posXX-1, 11 );
          '=' : myputimage( posYY-1, posXX-1, 12 );
          '+' : myputimage( posYY-1, posXX-1, 13 );
          '`' : myputimage( posYY-1, posXX-1, 14 );
          '~' : myputimage( posYY-1, posXX-1, 15 );
     end;
end;
}
procedure F1message;
begin
     SetTextStyle( 2, 0, 5 );
     OutTextXY( 32, 330, 'F1-Status Screen  F2-Turn Scroll      F3-Turn Sound      F10-Quit to DOS' );
     if scrollon=1 then
        outtextxy( 287, 330, 'Off') else
        outtextxy( 287, 330, 'On' );
     if soundon=1 then
        outtextxy( 441, 330, 'Off') else
        outtextxy( 441, 330, 'On' );
end;

procedure stop;
begin
     closegraph;
     writeln('MESSAGE FROM DARREN RANALLI, THE AUTHOR OF DEMONITION:                         ');
     writeln('   Thank you for playing Demonition!  I hope you enjoyed it.  I put a lot of   ');
     writeln('time and effort into the production, and I would enjoy hearing any comments or ');
     writeln('suggestions from you.  If you had fun playing Demonition, then it was worth the');
     writeln('effort of creating it.  It took me several years to create it.  I started it at');
     writeln('the age of 12, and worked on it around my busy schedule.  I am active as an    ');
     writeln('actor, clarinet player, singer, and programmer.  I am now 15 years old, and an ');
     writeln('honors student in high school.  I have not, as of yet, taken any computer      ');
     writeln('courses--I taught myself.');
     writeln('   Again, I would love to hear any comments or suggestions about Demonition. If');
     writeln('you feel that a small token of appreciation is in order, it would be greatly   ');
     writeln('appreciated.  Feel free to distribute this game in its original form--please do');
     writeln('not make any changes to this game.  I strongly encourage you to give it to all ');
     writeln('of your friends!');
     writeln('');
     writeln('   I can be reached at:');
     writeln('');
     writeln('     Darren Ranalli');
     writeln('     5 Williams Circle');
     writeln('     Burlington, MA 01803');
     writeln('');
     writeln('   Thanks, and enjoy the game!');
     pause := readkey;
     restorekeyhand;
     halt;
end;

end.