#define FPS 25

class FPS_Limiter // A simple FPS limiter, it uses the value defined above
{
	private:
		int last_time;
		
	public:
		FPS_Limiter();
		void Limit();
};

FPS_Limiter::FPS_Limiter()
{
	last_time = SDL_GetTicks();
}

void FPS_Limiter::Limit()
{
	int timenow = SDL_GetTicks();
	
	if (timenow - last_time < (1.0/(float)FPS)*1000)
		SDL_Delay((int)((1.0/(float)FPS)*1000 - (timenow - last_time)));
	
	last_time = SDL_GetTicks();
}
