#include "main.h"

#define STRUKTURES 5

class kommando
{
	private:
		int beginning;
		SDL_Surface *temp;
		SDL_Surface *komm;
		SDL_Surface *ouro_b;
		SDL_Surface *ouro_w;
		
		Mix_Chunk *noise;
		Mix_Chunk *ambient;
		
		SDL_Rect dst;
		SDL_Rect src;
		
		int tempe;
		
		struct kuva
		{
			SDL_Surface *surface;
			int last_x, last_y;
			int current_x, current_y;
		};
		
		kuva kuvat[STRUKTURES];
		
		int beginning2;
		
	public:
		void piirra();
		void lataa_kuvat();
		void loadplay_audio();
		void clear();
		bool piirranx();
		void flush();
		kommando();
};

kommando::kommando()
{
	
	tempe = 666;
	beginning = SDL_GetTicks();
	
	for (int i = 0; i < STRUKTURES; i++)
	{
		kuvat[i].last_x = 0;
		kuvat[i].last_y = 0;
		kuvat[i].current_x = 0;
		kuvat[i].current_y = 0;
	}
	
	
	lataa_kuvat();
	
	kuvat[2].current_x = 200;
	kuvat[2].current_y = 200;
	beginning2 = 0;
}


void kommando::lataa_kuvat()
{
	kuvat[1].surface = IMG_Load("data/mmh.png");
	kuvat[2].surface = IMG_Load("data/arrow.png");
	kuvat[3].surface = IMG_Load("data/swastika.png");
	kuvat[4].surface = IMG_Load("data/riimu.png");

	SDL_SetColorKey( kuvat[2].surface, SDL_SRCCOLORKEY, SDL_MapRGB(kuvat[2].surface->format,0,0,0));
	SDL_SetColorKey( kuvat[3].surface, SDL_SRCCOLORKEY, SDL_MapRGB(kuvat[3].surface->format,255,255,255));
}

void kommando::piirra()
{
	
	if (SDL_GetTicks() - beginning > 15000 || tempe == 667)
	{
		if (tempe == 666)
		{
			beginning2 = 0;
			beginning = SDL_GetTicks();
			tempe++;
		}
		clear();
	}
	else
	{
	
	Uint8 *p = (Uint8 *)screen->pixels;
	
	
	for (int i = 0; i < (SDL_GetTicks()-beginning)/2; i++)
	if (SDL_GetTicks() - beginning > 2000)
	{
		if (rand()%2 == 1)
		{
			*(Uint32 *)(p + rand()%S_HEIGHT * screen->pitch + (rand()%S_WIDTH << 2)) = SDL_MapRGB(screen->format,255,255,255);
		}
		else
			*(Uint32 *)(p + rand()%S_HEIGHT * screen->pitch + (rand()%S_WIDTH << 2)) = SDL_MapRGB(screen->format,0,0,0);
		
		Uint8 *p = (Uint8 *)kuvat[1].surface->pixels;
		
		if (rand()%2 == 1)
		{
			*(Uint32 *)(p + rand()%kuvat[1].surface->h * kuvat[1].surface->pitch + (rand()%kuvat[1].surface->w << 2)) = SDL_MapRGB(screen->format,255,255,255);
		}
		else
			*(Uint32 *)(p + rand()%kuvat[1].surface->h * kuvat[1].surface->pitch + (rand()%kuvat[1].surface->w << 2)) = SDL_MapRGB(screen->format,0,0,0);
		
		p = (Uint8 *)kuvat[2].surface->pixels;
		
		if (rand()%2 == 1)
		{
			*(Uint32 *)(p + rand()%kuvat[2].surface->h * kuvat[2].surface->pitch + (rand()%kuvat[2].surface->w << 2)) = SDL_MapRGB(kuvat[2].surface->format,255,255,255);
		}
		else
			*(Uint32 *)(p + rand()%kuvat[2].surface->h * kuvat[2].surface->pitch + (rand()%kuvat[2].surface->w << 2)) = SDL_MapRGB(kuvat[2].surface->format,0,0,0);
	}
	
		SDL_BlitSurface(kuvat[1].surface, NULL, screen, NULL);
	
	kuvat[2].current_x = 500;
	kuvat[2].current_y = 200 + (int)(sin(SDL_GetTicks()/600.)*100.);

	dst.x = kuvat[2].current_x;
	dst.y = kuvat[2].current_y;
	
	SDL_BlitSurface(kuvat[2].surface, NULL, screen, &dst);
	}
}

void kommando::loadplay_audio()
{
	beginning = SDL_GetTicks();
	
	noise = Mix_LoadWAV("data/audioterror.ogg");
	ambient = Mix_LoadWAV("data/viking_tzaeru.ogg");
	
	if(!noise) {
    printf("Mix_LoadWAV: %s\n", Mix_GetError());
    // handle error
}

	
	if(Mix_PlayChannel(-1, noise, 0)==-1) {
    printf("Mix_PlayChannel: %s\n",Mix_GetError());
    // may be critical error, or maybe just no channels were free.
    // you could allocated another channel in that case...
		}
}

void kommando::clear()
{
	dst.x = 0;
	dst.y = 0;
	for (int i = 0; i < 30; i++)
	{
		if (i%2 == 1)
			dst.x = S_WIDTH - (int)((SDL_GetTicks()-beginning)/10.) + 100;
		else
			dst.x = (int)((SDL_GetTicks()-beginning)/10.) - 100;
		
		SDL_BlitSurface(kuvat[3].surface, NULL, screen, &dst);
		dst.y += 18;
	}
	
	if ((S_WIDTH - ((SDL_GetTicks()-beginning)/10.) + 100) - ((SDL_GetTicks()-beginning)/10. - 100) < -81)
	{
	if (beginning2 == 0)
	{
		beginning2 = SDL_GetTicks()-1;
		Mix_PlayChannel(-1, ambient, 0);
	}
	
	src.x = (int)(S_WIDTH - ((SDL_GetTicks()-beginning)/10.) + 100)+81;
	src.y = 0;
	src.w = (int)((SDL_GetTicks()-beginning)/10. - 100) - src.x;
	src.h = S_HEIGHT;
	
	dst.x = (int)(S_WIDTH - ((SDL_GetTicks()-beginning)/10.) + 100)+81;
	dst.y = 0;
	
	cout<<SDL_GetTicks()/1000<<"\n";
		
	SDL_BlitSurface(kuvat[4].surface, &src, screen, &dst);
	}
	

}

bool kommando::piirranx()
{
	if (tempe == 667)
		return 0;
	else
		return 1;
}

void kommando::flush()
{
	Mix_FreeChunk(noise);
	Mix_FreeChunk(ambient);
	noise = 0;
	ambient = 0;

}
