
/*
     
     
     PlayStation GsSprite sample source
     Released by HITMEN PSX DIVISION 1997

     This source code does *only* compile on the YAROZE GNU
     compiler & the appropriate libraries. 
     
     This is, however, a VERY VERY basic example of the Playstation and
     all its capabilities. We are just releasing this because we think
     that to many people got scared away by the insufficient documentation
     of the sources that have been spread yet. 

     We strictly recommend you to browse through the library reference (.pdf)
     files before coming up with questions email wise.
     

     HITMEN PSX DIVISION, 1997



*/

#include <libps.h>

#define PADLup     (1<<12)
#define PADLdown   (1<<14)
#define PADLleft   (1<<15)
#define PADLright  (1<<13)
#define PADRup     (1<< 4)
#define PADRdown   (1<< 6)
#define PADRleft   (1<< 7)
#define PADRright  (1<< 5)
#define PADi       (1<< 9)
#define PADj       (1<<10)
#define PADk       (1<< 8)
#define PADl       (1<< 3)
#define PADm       (1<< 1)
#define PADn       (1<< 2)
#define PADo       (1<< 0)
#define PADh       (1<<11)
#define PADL1      PADn
#define PADL2      PADo
#define PADR1      PADl
#define PADR2      PADm
#define PADstart   PADh
#define PADselect  PADk


#define OT_LENGTH  10  
GsOT WorldOT[2];
GsOT_TAG OTTags[2][1<<OT_LENGTH]; 

#define PACKETMAX 300             
PACKET GpuPacketArea[2][PACKETMAX*24];

#define SPRITEMAX 300             /* This should be more than enough */     
GsSPRITE Sprites[SPRITEMAX];           

#define TEX_ADDR   0x80180000    /* load your TIM to this adress */      
GsIMAGE TexInfo;                       

static u_long PadData;                                                 

volatile u_char *bb0,*bb1;


/* 
   'ONE' is a defined volatile constant and equates 4096 or 0x1000.
   It is used for fixpoint notation (rotation angle, scale percentage)
*/
   

main()
{
                
                
                GetPadBuf(&bb0,&bb1);
                PadData = 0 ;
                
                SetVideoMode(1);     /* 0=NTSC, 1=PAL */
                ResetGraph (0) ;
                GsInitGraph(320,240,0,0,0);
                GsDefDispBuff(0,0,0,240);
                SetDispMask(1);                

                WorldOT[0].length=OT_LENGTH;
                WorldOT[0].org=OTTags[0];
                WorldOT[1].length=OT_LENGTH;
                WorldOT[1].org=OTTags[1];
                
                GsInit3D(); 

                initTexture(TEX_ADDR);
                
                initSprite();
                

                /* main loop */
                
                while ((PadData & PADselect)==0) {
                moveSprite(); 
                drawAll();
                }
                  
                  ResetGraph(0);
                  return(0);

}



drawAll()
{
                int i;
                int activeBuff;
                
                
                
                activeBuff=GsGetActiveBuff();
                
                GsSetWorkBase((PACKET*)GpuPacketArea[activeBuff]);

                GsClearOt(0, 0, &WorldOT[activeBuff]);

                for(i = 0; i < SPRITEMAX; i++) {
                                GsSortSprite(&Sprites[i], &WorldOT[activeBuff], i+1);
                }
                /* This function registers the sprite drawing commands into
                   the Ordering Table (OT). The OT is the 'stack' that 
                   contains all the object that have to be drawn in the
                   next frame */
                                
                PadData = PadRead(1);  
                  

                VSync(0);     /* waits for vertical retrace */

                
                GsSwapDispBuff();                               
                
                GsSortClear(0, 0, 0, &WorldOT[activeBuff]);
                
                /* registers a CLEARSCREEN command into the OT */
                
                
                GsDrawOt(&WorldOT[activeBuff]);
}


moveSprite()
{
                
                if((PadData & PADRup)>0 & Sprites[1].scalex > ONE - 100*32 ){   
                                              Sprites[1].scalex -= 32;
                                              Sprites[1].scaley -= 32;
                                        }
                
                if((PadData & PADRdown)>0 & Sprites[1].scalex < ONE + 70*32 ){   
                                              Sprites[1].scalex += 32;
                                              Sprites[1].scaley += 32;
                                        }
                
                if((PadData & PADRleft)>0) Sprites[1].rotate -= ONE*3;
                
                if((PadData & PADRright)>0) Sprites[1].rotate += ONE*3;
                                                
              

                if((PadData & PADLright)>0) Sprites[1].x +=2;

                if((PadData & PADLleft)>0) Sprites[1].x -=2;
              

            

                if((PadData & PADLup)>0) Sprites[1].y -=2;

                if((PadData & PADLdown)>0) Sprites[1].y +=2;
              


}


initTexture(addr)
u_long *addr;

{               RECT rect1;
                
                addr++;

                GsGetTimInfo(addr, &TexInfo);
                
                rect1.x=TexInfo.px;
                rect1.y=TexInfo.py;
                rect1.w=TexInfo.pw;
                rect1.h=TexInfo.ph;

                LoadImage(&rect1,TexInfo.pixel);  
                /* dma xfer from memory to videoram */

}

initSprite()
{
                int i;
                u_long colorMode;
                u_short tPage;

                colorMode = TexInfo.pmode&0x03;
                
                tPage = GetTPage(0,0,TexInfo.px, TexInfo.py);
                       

                Sprites[1].attribute = (colorMode<<24);
                Sprites[1].w = 255;              
                Sprites[1].h = 155;
                
                Sprites[1].x = 0;
                Sprites[1].y = 0;
                
                Sprites[1].mx = 128;       /* center f. rotation/scaling */
                Sprites[1].my = 78;
                
                Sprites[1].tpage = tPage;
                
                
                Sprites[1].u = 0;        /* offset of the sprite INSIDE */
                Sprites[1].v = 0;        /* the 255X255 pixel TIM picture */
                
                
                Sprites[1].cx = TexInfo.cx;
                Sprites[1].cy = TexInfo.cy;
                
                Sprites[1].r = 0x80;
                Sprites[1].g = 0x80;
                Sprites[1].b = 0x80;
                
                Sprites[1].rotate = ONE*0;
                Sprites[1].scalex = ONE;
                Sprites[1].scaley = ONE;
                                
}

int PadRead(long id)
{
                return(~(*(bb0+3) | *(bb0+2) << 8 | *(bb1+3) << 16 | *(bb1+2) << 24));
}
