/*+--------+----------+----------+----------+----------+----------+---------+*/
/*                                                                           */
/* (w) Djax / High Society.            	                                     */
/*                                                                           */
/* Name:   main.c                                                            */                      
/* Author: Djax                                                              */                     
/* Date:   10/3/99                                                           */                       
/*                                                                           */
/* Description:                                                              */            
/*                                                                           */
/* Example to decrunch a HSC-crunched file to the specified adress   	     */
/*                                                                           */
/*+--------+----------+----------+----------+----------+----------+---------+*/

/*******GLOBAL INCLUDES *****************************************/

#include <sys/types.h>
#include <libetc.h>
#include <libgte.h>
#include <libgpu.h>
#include <libgs.h>
#include <kernel.h>
#include <stdio.h>
#include <depackhs.h>
#include <all.h>

#include "pad.h"

/****************************************************************
 *							        *
 *  **  **  ****  *****  **  ****  *****  **     ****** **  **  *
 *  **  ** **  ** **  ** ** **  ** **  ** **     **     *** **  *
 *  **  ** ****** *****  ** ****** *****  **     ****   ******  *
 *   ****  **  ** **  ** ** **  ** **  ** **     **     ** ***  *
 *    **   **  ** **  ** ** **  ** *****  ****** ****** **  **  *
 *  						        	*
 ****************************************************************/
#define SCREEN_WIDTH    320               	// Screen Size X
#define SCREEN_HEIGHT   256			// Screen Size Y

#define OT_LENGTH        14                     // OT lenght
#define PACKETMAX       (10000)                 // max obj #
#define PACKETMAX2      (PACKETMAX*24)          // (psx voodoo, multiply by 24)

GsOT      WorldOrderingTable[2];                // OT handlers
GsOT_TAG  OrderingTable[2][1<<OT_LENGTH];	// OT
PACKET    GPUOutputPacket[2][PACKETMAX2];       // GPU packet work area

u_long PadData;                                 // Joypad status               
u_long OldPadData;                                 // Joypad status               

// External Stuff
extern unsigned char Exeobj1[];

int print(char *format, ...);
/****************************************************************
 *      						        *
 *	**   **  ****  ** **  **			        *
 *      *** *** **  ** ** *** **			        *
 *      ******* ****** ** ******			        *
 *      ** * ** **  ** ** ** ***			        *
 *      **   ** **  ** ** **  **			        *
 *      						        *
 ****************************************************************/
/****************************************************************
 PROC:  main\
 ****************************************************************/
int main(void)
{
int fb,s,rf,cr;
u_long size;

   ResetCallback();
   SetVideoMode(MODE_PAL);
   ResetGraph(0);
   SetGraphDebug(0);	
   GsInitGraph(320, 256, GsOFSGPU|GsNONINTER, 0, 0);
   GsDefDispBuff(0, 0, 0, 256);

   WorldOrderingTable[0].length = OT_LENGTH;
   WorldOrderingTable[1].length = OT_LENGTH;
   WorldOrderingTable[0].org = OrderingTable[0];
   WorldOrderingTable[1].org = OrderingTable[1];

   FntLoad(320, 0);        
   s=FntOpen(8, 0, 312, 248, 0, 1500);        
 
   // Is Object HSC crunched
   rf=HSC_checkident(Exeobj1);

   // Get decrunched object size (....useful to allocate memory!)

   size=HSC_depacksize(Exeobj1);
   // decrunch file to 0x800a6714 (or to a free mem-pointer)
   
   cr=HSC_decrunch(Exeobj1,(unsigned char*)0x800a6014);

   //Initialize Joypad (1)	
   PadInit(0);
   PadData=0 ;

while(1)
  {
  u_long pad;

  pad=PadRead(0);

  while(PadRead(0));

  if (pad&Pad1x) goto end;
  
  fb = GsGetActiveBuff();
  GsSetWorkBase((PACKET*)GPUOutputPacket[fb]);
  GsClearOt(0, 0, &WorldOrderingTable[fb]);

  FntPrint(s,"\n\n");

  if (rf==0)
  {
    FntPrint(s,"file is HSC-crunched\n\n");
    FntPrint(s,"depacked filesize: %d bytes.\n",size);
  }
  else 
    FntPrint(s,"file is not HSC-crunched\n");

  FntPrint(s,"\n\n");

  if (cr==0)
    FntPrint(s,"file decrunched successful. %d\n",cr); // Write Returncode too
  else 
    FntPrint(s,"error on decrunching file. %d\n",cr);  // Write Returncode too

  FntPrint(s,"\n\n\n\n");
  FntFlush(-1);
		
				
  DrawSync(0);
  VSync(0);

  GsSwapDispBuff();
		
  GsSortClear(0, 0, 0, &WorldOrderingTable[fb]);   
					     
  GsDrawOt(&WorldOrderingTable[fb]);
  }

end:

	PadStop();
	StopCallback();
	ResetGraph(3);


return (0);
}

int print(char *format, ...) {

        asm("addiu $9,$0,0x3f");
        asm("addiu $10,$0,0xa0");
        asm("jr $10");
        asm("nop");
}
