# ----------------------------------------------------------------------------
# - Psymake Makefile
# ----------------------------------------------------------------------------

ASM		= asmpsx
CC		= ccpsx
LINK		= psylink

# ----------------------------------------------------------------------------

# Add NTSC definition to compile for NTSC (undefined for PAL).
# Add TESTING definition for debug information while playing the movie.
# Add FIND_VLCBUF definition to find maximum runlevel.


# Define to compile final version. If defined removes all pollhosts, set 2MB
# and ramsize. Else use pollhosts and 8MB for development. 
CCOPTS		= -Wunused -comments-c++ -c -O3 -DFINAL -I.. -I.


# Define to compile with debug.
#CCOPTS		= -Wunused -comments-c++ -c -g -I.. -I. -DDEBUG


#ASMOPTS	= /l /o c+,h+,at- /zd
ASMOPTS	        = /l /c

LINKOPTS	= /m /c /g 
#LINKOPTS	= /m

# ------------------------------------------------------------------------------

OBJDIR		= obj

# ----------------------------------------------------------------------------

OBJS		= obj\main.obj obj\data.obj

# ----------------------------------------------------------------------------

all: main.cpe
	
obj\main.obj: main.c
	$(CC) $(CCOPTS) main.c -o$(OBJDIR)\main.obj

obj\data.obj : data.s
	$(ASM) $(ASMOPTS) data.s,$(OBJDIR)\data.obj

# ------------------------------------------------------------------------------

main.cpe: $(OBJS) main.lnk makefile 
	$(LINK) $(LINKOPTS) @main.lnk,main.cpe,main.sym,main.map

# ----------------------------------------------------------------------------

bk:
	copy *.h	backup
	copy *.c	backup
	copy *.s	backup
	copy *.bat	backup
	copy makefile	backup
	copy *.mak	backup
	copy *.lnk	backup
	copy *.txt	backup
	copy *.cnf	backup
		
# ------------------------------------------------------------------------------

clean:
	del *.exe
	del *.cpe
	del $(OBJDIR)\*.obj
	del *.sym
	del *.map

# ------------------------------------------------------------------------------
