/*
 * static.c
 *
 * Contains static display lists for morphdemo.c
 *
 * Some defines like DOMM and DOLIGHTING are leftovers from morphcube
 * they probably don't work properly anymore.
 */

#include "demo.h"

/*  Z-buffer.  Defined in zbuf.c */
extern unsigned short zbuffer[];

/*
 * Remember, viewport structures have 2 bits of fraction in them.
 */
static Vp vp = {
	SCREEN_WD*2, SCREEN_HT*2, G_MAXZ/2, 0,	/* scale */
	SCREEN_WD*2, SCREEN_HT*2, G_MAXZ/2, 0,	/* translate */
};

/*
 * Display list to initialize the RSP state
 */
Gfx rspinit_dl[] = {
    gsSPViewport(&vp),
    gsSPClearGeometryMode(G_SHADE | G_SHADING_SMOOTH | G_CULL_BOTH |
			  G_FOG | G_LIGHTING | G_TEXTURE_GEN |
			  G_TEXTURE_GEN_LINEAR | G_LOD ),
    gsSPTexture(0, 0, 0, 0, G_OFF),
    gsSPSetGeometryMode(G_SHADE | G_SHADING_SMOOTH | G_ZBUFFER),
    gsSPEndDisplayList(),
};

/*
 * Light -- only needed if lighting is turned on
 */
//0x20 0xcf
Lights1 thelight = gdSPDefLights1(0x40, 0x40, 0x40,  /* Ambient */
				  0xff, 0xff, 0xff,  /* Color? */
				  -90, 0x00, 90   /* norm'd Normal */
				  );

/*
 * Display list to initialize the RDP state
 * Some init is also done in the screen clear display list, and in
 * morphdemo.c
 */
 
Gfx rdpinit_dl[] = {
    gsDPSetCycleType(G_CYC_1CYCLE),
    gsDPPipelineMode(G_PM_1PRIMITIVE), /* Don't pipeline primitives */
    gsDPSetScissor(G_SC_NON_INTERLACE, 0, 0, SCREEN_WD, SCREEN_HT),
    /*
     * Various texture commands.  They're harmless if we don't do texturing
     */
    gsDPSetTextureLOD(G_TL_LOD),       /* Choose tile # based on LOD */
//    gsDPSetTextureLOD(G_TL_TILE),      /* Use tile # as is */
    gsDPSetTextureLUT(G_TT_NONE),      /* Disable color lookup table */
    gsDPSetTextureDetail(G_TD_CLAMP),  /* No sharpen or detail */
    gsDPSetTexturePersp(G_TP_PERSP),   /* Use s,t persp correction */
    gsDPSetTextureFilter(G_TF_BILERP), /* Bilinear interpolation   */
    gsDPSetTextureConvert(G_TC_FILT),  /* No YUV conversion stuff  */
    gsDPSetCombineKey(G_CK_NONE),      /* ?? */
    gsDPSetAlphaCompare(G_AC_NONE),    /* No alpha compare */
    /*
     * Turn dithering on or off.  Note that on HW2 where dithering works
     * better it might make sense to turn in on even when lighting is off.
     * Right now it doesn't look so good, but it's necessary when you're
     * lighting to avoid horrible banding effects.
     */
    gsDPSetColorDither(G_CD_ENABLE),   /* Turn on dithering */
//    gsDPSetColorDither(G_CD_DISABLE),  /* Turn off dithering */
    /*
     * Set color combiner modes and load light if appropriate
     */
    /* Load the light */
    gsSPSetLights1(thelight),
    /* lighting; texture w/trilinear mipmapping */
    gsDPSetCombineMode(G_CC_TRILERP, G_CC_MODULATERGB2),
    /* lighting; texture w/o mipmapping */
//    gsDPSetCombineMode(G_CC_DECALRGBA, G_CC_DECALRGBA),
    /* lighting; no texture */
//    gsDPSetCombineMode(G_CC_SHADE, G_CC_SHADE),

    gsDPPipeSync(),
    gsSPEndDisplayList(),
};

/*
 * Display list to Clear the CFB and Zbuf
 * A gDPSetColorImage must be done before this display list is called,
 * (and afterwards as well before drawing).
 * We also set the cycle mode and rendering mode to use for drawing later
 */
Gfx scrnclr_dl[] = {
  gsDPPipeSync(), /* Not sure if necessary */
  gsDPSetCycleType(G_CYC_FILL),
  /* When in fill mode, must not have AA or ZBUF bits set */
  gsDPSetRenderMode(G_RM_OPA_SURF, G_RM_OPA_SURF2),
  /* Clear color; coverage = 1 */
  gsDPSetFillColor(GPACK_RGBA5551(0x00,0x00,0x00,1) << 16 |
		   GPACK_RGBA5551(0x00,0x00,0x00,1)),
  gsDPFillRectangle(0, 0, SCREEN_WD-1, SCREEN_HT-1),
  gsDPNoOp(),    /* Necessary ? */
  gsDPPipeSync(), 
  /* Clear Z, z = max z, dz = 0 */
  gsDPSetColorImage(G_IM_FMT_RGBA, G_IM_SIZ_16b, SCREEN_WD,
		    OS_K0_TO_PHYSICAL(zbuffer)),
  gsDPSetFillColor(GPACK_ZDZ(G_MAXFBZ, 0) << 16 | GPACK_ZDZ(G_MAXFBZ, 0)),
  gsDPFillRectangle(0, 0, SCREEN_WD-1, SCREEN_HT-1),
  gsDPNoOp(),  /* Necessary ? */
  gsDPPipeSync(),
  /*
   * Set cycle mode to use for rendering
   */
  gsDPSetCycleType(G_CYC_2CYCLE),  /* Put into 2-cycle mode */
//  gsDPSetCycleType(G_CYC_1CYCLE),  /* Put into 1-cycle mode */
  /*
   * Set rasterization mode for triangles
   * Mode = Anti-aliased, Z-buffered, opaque surfaces
   */
  /* ..._TERR2 looks a little better than ..._SURF2 because the non-silhouette
   * edges are anti-aliased better.
   */
  gsDPSetRenderMode(G_RM_PASS, G_RM_AA_ZB_OPA_TERR2),
  /* No Z-buffering: Doesn't look quite as good, but runs faster */
//  gsDPSetRenderMode(G_RM_PASS, G_RM_AA_OPA_SURF2),
  gsSPEndDisplayList()
};
