
sampler s0 : register(s0);
sampler s1 : register(s1);
sampler s2 : register(s2);
sampler s3 : register(s3);
sampler s4 : register(s4);
sampler s5 : register(s5);
sampler s6 : register(s6);

float4 one = {1,1,1,1};

float r_texdx_1 = 0;
float r_texdx_0 = 0;
float r_texdx_4 = 0;

float r_frame_dt = 0;

struct VS_TASK_INPUT
{
    float4 m_position		: POSITION;
    float2 m_texture		: TEXCOORD0;
};

VS_TASK_INPUT task_vs(const VS_TASK_INPUT v)
{
    VS_TASK_INPUT o = (VS_TASK_INPUT) 0;

	o.m_position = float4(v.m_position.xy, 0.5, 1.0);
    o.m_texture  = float4(v.m_texture, v.m_position.xy);
  
    return o;
}


////////////////////////////////////////////////////////////////////////////
// bbox calculation
////////////////////////////////////////////////////////////////////////////

float4 groups_bb_min_task_ps(in float2 t : TEXCOORD0) : COLOR
{
	float4 group_address = tex2D(s0, t);
	float4 group_header = tex2D(s1, group_address.xy);
	
	float4 result = float4(100000.0f, 100000.0f, 100000.0f, 100000.0f);
	
	float last_pos_x = group_header.y * r_texdx_1 + group_header.w;
	[loop] for (float pos_x = group_header.w; pos_x < last_pos_x - 0.01 * r_texdx_1; pos_x = pos_x + r_texdx_1)
	{
		float4 pos_address = tex2Dlod(s1, float4(pos_x, group_address.y, 0, 0));
		float4 pos = tex2Dlod(s2, float4(pos_address.xy, 0, 0));
		
		result = min(result, pos);
	}
	
	return result;
}

technique groups_bb_min_task < string params = "r_texdx_1"; string vertex = "position texture"; >
{
	pass P0
	{
        VertexShader = compile vs_3_0 task_vs();
		PixelShader = compile ps_3_0 groups_bb_min_task_ps();
	    CullMode = NONE;
		ZEnable = FALSE;
	}
}


float4 groups_bb_max_task_ps(in float2 t : TEXCOORD0) : COLOR
{
	float4 group_address = tex2D(s0, t);
	float4 group_header = tex2D(s1, group_address.xy);
	
	float4 result = -float4(100000.0f, 100000.0f, 100000.0f, 100000.0f);
	
	float last_pos_x = group_header.y * r_texdx_1 + group_header.w;
	[loop] for (float pos_x = group_header.w; pos_x < last_pos_x - 0.01 * r_texdx_1; pos_x = pos_x + r_texdx_1)
	{
		float4 pos_address = tex2Dlod(s1, float4(pos_x, group_address.y, 0, 0));
		float4 pos = tex2Dlod(s2, float4(pos_address.xy, 0, 0));
		
		result = max(result, pos);
	}
	
	return result;
}

technique groups_bb_max_task < string params = "r_texdx_1"; string vertex = "position texture"; >
{
	pass P0
	{
        VertexShader = compile vs_3_0 task_vs();
		PixelShader = compile ps_3_0 groups_bb_max_task_ps();
	    CullMode = NONE;
		ZEnable = FALSE;
	}
}

////////////////////////////////////////////////////////////////////////////
// groups bbox collisions
////////////////////////////////////////////////////////////////////////////

float test_intersection(float s1, float e1, float s2, float e2)
{
	float lmax = (e1 - s1) + (e2 - s2);
	
	float smin = min(s1, s2);
	float emax = max(e1, e2);
	float l = emax - smin;

	return lmax - l;
}

float4 groups_collision_task_ps(in float2 t : TEXCOORD0) : COLOR
{
	float4 pair = tex2D(s0, t);
	
	float4 ret = float4(1,1,1,1);
		
	if (any(pair - float4(0.99, 0.99, 0.99, 0.99)))
	{
		float4 bbmin1 = tex2D(s1, pair.xy);
		float4 bbmin2 = tex2D(s1, pair.zw);
		float4 bbmax1 = tex2D(s2, pair.xy);
		float4 bbmax2 = tex2D(s2, pair.zw);
		
		if (test_intersection(bbmin1.x, bbmax1.x, bbmin2.x, bbmax2.x) < 0)
		{
			ret = float4(-1, -1, -1, -1);
		}
		
		if (test_intersection(bbmin1.y, bbmax1.y, bbmin2.y, bbmax2.y) < 0)
		{
			ret = float4(-1, -1, -1, -1);
		}
		
		if (test_intersection(bbmin1.z, bbmax1.z, bbmin2.z, bbmax2.z) < 0)
		{
			ret = float4(-1, -1, -1, -1);
		}
	}
	
	return  ret;
}

technique groups_collision_task < string params = "r_texdx_1"; string vertex = "position texture"; >
{
	pass P0
	{
        VertexShader = compile vs_3_0 task_vs();
		PixelShader = compile ps_3_0 groups_collision_task_ps();
	    CullMode = NONE;
		ZEnable = FALSE;
	}
}

////////////////////////////////////////////////////////////////////////////
// groups bbox collisions
////////////////////////////////////////////////////////////////////////////

float4 get_point(float4 a, float4 b, float4 n)
{
	float t = (n.w - dot(a.xyz, n.xyz)) / dot(b.xyz - a.xyz, n.xyz);
	
	return float4((a + t*(b-a)).xyz, t);
}

bool test_range(float t)
{
	bool ret = true;
	
	if (t < 0.01)
		ret = false;
		
	if (t > 0.99)
		ret = false;

	return ret;
}

bool test_collision(float t1, float t2, float t3)
{
	int test = 0;
	
	if (test_range(t1))
		test++;

	if (test_range(t2))
		test++;

	if (test_range(t3))
		test++;

	return test > 1;
}

bool test_ranges(float a1, float b1, float a2, float b2)
{
	float d = b1 - a1;
	float t1 = (a2 - a1) / d;
	float t2 = (b2 - a1) / d;
	
	bool ret = false;
	
	if (test_range(t1))
		ret = true;
		
	if (test_range(t2))
		ret = true;
		
	if ((t1 < 0.01) == (t2 > 0.99))
		ret = true;
		
	return ret;
}

float4 triangle_collision_task_ps(in float2 t: TEXCOORD0) : COLOR
{
	float4 coords = tex2Dlod(s0, float4(t,0,0));
	float4 tri1x = tex2D(s4, float2(coords.z, 0));

	return float4(tri1x.xyz, coords.z); 
}

technique triangle_collision_task < string params = "r_texdx_4"; string vertex = "position texture"; >
{
	pass P0
	{
        VertexShader = compile vs_3_0 task_vs();
		PixelShader = compile ps_3_0 triangle_collision_task_ps();
	    CullMode = NONE;
		ZEnable = FALSE;
	}
}

float4 stex(sampler s, float2 t)
{
	float2 tc = float2(0, 0);
	
	if (t.x > -1)
	{
		tc = t;
		return tex2Dlod(s, float4(t, 0, 0));
	}
	else
		return float4(0, 0, 0, 0);
		
}

float4 test_ps(in float2 t: TEXCOORD0) : COLOR
{
	float4 coords = tex2D(s0, t);
	
/*	float z = 0;
	if (coords.z > 0)
		z = coords.z + 0.0001;
*/		
	float coordx = t.x + (coords.z) * r_texdx_4;
	float4 tri1x = stex(s4, float2(coordx, 0));

	return float4(tri1x.xyz, coordx);
}

technique test_ps_task < string params = "r_texdx_4 r_texdx_0"; string vertex = "position texture"; >
{
	pass P0
	{
        VertexShader = compile vs_3_0 task_vs();
		PixelShader = compile ps_3_0 test_ps();
	    CullMode = NONE;
		ZEnable = FALSE;
	}
}
