{///////////////////////////////////////////////////////////////////////////}
{ Ca y est...  je  me suis  dcid   mettre  le source  de MEGSCROL dans le
  domaine public!  A mon point  de vue,  c'est  un petit programme assez peu
  important,  mais c'est a priori  susceptible  d' intresser  quelques  uns
  d'entre vous.  Ceux-ci  sont  videmment  curieux  de savoir  comment "a"
  marche! En fait, c'est relativement simple (une fois  que l'on a visualis
  le fichier PCX), sauf peut-tre en ce qui concerne  la partie graphique en
  BASM.  J'ai fait un effort violent  en rcrivant  les routines SB pour le
  DMA  entirement  en TP ( l'origine c'est en BASM et pour toute ligne IRQ
  et canal DMA,  et avec  une relle dtection automatique du port). Voil!,
  sachez donc tirer profit  de ce petit cadeau  et vitez de faire partie du
  club  trs large  des  LAMERS  en "pompant"  btement  et en changeant les
  textes des messages...

  Pour  de  plus  amples  informations,  d'ventuelles suggestions,  ou tout
  simplement pour le fun, vous pouvez m'crire  l'adresse suivante:

                               Patrick Ruelle
                         43, av. de Grande Bretagne
                                98000 Monaco
                            Principaut de Monaco

  Evidemment  je n'ai pas pris  la dcision  de diffuser  ce source  dans le
  but de demander de l'argent,  mais il va de soit que toutes sortes de dons
  sont accepts (carte  postale,  matos,  argent, spcialits locales, docs,
  etc...).  N'oubliez pas non plus que cette diffusion ne m'enlve nullement
  mes  droits d'auteur  de cette mmm... de dmo;  ce petit package peut tre
  diffus librement  condition de rester sous sa forme initiale:

 MEGSCROL.EXE  27/07/94  12208 L'excutable utilisant MEGIMG et MEGSCROL.DGT
 MEGSCROL.PAS  27/07/94  20923 Le source principal de la dmo
 SB_DMA2 .PAS  27/07/94   6805 Le source des routines DMA pour la SB
 MEGSCROL.PCX  03/06/93  31894 L'image des polices au format PCX
 MEGSCROL.RAW  27/07/94  64768    "     "     "    en format brut (img+pal)
 MEGSCROL.DGT  03/06/94  41736 Le pattern sonore rptitif
                        ------
               TOTAL    178334

  La version  actuelle  est remanie exprs pour la diffusion de ce package,
  mais en fait ce programme date de dbut 1993...

                                          Patrick Ruelle (Monac) / GRYPHAEA }
{///////////////////////////////////////////////////////////////////////////}
UNIT SB_DMA2;{Uniquement pour IRQ=7 et DMA=1,  mais facilement adaptable}
             {pour un autre IRQ et DMA. La dtection automatique du port}
             {de base se fait en testant les Dizaines avec InitDSP.     }
INTERFACE


VAR
 s  :Pointer;
 sze:WORD;


FUNCTION  InitDSP(base:WORD):BOOLEAN;
PROCEDURE SpeakerON;
PROCEDURE SpeakerOFF;
PROCEDURE ArreteDMA;
PROCEDURE InitPlayback;
PROCEDURE FinPlayBack;


IMPLEMENTATION


USES Crt,Dos;


VAR
 DSP_RESET,DSP_READ_DATA,
 DSP_WRITE_DATA,
 DSP_WRITE_STATUS,
 DSP_DATA_AVAIL          :WORD;
 OldIRQ                  :Pointer;


FUNCTION InitDSP(base:WORD):BOOLEAN; {1<=base<=6 correspond  210h  260h}
BEGIN
  base:=base*$10;
  {Calculs des adresses utiles}
  DSP_RESET       :=base+$206;
  DSP_READ_DATA   :=base+$20A;
  DSP_WRITE_DATA  :=base+$20C;
  DSP_WRITE_STATUS:=base+$20C;
  DSP_DATA_AVAIL  :=base+$20E;
  {Reinitialise le DSP}
  Port[DSP_RESET]:=1;
  Delay(30);
  Port[DSP_RESET]:=0;
  Delay(30);
  IF (Port[DSP_DATA_AVAIL] AND $80=$80) AND (Port[DSP_READ_DATA]=$AA) THEN
    InitDSP:=True
  ELSE
    InitDSP:=False;
END;


PROCEDURE EcritDSP(valeur:BYTE);
BEGIN
  WHILE Port[DSP_WRITE_STATUS] AND $80<>0 DO;
  Port[DSP_WRITE_DATA]:=valeur;
END;


FUNCTION LitDSP:BYTE;
BEGIN
  WHILE Port[DSP_DATA_AVAIL] AND $80=0 DO;
  LitDSP:=Port[DSP_READ_DATA];
END;


PROCEDURE EcritDAC(Commande:BYTE);
BEGIN
  EcritDSP($10);
  EcritDSP(Commande);
END;


FUNCTION LitDAC:BYTE;
BEGIN
  EcritDSP($20);
  LitDAC:=LitDSP;
END;


PROCEDURE SpeakerON;
BEGIN
  EcritDSP($D1);
END;


PROCEDURE SpeakerOFF;
BEGIN
  EcritDSP($D3);
END;


PROCEDURE ArreteDMA;
BEGIN
  EcritDSP($D0);
END;


PROCEDURE Playback;INTERRUPT; {Routine greffe sur l'IRQ dclenche par le}
VAR page,offset:WORD;         {DSP de la carte SoundBlaster en fin de DMA }
    recu       :BYTE;
BEGIN
  {Accus de rception}
  recu:=Port[DSP_DATA_AVAIL];
  {Calcul de l'adresse Physique et Page de la sequence}
  sze:=41735;          { ce niveau la taille est dja ajuste  -1}
  offset:=Seg(s^) SHL 4+Ofs(s^);
  page  :=(Seg(s^)+Ofs(s^) SHR 4) SHR 12;
  {Prparation du DMAC pour le transfert}
  Port[$0A]:=5;         {5=4+CanalDMA; donc 7=DMA3}
  Port[$0C]:=0;
  Port[$0B]:=$49;       {Via DAC}
  Port[$02]:=Lo(offset);{06 pour DMA3}
  Port[$02]:=Hi(offset);{06 pour DMA3}
  Port[$83]:=page;
  Port[$03]:=Lo(sze); {07 pour DMA3}
  Port[$03]:=Hi(sze); {07 pour DMA3}
  Port[$0A]:=1;         {Canal DMA}
  {Activation du transfert par le DAC}
  EcritDSP($14);
  EcritDSP(Lo(sze));
  EcritDSP(Hi(sze));
  {Actualisation de la squence  jouer; ici on est en tche de fond}
  {Avis de fin d'interruption au contrleur d'INT}
  Port[$20]:=$20;
END;


PROCEDURE ActiveIRQ(i:WORD);
BEGIN
  IF i<8 THEN
    PORT[$21]:=PORT[$21] AND (NOT (1 SHL i))
  ELSE
  BEGIN
    PORT[$A1]:=PORT[$A1] AND (NOT (1 SHL (i-8)));
    PORT[$21]:=PORT[$21] AND (NOT (1 SHL 2));
  END;
END;


PROCEDURE DesactiveIRQ(i:WORD);
BEGIN
  IF i<8 THEN
    PORT[$21]:=PORT[$21] OR (1 SHL i)
  ELSE
  BEGIN
    PORT[$A1]:=PORT[$A1] OR (1 SHL (i-8))
  END;
END;


FUNCTION ChangeVecteurIRQ(i:WORD; Vec:POINTER):POINTER;
VAR
 p:POINTER;
 j:WORD;
BEGIN
  IF i<8 THEN
    j:=i+$08
  ELSE
    j:=i+$68;
  GetIntVec(j,p);
  SetIntVec(j,Vec);
  ChangeVecteurIRQ:=p;
END;


PROCEDURE InitPlayback;
VAR time_constant:WORD;
    page,offset,
    taille       :WORD;
BEGIN
  {Dfinit la frquence}
  time_constant:=256-1000000 DIV 11000; {11Khz}
  EcritDSP($40);
  EcritDSP(time_constant);
  SpeakerON;
  taille:=41735;
  offset:=Seg(s^) SHL 4+Ofs(s^);
  page  :=(Seg(s^)+Ofs(s^) SHR 4) SHR 12;
  Port[$0A]:=5;
  Port[$0C]:=0;
  Port[$0B]:=$49;
  Port[$02]:=Lo(offset);
  Port[$02]:=Hi(offset);
  Port[$83]:=page;
  Port[$03]:=Lo(taille);
  Port[$03]:=Hi(taille);
  Port[$0A]:=1;
  {La routine PlayBack est sur l'IRQ 7}
  OldIRQ:=ChangeVecteurIRQ(7,@PlayBack);
  ActiveIRQ(7);
  EcritDSP($14);
  EcritDSP(Lo(taille));
  EcritDSP(Hi(taille));
END;


PROCEDURE FinPlayBack;
VAR p:Pointer;
BEGIN
  ArreteDMA;
  DesactiveIRQ(7);
  p:=ChangeVecteurIRQ(7,OldIRQ);
  SpeakerOFF;
END;


END.
