;* NOTE: You must assemble this program as a .COM file, either as a PWB
;*       build option or with the ML /AT option.

        .MODEL tiny, pascal, os_dos
        .STACK

        .CODE

        ORG     5Dh                     ; Location of time argument in PSP,
CountDown       LABEL   WORD            ;   converted to number of 5-second
                                        ;   intervals to elapse
        .STARTUP
        jmp     Install                 ; Jump over data and resident code

; Data must be in code segment so it won't be thrown away with Install code.

OldTimer          DWORD   ?     ; Address of original timer routine
TickCount         BYTE    91    ; Counts 91 clock ticks (5 seconds)
ProgramActiveFlag BYTE	  0		  ; Active flag for timer handler
counter 	WORD	0

; The colors in mode 3 are not ordered, that
; would be far to logic for an IBM pc. So, the colors
; are NOT 0h to Fh, but 0h-5h,14h,7h and 38h-63. 
; We skip 0, because this is our background colour.

stijg    db 00h
daal     db 3fh
color    db 00h
kleur    db 01h,02h,03h,04h,05h,14h,07h,38h,39h,3ah,3bh,3ch,3dh,3eh,3fh

;color value initialisation
rood     db 0h,0h,0h,0h,0h,0h,0h,0h,0h,0h,0h,0h,0h,0h,0h
groen    db 3fh,3fh,3fh,3fh,3fh,3fh,3fh,3fh,3fh,3fh,3fh,3fh,3fh,3fh,3fh
blauw    db 0h,0h,0h,0h,0h,0h,0h,0h,0h,0h,0h,0h,0h,0h,0h

; All attributes (2000 values!!) in a pattern.
array db 1,1,1,1,1,1,1,1,2,2,2,3,3,3,4,4,4,4,3,3,3,3,2,2,3,3,3,3,3,4
db 4,5,5,6,6,7,6,6,6,5,5,5,5,4,4,4,3,3,3,3,3,3,4,4,4,4,5,5,5,6,6,6,6,7
db 7,7,7,8,8,8,8,9,9,9,0ah,0ah,0bh,0bh,0ch,0dh
db 1,1,1,1,1,2,2,2,2,2,3,3,3,4,4,5,4,3,3,3,4,4,2,2,2,2,2,2,3,3,4,4,5
db 5,6,6,6,5,5,5,5,5,4,4,3,3,3,3,2,2,2,3,3,3,4,5,5,5,6,6,6,6,7,7,8,7,7
db 7,7,8,8,8,9,0ah,0ah,0bh,0bh,0ch,0ch,0dh
db 1,1,2,2,2,2,3,4,3,2,2,2,3,3,4,5,5,4,4,3,3,3,3,2,2,3,3,2,2,2,3,3,4
db 5,5,5,5,4,4,4,5,4,4,4,4,3,3,2,2,2,2,2,3,3,4,5,6,6,6,7,7,7,7,8,8,8,8
db 8,8,8,8,8,9,0ah,0bh,0bh,0ch,0ch,0dh,0dh
db 1,2,2,2,2,2,2,2,2,2,1,2,2,3,4,5,6,5,4,3,2,2,2,1,1,2,2,2,2,2,2,2,3
db 4,4,4,4,4,3,3,4,4,5,5,4,4,4,3,3,3,3,3,4,4,5,6,6,7,7,7,8,8,8,8,8,8,9
db 9,9,9,9,9,0ah,0bh,0bh,0ch,0ch,0dh,0dh,0dh
db 2,2,3,3,3,3,3,2,2,2,1,1,2,4,5,6,7,6,5,4,3,2,1,1,1,1,1,2,2,2,3,3,3
db 3,3,3,3,3,3,2,3,4,5,5,5,5,5,4,4,4,4,4,5,5,6,7,7,8,8,8,9,9,9,9,9,9,9
db 9,0ah,0ah,0ah,0ah,0ah,0ah,0ah,0bh,0bh,0ch,0dh,0dh
db 2,2,3,3,4,4,4,3,3,3,2,2,3,4,5,6,7,7,6,5,4,3,2,1,1,1,1,1,2,2,2,2,2
db 2,2,2,2,2,2,2,2,3,4,4,4,4,4,4,4,4,5,5,5,6,7,7,8,8,8,9,9,9,9,0ah,0ah
db 0ah,0ah,0ah,0ah,0ah,0ah,0ah,0ah,9,9,9,0ah,0bh,0ch,0dh
db 3,3,4,4,5,4,4,3,3,2,2,1,2,3,5,7,8,7,6,5,3,2,2,1,1,1,1,1,1,2,2,2,1
db 1,1,2,2,2,2,1,1,2,3,3,3,3,3,3,3,4,5,6,6,6,6,7,7,8,8,8,8,9,9,9,9,9,9
db 9,9,9,9,9,9,8,8,9,0ah,0ah,0bh,0ch
db 3,4,4,5,6,5,5,4,3,3,3,2,3,4,5,6,7,7,6,5,4,3,2,2,1,1,1,1,2,3,3,2,2
db 1,1,1,1,2,1,1,1,2,2,2,2,2,2,2,2,3,4,5,4,4,5,6,6,6,7,7,7,7,8,8,8,8,8
db 8,8,8,8,8,8,7,8,8,9,9,0ah,0ah
db 4,4,5,6,7,6,5,4,4,3,2,2,3,5,6,8,9,7,5,4,3,3,2,2,2,1,1,1,2,3,4,3,2
db 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,4,5,5,5,6,6,7,7,7,7,7,7
db 7,7,7,7,6,7,8,8,8,8,8,9,9
db 5,6,6,7,7,6,5,4,4,4,3,3,4,5,7,8,9,9,7,5,4,3,3,3,2,2,2,1,2,2,3,2,2
db 2,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,2,2,2,2,2,3,4,4,4,5,5,6,6,6,6,6
db 6,6,6,6,7,7,8,8,7,7,8,8,8
db 5,6,7,8,7,7,6,5,5,5,4,4,5,6,7,9,0ah,0ah,0ah,8,6,4,4,3,3,3,2,2,2,2
db 2,2,2,1,1,1,1,2,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,2,2,3,4,5,5,6,6,5
db 6,6,6,6,6,7,7,6,6,7,7,7,8,8,7,7
db 6,7,8,8,9,8,7,6,6,6,6,6,6,7,9,0ah,0ah,0ah,0ah,9,7,6,5,4,4,3,3,2,2
db 2,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,2,2,2,1,1,1,1,2,3,3,4,5,6,6,6,6
db 6,6,7,7,7,7,7,6,6,6,6,6,7,8,7,7,6
db 7,8,9,9,9,9,8,7,8,8,8,7,8,8,8,9,0ah,0bh,0ah,0ah,9,8,6,5,5,5,4,4,3
db 2,2,2,1,1,2,2,3,3,3,2,2,3,3,3,3,3,3,3,3,2,2,2,1,2,3,4,4,5,6,7,7,7,7
db 7,7,7,6,6,6,6,6,5,5,5,5,6,7,6,6,6
db 8,8,9,0ah,0ah,9,8,8,8,9,9,8,9,9,0ah,0ah,0ah,0bh,0bh,0ah,0ah,9,8,7
db 6,6,5,5,4,4,3,2,1,2,3,3,3,4,4,3,3,3,3,4,4,4,4,3,3,3,3,3,2,2,3,4,5,6
db 7,7,7,7,8,8,8,7,7,6,6,6,5,5,5,5,5,6,6,5,5,5
db 9,9,0ah,0ah,0ah,0ah,9,9,9,0ah,0ah,0ah,0ah,0ah,0ah,0bh,0bh,0bh,0bh
db 0bh,0ah,0ah,9,8,7,7,6,5,5,4,4,3,2,3,3,4,5,5,5,4,4,4,4,5,5,5,5,5,4,4
db 4,4,3,3,4,5,5,6,7,8,8,8,8,8,8,8,8,7,7,6,5,5,4,4,5,5,5,5,4,4
db 9,0ah,0ah,0ah,0ah,0ah,0ah,0ah,0ah,0ah,0ah,0ah,0ah,0bh,0bh,0bh,0bh
db 0bh,0bh,0bh,0bh,0ah,9,8,8,7,6,6,5,5,5,4,3,4,4,5,5,6,6,5,4,5,5,5,6,6
db 6,6,5,5,5,5,4,4,5,6,6,7,8,7,7,8,8,8,8,8,8,8,7,7,7,6,5,4,4,4,4,4,4,3
db 0ah,0ah,0ah,0ah,0bh,0bh,0ah,0ah,0ah,0ah,0ah,0ah,0bh,0bh,0bh,0bh,0ch
db 0ch,0ch,0bh,0bh,0bh,0ah,9,8,8,7,7,7,6,6,5,4,4,5,6,6,6,7,6,5,6,6,6,6
db 6,6,6,6,6,5,5,5,5,5,5,5,6,7,7,8,8,7,7,8,8,8,7,7,7,7,7,7,6,5,4,3,3,3,3
db 0ah,0ah,0bh,0bh,0bh,0bh,0bh,0bh,0bh,0bh,0bh,0bh,0bh,0bh,0bh,0ch,0ch
db 0ch,0ch,0ch,0ch,0bh,0ah,0ah,9,9,8,8,7,7,7,6,5,5,6,6,7,7,8,7,6,6,7,7,7
db 7,7,7,7,6,6,6,6,6,6,5,5,6,6,7,7,7,7,7,7,7,7,7,7,7,6,6,6,5,5,4,4,3,3,2
db 0ah,0bh,0bh,0bh,0ch,0ch,0ch,0bh,0bh,0bh,0bh,0bh,0bh,0ch,0ch,0ch,0ch
db 0dh,0dh,0dh,0ch,0bh,0bh,0ah,0ah,0ah,0ah,9,8,8,7,7,7,6,6,7,7,8,8,8,7,7
db 7,7,8,8,8,8,8,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5
db 4,4,3
db 0bh,0bh,0ch,0ch,0ch,0ch,0ch,0ch,0ch,0ch,0ch,0ch,0ch,0ch,0ch,0dh,0dh
db 0dh,0eh,0dh,0dh,0ch,0ch,0ch,0bh,0bh,0ah,0ah,9,9,9,8,8,7,7,8,8,9,9,9,8
db 7,7,8,8,8,9,9,8,8,8,8,8,7,7,7,7,6,6,5,5,5,5,5,5,5,6,6,6,6,6,5,5,5,5,4
db 4,4,4,3
db 0ch,0ch,0ch,0ch,0ch,0dh,0dh,0dh,0dh,0dh,0dh,0dh,0dh,0dh,0dh,0dh,0eh
db 0eh,0eh,0eh,0dh,0dh,0dh,0dh,0ch,0ch,0ch,0ah,0ah,0ah,9,9,9,8,8,8,8,8,8
db 8,8,8,8,8,9,9,9,8,8,8,8,8,8,8,8,7,7,7,6,6,5,5,5,5,6,6,6,6,6,6,6,6,6,6
db 5,5,5,5,5,4
db 0dh,0dh,0dh,0dh,0dh,0dh,0dh,0eh,0eh,0eh,0eh,0eh,0eh,0eh,0eh,0eh,0eh
db 0fh,0fh,0eh,0eh,0eh,0dh,0dh,0dh,0ch,0ch,0ch,0ah,0ah,0ah,9,9,9,9,9,9,9
db 9,8,8,8,9,9,0ah,0ah,0ah,9,9,9,9,9,9,8,8,8,8,8,7,6,6,6,6,6,6,6,7,7,7,7
db 7,7,7,6,6,6,6,6,6,5
db 0dh,0eh,0eh,0eh,0eh,0eh,0eh,0eh,0eh,0eh,0eh,0eh,0eh,0eh,0eh,0fh,0fh
db 0fh,0fh,0fh,0fh,0eh,0eh,0dh,0dh,0dh,0ch,0ch,0ah,0ah,9,9,9,9,9,9,8,8,8
db 8,8,9,9,0ah,0ah,0ah,0ah,0ah,0ah,0ah,0ah,0ah,9,9,9,9,9,9,8,7,7,7,7,7,7
db 7,8,8,8,8,8,8,8,7,7,7,7,7,7,6
db 0eh,0eh,0eh,0eh,0eh,0fh,0fh,0fh,0fh,0fh,0fh,0fh,0fh,0fh,0fh,0fh,0fh
db 0fh,0fh,0fh,0eh,0eh,0eh,0eh,0dh,0ch,0ch,0ah,0ah,9,9,9,9,8,8,8,8,8,8,8
db 8,9,0ah,0ah,0bh,0bh,0bh,0bh,0bh,0bh,0bh,0ah,0ah,0ah,0ah,0ah,0ah,9,9,9
db 8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7
db 0eh,0eh,0eh,0fh,0fh,0fh,0fh,0fh,0fh,0fh,0fh,0fh,0fh,0eh,0eh,0eh,0fh
db 0fh,0fh,0eh,0eh,0eh,0dh,0dh,0ch,0ch,0ah,0ah,9,9,9,8,8,8,8,8,7,7,7,7,8
db 9,0ah,0ah,0ah,0bh,0bh,0bh,0bh,0bh,0bh,0bh,0bh,0bh,0bh,0ah,0ah,0ah,0ah
db 0ah,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,8,8,8,8

;* NewTimer - Handler routine for timer interrupt (interrupt 08).

NewTimer PROC   FAR

  .IF cs:ProgramActiveFlag != 0         ; If program busy with handling current stuff, or retired (stopped by user)
        jmp     cs:OldTimer             ;   jump to original timer routine
        .ENDIF
	inc	cs:ProgramActiveFlag	; Set active flag
        pushf                           ; Simulate interrupt by pushing flags,
        call    cs:OldTimer             ;   then far-calling original routine
        sti                             ; Enable interrupts
        push    ds                      ; Preserve DS register
        push    cs                      ; Point DS to current segment for
        pop     ds                      ;   further memory access
        dec     TickCount               ; Count down for 20 ticks
        call    roteer_palet            ; Rotate colours in palette
        call    kleur_setten            ; and use crt to set them
        .IF     zero?                   ; If 20 ticks have elapsed,
        mov     TickCount, 20           ;  reset our little counter to
                                        ;  the number of ticks we have to wait
        call    Pattern
        .ENDIF

        dec ProgramActiveFlag           ; Decrement active flag
        pop     ds                      ; Recover DS
        iret                            ; Return from interrupt handler

NewTimer ENDP

;Ŀ
;į  This is where it all starts. We mess around in the video   
;     memory by using segment override to store some colours in  
; it. This, we repeat for every line, so that a cloud - like     
; is accomplished.                                               
;                                                                
;į  Here, the cloud is being laid upon the screen character    
;     attributes. This procedure is called every now and then,   
; because something might have changed the screen. This is pro-  
; bably not going to happen with the normal version of this pro- 
; gram, but in the TSR version, it is highly recommenced to do   
; so, as then every sucker can change the contents of the screen.
;

pattern proc uses ax bx cx dx es si
	mov     ax,0B800h       ; video segment
	mov     es,ax           ; not to be placed directly in es
	xor     dh,dh           ; colour 0
	mov     cx, 07d0h       ; 07d0 is 25 * 80 chars in a screen
	xor     bx,bx           ; index is 0, first char
	inc     bx              ; attributes
	xor     si,si           ; begin array

@lijndoen:
	mov     ah,[cs:array+si] ; form: foreground, background
	mov     es:[bx],ah      ; again not directly
	inc     bx              ; increment to next char position
	inc     bx              ; twice
	inc     si              ; next element
	dec     cx              ; decrement, start with 2000, 80 * 25
	cmp     cx,0            ; are whe there yet?
	jne     @lijndoen       ; nope, continue.
	ret
pattern endp

;Ŀ
;į  Here, the colours stored in KLEUR, are set on the corresponding  
;     bytes in ROOD, GROEN and BLAUW byte arrays, which are the  
; red, green and blue components.  
;

kleur_setten proc uses ax cx si dx
	mov     cx,000Fh        ;  for every colour in table: 15 x
	xor     ax,ax           
	xor     si,si
	mov     dx,03C8h        ; paletregister, fill in colour

@setcolor:
	mov     al,[cs:kleur+si]; load color that needs to be changed
	out     dx,al           ; this is the one (table provides number)
	inc     dx              ; color values are to be set in next port
	mov     al,[cs:rood+si] ; red
	out     dx,al
	mov     al,[cs:groen+si]; green
	out     dx,al
	mov     al,[cs:blauw+si]; blue
	out     dx,al
	dec     dx              ; back to the original palette register
	inc     si              ; next value in color array
	dec     cx              ; next colour
	cmp     cx,0
	jne     @setcolor
	ret
kleur_setten endp

;Ŀ
;į  Here the pallette is rotated by changing the arrays.       
;                                                                
;Ŀ     Ŀ                                           
;abcdef --> ?abcde   with ? as the newly calculated value.   
;                                                     
;                                                                
; Can be optimized by no longer losing valuable time writing the 
; array over and over with te same values on a different         
; position, but keeping a pointer instead.                       
;

roteer_palet proc uses si ax
	mov	si,0fh		; rotate 15 colour values, and doing so, lose valuable time
@verder:
	dec     si
	mov     al,[cs:rood+si-1]; take a byte
	mov     [cs:rood+si],al ; and store it in the next entry
	mov     al,[cs:groen+si-1]
	mov     [cs:groen+si],al
	mov     al,[cs:blauw+si-1]
	mov     [cs:blauw+si],al
	cmp     si,1h
	jne     @verder         ; over and over
                          ; if color = 0
	cmp     [cs:color],0    ; now we are going to enter a new colour
	jne     @over1          ; it depends on the color cycle we're in 
	mov     al,[cs:stijg]   ; stijg is a variable that holds a value
	mov     [cs:rood],al    ; that is incremented, and reset if reached
	mov     al,[cs:daal]    ; its maximum. daal is the same, but with
	mov     [cs:groen],al   ; decreasing values. The only thing we have
	mov     [cs:blauw],0    ; to do is determining which colour should
	jmp     @over3          ; be getting daal, which should stay 0, and
@over1:                   ; which should get the stijg. This is determined
	cmp     [cs:color],1    ; by a flag named cs:color.
	jne     @over2
	mov     al,[cs:daal]
	mov     [cs:rood],al
	mov     [cs:groen],0
	mov     al,[cs:stijg]
	mov     [cs:blauw],al
	jmp     @over3
@over2:
	mov     [cs:rood],0
	mov     al,[cs:stijg]
	mov     [cs:groen],al
	mov     al,[cs:daal]
	mov     [cs:blauw],al
@over3:
	add     [cs:stijg],5    ; increment with five at a time, because
	sub     [cs:daal],5     ;  we needn't work that fluently.
	
; if daal=0 then begin    ; daal is the variable that keeps decreasing
	cmp     [cs:daal],0     ; if we reached our minimum, 
	jge     @einderot       ;  we can reset it, or else, we jump over
	mov     [cs:stijg],0
	mov     [cs:daal],3fh   ; 40h is 64, exp (6 * ln 2), therefore 2^6, -1.
	inc     [cs:color]
	cmp     [cs:color],3
	jne     @einderot
	mov     [cs:color],0
@einderot:        
	ret
roteer_palet endp

;* Install - replaces NewTimer as the interrupt handler for the timer,
;* then makes program memory resident by exiting through function 31h.
;*
;* This procedure marks the end of the TSR's resident section and the
;* beginning of the installation section.  When TSR terminates through
;* function 31h, the above code and data remain resident in memory.  The
;* memory occupied by the following code is returned to DOS.


Install PROC

;Ŀ
;į  Shew Thy CopyRight String, Thou Art Of Great Importance.   
;
.data
	stri db "This TSR Was Written By Yicusur. (Email: Steven.VanVooren@Rug.Ac.Be.)",10,13,"$"
.code
	mov	ax,cs
	mov     ds,ax
	mov     dx, offset stri
	mov     AH,09h
	int	21h
        mov     ax, 3508h               ; Request function 35h
        int     21h                     ; Get vector for timer (interrupt 08)
        mov     WORD PTR OldTimer[0], bx; Store address of original
        mov     WORD PTR OldTimer[2], es;  timer interrupt
        mov     ax, 2508h               ; Request function 25h
        mov     dx, OFFSET NewTimer     ; DS:DX points to new timer handler
        int     21h                     ; Set vector with address of NewTimer

        mov     dx, OFFSET Install      ; DX = bytes in resident section
        mov     cl, 4
        shr     dx, cl                  ; Convert to number of paragraphs
        inc     dx                      ;  plus one
        mov     ax, 3100h               ; Request function 31h, error code=0
        int     21h                     ; Terminate-and-Stay-Resident

Install ENDP

        END
