/*
 * Decompiled with CFR 0.152.
 */
package demoOrDie;

import demoOrDie.LevitateChars;
import demoOrDie.ScrollTextStream;
import demoOrDie.aCharacterOnScreen;
import java.awt.AlphaComposite;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.DisplayMode;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.swing.JFrame;

public class Scroller
extends JFrame {
    static int xsize = 900;
    static int ysize = 600;
    static int charsizX = 73;
    static int charsizY = 73;
    static BufferedImage bufImgCharset;
    static ArrayList<Integer> sinArray;
    static final int sinTabDimensions = 8784;
    public static int sinOffset;
    public static int sinRotate;
    public static int scrollYOffset;
    public static int centerAdjust;
    public static int scrollSpeed;
    public static boolean running;
    public static long initial;
    public static int refreshRate;
    public static int zoomFader;
    public static boolean doZoom;
    public static int zoomOffset;
    public static int zoomRotate;
    static ArrayList<Integer> zoomArray;

    static {
        sinArray = new ArrayList();
        sinOffset = 10;
        sinRotate = -90;
        scrollYOffset = ysize / 4 - charsizY / 2;
        centerAdjust = ysize / 4;
        scrollSpeed = -8;
        running = true;
        initial = 0L;
        zoomFader = 0;
        doZoom = false;
        zoomOffset = 50;
        zoomRotate = -90;
        zoomArray = new ArrayList();
        double jj = 0.0;
        int ii = 0;
        while (ii < 8784) {
            sinArray.add((int)((double)scrollYOffset * Math.sin(Math.toDegrees(jj / 1000.0 / 8.0))));
            zoomArray.add((int)(100.0 * Math.sin(Math.toDegrees(jj / 1000.0 / 8.0))));
            jj += 0.1;
            ++ii;
        }
    }

    public static void main(String[] args) {
        Scroller frame = new Scroller();
        frame.setIgnoreRepaint(true);
        frame.setDefaultCloseOperation(3);
        frame.setLocation(20, 20);
        Canvas canvas = new Canvas();
        canvas.setIgnoreRepaint(true);
        canvas.setSize(xsize, ysize);
        frame.add(canvas);
        frame.pack();
        frame.setVisible(true);
        canvas.createBufferStrategy(2);
        BufferStrategy buffer = canvas.getBufferStrategy();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        DisplayMode dm = gd.getDisplayMode();
        refreshRate = dm.getRefreshRate();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        BufferedImage bi = gc.createCompatibleImage(xsize, ysize);
        BufferedImage ci = gc.createCompatibleImage(xsize, ysize);
        BufferedImage di = gc.createCompatibleImage(xsize, ysize);
        frame.render(buffer, bi, ci, di);
    }

    public Scroller() {
        URL url = this.getClass().getResource("workspacce.png");
        try {
            bufImgCharset = ImageIO.read(url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        boolean SoundOn = true;
        if (SoundOn) {
            URL yourFile = this.getClass().getResource("birthdaywav.wav");
            try {
                AudioInputStream stream = AudioSystem.getAudioInputStream(yourFile);
                AudioFormat format = stream.getFormat();
                DataLine.Info info = new DataLine.Info(Clip.class, format);
                Clip clip = (Clip)AudioSystem.getLine(info);
                clip.open(stream);
                clip.loop(-1);
                clip.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void render(BufferStrategy buffer, BufferedImage bi, BufferedImage ci, BufferedImage di) {
        long curTime;
        Graphics g = null;
        Graphics graphics = null;
        boolean newstyle = true;
        LevitateChars.initNewLetter(ScrollTextStream.getScrolltext(), xsize, ysize / 2);
        int fps = 0;
        int frames = 0;
        long totalTime = 0L;
        long lastTime = curTime = System.currentTimeMillis();
        int TICKS_PER_SECOND = refreshRate - 1;
        int SKIP_TICKS = 1000 / TICKS_PER_SECOND;
        int MAX_FRAMESKIP = 5;
        long next_frame_tick = Scroller.GetTickCount();
        while (running) {
            try {
                int loops = 0;
                while (Scroller.GetTickCount() > next_frame_tick && loops < MAX_FRAMESKIP) {
                    lastTime = curTime;
                    curTime = System.currentTimeMillis();
                    if ((totalTime += curTime - lastTime) > 1000L) {
                        totalTime -= 1000L;
                        fps = frames;
                        frames = 0;
                    }
                    ++frames;
                    if (newstyle) {
                        g = bi.createGraphics();
                        ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, 0.5f));
                        g.drawImage(ci, 0, 0, null);
                        ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, 1.0f));
                    } else {
                        g = bi.createGraphics();
                        Color background = new Color(0, 0, 0, 128);
                        g.setColor(background);
                        g.fillRect(0, 0, xsize, ysize);
                    }
                    LevitateChars.moveDems(xsize + charsizX, ysize / 2);
                    LevitateChars.scaleDems();
                    Scroller.copyCharsToScreenZoomed((Graphics2D)g);
                    if (doZoom) {
                        this.fadeInZoom();
                    } else {
                        this.fadeOutZoom();
                    }
                    Scroller.rollSin();
                    Scroller.rollZoom();
                    Scroller.displayDebugInfo((Graphics2D)g, fps);
                    graphics = buffer.getDrawGraphics();
                    graphics.drawImage(bi, 0, 0, null);
                    if (!buffer.contentsLost()) {
                        buffer.show();
                    }
                    next_frame_tick += (long)SKIP_TICKS;
                    ++loops;
                }
                Thread.yield();
            }
            finally {
                if (g != null) {
                    g.dispose();
                }
                if (graphics != null) {
                    graphics.dispose();
                }
            }
        }
    }

    private void tvfuzz(Graphics2D g, BufferedImage bi, BufferedImage di) {
        Graphics2D ok = bi.createGraphics();
        Random fuzz = new Random();
        Color newColor = new Color(fuzz.nextInt(255), fuzz.nextInt(255), fuzz.nextInt(255), 0);
        ok.setColor(newColor);
        ok.setComposite(AlphaComposite.getInstance(4, 1.0f));
        ok.fillRect(0, 0, xsize, ysize);
        ok.dispose();
    }

    static BufferedImage deepCopy(BufferedImage bi) {
        ColorModel cm = bi.getColorModel();
        boolean isAlphaPremultiplied = true;
        WritableRaster raster = bi.copyData(null);
        return new BufferedImage(cm, raster, isAlphaPremultiplied, null);
    }

    private static void copyCharsToScreenZoomed(Graphics2D g) {
        int aa = 0;
        while (aa < LevitateChars.charControl.size()) {
            aCharacterOnScreen cCObj = LevitateChars.charControl.get(aa);
            BufferedImage img = bufImgCharset.getSubimage(cCObj.getTileCoordsX(), cCObj.getTileCoordsY(), charsizX, charsizY);
            double limited = ((double)cCObj.getZoomScale() + 100.0) / 100.0;
            double highest = 2.0;
            double lower_limit = 0.0;
            double upper_limit = 1.3;
            limited = limited / (highest / (upper_limit - lower_limit)) + lower_limit;
            limited = 1.0 + (double)zoomFader * (limited / 200.0);
            int scaled = (int)((double)charsizX * limited);
            g.drawImage(img, cCObj.getLevitPosX() - scaled / 2, cCObj.getLevitPosY() - scaled / 2, scaled, scaled, null);
            img.flush();
            ++aa;
        }
    }

    private static void rollSin() {
        Collections.rotate(sinArray, sinRotate);
    }

    private static void rollZoom() {
        Collections.rotate(zoomArray, zoomRotate);
    }

    private static long GetTickCount() {
        long time = System.currentTimeMillis();
        long calced = time - initial;
        time = initial;
        return calced;
    }

    public void fadeOutZoom() {
        if (--zoomFader < 1) {
            zoomFader = 0;
        }
    }

    public void fadeInZoom() {
        if (++zoomFader > 100) {
            zoomFader = 100;
        }
    }

    private static void displayDebugInfo(Graphics2D g, int fps) {
        g.setFont(new Font("Courier New", 0, 12));
        g.setColor(Color.GREEN);
        g.drawString(String.format("FPS: %s", fps), 20, 20);
        g.setColor(Color.YELLOW);
        g.drawString(String.format("RR: %s", refreshRate), 20, 35);
        String dispElements = "";
        ArrayList<aCharacterOnScreen> tempObj = LevitateChars.getCharControl();
        int ii = 0;
        while (ii < LevitateChars.getCharControl().size() - 1) {
            aCharacterOnScreen tempCoS = tempObj.get(ii);
            dispElements = String.valueOf(dispElements) + tempCoS.getCurrChar();
            ++ii;
        }
        g.setColor(Color.RED);
        g.drawString(String.format("Actif: %s", dispElements), 20, 50);
    }
}

