#version 330 core

uniform sampler2D color_buffer;
uniform sampler2D depth_buffer;
uniform vec2 TexelSize;
uniform mat4 PreviousMatrix;
uniform mat4 CurrentMatrix;

in vec2 uv;

layout (location = 0) out vec4 frag_color;

void main()
{
	const int numSamples = 8;

	float z = texture(depth_buffer, uv).x;
	vec4 h = vec4((uv.x - 0.5)*2.0, (uv.y - 0.5)*2.0, z, 1.0);
	vec4 d = CurrentMatrix * h;
	vec4 wp = d * (1.0 / d.w);

	vec4 p = PreviousMatrix * wp;
	p *= 1.0 / p.w;
	vec2 velocity = (h.xy - p.xy)*0.25;

	vec4 color = texture(color_buffer, uv);
	for (int i=1; i <= numSamples; i++)
	{
		color += texture(color_buffer, uv + velocity*float(i));
	}

	frag_color = color / float(numSamples + 1);
}

