#version 330 core

uniform sampler2D tex;

uniform vec2 Direction;
uniform vec2 TexelSize;
uniform vec4 Weights;
uniform float B;
uniform vec4 color;

in vec2 uv;

layout (location = 0) out vec4 frag_color;

void main()
{
#define LOD_LEVEL 0.0

	vec2 sc = Direction*TexelSize*B;

	vec4 final = textureLod(tex, uv, LOD_LEVEL)*Weights.x;

	final += textureLod(tex, uv + sc, LOD_LEVEL)*Weights.y;
	final += textureLod(tex, uv - sc, LOD_LEVEL)*Weights.y;

	sc += sc;
	final += textureLod(tex, uv + sc, LOD_LEVEL)*Weights.z;
	final += textureLod(tex, uv - sc, LOD_LEVEL)*Weights.z;

	sc += sc;
	final += textureLod(tex, uv + sc, LOD_LEVEL)*Weights.w;
	final += textureLod(tex, uv - sc, LOD_LEVEL)*Weights.w;
	final *= 1.0 / 2.0;

	frag_color = (final - color)*color.a;
}
