#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat3 NormalMatrix;

layout (location = 0) in vec3 POSITION; //
layout (location = 3) in vec3 TANGENT; // radius

out float lit;
out vec3 wpos;

void main()
{
	vec4 pos = vec4(POSITION, 1.0);
	wpos = vec3(ModelViewMatrix * pos);

	lit = max(1.0 - (length(wpos) / 60.0), 0.0);
	gl_PointSize = TANGENT.x*lit;
	gl_Position = ModelViewProjectionMatrix * pos;
}
