#version 330 core

in vec4 gs_light_plane[1];
in vec3 gs_light_coeff[1]; // size, length, intensity
in vec3 gs_color[1];

out vec4 light_plane;
out vec3 light_pos;
out vec3 light_coeff; // size, length, intensity
out vec3 light_color;

layout(points) in;
layout(triangle_strip, max_vertices = 4) out;

#define EMIT(VTX) \
	light_plane = gs_light_plane[0]; \
	light_pos = gl_in[0].gl_Position.xyz; \
	light_coeff = gs_light_coeff[0]; \
	light_color = gs_color[0]; \
	gl_Position = VTX; \
	EmitVertex()

void main()
{
	EMIT(vec4(1.0, 1.0, 1.0, 1.0));
	EMIT(vec4(-1.0, 1.0, 1.0, 1.0));
	EMIT(vec4(1.0, -1.0, 1.0, 1.0));
	EMIT(vec4(-1.0, -1.0, 1.0, 1.0));
	EndPrimitive();
}
