/***************************************************************************
 *   Copyright (C) 2012                                                    *
 *   Anatole Duprat <anatole.duprat@gmail.com>                             *
 *   Charles Bulckaen  <xtrium@frequency.fr>                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU General Public License           *
 *   as published by the Free Software Foundation; either version 2        *
 *   of the License, or (at your option) any later version.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA          *
 ***************************************************************************/



#ifndef VIDEOEXPORTWIDGET_H
#define VIDEOEXPORTWIDGET_H

#include <QDockWidget>



namespace Ui {
    class VideoExportWidget;
}


class RenderWidget;
class CurveEditorWidget;

class VideoExportWidget : public QDockWidget {
    Q_OBJECT
public:
    VideoExportWidget(RenderWidget *rw, CurveEditorWidget *cew, QWidget *parent = 0);
    ~VideoExportWidget();


public slots:
    void selectPath();
    void exportVideo();


protected:
    void changeEvent(QEvent *e);

private:
    Ui::VideoExportWidget *ui;
    RenderWidget *_rw;
    CurveEditorWidget *_cew;
};

#endif // VIDEOEXPORTWIDGET_H
