/***************************************************************************
 *   Copyright (C) 2012                                                    *
 *   Anatole Duprat <anatole.duprat@gmail.com>                             *
 *   Charles Bulckaen  <xtrium@frequency.fr>                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU General Public License           *
 *   as published by the Free Software Foundation; either version 2        *
 *   of the License, or (at your option) any later version.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA          *
 ***************************************************************************/



#include "splashwidget.hh"
#include "loaderthread.hh"

SplashWidget::SplashWidget(QWidget* parent) : QWidget(parent)
{
    setGeometry(
        QApplication::desktop()->width()  / 2 - 200,
        QApplication::desktop()->height() / 2 - 150,
        400,
        300
    );
    setWindowFlags(Qt::FramelessWindowHint | Qt::WindowStaysOnTopHint);
    setStyleSheet("background: url(:/res/img/splash.png);");

    //setAttribute(Qt::WA_DeleteOnClose); // This class crashes on deletion for no apparent reason.
                                          // Destructor seems to be called twice under some obscure conditions.
                                          // Must examine further...

    _thread = new LoaderThread();
    connect(_thread, SIGNAL(finished()), this, SLOT(launchApp()));
}

SplashWidget::~SplashWidget()
{
}

void SplashWidget::paintEvent(QPaintEvent* event) {
    QWidget::paintEvent(event);
    QStyleOption styleOption;
    styleOption.init(this);
    QPainter painter(this);
    style()->drawPrimitive(QStyle::PE_Widget, &styleOption, &painter, this);
}

void SplashWidget::showEvent(QShowEvent* event)
{
    QWidget::showEvent(event);
    _thread->start();
}

void SplashWidget::launchApp()
{
    _thread->deleteLater();
    emit loadingFinished();
    close();
}
