/***************************************************************************
 *   Copyright (C) 2012                                                    *
 *   Anatole Duprat <anatole.duprat@gmail.com>                             *
 *   Charles Bulckaen  <xtrium@frequency.fr>                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU General Public License           *
 *   as published by the Free Software Foundation; either version 2        *
 *   of the License, or (at your option) any later version.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA          *
 ***************************************************************************/



#ifndef DEF_SHADER
#define DEF_SHADER


#include "glextensions.hh"

//-----------------------------------------------------------------------------
// ShaderCompile
//-----------------------------------------------------------------------------
GLuint ShaderCompil(const char *vsh, const char *psh, int *error, const char *gsh = NULL);

//-----------------------------------------------------------------------------
// ShaderSend
//-----------------------------------------------------------------------------
void  inline ShaderSendi(GLuint shader, const char *name, int x)
{
	glUniform1i(glGetUniformLocation(shader,name), x);
}
void  inline ShaderSendf(GLuint shader, const char *name, float x)
{
	glUniform1f(glGetUniformLocation(shader,name), x);
}
void  inline ShaderSendf(GLuint shader, const char *name, float x, float y)
{
        glUniform2f(glGetUniformLocation(shader,name), x,y);
}
void  inline ShaderSendf(GLuint shader, const char *name, float x, float y, float z)
{
        glUniform3f(glGetUniformLocation(shader,name), x,y,z);
}
void  inline ShaderSendf(GLuint shader, const char *name, float x, float y, float z, float w)
{
	glUniform4f(glGetUniformLocation(shader,name), x,y,z,w);
}

//-----------------------------------------------------------------------------
// ShaderUse
//-----------------------------------------------------------------------------
void  inline ShaderUse(GLuint shader)
{
	glUseProgramObject(shader);
}





#endif
