/***************************************************************************
 *   Copyright (C) 2012                                                    *
 *   Anatole Duprat <anatole.duprat@gmail.com>                             *
 *   Charles Bulckaen  <xtrium@frequency.fr>                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU General Public License           *
 *   as published by the Free Software Foundation; either version 2        *
 *   of the License, or (at your option) any later version.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA          *
 ***************************************************************************/



#ifndef PLAYERWIDGET_HH
#define PLAYERWIDGET_HH

#include <QtGui>

namespace Ui {
    class PlayerWidget;
}

#include "qfmodex.hh"

class PlayerWidget : public QWidget
{
    Q_OBJECT
public:
    PlayerWidget(QWidget* parent = NULL);
    ~PlayerWidget();

public slots:
    void openMusicFile();

    void goToBegin();
    void seekBackward();
    void togglePlay();
    void seekForward();
    void goToEnd();

    void changeButtonsState(QFmodEx::State oldState, QFmodEx::State newState);

    void updateTime(unsigned int time);
    void mediaSeek(unsigned int time);

    void setFollowTimeBar(bool b);
    void setDisplayWaveform(bool b);
    //void emitNewAudiogram(QImage img);

signals:
    void songTimeChanged(float t);
    void followTimeBarChanged(bool b);
    void displayWaveformChanged(bool b);
    void newAudiogramAvailable();

private:
    Ui::PlayerWidget *ui;

    float _songTime;
    QFmodEx* _fmodEx;
};

#endif // PLAYERWIDGET_HH
