
#include <string.h>
#include <math.h>

#define XS 320
#define YS 200

static short skurt[300*300];

void rings_init(void)
{
    int n;
    for(n=0;n<300*300;n++)
        skurt[n]=sqrt(n);
}

static void horline(int x1,int x2,int y,unsigned char *s,unsigned char col)
{
    int n;

    if(x1<0) x1=0;
    if(x2>=XS) x2=XS-1;
    if(x1>x2)
        return;

    //for(n=x1;n<=x2;n++)
        //s[y*XS+n]=col;

    memset(&s[y*XS+x1],col,x2-x1+1);
}

void rings(unsigned char *s,int tid,int thick,int style,unsigned char col)
{
    int n,
        r,r2,y,x,
        ir,ir2,ix,
        py,px,
        off;
    float k;

    for(r=290;r>20;r-=40)
    {
        if(style==1)
        {
            k=sin(r/500.0+tid/1900.0)*1.0;
            px=XS/2-sin(tid/1000.0+k)*100.0;
            py=YS/2+cos(tid/1000.0+k)*100.0;
            off=sin(r/300.0+tid/666.0)*32.0;
        }
        if(style==2)
        {
            off=-15;
            px=XS/5+off*r/40+XS/2+sin(tid/300.0-r/200.0)*75.0;
            py=YS/2+cos(tid/300.0-r/200.0)*75.0;
        }

        ir=r-thick;
        r2=r*r;
        ir2=ir*ir;
        for(y=-r;y<=r && py+y<YS;y++)
        {
            if(py+y<0)
                continue;
            
            x=skurt[r2-y*y];
            if(ir2-y*y<=0)
                horline(px-x,px+x,py+y,s,col);
            else
            {
                ix=skurt[ir2-y*y];
                horline(px-x,px-ix-off,py+y,s,col);
                horline(px+ix-off,px+x,py+y,s,col);
            }
        }
    }
}