;     ----------------
;  RaySins 512 byte intro 
;   Code : D-Art/Fenomen
;   -------------------
;    Compile with NASM 
;  Example of BAT file:
;      nasm -f bin RaySins.asm -o RaySins.com


radint  equ 8
tab1    equ 0800h
tab2_   equ radint*2*160
tab2    equ tab1+tab2_

        org     100h
        mov     al,13h
        int     10h

        mov ax,0a000h
        mov gs,ax

        mov ax,cs
        add ah,10h
        mov es,ax
        
        mov     si,efftab

main
ln1     xor [l3+1],byte 8
 
        sub     ax,ax           ; Initial Palete
        sub     cx,cx
ln2     mov     al,cl 
        mov     dx,3c8h
        out     dx,al
        inc     dl
        shr     al,1
        mov     ch,al

        cmp     cl,128
        jb      l1
        mov     ah,ch
        mov     ch,63
l1      mov     al,ch
        out     dx,al
l2      mov     al,ch
        out     dx,al
l3      mov     al,ch
        out     dx,al
        inc     cl      
        jnz     ln2

        mov     bp,RadBlr

        mov cx,080h             ; Main Cycle
xxx     pusha
        fninit
        call    sinus
        call    Initab          ; Init Radial Tab
        call    Radial_Blur
        call    View            ;Copy from Buffer to Screen
        popa
        in      al,60h
        dec     al
        jz     exit
        loop    xxx

exi     lodsb                                   ; Change Effect
        mov [byte bp-(RadBlr-ch1-3)],al
        lodsb
        mov [byte bp-(RadBlr-ch2-3)],al
        lodsb
        mov [byte bp-(RadBlr-ch3-3)],al
        lodsb
        mov [ln1+2],al
        cmp [byte bp-(RadBlr-ch1-3)],byte 0x80
        jnz main
exit    mov     ax,3
        int     10h
        ret



sinus   
        mov si,temp
        fldpi
        fidiv word [byte si-(temp-p128)]
        fild word [si+grad3]
        fmul st0,st1
        fsin
        fidiv word [byte si-(temp-p100)]
        fadd dword [byte si-(temp-inten)]
        fstp dword [byte si+intens]
        
        push dword [byte si+grad]
        push dword [byte si+grad3]

        mov ch,1  
sn1            
        fild word [si+grad]
        fmul st0,st1
        fsincos
        
        fild word [si+grad2]
        fmul st0,st3
        fsin

        fild word [si+grad4]
        fmul st0,st4 
        fcos
        fimul word [ampl]
;        fiadd word [minamp]
     
        fmulp st1,st0

        fmul st1,st0
        fmulp st2,st0
        fistp word [si]
        fistp word [byte  si+2]


        mov bx,[si]
        add bx,100
        imul bx,word [byte si-(temp-p320)]
        add bx,[byte si+2]

        sub eax,eax
        dec eax
        mov [es:bx+161    ],ax
        mov [es:bx+320+160],eax
        mov [es:bx+640+160],eax
        mov [es:bx+960+161],ax



ch1     add byte [byte si+grad],2
ch2     add byte [byte si+grad2],0
ch3     add byte [byte si+grad4],3
        loop sn1
        pop dword [byte si+grad3]
        pop dword [byte si+grad]

        add byte [byte si+grad3],2      ;radial
        add byte [byte si+grad4],5      ;ampl speed

;        add byte [byte si+grad],4       ;rotator
        add byte [byte si+grad2],3      ;zoom speed
        ret        


Radial_Blur
        mov     dx,100*256+159
        mov     cl,radint*2
        mov     di,tab2
        mov     si,tab1
        mov     [byte bp+sgn1],word 0xdbf7      
        call    bp                              ;4
        mov     [byte bp+sgn2],byte 0x03
        add     si,cx
        call    bp                              ;1
        add     di,cx
        sub     si,cx
        mov     [byte bp+sgn1],word 0x9090      ;2
        call    bp                              
        add     si,cx
        mov     [byte bp+sgn2],byte 0x2b
                                               ;3

RadBlr  
        pusha
rad3    pusha
rad2    push    di

        mov     cl,radint

        xor     ax,ax
rad1    mov     bx,[di]

sgn1    equ     $-RadBlr
        neg     bx
sgn2    equ     $-RadBlr
        sub     bx,[si]
        inc     si
        inc     si
        inc     di
        inc     di
        add     al,[es:bx+320*100+160]       
        adc     ah,ch
        loop    rad1

        shr     ax,3
        add     [es:bx+320*100+160],al
        pop     di
        dec     dl
        jnz     rad2        
        popa
        add     di,radint*2
        dec     dh
        jnz     rad3
        popa
        ret

Initab:
     ;  mov     si,temp   !!!!!

        mov     di,tab1+radint*2-2
        mov     word [byte si+count],0        
i2      
        fninit
        fld     dword [byte si+(intens)]
        mov     cx,radint
        fld1
i1      
        fild    word [byte si+count]
        fmul    st0,st1
        fist    word [di]
        frndint
        fimul   word [byte si-(temp-p320)]
        fistp   word [di+tab2_]
        dec     di
        dec     di
        fmul    st0,st1
        loop    i1
        add     di,radint*4        
        inc     word [byte si+count]
        cmp     byte [byte si+count],160
        jnz     i2
        ret


View

man     mov     dx,3DAh
        in      al,dx
        test    al,8
        jz      man 
m1      in      al,dx
        test    al,8
        jnz     m1

        xor di,di
        xor al,al
        mov ch,0fah
mv1:    mov ah,[es:di]
        mov [gs:di],ah
        stosb
        loop mv1
        ret

n1      equ 0x2d+5
n2      equ 0x30+5
n3      equ 0x33+5


efftab  db 1,1,1, n1
        db 1,2,2, n3
        db 1,2,1, n2
        db 2,3,1, n1
        db 3,1,1, n3
        db 2,1,3, n2
        db 1,3,1, n1    ;-g-
        db 3,2,2, n3
        db 3,2,3, n2
        db 3,3,1, n1    ;r-b
        db 2,3,2, n3   
        db 1,2,3, n2
        db 0x80


inten   dd 0.987      ;4 byte
p320    dw 320
p100    dw 100
        
p128    dw 128
ampl    dw 80 
        db 'D-Art!'

;--------------------
temp    

b1      equ $-temp
b2      equ b1+2
intens  equ b2+2
ampltd  equ intens+4
count   equ ampltd+2
grad    equ count+2
grad2   equ grad+2
grad3   equ grad2+2
grad4   equ grad3+2

        
