//--------------------------------------------------------------------------------
//
// farbrausch V2
//
// This is the header file for using libv2. This header file is in the public
// domain, use and abuse it as you wish (and if it's a port to other compilers
// than VC++, feel free to send it back ;)
//
// Tammo "kb" Hinrichs, Dec. 2004
//
//--------------------------------------------------------------------------------

#ifndef LIBV2_H_
#define LIBV2_H_
#ifdef __cplusplus
extern "C"
{
#endif

	// init sound system
	// data: pointer to V2M file
	// hWnd: your window handle
  extern void __stdcall ssInit(const unsigned char *data, void *hWnd);

	// close sound system
  extern void __stdcall ssClose();

	// start playing (from song start)
	extern void __stdcall ssPlay();

	// stop playing
	extern void __stdcall ssStop();

	// get the current timer value in milliseconds (will be reset when starting)
	// NOTE: The timer value is synchronized with the sound
	//			 output and will thus start at a negative value
	//       while the sound system fills up the first buffer!
	extern long __stdcall ssGetTime();


	// Does a fade-out of the music within "time" milliseconds.
	// NOTE: Due to sound card latency, the fade will start
	//       some msecs later than you called this function, so
	//       make sure you wait a certain amount of time to
	//       not interrupt a running fade... or so...
	extern void __stdcall ssFadeOut(unsigned long time);

  // make the sound system render the next block
  // put this in your frame loop
	// NOTE: The sound output normally runs in its own background
	//       thread which gets called often enough to keep the
	//       music running without any glitch, so omitting this
	//       call won't do any harm. BUT: if you have video output
	//       this can seriously hurt your frame rate as the sound
	//       thread takes CPU time whenever it finds it necessary
	//       (and will probably make eg. Direct3D miss that VSync
	//       it would have made otherwise).
	//       If you put this call into your per-frame loop, you
	//       guarantee that audio rendering will be in-sync with
	//       your video rendering and your visuals will run smoothly.
  extern void __stdcall ssDoTick();

#ifdef __cplusplus
}
#endif
#endif
