
; VBE2.ASM - VBE 2.0 Library
; (C) 1998 fairway@gmx.net

          BITS 32
          GLOBAL _blitscreen3216;
          GLOBAL _xcopy;
          GLOBAL _wait_retrace;

	  SECTION .text

;---------------------------------------------------------------
; void wait_retrace();
;---------------------------------------------------------------
_wait_retrace:
          pusha
          mov   dx,0x3da
.wait1:   in    al,dx
          test  al,0x08
          jnz   .wait1
.wait2:   in    al,dx
          test  al,0x08
          jz    .wait2
          popa
          ret

;---------------------------------------------------------------
; XCopy - Copies a buffer without a special value
;---------------------------------------------------------------
_xcopy:   push  ebp
          mov   ebp,esp
          pushad

          mov   esi,[ebp+8]
          mov   edi,[ebp+12]
          mov   ecx,[ebp+16]

.xcpy1:   lodsd
          cmp   eax,0x0f0f0f
          jb    .xcpy2
          stosd
          jmp   .xcpy3
.xcpy2:   add   edi,4
.xcpy3:   loop  .xcpy1

          popad
          mov   esp,ebp
          pop   ebp
          ret

;---------------------------------------------------------------
; void blit(char *source,char *dest,int x*y)
;---------------------------------------------------------------
_blitscreen3216:
          push  ebp
          mov   ebp,esp
          pushad

          mov    esi,[ebp+8]
          mov    edi,[ebp+12]
          mov    ebp,[ebp+16]
          dec    ebp

          @@blitloop:                                             
          mov    edx,[esi+ebp*4+0]                
          mov    ecx,[esi+ebp*4+4]                
          mov    ebx,[esi+ebp*4+8]                
          mov    eax,[esi+ebp*4+12]               
          shr    dh,2                                                     
          shr    bh,2                                                     
          shr    ch,2                                                     
          shr    ah,2                                                     
          shr    edx,3                                            
          shr    ecx,3                                            
          shr    ebx,3                                            
          shr    eax,3                                            
          shl    dx,5                                                     
          shl    bx,5                                                     
          shl    cx,5                                                     
          shl    ax,5                                                     
          shr    edx,5                                            
          shl    ecx,11                                           
          shr    ebx,5                                            
          shl    eax,11                                           
          mov    cx,dx                                            
          mov    ax,bx                                            
          mov    [edi+ebp*2+0],ecx                
          mov    [edi+ebp*2+4],eax
          dec    ebp
          jns    short @@blitloop
          pop    ebp                                                      

          popad
          mov   esp,ebp
          pop   ebp
          ret


