
/* VBE2.C - VBE 2.0 Library */
/* (C) 1998 fairway@gmx.net */

#include "vbe2.h"

unsigned int addr;               // Address of the linear frame buffer
unsigned short *vid_point;       // 16 bit pointer

int getvbeinfo(VbeInfoBlock *vbeinfo)
{
  __dpmi_regs regs;

  regs.x.ax = 0x4f00;
  regs.x.es = __tb/16;
  regs.x.di = 0;
  __dpmi_int(0x10, &regs);
  dosmemget(__tb,sizeof(*vbeinfo), vbeinfo);
  if (regs.x.ax == 0x4f) return 1;
  return 0;
}

void getmodeinfo(unsigned short mode, VbeModeInfoBlock *modeinfo)
{
  __dpmi_regs regs;

  regs.x.ax = 0x4f01;
  regs.x.cx = mode;
  regs.x.es = __tb/16;
  regs.x.di = 0;
  __dpmi_int(0x10, &regs);
  dosmemget(__tb, sizeof(*modeinfo), modeinfo);
}

int searchvideomode(short x,short y,char bits)
{
  long vidptr;
  unsigned short mode;

  vidptr = ((vbeinfo.VideoModePtr & 0xffff0000) >> 12)
         + (vbeinfo.VideoModePtr & 0xffff);

  while((mode = _farpeekw(_dos_ds,vidptr)) != 0xffff)
  {
    getmodeinfo(mode,&modeinfo);
    if ((modeinfo.XResolution == x) && (modeinfo.YResolution == y) &&
      (modeinfo.BitsPerPixel == bits)) return(mode);
    vidptr += 2;
  }

  return 0;
}

int testmode(short x,short y,char bits)
{
  int mode;

  if (!getvbeinfo(&vbeinfo))
  {
    printf("\nVESA not available.\n");
    exit(1);
  }

  if (vbeinfo.VbeVersion<0x200)
  {
    printf("\nVBE 2.0 not available.\n");
    printf("Please try with Scitech Display Doctor.\n");
    exit(1);
  }

  if (!(mode = searchvideomode(x,y,bits)))
  {
    printf("\nMode %ux%ux%u bpp not supported by this video card.\n",x,y,bits);
    exit(1);
  }

  return(mode);
}

void initmode(int mode)
{
  __dpmi_regs regs;
  __dpmi_meminfo mem;

  int xres,yres,bpp;

  getmodeinfo(mode,&modeinfo);
  xres = modeinfo.XResolution;
  yres = modeinfo.YResolution;
  bpp = modeinfo.BitsPerPixel/8;

  mem.size = yres*xres*(bpp+1);
  mem.address = modeinfo.PhysBasePtr;
  __dpmi_physical_address_mapping(&mem);

  addr=mem.address;
  vid_point = (unsigned short *)(addr + __djgpp_conventional_base);

  regs.x.ax = 0x4f02;
  regs.x.bx = 0x4000+mode;
  __dpmi_int(0x10, &regs);
}

void settextmode()
{
  __dpmi_regs r;
  r.x.ax = 0x0003;
  __dpmi_int(0x10,&r);
}

