	  BITS 32
          GLOBAL _asmblurscreenrgbmmx
          EXTERN _schweif:320*200*4
;         GLOBAL _mmxdetection
;         GLOBAL _mmxdetected

	  SECTION .text



_asmblurscreenrgbmmx:
	push    ebp
	mov     ebp,esp
        push    esi

        pxor    mm7,mm7                         ;mmxregister auf 0
        movd    mm6,[ebp+8]                     ;parameter in mm6 register

        mov     esi,320*4                         ;esi = n = counter

@mmxloop:
        movd    mm0,[_schweif+esi+319*4]        ;(l)mm0 = schweif {0000000011111111}
        punpcklbw mm0,mm7                       ;byte->word       {0101010101010101}

        movd    mm1,[_schweif+esi+321*4]
        punpcklbw mm1,mm7

        movd    mm2,[_schweif+esi-319*4]
        punpcklbw mm2,mm7

        movd    mm3,[_schweif+esi-321*4]
        punpcklbw mm3,mm7

        paddusw mm0,mm1                         ;unsig. saturation byte addition
        paddusw mm0,mm2
        paddusw mm0,mm3

        psrlw   mm0,2                           ; div 4
        packuswb mm0,mm7                        ; wieder zurckpacken
        psubusb mm0,mm6                         ; sub variable

        movd     [_schweif+esi],mm0

@wkrlfg:
        lea     esi,[esi+4]
        cmp     esi,199*320*4
        ja      @mmxend
        jmp     @mmxloop

@mmxend:
        emms                                    ;clear mmx

        pop     esi
	mov     esp,ebp
	pop     ebp
	ret


	  SECTION .data
	  SECTION .bss

;_mmxdetected resd 1
_dwvar2      resd 1

