
/* -- TRiP ENGiNE (C) 1998 by FAiRWAY ---------------------------- */

#include <stdio.h>
#include <conio.h>
#include <midasdll.h>
#include <string.h>
#include <sys/movedata.h>
#include <mem.h>

#include <mag.h>

#include <allegro.h>

#include <x_src_me.h>
#include <x_src_st.h>

/* ---- DEFINE --------------------------------------------------- */

#define PX 319
#define PY 240

#define TRUE                    1
#define FALSE                   0

#define X_RES                   640
#define Y_RES                   480
#define BPP                     16

#define PICTURE_X               25
#define PICTURE_Y               70
#define PICTURE_WIDTH           320
#define PICTURE_HEIGHT          240

#define FONT_X                  1000
#define FONT_Y                  23

/* ---- EXTERN VARIABLES/POINTERS -------------------------------- */

extern unsigned char coolfont[];
extern unsigned char ansis[];
extern unsigned char picture1[];
extern unsigned char picture2[];
extern unsigned char picture3[];
extern unsigned char it3[];

/* ---- GLOBAL VARIABLES/POINTERS -------------------------------- */

int mode;

extern volatile char key[128];

unsigned char it3x[PX*PY*3];

unsigned char *screen_ptr;
unsigned char picture_ptr[640*480*3];
unsigned char picture_ptr2[640*480*3];
unsigned char picture32[640*480*4];
unsigned char picture322[640*480*4];
unsigned char picture323[640*480*4];

unsigned char *font_ptr;
unsigned char *virtual_screen;
unsigned char *title_ptr;
unsigned char *credits_ptr;
unsigned char *end_ptr;

unsigned int  row_number=0;
unsigned int  pic_number=0;
unsigned long txt_offset=0;

int fxstart;
int fystart;
int fheight;
int fwidth;

/* ---- PROCEDURES ----------------------------------------------- */

/****************************************************************************\
*
* Function:     void MIDASerror(void)
*
* Description:  Displays most recent MIDAS error and exits to DOS
*
\****************************************************************************/

void MIDASerror(void)
{
    printf("MIDAS error: %s\n", MIDASgetErrorMessage(MIDASgetLastError()));
#ifndef NOMUSIC
    MIDASclose();
#endif
    exit(1);
}

x_src_streamT *fp;

extern unsigned short *vid_point;

unsigned char *screen1;
unsigned char *jpeg;

void memory_error()
{
  printf("\nNot enough memory!\n");
  exit(1);
}

void init_demo_system(short x,short y,short bpp)
{
  int mode;
  if ((screen1 = (unsigned char*)malloc(X_RES*Y_RES*4)) == NULL) memory_error();
  if ((jpeg = (unsigned char*)malloc(X_RES*Y_RES*4)) == NULL) memory_error();
  mode = testmode(x,y,bpp);
  initmode(mode);
}

void exit_demo_system()
{
  free(screen1);
  free(jpeg);
  settextmode();
}

void init_font(int x,int y,int height,int width)
{
  fxstart = x;
  fystart = y;
  fheight = height;
  fwidth = width;
}

MIDASmodule module;                     /* Der Module */
MIDASmodulePlayHandle playHandle;       /* Das Playing Handle */

unsigned char colorpal[48] = {
     0,0,0,
     0,0,42,
     0,42,0,
     0,42,42,
     42,0,0,
     42,0,42,
     42,21,0,
     42,42,42,
     21,21,21,
     21,21,63,
     21,63,21,
     21,63,63,
     63,21,21,
     63,21,63,
     63,63,21,
     63,63,63};

unsigned int table16[20];

void build_color_table()
{
  int i,c;
  for (i=0;i<=15;i++)
    table16[i]=makecol16(4*colorpal[i*3],
                         4*colorpal[i*3+1],
                         4*colorpal[i*3+2]);
}

unsigned long table32[480];

void build_table32()
{
  int i;
  for (i=0;i<480;i++)
  table32[i]=i*640*2;
}

unsigned long table33[9999];

void build_table33()
{
  int i;
  for (i=0;i<10000;i++)
  table33[i]=i*160;
}

unsigned int zz=0;
unsigned int e=20;
int z=0;
int current;

void artikel()
{
  int a=0,e=length[zz]-25;
  unsigned long offset=0;
  unsigned char c=0;
  int i=0;
  int x,j,xx;
  int l;
  l = length[zz];

  if (zz > 0)
  for (i=0;i<zz;i++)
    offset += length[i]*160;

  clear_keybuf();

  while((!key[KEY_ESC]) & (!key[KEY_ENTER]))
  {
    memcpy(picture32,picture322,640*480*2);
    putinversetextto16(coolfont,picture32,text+75*current,75,15,16+2*640*10,0);
    blitansito16(coolfont,picture32,ansis+offset,a);

    if (l!=25) x = a*100/(length[zz]-25);
    else x = 0;

    for (xx=0;xx<=1;xx++)
      for (i=0;i<=110;i++)
        for (j=0;j<2;j++)
          picture32[640*2*(450+xx*5)+j+30*2-2+2*i]=0xa5;

    for (i=0;i<=5;i++)
      for (j=0;j<2;j++)
        picture32[640*2*(450+i)+j+30*2-2]=0xa5;

    for (i=0;i<=5;i++)
      for (j=0;j<2;j++)
        picture32[640*2*(450+i)+j+30*2+110*2]=0xa5;

    for (i=0;i<5;i++)
    {
      for (j=0;j<20;j++)
        picture32[640*2*(450+i)+30*2+2*x+j]=0xa5;
    }

    vsync();
    movedata(_my_ds(),(unsigned)picture32,screen->seg,0,640*480*2);

    clear_keybuf();
    while (!keypressed());

    if (key[KEY_HOME]) a=0;
    if (key[KEY_END]) a=e;

    if (key[KEY_UP])
    {
      if (a>0) a--;
    }

    if (key[KEY_DOWN])
    {
      if (a<e) a++;
    }

    if (key[KEY_PGDN])
    {
      if (a<e-25) a+=25; else a=e;
    }

    if (key[KEY_PGUP])
    {
      if (a>25) a-=25; else a=0;
    }
  }
}

int main()
{
  int x,y,mode;
  unsigned int c;
  int i;
  unsigned char d;

  MIDASstartup();

  allegro_init();
  install_keyboard();

  set_color_depth(16);
  if (set_gfx_mode(GFX_VESA2L,640,480,0,0))
  {
    printf("Sorry, but this program doesn't support your video card.\n");
    printf("Please try again with Scitech Display Doctor.\n");
    return 1;
  };

  build_color_table();
  build_table32();
  build_table33();

  MIDASdetectSoundCard();
  MIDASinit();

  _farsetsel(screen->seg);

  fp = X_src_mem_open(picture1,TITLE_PICTURE_SIZE);
  Xread_JPEG_file(fp,picture_ptr2);

  blitscreen24to32(picture_ptr2,picture32,640*480);
  blitscreen32to16(picture32,picture32,640*480);

  fp = X_src_mem_open(picture2,MAIN_PICTURE_SIZE);
  Xread_JPEG_file(fp,picture_ptr);

  blitscreen24to32(picture_ptr,picture322,640*480);
  blitscreen32to16(picture322,picture322,640*480);

  module = MIDASloadModule(MODULE_NAME);
  playHandle = MIDASplayModule(module,TRUE);

  // put the title picture

  vsync();
  movedata(_my_ds(),(unsigned)picture32,screen->seg,0,640*480*2);

  while (!keypressed());
  clear_keybuf();

  while(!key[KEY_ESC])
  {
    memcpy(picture32,picture322,640*480*2);
    z=0;
    putinversetextto16(coolfont,picture32,title,75,15,16+2*640*10);

    table16[14]=makecol16(3*63,3*56,3*21);

    for (i=0;i<e;i++)
    {
      d=text[75*z];
      if (d == '-') z++;
      if (i==zz) {putselectedtextto16(coolfont,picture32,text+75*z,75,15,2*8+640*(4*16+3+15*z)); current=z;}
      else putnormaltextto16(coolfont,picture32,text+75*z,75,7,2*8+640*(4*16+3+15*z));
      z++;
    }

    putnormaltextto16(coolfont,picture32,text+75*current,75,14,16+640*447);

    table16[14]=makecol16(4*63,4*63,4*21);

    vsync();
    movedata(_my_ds(),(unsigned)picture32,screen->seg,0,640*480*2);

    clear_keybuf();
    while (!keypressed());

    if (key[KEY_ENTER])
    {
      artikel();
      clear_keybuf();
    }

    if (key[KEY_HOME]) zz=0;
    if (key[KEY_END]) zz=e-1;

    if (key[KEY_UP])
    {
      if (zz>0) zz--;
    }

    if (key[KEY_DOWN])
    {
      if (zz<e-1) zz++;
    }

    if (key[KEY_PGDN])
    {
      if (zz<e-1) zz=e-1; else zz=e-1;
    }

    if (key[KEY_PGUP])
    {
      if (zz>e-1) zz-=e-1; else zz=0;
    }
  }

  MIDASstopModule(playHandle);
  MIDASfreeModule(module);
  MIDASclose();
  set_gfx_mode(GFX_TEXT,80,25,0,0);
  return 0;
}

