;---  
; Land_draw: draws the landscape on the screen
;-- --   -- -    
Land_draw:         mov   ax, seg landscape
                   mov   ds, ax
                   mov   ax, seg virt_scrn
                   mov   es, ax
                   lea   si, landscape
                   mov   di, Horizon*Xres

                   xor   bp, bp
Land_loop:         mov   cx, 80

Land_x:            lodsb
                   push  di
                   push  cx
                   ;> HZ_line PROC <
                   xor   cx, cx
hz_line:           mov   dx, bp
                   inc   dl
                   mov   dh, dl
                   shl   edx, 16
                   mov   dx, bp
                   inc   dl
                   mov   dh, dl
                   mov   es:[di], edx
                   inc   cl
                   sub   di, Xres
                   cmp   di, Xres
                   ja    HeightOk
                   mov   cl, al
HeightOk:          cmp   cl, al
                   jne   hz_line
                   ;> HZ_line ENDP <
                   pop   cx
                   pop   di

                   add   di, 4
                   dec   cx
                   jnz   Land_x

                   inc   bp

                   push  cx
                   mov   cx, 80
                   mov   ax, bp
                   mov   ah, al
                   shl   eax, 16
                   mov   ax, bp
                   mov   ah, al
                   rep   stosd
                   push  bp
                   push  si
                   push  di
                   call  MakeMOD
                   pop   di
                   pop   si
                   pop   bp
                   pop   cx

                   inc   bp
                   cmp   bp, Clip_b-Horizon
                   jb    Land_loop
                   ret

;---  
; Land_move: moves forward the landscape
;-- --   -- -    
Land_move:         mov   ax, seg landscape
                   mov   ds, ax
                   mov   es, ax
                   mov   si, 99*80
                   lea   di, line_buffer
                   mov   cx, 20
                   rep   movsd

                   mov   si, 98*80
                   mov   di, 99*80

                   mov   cx, 99
Scroll_land_X:     push  cx
                   mov   cx, 20
                   rep   movsd
                   pop   cx

                   sub   si, 160
                   sub   di, 160

                   dec   cx
                   jnz   Scroll_land_X

                   lea   si, line_buffer
                   xor   di, di
                   mov   cx, 20
                   rep   movsd
                   ret