class ZipLine_Gen {
  float spawnRate;
  ArrayList <Line> lines;
  int density;
  String theme;
  boolean startup, shutdown;
  ZipLine_Gen() {
    startup = false;
    shutdown = false;
    theme = "rgb";
    lines = new ArrayList<Line>();
    density = 5;
  } 

  void manageSpawn() {
    float rand = random(0, 1);  
    if (rand < spawnRate) {

      for (int x = 0; x< density; x++) {
        lines.add(new Line(theme));
      }
    }
  }

  void display() {
    for (int i = lines.size()-1; i >= 0; i--) {
      Line l = lines.get(i);
      l.render();
      if (l.finished() == true) {
        lines.remove(i);
      }
    }
  }

  void transitions() {
    if (startup) {
      if (spawnRate < 1) {
        if(theme == "rain"){
          spawnRate += .001;
        } else{
        spawnRate += .01;
        }
      }
      else if (spawnRate >= 1) {
        spawnRate = 1;
        startup = false;
      }
    }

    if (shutdown) {
      if (spawnRate > 0) {
        spawnRate -= .01;
      }
      else if (spawnRate <= 0) {
        spawnRate = 0;
        shutdown = false;
      }
    }
  }

  void render() {
    transitions();
    manageSpawn();
    display();
  }
}
///////////////////////END OF ZIPLINE_GEN


class Line {
  PVector loc1, loc2, vel;
  float size;
  int age, lifespan;
  String theme;


  Line(String _theme) {
    theme = _theme;
    lifespan =(int) random(50, 200);
    size = random(50, 120);

    float startX = 0;
    float startY = random(0, height-random(50));

    vel = new PVector(100, 0);

    loc1 = new PVector(startX, startY);
    loc2 = new PVector(startX + size, startY);
  }

  void step() {
    loc1.add(vel);
    loc2.add(vel);
  }

  void colorize() {
    if (theme == "rgb") {
      colorMode(HSB, 255);
      strokeWeight(4);
      stroke(random(255), 255, 255);
    }

    if (theme == "rain") {
      colorMode(HSB, 255);
      strokeWeight(2);
      stroke(random(222, 252), 100, random(60, 80));
    }
  }

  void display() {
    line(loc1.x, loc1.y, loc2.x, loc2.y);
  }

  void render() {
    colorize();
    display();
    step();

    age++;
  }

  boolean finished() {
    if (age < lifespan) {
      return false ;
    }
    else {
      return true;
    }
  }
}

