//Tree_Trunk(float baseX , float baseY);
class Trunk_Maker {
  PImage[] textures;
  float spawnRate;
  ArrayList <Tree_Trunk> trees;
  int count;

  Trunk_Maker() {
    trees = new ArrayList<Tree_Trunk>();
    textures = new PImage[4];
    for (int x = 0; x < 4; x++) {
      String filename = "bark" + x +".jpg";
      textures[x] = loadImage(filename);
    }
  } 

  void manageSpawn() {
    float rand = random(0, 1);  
    if (count > 100) {
      if (rand < spawnRate) {
        trees.add(new Tree_Trunk(random(width*.1, width*.9), height));
      }
      count = 0;
    }
    count ++;
  }

  void render() {
    manageSpawn();
    display();
  }

  void display() {
    for (int i = trees.size()-1; i >= 0; i--) {
      Tree_Trunk t = trees.get(i);
      t.render();
      if (t.finished() == true) {
        trees.remove(i);
      }
    }
  }



  class Tree_Trunk {
    ArrayList<Plane> planes;
    float baseX, baseY;
    int cnt;

    int age, lifespan;

    Tree_Trunk(float _x, float _y) {
      baseX = _x;
      baseY = _y;
      planes = new ArrayList<Plane>();
      lifespan =(int) random(200, 400);
    }

    void manage() {
      baseX+=.1;
      if (cnt%5 == 0) {
        planes.add(new Plane(textures[(int)random(0, 4)]));
      }
      cnt++;
    }

    void render() {
      manage();
      display();
      age++;
    }

    void display() {
      for (int i = planes.size()-1; i >= 0; i--) {
        Plane plane = planes.get(i);
        plane.render();
        if (plane.finished() == true) {
          planes.remove(i);
        }
      }
    }

    boolean finished() {
      if (age < lifespan) {
        return false ;
      }
      else {
        return true;
      }
    }


    class Plane {
      float offsetX, offsetY;
      int lifeSpan, age;
      PImage tex;
      PVector size;
      Plane(PImage t) {
        tex = t;
        lifeSpan = (int) random(10, 30);
        age = 0;
        offsetX = random(-10, 10);
        offsetY = random(-10, 20);
        size = new PVector(-random(80, 100), -random(400, 1200));
      }
      void render() {
        colorMode(RGB);
        tint(random(100, 140), random(150, 180), random(120, 160), 140);
        image(tex, baseX + offsetX, baseY + offsetY, size.x, size.y );
        noTint();
        age++;
      }

      boolean finished() {
        if (age < lifeSpan) {
          return false ;
        }
        else {
          return true;
        }
      }
    }
  }
}

