class Text_Gen {
  float spawnRate;
  String sourceText;
  String[] splitText;
  ArrayList<Text> words;
  int count;
  PFont font;
  Text_Gen() {
    font = loadFont("starFont.vlw");
    loadText();
    words = new ArrayList<Text>();
  }

  void manageSpawn() {
    if (count > 300) {
      float rand = random(0, 1);
      if (rand < spawnRate) {
        words.add(new Text());
        count = 0;
      }
    }
    count++;
  }

  void display() {
    for (int i = words.size()-1; i >= 0; i--) {
      Text t = words.get(i);
      t.render();
      if (t.finished() == true) {
        words.remove(i);
      }
    }
  }

  void render() {
    manageSpawn();
    display();
  }

  class Text {
    String script = "";
    int age, lifespan, rand, opac;
    int voiceIndex;
    PVector loc, vel;
    String word;
    boolean first = true;
    Text() {
      voiceIndex =(int) random(TextToSpeech.voices.length - 1);
      lifespan =(int) random(200, 300);
      rand = (int) random(0, 24);
      word = splitText[rand];
      script = word;
      loc = new PVector(random(0, width-50), random(0, height-50));
      vel = new PVector(random(.4, 1), 0);
    }

    void fadeIn() {
      loc.add(vel);
      if (opac !=255) {
        opac++;
      }
    }
    void display() {
      if (opac == 10) {
        TextToSpeech.say(script, TextToSpeech.voices[voiceIndex], 90);
        first = false;
      }
      fill(255,opac);
      textFont(font, 32);
      text(word, loc.x, loc.y);
    }

    void render() { 
      fadeIn();
      display();

      age++;
    }
    boolean finished() {
      if (age < lifespan) {
        return false ;
      }
      else {
        return true;
      }
    }
  }

  void loadText() {
    sourceText = "rain forests hike feel alone Northwest stay city nature boots great sky trees forgotten left clouds storm inside use useful recall feel alone Northwest stay city nature boots great sky trees forgotten left clouds storm inside use useful recall";
    splitText = split(sourceText, " ");
  }
}

