//Rain_Producer();

class Rain_Producer {
  boolean startup, shutdown, full;

  float dropRate;
  ArrayList<Drop> drops;
  AudioSample[] dropSound;
  Window_Flash window;
  AudioSample[] t;
  boolean spawn = false;
  int dropGrp;
  PVector wind;

  Rain_Producer () {
    //init drop sound
    dropSound = new AudioSample[5];
    for (int x = 0; x <= 4; x++) {
      String filename = "drip" + x +".aiff";
      dropSound[x] = minim.loadSample(filename, 512);
    }
    //init crash sound
    t = new AudioSample[3];
    for (int x = 0; x<3; x++) {
      String filename = "t" + x + ".aif";
      t[x] = minim.loadSample(filename, 512);
    }
    //init crash generator and texture
    window = new Window_Flash();

    //init rain
    startup = true;

    shutdown = false;

    dropRate = 0;
    drops = new ArrayList<Drop>();
    wind = new PVector(0, 0);
  }

  void create() {
    float rand;
    rand = random(0, 1);
    if (rand < dropRate) {
      int rand1 = (int)random(1, dropGrp );
      for (int x = 0; x<=rand1; x++) {
        drops.add(new Drop());
      }
    }
  }

  void display() {
    for (int i = drops.size()-1; i >= 0; i--) {
      Drop drop = drops.get(i);
      if (drop.finished() == true) {
        drops.remove(i);
      }
      drop.render();
    }
  }
  void render() {
    if (spawn) {
      changeRates();
      create();
      display();
      if (dropRate > .7) {
        window.render();
      }
    }
  }
  void changeRates() {
    if (startup == true) {
      full = false;
      startup();
    }

    if (shutdown == true) {
      full = false;
      shutdown();
    }

    if ((startup == false) && (shutdown == false)) {
      full = true;
      dropGrp =(int) random(30, 60);
      dropRate = 1;
      zipline.theme = "rain";
      zipline.startup = true;
      windChange();
    }
    else {
      zipline.shutdown = true;
    }
  }

  void shutdown() {
    if (dropRate < .1) {
      dropGrp = (int)random(1, 3);
      dropRate -=.0005;
    }
    else {
      dropGrp =(int) random(5, 15);
      dropRate -=.001;
    }
    if (dropRate < -.01) {
      spawn = false;
    }
    windChange();
  } 

  void startup() {
    if (dropRate < .1) {
      dropRate +=.0001;
      dropGrp = (int)random(1, 3);
      ;
    }
    else {
      dropRate +=.002;
      dropGrp =(int) random(5, 15);
    }
    if (dropRate > 1) {

      startup = false;
    }
  }

  void windChange() {
    if (shutdown == false) {
      PVector wChange = new PVector(.00005, 0);
      wind.add(wChange);
    }
    else if (shutdown == true) {
      PVector wChange = new PVector(-.001, 0);
      if (wind.x > 0) {
        wind.add(wChange);
      }
    }
  }

  class Drop {
    PVector loc;
    PVector ploc;
    PVector vel;
    PVector accel;
    float tx;

    Drop() {
      int offset = -41;
      if (full == true) {
        offset = (-500);
      }
      loc = new PVector(random(offset, width), random(-1000, -40));
      ploc = new PVector(loc.x, loc.y);
      vel = new PVector(0, .4);
      accel = new PVector(.009, 3);
    }
    void math() {

      ploc.x = loc.x;
      ploc.y = loc.y;
      accel.add(wind);
      vel.add(accel);
      loc.add(vel);
      tx+=1;
    }

    void render() {
      math();
      strokeWeight(2);
      colorMode(RGB, 255);
      stroke(46, 93, 142);
      line(ploc.x, ploc.y, loc.x, loc.y);
    }

    boolean finished() {
      if (loc.y > height) {
        noStroke();
        colorMode(RGB);
        fill(255, 255, 255);
        arc(loc.x, height, random(6, 13), random(6, 13), PI, 2*PI, OPEN);
        int rand = (int) random(0, 4);
        //dropSound[(int) random(5)].trigger();
        return true;
      }
      else {
        return false;
      }
    }
  }
  /*
  
   WINDOW FLASH CLASS
   
   */
  class Window_Flash {
    int count;
    int delay = 100;
    ArrayList <Flash> flashes;
    PImage[] img;
    Window_Flash () {
      flashes = new ArrayList<Flash>();
      img = new PImage[10];
      for (int x = 0; x<10; x++) {
        String filename = "g"+x+".png";
        img[x] = loadImage(filename);
      }
    }

    void manageSpawn() {
      if (count == delay) {
        float rand = random(0, 1);
        if (rand < .15) {
          t[(int)random(0, 3)].trigger();
          flashes.add(new Flash());
        } 
        count = 0;
      }
    }

    void display() {
      for (int i = flashes.size()-1; i >= 0; i--) {
        Flash fl = flashes.get(i);
        fl.render();
        if (fl.finished() == true) {
          flashes.remove(i);
        }
      }
    }

    void render() {
      manageSpawn();
      display(); 
      count++;
    }

    class Flash {
      int age, lifespan;

      Flash() {
        lifespan = (int) random(30, 45);
      }

      void render() {
        display();
        age++;
      }

      void display() {
        image(img[(int)random(0, 9)], random(0, 200), random(0, 200), random(width-200, width-200), random(height-200, height-200));
      }

      boolean finished() {
        if (age < lifespan) {
          return false ;
        }
        else {
          return true;
        }
      }
    } // end of flash
  }// end of window flash
}// end of rain producer.

class Texture {
  boolean spawn, startup, shutdown;
  PImage[] imgs;
  PImage[] circs;
  float alph, maxAlph;
  PVector loc;
  float cx, cy;

  Texture() {
    imgs =  new PImage[20];
    circs = new PImage[10];
    for (int x = 0;x<imgs.length;x++) {
      String filename = "tex" + x+".png";
      imgs[x] = loadImage(filename);
    }
    for (int x = 0;x<circs.length;x++) {
      String filename = "c" + x+".png";
      circs[x] = loadImage(filename);
    }
    startup = true;
    maxAlph = 50;
    loc = new PVector(random( 250, width-250), random( 250, height-250));
    cx = random(1000000);
    cy = random(1000000);
  }
  void transitions() {
    if (startup) {
      if (alph < maxAlph) {
        alph++;
      }
      else if (alph > maxAlph) {
        alph = maxAlph;
        startup = false;
      }
    }

    if (shutdown) {
      startup = false;
      if (alph > 0) {
        alph -=1;
      } 
      else if (alph < 0) {
        alph = 0;
        shutdown = false;
        spawn = false;
      }
    }
  }
  void display() {
    loc.x = map(noise(cx), 0, 1, 250, width-250);
    loc.y = map(noise(cy), 0, 1, 250, height-250);
    int randcall = (int)random(imgs.length);
    int randcall2 = (int)random(circs.length);

    
    tint(255, alph*5);
    imageMode(CENTER);
    image(circs[randcall2], loc.x, loc.y);

    tint(255, alph);
    imageMode(CORNER);
    image(imgs[randcall], 0, 0, width, height);
    cx +=.1;
    cy +=.1;
  }
  void render() {
    if (spawn) {
      transitions();
      display();
    }
  }
}

