class Night_Scene {
  Moon moon;
  Starfield starfield;
  boolean spawn = false;
  boolean first = true;
  Night_Scene() {
    moon = new Moon();
    starfield = new Starfield(5);
  }

  void display() {
    if (spawn) {
      starfield.render();
      moon.render();
    }
  }

  void pyramidMoon() {
    //filter(GRAY);
    //image(moonMovie, 0, 0);
  }

  void render() {
    display();
  }

  class Moon {
    PImage[] moonpics;
    boolean startup = false;
    boolean shutdown = false;
    int count;
    PVector loc;
    float size;
    int maxsize = 200;
    Moon() {
      moonpics = new PImage[6];
      for (int x = 0; x<6;x++) {
        String filename = "moonImages" + x+".png";
        moonpics[x] = loadImage( filename);
      }
      size = 0;
      loc = new PVector(200, 200);
    }

    void transition() {
      if (startup) {
        size+= .05;
        if (size > maxsize) {
          size = maxsize;
          startup = false;
        }
      }

      if (shutdown) {
        size = 0;
      }
    }
    void step() {
      translate(loc.x, loc.y);
      //rotate(count);
      count++;
    }
    void display() {
      imageMode(CENTER);
      colorMode(HSB);
      fill(0, 0, random(240, 255));
      noStroke();
      int rand = (int) random(0, 6);
      tint(255);
      image(moonpics[rand], -0, -0, size, size);
    }
    void render() {
      pushMatrix();
      transition();
      step();
      display();
      popMatrix();
    }
  }
}
/* 
 
 
 STARFIELD CLASS
 
 
 */


class Starfield {
  Layer[] layers;
  boolean startup, shutdown;
  int amount, count, countC;
  Starfield(int amt) {
    amount = amt;
    startup = true;
    layers = new Layer[amt];
    for (int x = 0; x < amt; x++) {
      layers[x] = new Layer(random(.05, .4));
    }
  }

  void render() {
    for (int x = 0; x < amount; x++) {
      layers[x].render();
    }
  } 

  class Layer {
    PVector drift;
    float msize;
    ArrayList<Star> stars;
    float maxDensity, density;
    Layer(float _drift) {
      maxDensity = 70;
      msize = map(_drift, .05, .4, .8, 4);
      stars = new ArrayList<Star>();
      drift = new PVector( _drift, 0);
    }
    void transitions() {
      if (startup) {
        if (density < maxDensity) {
          if (density <15) {
            density +=.005;
          } 
          else if (density >=15) { 

            density+=.05;
          }
        }
        if (density >= maxDensity) {
          startup = false;
        }
      }
      if (shutdown) {
        density = 0;
        for (int i = stars.size()-2; i >= 0; i--) {
          Star s = stars.get(i);
          stars.remove(i);
        }
      }
    }
    void  manageSpawn() {
      //stars
      if (count > 30) {
        int rando = (int)random(density-30, density);
        for (int x=0;x<rando;x++) {
          stars.add(new Star(msize));
        }
        count = 0;
      }
      count ++;
    }

    void display() {
      //stars
      for (int i = stars.size()-2; i >= 0; i--) {
        Star s = stars.get(i);
        s.render();
        if ((stars.size() > 10)&&(i == 9)) {
          Star s1 = stars.get(8);
          colorMode(HSB);
          stroke(random(255), 255, 255);
          strokeWeight(1);
          float rand = random(0, 1);
          if (rand < .01) {
            line(s.loc.x, s.loc.y, s1.loc.x, s1.loc.y);
          }
        }

        if (s.finished() == true) {
          stars.remove(i);
        }
      }
    }
    void render() {
      transitions();
      manageSpawn();
      display();
    }

    class Star {
      int lifespan, age;
      float size;
      PVector loc;
      Star(float _s) {
        size = _s;
        loc = new PVector(random(0, width), random(0, height));
        lifespan =(int) random(60, 140);
      }

      void step() {
        loc.add(drift);
      }

      void display() {
        noStroke();
        fill(255);
        ellipse(loc.x, loc.y, size, size);
      }
      void render() {
        step();
        display();

        age++;
      }
      boolean finished() {
        if (age < lifespan) {
          return false ;
        }
        else {
          return true;
        }
      }
    } // end of star
  } // end of layer
} // end of starfield

