import processing.core.*; 
import processing.data.*; 
import processing.event.*; 
import processing.opengl.*; 

import ddf.minim.*; 
import processing.video.*; 
import java.util.*; 

import java.util.HashMap; 
import java.util.ArrayList; 
import java.io.File; 
import java.io.BufferedReader; 
import java.io.PrintWriter; 
import java.io.InputStream; 
import java.io.OutputStream; 
import java.io.IOException; 

public class NORTHWEST extends PApplet {

//NORTHWEST by Mark Fingerhut 2013



 

AudioOutput out;
Minim minim;

PImage[] titlePics;
GROUND ground;
Title title;

Cloud_Gen cloud;
Line_Gen line;
Rain_Producer rain;
Night_Scene night;
Time_Keeper time;
Firefly_Gen fly;
Trunk_Maker tree;
RGB_Chaos rgbchaos;
Arrow_Gen arrow;
ZipLine_Gen zipline;
Text_Gen text;
Galaxy galaxy;
Texture texture;



PrintWriter output;
AudioSample gong;
boolean okToRun;
boolean looping = false;

public void setup() {
  load();
}

public void draw() {
  noStroke();
  background(0);
  if (!okToRun) {
    fill(255);
    textSize(24);
    textAlign(LEFT);
    text("Click to Embark", 20, height-20);
  }
  if (okToRun) {
    spawnCheck();
    renderAll();
  }
}

public void spawnCheck() {
  if (time.scene == 1) {

    ground.startup = true;
    rgbchaos.spawnRate = .01f;
  }
  //BEGIN RGB CHAOS
  if (time.scene == 1.5f) {
    rgbchaos.spawnRate = .05f;
  }
  if (time.scene == 2) {
    rgbchaos.spawnRate = .05f;
  }
  if (time.scene == 2.5f) {
    line.spawn = true;
    rgbchaos.spawnRate = .2f;
  }
  if (time.scene == 3) {
    rgbchaos.spawnRate = .4f;
  }
  if (time.scene == 3.5f) {
    line.shutdown = true;
    arrow.spawnRate = .1f;
    rgbchaos.spawnRate = .7f;
  }
  if (time.scene == 4) {
    zipline.shutdown =true; 
    arrow.spawnRate = .2f;
    cloud.spawn = true;
    rgbchaos.spawnRate = .05f;
    tree.spawnRate = .05f;
  }
  //BEGIN RAIN
  if (time.scene == 4.5f) {
    rgbchaos.spawnRate = 0;
    rain.spawn = true;
    arrow.spawnRate = .3f;
    tree.spawnRate = .1f;
  }
  if (time.scene == 5) {
    tree.spawnRate = .2f;
  }
  if (time.scene == 5.5f) {
    tree.spawnRate = .25f;
  }
  if (time.scene == 6) {
    tree.spawnRate = .5f;
    texture.spawn = true;
  }
  if (time.scene == 6.5f) {
    arrow.spawnRate = 0;
    tree.spawnRate = .7f;
  }
  if (time.scene == 7) {
    tree.spawnRate = .2f;
    texture.shutdown = true;
    night.spawn = true;
    rain.shutdown = true;
    night.starfield.startup = true;

    //fly.spawnRate = .1;
  }
  //BGIN NIGHT
  if (time.scene == 7.5f) {
    cloud.shutdown = true;
    tree.spawnRate = .05f;

    //fly.spawnRate = .2;
  }
  if (time.scene == 8) {
    tree.spawnRate = 0;
    night.moon.startup = true;

    //fly.spawnRate = .3;
  }
  if (time.scene == 8.5f) {
    text.spawnRate = .1f;
  }
  if (time.scene == 9) {
    fly.spawn = true;
    galaxy.spawn = true;
  }
  if (time.scene == 9.5f) {
    galaxy.fractalSpawn = true;
  }
  if (time.scene == 10) {
  }
  //END NIGHT
  if (time.scene == 10.5f) {
  }
  if (time.scene == 11) {
    text.spawnRate = 0;
  }
}







public void loadObjects() {
  ground = new GROUND();
  time = new Time_Keeper();
  fly = new Firefly_Gen(3);
  rain= new Rain_Producer();
  line = new Line_Gen(10);
  tree = new Trunk_Maker();
  rgbchaos = new RGB_Chaos();
  arrow = new Arrow_Gen();
  night = new Night_Scene();
  cloud = new Cloud_Gen(3);
  zipline = new ZipLine_Gen();
  text = new Text_Gen();
  galaxy = new Galaxy();
  texture = new Texture();
}

public void renderAll() {
  renderTexture();
  renderZipLine();
  renderNight();
  renderGalaxy();
  renderRGBChaos();
  renderArrow();
  renderTree();
  renderLines();
  renderTitle();
  renderGround();
  renderTime();
  renderFly();
  renderText();
  renderRain();
  renderCloud();
}



public void renderGround() {
  ground.render();
}
public void renderLines() {
  line.render();
}
public void renderRain() {
  rain.render();
}
public void renderFly() {
  fly.render();
}
public void renderTime() {
  time.render();
}
public void renderTree() {
  tree.render();
}
public void renderRGBChaos() {
  rgbchaos.render();
}
public void renderArrow() {
  arrow.render();
}
public void renderNight() {
  night.render();
}
public void renderCloud() {
  cloud.render();
}
public void renderZipLine() {
  zipline.render();
}
public void renderText() {
  text.render();
}
public void renderGalaxy() {
  galaxy.render();
}
public void renderTexture() {
  texture.render();
}
public void movieEvent(Movie m) {
  m.read();
}
public void captureTime() {
  println("This game started at " + minute() + ":" + second());
}

public void renderTitle() {
  title.render();
}

class Title {
  boolean first = true;
  Title() {
  }
  public void render() {
    if ((time.time > 400) &&(time.scene == 1)) {
      if (first) {
        gong.trigger();
        time.soundtrack.trigger();
        night.moon.shutdown = false;
        night.starfield.shutdown = false;
        first = false;
      }
      pushMatrix();
      imageMode(CENTER);
      translate(width/2, height/2);
      rotate(-radians(time.time/22)+45);
      tint(255);
      image(titlePics[(int)random(0, 30)], 0, 0);
      popMatrix();
    }
  }
}

public void stop() {
  minim.stop();
  super.stop();
  output.println ("You wil never go to Northwest.");
  output.flush();
  output.close();
}
/* 
 
 TEXT TO SPEECH
 
 
 */



static class TextToSpeech extends Object {

  // Store the voices, makes for nice auto-complete in Eclipse
  static final String ALEX = "Alex";
  static final String BRUCE = "Bruce";
  static final String FRED = "Fred";
  static final String JUNIOR = "Junior";
  static final String RALPH = "Ralph";
  static final String AGNES = "Agnes";
  static final String KATHY = "Kathy";
  static final String PRINCESS = "Princess";
  static final String VICKI = "Vicki";
  static final String VICTORIA = "Victoria";

  static String[] voices = {
    ALEX, BRUCE, FRED, RALPH, AGNES, KATHY, 
    PRINCESS, VICKI, VICTORIA
  };

  // this sends the "say" command to the terminal with the appropriate args
  public static void say(String script, String voice, int speed) {
    try {
      Runtime.getRuntime().exec(new String[] {
        "say", "-v", voice, "[[rate " + speed + "]]" + script
      }
      );
    }
    catch (IOException e) {
      System.err.println("IOException");
    }
  }

  // Overload the say method so we can call it with fewer arguments and basic defaults
  public static void say(String script) {
    // 200 seems like a resonable default speed
    say(script, ALEX, 200);
  }
}

public void reset() { 
  load();
  //  text.spawnRate = 0;
  //  fly.spawn = false;
  //  zipline.shutdown =false; 
  //  arrow.spawnRate = 0;
  //  cloud.spawn = false;
  //  night.moon.shutdown = true;
  //  night.starfield.shutdown = true;
  //  rgbchaos.spawnRate = 0;
  //  tree.spawnRate = 0;
  //  night.moon.startup = false;
  //  night.starfield.startup = false;
  //  line.shutdown = false;
  //  ground.startup = false;
  //  rain.shutdown = false;
  //  title.first = true;
  //  galaxy.spawn = false;
  //  galaxy.fractalSpawn = false;
  //  time.time = 0;
  //  time.story.reset();
}

public void mousePressed() {
  okToRun = true;
}

public void keyPressed() {
  if (key == 'r') {
    fill(0);
    rect(0, 0, width, height);
    textAlign(CENTER);
    text("Resetting", width/2, height/2);
    reset();
  }
  if (!okToRun) {
    if (key == 'l') {
      if (looping == false) {
        text("Looping", 20, 40); 
        looping = true;
      }
      else if (looping == true) {
        text("Not Looping", 20, 40); 
        looping = false;
      }
    }
  }
}

public void load() {
  output = createWriter("travelLog.txt"); 
  minim = new Minim(this);
  title = new Title();
  gong = minim.loadSample("gong.aif");
  titlePics = new PImage[30];
  for (int x = 0; x< 30; x++) {
    String filename = "title"+x+".png";
    titlePics[x] = loadImage(filename);
  }
  size(1440, 900, P2D);
  noCursor();
  loadObjects();
  okToRun = false;

  captureTime();
}

//Arrow_Fly(int amount, boolean Arrow?);
class Arrow_Gen {
  AudioPlayer clicking;
  float spawnRate;
  ArrayList <Arrow> arrows;
  int count;

  Arrow_Gen() {
    clicking = minim.loadFile("clicking.wav", 2048);
    arrows = new ArrayList<Arrow>();
  } 

  public void manageSpawn() {
    float rand = random(0, 1);  
    if (count > 30) {
      if (rand < spawnRate) {
        arrows.add(new Arrow());
      }
      count = 0;
    }
    count ++;
  }

  public void render() {
    manageSpawn();
    display();
  }

  public void display() {
    for (int i = arrows.size()-1; i >= 0; i--) {
      Arrow a = arrows.get(i);
      a.render();
      if (a.finished() == true) {
        arrows.remove(i);
      }
    }
  }


  class Arrow {
    PVector loc, ploc;
    PImage arrow;
    float tx, ty;
    int age, lifespan;
    Arrow () {
      loc = new PVector(width, height);
      ploc = new PVector(width, height);
      tx = random(0, 100000);
      ty = random(0, 100000);
      arrow = loadImage("mac-cursor.png");
      lifespan =(int) random(300, 400);
    }
    public void render() {
      clicking.loop(); 
      step();
      display();

      age++;
    }

    public void display() {
      stroke(255);
      strokeWeight(4);    
      image(arrow, loc.x, loc.y);
    }

    public void step() {
      ploc.x = loc.x;
      ploc.y = loc.y;

      loc.x = map(noise(tx), 0, 1, -200, width+200);
      loc.y = map(noise(ty), 0, 1, -200, height+200);
      tx += 0.01f;
      ty += 0.01f;
    }


    public boolean finished() {
      if (age < lifespan) {
        return false ;
      }
      else {
        return true;
      }
    }
  }
}

class Cloud_Gen {
  AudioPlayer whitenoise;
  boolean spawn= false;
  Cloud[] clouds;
  int amount;
  Random generator;

  boolean startup, shutdown, first;

  Cloud_Gen(int amt) {
    whitenoise = minim.loadFile("whitenoise.aiff",512);
    first = true;
    amount = amt;
    clouds = new Cloud[amount];
    generator = new Random();
    for (int x=0;x<amount;x++) {
      clouds[x] = new Cloud(x*(width/3)+250, random(0, height*.005f));
    }
  }
  public void render() {
    if (spawn) {
      whitenoise.loop();
      if (first) {
        startup = true;
        first = false;
      }
      for (int x=0;x<amount;x++) {
        clouds[x].render();
      }
    }
  } 

  class Cloud {
    ArrayList<Line> lines;
    PVector base;
    float spawnRate = .9f;
    float count, thickness;
    Cloud(float _x, float _y) {
      lines = new ArrayList<Line>();
      base = new PVector(_x, _y);
      base.x = _x;
      base.y = _y;
    }

    public void manageSpawn() {
      float rand = random(0, 1);  
      if (rand < spawnRate) {
        for (int x = 0; x< thickness; x++) {
          lines.add(new Line());
        }
      }
    }

    public void display() {
      for (int i = lines.size()-1; i >= 0; i--) {
        Line l = lines.get(i);
        l.render();
        if (l.finished() == true) {
          lines.remove(i);
        }
      }
    }
    public void render() {
      changeParams();
      manageSpawn();
      display();
    } 

    public void changeParams() {
      PVector move = new PVector(random(0, 10), random(0, 5));
      int max = 20;
      if (startup) {
        float thickCh = .1f;
        if (thickness < max) {
          thickness += thickCh;
        }
        else {
          startup = false;
        }
      }

      if (shutdown) {
        float thickCh = .1f;
        if (thickness <= max) {
          thickness -= thickCh;
        }
        if (thickness < 0) {
          shutdown = false;
          spawn = false;
        }
      }
      if ((shutdown == false) && (startup == false)) {
        thickness = max;
      }
    }

    class Line {
      PVector loc1, loc2;
      int lineFill;
      int age, lifespan;
      Line() {
        loc1 = new PVector(gaus(base.x, 200), gaus(base.y, 50));
        loc2 = new PVector(gaus(base.x, 200), gaus(base.y, 50));
        lifespan =(int) random(3, 10);
      }

      public void step() {
      }
      public void display() {
        colorMode(HSB);
        lineFill = color(0, 0, random(0, 255), random(0, 255));
        strokeWeight(1);
        stroke(lineFill);
        line(loc1.x, loc1.y, loc2.x, loc2.y);
      }
      public void render() {
        step();
        display();

        age++;
      }

      public boolean finished() {
        if (age < lifespan) {
          return false ;
        }
        else {
          return true;
        }
      }
      public float gaus(float baseMean, int offset) {
        float num = (float) generator.nextGaussian();
        float sd = offset;
        float mean = baseMean;
        float x = sd * num + mean;
        return x;
      }
    }
  }
}

class Firefly_Gen {
  AudioPlayer buzz;
  boolean spawn= false;
  Swarm[] swarms;
  int amount;
  Random generator;
  boolean first;

  Firefly_Gen(int amt) {
    //buzz = minim.loadFile("whitenoise.aiff",512);
    first = true;
    amount = amt;
    swarms = new Swarm[amount];
    generator = new Random();
    for (int x=0;x<amount;x++) {
      swarms[x] = new Swarm(random(0, width), height-30);
    }
  }
  public void render() {
    if (spawn) {
      //buzz.loop();
      if (first) {
        first = false;
      }
      for (int x=0;x<amount;x++) {
        swarms[x].render();
      }
    }
  } 

  class Swarm {
    ArrayList<Fly> flies;
    PVector base;
    float spawnRate = .05f;
    float count, thickness;

    Swarm(float _x, float _y) {
      flies = new ArrayList<Fly>();
      base = new PVector(_x, _y);
      thickness = 3;
    }

    public void manageSpawn() {
      float rand = random(0, 1);  
      if (rand < spawnRate) {
        for (int x = 0; x< thickness; x++) {
          flies.add(new Fly(base));
        }
      }
    }

    public void display() {
      for (int i = flies.size()-1; i >= 0; i--) {
        Fly f = flies.get(i);
        f.render();
        if (f.finished() == true) {
          flies.remove(i);
        }
      }
    }
    public void render() {
      manageSpawn();
      display();
    } 

    class Fly {
      PVector loc, vel;
      int age, lifespan;

      Fly(PVector base) {
        age = 0;
        lifespan =(int) random(10, 30);
        loc = new PVector(random(base.x-200, base.x+200), random(base.y-30, base.y+30));
      } 

      public void render() {
        step();
        display();
        age++;
      }
      public void step() {
        vel = new PVector(random(-6, 6), random(-6, 6));
        loc.add(vel);
      }
      public void display() {
        noStroke();
        colorMode(HSB);
        fill(random(60, 70), 125, 255);
        ellipse(loc.x, loc.y, age*.2f, age*.2f);
      }
      public boolean finished() {
        if (age < lifespan) {
          return false ;
        }
        else {
          return true;
        }
      }
    }// end of fly
  }//end of fly swarm
}// end of fireFly_Gen

class Galaxy {
  ArrayList <Circle> circles;
  int numC, count;
  int MaxAmount = 6;

  boolean spawn = false;
  boolean fractalSpawn = false;
  Fractal fractal;
  Galaxy() {
    circles = new ArrayList<Circle>();
    fractal = new Fractal();
  }

  public void manageSpawn() {
    if (count%200 == 0) {
      circles.add(new Circle());
      numC++;
      count = 0;
    }
    count++;
  }

  public void display() {
    for (int i = circles.size()-1; i >= 0; i--) {
      Circle c = circles.get(i);
      c.render();
      if (c.finished() == true) {
        circles.remove(i);
        numC --;
      }
    }
  }
  public void render() {
    if (spawn) {
      manageSpawn();
      display();
      if (fractalSpawn) {
        fractal.render();
      }
    }
  }

  class Circle {
    float size, rot, alph;
    PVector loc;

    Circle() {
      loc = new PVector(width/2, height/2);
      rot = radians(random(360));
      alph = 255;
    }
    public void step() {
      size++;
      translate(loc.x, loc.y);
      rotate(rot);
    }
    public void display() {
      ellipseMode(CENTER);
      noFill();
      colorMode(HSB);
      stroke(0, 0, 255,alph);
      if (size > 700) {
        alph -= 2;
      }
      ellipse(0, 0, size, size);
    }
    public void render() {
      if (spawn) {
        pushMatrix();
        step();
        display();
        popMatrix();
      }
    }
    public boolean finished() {
      if (alph < 0) {
        return true;
      }
      else {
        return false;
      }
    }
  }
}  

/*

 FRACTAL CLASS
 
 
 */

class Fractal {
  int _numChildren =3;
  int _maxLevels = 4;
  Branch _trunk;
  float tx, ty;
  PVector baseloc;

  Fractal() {
    newTree();
    baseloc = new PVector(width/2, height/2);
    tx = random(1000);
    ty = random(1000);
  }

  public void newTree() {
    _trunk = new Branch(1, 0, width/2, height/2, 0);
    _trunk.drawMe();
  }


  class Branch {
    float level, index;
    float x, y;
    float endx, endy;
    float strokeW, alph;
    float len, lenChange;
    float rot, rotChange;

    Branch[] children = new Branch[0];

    Branch(float lev, float ind, float ex, float why, float a) {
      level = lev;
      index = ind;
      strokeW = (1/level)*100;
      alph = (255/level)*a;
      len = (1/level)*random(200);
      rot = random(360);
      lenChange = random(10)-5;
      rotChange = random(2)-1;
      updateMe(ex, why);
      if (level < _maxLevels) {
        children = new Branch[_numChildren];
        for (int x = 0; x<_numChildren; x++) {
          children[x] = new Branch(level+1, x, endx, endy, 1);
        }
      }
    }
    public void updateMe( float ex, float why) {
      PVector loc = new PVector(ex, why);
      PVector grav = new PVector (0, 40);

      x = loc.x;
      y = loc.y;
      rot +=rotChange;
      if (rot>360) {
        rot = 0;
      }
      else if (rot < 0) {
        rot = 360;
      }

      len -= lenChange;
      if (len<0) {
        lenChange*=-1;
      }
      else if (len > 500) {
        lenChange*=-1;
      }

      float radian = radians(rot);

      endx =  x+(len*cos(radian));
      endy = y+(len*sin(radian));

      for (int x = 0; x< children.length; x++) {
        children[x].updateMe(endx, endy);
      }
    }
    public void drawMe() {
      strokeWeight(_maxLevels - level+1);
      colorMode(HSB);
      stroke(0, 0, 255,alph);
      line(x, y, endx, endy);
      ellipse(x, y, 3, 3);
      for (int x=0; x< children.length; x++) {
        children[x].drawMe();
      }
    }
  }
  public void updateLoc() {
    baseloc.x = width/2;
    baseloc.y = height/2;
    tx+= .001f;
    ty+=.001f;
  }

  public void render() {
    updateLoc();
    _trunk.updateMe(width/2, height/2);
    _trunk.drawMe();
  }
}

class GROUND {
  float t = 0.0f;
  float baseY = 750;
  float offset = 900;
  boolean startup, shutdown;
  GROUND() {
    startup = false;
    shutdown = false;
    smooth();
  }

  public void transitions() {
    if (startup) {
      if (offset > baseY) {
        offset -=.1f;
      }
      else {
        offset = baseY;
        startup = false;
      }
    }

    if (shutdown) {
      if (offset >= baseY) {
        offset +=.1f;
      }
      else if (offset > 1200) {
        shutdown = false;
      }
    }
  }

  public void display() {
    noStroke();
    colorMode(RGB);
    fill(0, 15, 15);      
    float xoff = t;
    pushMatrix();
    translate(0, offset);
    beginShape();
    for (int i = 0; i < width; i++) {
      float y = noise(xoff)*(height/5);
      vertex(i, y);
      xoff += 0.001f;
    }
    vertex(width, height);
    vertex(0, height);
    endShape(CLOSE);
    t+= -0.0005f;
    popMatrix();
  }

  public void render() {
    transitions();
    display();
  }
}

//Line_Wander(int AmountOfLines);

class Line_Gen {
  AudioPlayer wave1;
  int MaxAmount;
  ArrayList <Line> lines;
  int age, lifespan, lncnt, count;
  boolean startup, shutdown,first;
  boolean spawn = false;

  Line_Gen(int _amt) {
    startup = true;
    first = true;
    wave1 = minim.loadFile("wave1.aif",2048);
    MaxAmount = _amt;
    lines = new ArrayList <Line>() ;
    lifespan =(int) random(400, 600);
    if (spawn) {
    }
  }

  public void render() {
    if (spawn) {   
      wave1.play();  
      transition();
      display();
    }
    if(!spawn){
     wave1.pause(); 
    }
  }

  public void transition() {
    if (startup) {
      if (lncnt != MaxAmount) {
        if (count%200 == 0) {
          lines.add(new Line());
          lncnt++;
        }
      }
    }
    if (shutdown) {
      startup = false;
      if ((lncnt <= MaxAmount)&&(lncnt > 0)) {
        if (count%100 == 0) {
          lines.remove(0);
          lncnt --;
        }
      }
    }
    count++;
  }

  public void display() {
    for (int i = lines.size()-1; i >= 0; i--) {
      Line l = lines.get(i);
      l.render();
    }
  }

  class Line {
    PVector aloc1, aloc2, bloc1, bloc2;
    float ax, ay, bx, by;
    float tx, ty, tx1, ty1;
    Line() {
      tx = random(0, 100000);
      ty = random(0, 100000);
      tx1 = random(0, 100000);
      ty1 = random(0, 100000);
    }
    public void render() {
      step(); 
      colorMode(HSB);
      stroke(random(360), 360, 360);
      strokeWeight(2);
      line(ax, ay, bx, by);
      //println("line is going from "+ ax + "  " + ay +" to "+ bx + "  "+ by);
    }

    public void step() {
      ax = map(noise(tx), 0, 1, -200, width+200);
      ay = map(noise(ty), 0, 1, -200, height+200);
      bx = map(noise(tx1), 0, 1, -200, width+200);
      by = map(noise(ty1), 0, 1, -200, height+200);
      tx += 0.01f;
      ty += 0.01f;
      tx1 += 0.01f;
      ty1 += 0.01f;
    }
  }

  public boolean finished() {
    if (age < lifespan) {
      return false ;
    }
    else {
      return true;
    }
  }
}

class Night_Scene {
  Moon moon;
  Starfield starfield;
  boolean spawn = false;
  boolean first = true;
  Night_Scene() {
    moon = new Moon();
    starfield = new Starfield(5);
  }

  public void display() {
    if (spawn) {
      starfield.render();
      moon.render();
    }
  }

  public void pyramidMoon() {
    //filter(GRAY);
    //image(moonMovie, 0, 0);
  }

  public void render() {
    display();
  }

  class Moon {
    PImage[] moonpics;
    boolean startup = false;
    boolean shutdown = false;
    int count;
    PVector loc;
    float size;
    int maxsize = 200;
    Moon() {
      moonpics = new PImage[6];
      for (int x = 0; x<6;x++) {
        String filename = "moonImages" + x+".png";
        moonpics[x] = loadImage( filename);
      }
      size = 0;
      loc = new PVector(200, 200);
    }

    public void transition() {
      if (startup) {
        size+= .05f;
        if (size > maxsize) {
          size = maxsize;
          startup = false;
        }
      }

      if (shutdown) {
        size = 0;
      }
    }
    public void step() {
      translate(loc.x, loc.y);
      //rotate(count);
      count++;
    }
    public void display() {
      imageMode(CENTER);
      colorMode(HSB);
      fill(0, 0, random(240, 255));
      noStroke();
      int rand = (int) random(0, 6);
      tint(255);
      image(moonpics[rand], -0, -0, size, size);
    }
    public void render() {
      pushMatrix();
      transition();
      step();
      display();
      popMatrix();
    }
  }
}
/* 
 
 
 STARFIELD CLASS
 
 
 */


class Starfield {
  Layer[] layers;
  boolean startup, shutdown;
  int amount, count, countC;
  Starfield(int amt) {
    amount = amt;
    startup = true;
    layers = new Layer[amt];
    for (int x = 0; x < amt; x++) {
      layers[x] = new Layer(random(.05f, .4f));
    }
  }

  public void render() {
    for (int x = 0; x < amount; x++) {
      layers[x].render();
    }
  } 

  class Layer {
    PVector drift;
    float msize;
    ArrayList<Star> stars;
    float maxDensity, density;
    Layer(float _drift) {
      maxDensity = 70;
      msize = map(_drift, .05f, .4f, .8f, 4);
      stars = new ArrayList<Star>();
      drift = new PVector( _drift, 0);
    }
    public void transitions() {
      if (startup) {
        if (density < maxDensity) {
          if (density <15) {
            density +=.005f;
          } 
          else if (density >=15) { 

            density+=.05f;
          }
        }
        if (density >= maxDensity) {
          startup = false;
        }
      }
      if (shutdown) {
        density = 0;
        for (int i = stars.size()-2; i >= 0; i--) {
          Star s = stars.get(i);
          stars.remove(i);
        }
      }
    }
    public void  manageSpawn() {
      //stars
      if (count > 30) {
        int rando = (int)random(density-30, density);
        for (int x=0;x<rando;x++) {
          stars.add(new Star(msize));
        }
        count = 0;
      }
      count ++;
    }

    public void display() {
      //stars
      for (int i = stars.size()-2; i >= 0; i--) {
        Star s = stars.get(i);
        s.render();
        if ((stars.size() > 10)&&(i == 9)) {
          Star s1 = stars.get(8);
          colorMode(HSB);
          stroke(random(255), 255, 255);
          strokeWeight(1);
          float rand = random(0, 1);
          if (rand < .01f) {
            line(s.loc.x, s.loc.y, s1.loc.x, s1.loc.y);
          }
        }

        if (s.finished() == true) {
          stars.remove(i);
        }
      }
    }
    public void render() {
      transitions();
      manageSpawn();
      display();
    }

    class Star {
      int lifespan, age;
      float size;
      PVector loc;
      Star(float _s) {
        size = _s;
        loc = new PVector(random(0, width), random(0, height));
        lifespan =(int) random(60, 140);
      }

      public void step() {
        loc.add(drift);
      }

      public void display() {
        noStroke();
        fill(255);
        ellipse(loc.x, loc.y, size, size);
      }
      public void render() {
        step();
        display();

        age++;
      }
      public boolean finished() {
        if (age < lifespan) {
          return false ;
        }
        else {
          return true;
        }
      }
    } // end of star
  } // end of layer
} // end of starfield

class RGB_Chaos {
  float spawnRate;
  ArrayList <Band> bands;
  ArrayList <Border_Lines> borders;
  ArrayList<Pixel> pixel;
  ArrayList<Hole> hole;
  AudioSample[] glitches;
  int lineBuff, it;
  RGB_Chaos() {
    glitches = new AudioSample[20];
    for (int x=0;x<20;x++) {
      String filename = "glitch"+x+".aif";
      glitches[x] = minim.loadSample(filename, 512);

      bands = new ArrayList <Band>();
      borders = new ArrayList <Border_Lines>();
      pixel = new ArrayList<Pixel>();
      hole = new ArrayList<Hole>();
    }
  } 
  public void override() {
    hole.add(new Hole());
  }
  public void manageSpawn() {
    if (spawnRate >=.7f) {
      zipline.startup = true; 
      zipline.theme = "rgb";
    } 
    else if (spawnRate <.7f) {
    }
    if (lineBuff > random(2, 10)) {
      float rand = random(0, 1);  
      if (rand < spawnRate) {
        if (it > 25) {
          if (spawnRate >= .7f) {
            hole.add(new Hole());
            it=0;
          }
        }
        if (spawnRate > .4f) {
          pixel.add(new Pixel());
        }
        if (spawnRate > .2f) {
          borders.add(new Border_Lines());
        }

        bands.add(new Band());

        glitches[(int)random(0, 20)].trigger();
      }
      lineBuff = 0;
      it++;
    }
    lineBuff++;
  }
  public void render() {
    manageSpawn();
    display();
  }
  public void display() {
    for (int i = hole.size()-1; i >= 0; i--) {
      Hole h = hole.get(i);
      h.render();
      if (h.finished() == true) {
        hole.remove(i);
      }
    }
    for (int i = bands.size()-1; i >= 0; i--) {
      Band b = bands.get(i);
      b.render();
      if (b.finished() == true) {
        bands.remove(i);
      }
    }
    for (int i = borders.size()-1; i >= 0; i--) {
      Border_Lines b = borders.get(i);
      b.render();
      if (b.finished() == true) {
        borders.remove(i);
      }
    }
    for (int i = pixel.size()-1; i >= 0; i--) {
      Pixel p = pixel.get(i);
      p.render();
      if (p.finished() == true) {
        pixel.remove(i);
      }
    }
  }

  class Band {
    PVector loc;
    int lifespan, age;
    float h;
    Band() {
      h = random(0, 1);
      loc = new PVector(random(0, width), random(0, height));
      lifespan = (int)random(10, 15);
    }
    public void display() {
      colorMode(HSB);
      strokeWeight(1);
      stroke(random(255), 255, 255);

      if (h <.5f) {
        line(loc.x, height, loc.x, 0);
      }
      else {
        line(0, loc.y, width, loc.y);
      }
    }
    public void render() {
      display();
      age++;
    }
    public boolean finished() {
      if (age < lifespan) {
        return false ;
      }
      else {
        return true;
      }
    }
  }//end of Band

  class Border_Lines {
    int side;
    int age, lifespan;

    Border_Lines() {
      //side = 0;
      side = (int) random(0, 3);
      lifespan = (int) random(10, 20);
    }
    public void display() {
      if (side == 0) {
        for (int t=0; t<age;t++) {
          colorMode(HSB);
          strokeWeight(2);
          stroke(random(255), 255, 255);
          line(width-(t*4), 0, width-(t*4), height);
        }
      }
      if (side == 1) {
        for (int t=0; t<age;t++) {
          colorMode(HSB);
          strokeWeight(2);
          stroke(random(255), 255, 255);
          line(0, 0+(t*4), width, 0+(t*4));
        }
      }
      if (side == 2) {
        for (int t=0; t<age;t++) {
          colorMode(HSB);
          strokeWeight(2);
          stroke(random(255), 255, 255);
          line(0+(t*4), 0, 0+(t*4), height);
          ;
        }
      }
    }
    public void render() {
      display();

      age++;
    }

    public boolean finished() {
      if (age < lifespan) {
        return false ;
      }
      else {
        return true;
      }
    }
  }

  class Pixel {
    int age, lifespan;
    Pixel() {
      lifespan =(int) random(5, 10);
    }
    public void render() {
      for (int x=0; x<random(200,1000);x++) {
        point(random(0, width), random(0, height));
      }

      age++;
    }
    public boolean finished() {
      if (age < lifespan) {
        return false ;
      }
      else {
        return true;
      }
    }
  }//End of Pixel
  class Hole {
    int age, lifespan;
    int hue;
    Hole() {
      lifespan =(int) random(16, 30);
      hue =(int) random(0, 255);
    }
    public void display() {
      for (int x = 1; x< age; x++) {
        colorMode(HSB);
        //stroke(random(255), 255, 255-(40*x));
        fill(random(255), 255, 255-(10*x));
        int off = width - ((25*x)-25);
        int hoff = height - ((25*x)-25);
        rectMode(CORNERS);
        rect((25*x)-25, (25*x)-25, off, hoff);
      }
    }
    public void render() {
      display();

      age++;
    }
    public boolean finished() {
      if (age < lifespan) {
        return false ;
      }
      else {
        return true;
      }
    }
  }// end of Hole
} // end of RGB_Chaos

//Rain_Producer();

class Rain_Producer {
  boolean startup, shutdown, full;

  float dropRate;
  ArrayList<Drop> drops;
  AudioSample[] dropSound;
  Window_Flash window;
  AudioSample[] t;
  boolean spawn = false;
  int dropGrp;
  PVector wind;

  Rain_Producer () {
    //init drop sound
    dropSound = new AudioSample[5];
    for (int x = 0; x <= 4; x++) {
      String filename = "drip" + x +".aiff";
      dropSound[x] = minim.loadSample(filename, 512);
    }
    //init crash sound
    t = new AudioSample[3];
    for (int x = 0; x<3; x++) {
      String filename = "t" + x + ".aif";
      t[x] = minim.loadSample(filename, 512);
    }
    //init crash generator and texture
    window = new Window_Flash();

    //init rain
    startup = true;

    shutdown = false;

    dropRate = 0;
    drops = new ArrayList<Drop>();
    wind = new PVector(0, 0);
  }

  public void create() {
    float rand;
    rand = random(0, 1);
    if (rand < dropRate) {
      int rand1 = (int)random(1, dropGrp );
      for (int x = 0; x<=rand1; x++) {
        drops.add(new Drop());
      }
    }
  }

  public void display() {
    for (int i = drops.size()-1; i >= 0; i--) {
      Drop drop = drops.get(i);
      if (drop.finished() == true) {
        drops.remove(i);
      }
      drop.render();
    }
  }
  public void render() {
    if (spawn) {
      changeRates();
      create();
      display();
      if (dropRate > .7f) {
        window.render();
      }
    }
  }
  public void changeRates() {
    if (startup == true) {
      full = false;
      startup();
    }

    if (shutdown == true) {
      full = false;
      shutdown();
    }

    if ((startup == false) && (shutdown == false)) {
      full = true;
      dropGrp =(int) random(30, 60);
      dropRate = 1;
      zipline.theme = "rain";
      zipline.startup = true;
      windChange();
    }
    else {
      zipline.shutdown = true;
    }
  }

  public void shutdown() {
    if (dropRate < .1f) {
      dropGrp = (int)random(1, 3);
      dropRate -=.0005f;
    }
    else {
      dropGrp =(int) random(5, 15);
      dropRate -=.001f;
    }
    if (dropRate < -.01f) {
      spawn = false;
    }
    windChange();
  } 

  public void startup() {
    if (dropRate < .1f) {
      dropRate +=.0001f;
      dropGrp = (int)random(1, 3);
      ;
    }
    else {
      dropRate +=.002f;
      dropGrp =(int) random(5, 15);
    }
    if (dropRate > 1) {

      startup = false;
    }
  }

  public void windChange() {
    if (shutdown == false) {
      PVector wChange = new PVector(.00005f, 0);
      wind.add(wChange);
    }
    else if (shutdown == true) {
      PVector wChange = new PVector(-.001f, 0);
      if (wind.x > 0) {
        wind.add(wChange);
      }
    }
  }

  class Drop {
    PVector loc;
    PVector ploc;
    PVector vel;
    PVector accel;
    float tx;

    Drop() {
      int offset = -41;
      if (full == true) {
        offset = (-500);
      }
      loc = new PVector(random(offset, width), random(-1000, -40));
      ploc = new PVector(loc.x, loc.y);
      vel = new PVector(0, .4f);
      accel = new PVector(.009f, 3);
    }
    public void math() {

      ploc.x = loc.x;
      ploc.y = loc.y;
      accel.add(wind);
      vel.add(accel);
      loc.add(vel);
      tx+=1;
    }

    public void render() {
      math();
      strokeWeight(2);
      colorMode(RGB, 255);
      stroke(46, 93, 142);
      line(ploc.x, ploc.y, loc.x, loc.y);
    }

    public boolean finished() {
      if (loc.y > height) {
        noStroke();
        colorMode(RGB);
        fill(255, 255, 255);
        arc(loc.x, height, random(6, 13), random(6, 13), PI, 2*PI, OPEN);
        int rand = (int) random(0, 4);
        //dropSound[(int) random(5)].trigger();
        return true;
      }
      else {
        return false;
      }
    }
  }
  /*
  
   WINDOW FLASH CLASS
   
   */
  class Window_Flash {
    int count;
    int delay = 100;
    ArrayList <Flash> flashes;
    PImage[] img;
    Window_Flash () {
      flashes = new ArrayList<Flash>();
      img = new PImage[10];
      for (int x = 0; x<10; x++) {
        String filename = "g"+x+".png";
        img[x] = loadImage(filename);
      }
    }

    public void manageSpawn() {
      if (count == delay) {
        float rand = random(0, 1);
        if (rand < .15f) {
          t[(int)random(0, 3)].trigger();
          flashes.add(new Flash());
        } 
        count = 0;
      }
    }

    public void display() {
      for (int i = flashes.size()-1; i >= 0; i--) {
        Flash fl = flashes.get(i);
        fl.render();
        if (fl.finished() == true) {
          flashes.remove(i);
        }
      }
    }

    public void render() {
      manageSpawn();
      display(); 
      count++;
    }

    class Flash {
      int age, lifespan;

      Flash() {
        lifespan = (int) random(30, 45);
      }

      public void render() {
        display();
        age++;
      }

      public void display() {
        image(img[(int)random(0, 9)], random(0, 200), random(0, 200), random(width-200, width-200), random(height-200, height-200));
      }

      public boolean finished() {
        if (age < lifespan) {
          return false ;
        }
        else {
          return true;
        }
      }
    } // end of flash
  }// end of window flash
}// end of rain producer.

class Texture {
  boolean spawn, startup, shutdown;
  PImage[] imgs;
  PImage[] circs;
  float alph, maxAlph;
  PVector loc;
  float cx, cy;

  Texture() {
    imgs =  new PImage[20];
    circs = new PImage[10];
    for (int x = 0;x<imgs.length;x++) {
      String filename = "tex" + x+".png";
      imgs[x] = loadImage(filename);
    }
    for (int x = 0;x<circs.length;x++) {
      String filename = "c" + x+".png";
      circs[x] = loadImage(filename);
    }
    startup = true;
    maxAlph = 50;
    loc = new PVector(random( 250, width-250), random( 250, height-250));
    cx = random(1000000);
    cy = random(1000000);
  }
  public void transitions() {
    if (startup) {
      if (alph < maxAlph) {
        alph++;
      }
      else if (alph > maxAlph) {
        alph = maxAlph;
        startup = false;
      }
    }

    if (shutdown) {
      startup = false;
      if (alph > 0) {
        alph -=1;
      } 
      else if (alph < 0) {
        alph = 0;
        shutdown = false;
        spawn = false;
      }
    }
  }
  public void display() {
    loc.x = map(noise(cx), 0, 1, 250, width-250);
    loc.y = map(noise(cy), 0, 1, 250, height-250);
    int randcall = (int)random(imgs.length);
    int randcall2 = (int)random(circs.length);

    
    tint(255, alph*5);
    imageMode(CENTER);
    image(circs[randcall2], loc.x, loc.y);

    tint(255, alph);
    imageMode(CORNER);
    image(imgs[randcall], 0, 0, width, height);
    cx +=.1f;
    cy +=.1f;
  }
  public void render() {
    if (spawn) {
      transitions();
      display();
    }
  }
}

class Story {
  int part;
  ArrayList <String> words;
  int life;
  int tCnt = 22;
  int opac;
  PFont font;
  String chapter;
  Story () {
    life = 0;
    font = loadFont("story.vlw");
    words = new ArrayList <String>();
    words.add(new String("Rainy forests, we can hike there."));
    words.add(new String("I want to go to Northwest."));
    words.add(new String("We don't need to stay in the city."));
    words.add(new String("There's real nature there. Mud to stick on boots."));
    words.add(new String("We can find a great view to make a habit."));
    words.add(new String("We will feel less alone in the forest."));
    words.add(new String("I imagine it is a lot like home."));
    words.add(new String("When will we get there? It's a long way."));
    words.add(new String("I'm sorry, I forgot you."));
    words.add(new String("It rains there a lot."));
    words.add(new String("I heard it is green."));
    words.add(new String("My childhood neighbor, I forgot."));
    words.add(new String("My work, I forgot."));
    words.add(new String("A small enough city to make a home.")); 
    words.add(new String("My home, I forgot."));
    words.add(new String("It does not exist."));
    words.add(new String("But look at the sky!"));
    words.add(new String("Will we be creative there?"));
    words.add(new String("You told me to enter it for myself."));
    words.add(new String("A self similar pattern of recursion."));
    words.add(new String("The air was too clear for comfort."));
    words.add(new String("We walked across a screen.")); 
    words.add(new String("We."));
  }
  public void render() {
    if (life == 500) {
      int rand = (int) random(0, tCnt);
      chapter = words.get(rand);
      words.remove(rand); 
      tCnt--;
      output.println (chapter);
      output.flush();
      opac = 0;
    }

    changeOpacity();
    if (life != 0 ) {
      display();
    }
    life--;
  }


  public void changeOpacity() {
    if ((life <=500) && (life > 350)) {
      opac++;
    }

    if ((life < 250)) {
      opac --;
    }
  }
  public void display() {
    fill(255, opac);
    textAlign(CENTER);
    textFont(font, 36);
    text(chapter, width/2, 215);
  }

  public void reset() {
    for (int i = words.size()-1; i >= 0; i--) {
      words.remove(i);
    }
    words.add(new String("Rainy forests, we can hike there."));
    words.add(new String("I want to go to Northwest."));
    words.add(new String("We don't need to stay in the city."));
    words.add(new String("There's real nature there. Mud to stick on boots."));
    words.add(new String("We can find a great view to make a habit."));
    words.add(new String("We will feel less alone in the forest."));
    words.add(new String("I imagine it is a lot like home."));
    words.add(new String("When will we get there? It's a long way."));
    words.add(new String("I'm sorry, I forgot you."));
    words.add(new String("It rains there a lot."));
    words.add(new String("I heard it is green."));
    words.add(new String("My childhood neighbor, I forgot."));
    words.add(new String("My work, I forgot."));
    words.add(new String("A small enough city to make a home.")); 
    words.add(new String("My home, I forgot."));
    words.add(new String("It does not exist."));
    words.add(new String("But look at the sky!"));
    words.add(new String("Will we be creative there?"));
    words.add(new String("You told me to enter it for myself."));
    words.add(new String("A self similar pattern of recursion."));
    words.add(new String("The air was too clear for comfort."));
    words.add(new String("We walked across a screen.")); 
    words.add(new String("We."));
    tCnt = 22;
  }
}

class Text_Gen {
  float spawnRate;
  String sourceText;
  String[] splitText;
  ArrayList<Text> words;
  int count;
  PFont font;
  Text_Gen() {
    font = loadFont("starFont.vlw");
    loadText();
    words = new ArrayList<Text>();
  }

  public void manageSpawn() {
    if (count > 300) {
      float rand = random(0, 1);
      if (rand < spawnRate) {
        words.add(new Text());
        count = 0;
      }
    }
    count++;
  }

  public void display() {
    for (int i = words.size()-1; i >= 0; i--) {
      Text t = words.get(i);
      t.render();
      if (t.finished() == true) {
        words.remove(i);
      }
    }
  }

  public void render() {
    manageSpawn();
    display();
  }

  class Text {
    String script = "";
    int age, lifespan, rand, opac;
    int voiceIndex;
    PVector loc, vel;
    String word;
    boolean first = true;
    Text() {
      voiceIndex =(int) random(TextToSpeech.voices.length - 1);
      lifespan =(int) random(200, 300);
      rand = (int) random(0, 24);
      word = splitText[rand];
      script = word;
      loc = new PVector(random(0, width-50), random(0, height-50));
      vel = new PVector(random(.4f, 1), 0);
    }

    public void fadeIn() {
      loc.add(vel);
      if (opac !=255) {
        opac++;
      }
    }
    public void display() {
      if (opac == 10) {
        TextToSpeech.say(script, TextToSpeech.voices[voiceIndex], 90);
        first = false;
      }
      fill(255,opac);
      textFont(font, 32);
      text(word, loc.x, loc.y);
    }

    public void render() { 
      fadeIn();
      display();

      age++;
    }
    public boolean finished() {
      if (age < lifespan) {
        return false ;
      }
      else {
        return true;
      }
    }
  }

  public void loadText() {
    sourceText = "rain forests hike feel alone Northwest stay city nature boots great sky trees forgotten left clouds storm inside use useful recall feel alone Northwest stay city nature boots great sky trees forgotten left clouds storm inside use useful recall";
    splitText = split(sourceText, " ");
  }
}

class Time_Keeper {
  AudioSample soundtrack;
  float time;
  float scene, prevScene;
  int maxTime;
  int startTime;
  PImage[] walk;
  int walkCnt;
  Story story;
  boolean second;
  Time_Keeper() {
    walk = new PImage[10];
    for (int x = 0; x<10; x++) {
      String filename = "walk"+x+".png";
      walk[x] = loadImage(filename);
    }
    soundtrack = minim.loadSample("soundtrack.aif");
    time = 0; 
    maxTime = 16000;
    story = new Story();
  }

  public void render() {
    checkTime();
    display(); 
    story.render();
    time +=1;
  }

  public void checkTime() {

    float timeMili = time/frameRate;
    if ((time >= 0) && (time < maxTime*.05f)) {
      scene = 1;
    }
    if ((time >= maxTime *.05f) && (time < maxTime*.1f)) {
      scene = 1.5f;
    }
    if ((time >= maxTime *.1f) && (time < maxTime*.15f)) {
      scene = 2;
    }
    if ((time >= maxTime *.15f) && (time < maxTime*.2f)) {
      scene = 2.5f;
    }
    if ((time >= maxTime *.2f) && (time < maxTime*.25f)) {
      scene = 3;
    }
    if ((time >= maxTime *.25f) && (time < maxTime*.3f)) {
      scene = 3.5f;
    }
    if ((time >= maxTime *.3f) && (time < maxTime*.35f)) {
      scene = 4;
    }
    if ((time >= maxTime *.35f) && (time < maxTime*.4f)) {
      scene = 4.5f;
    }
    if ((time >= maxTime *.4f) && (time < maxTime*.45f)) {
      scene = 5;
    }
    if ((time >= maxTime *.45f) && (time < maxTime*.5f)) {
      scene = 5.5f;
    }
    if ((time >= maxTime *.5f) && (time < maxTime*.55f)) {
      scene = 6;
    }
    if ((time >= maxTime *.55f) && (time < maxTime*.6f)) {
      scene = 6.5f;
    }
    if ((time >= maxTime *.6f) && (time < maxTime*.65f)) {
      scene = 7;
    }
    if ((time >= maxTime *.65f) && (time < maxTime*.7f)) {
      scene = 7.5f;
    }
    if ((time >= maxTime *.7f) && (time < maxTime*.75f)) {
      scene = 8.0f;
    }
    if ((time >= maxTime *.75f) && (time < maxTime*.8f)) {
      scene = 8.5f;
    }
    if ((time >= maxTime *.8f) && (time < maxTime*.85f)) {
      scene = 9;
    }
    if ((time >= maxTime *.85f) && (time < maxTime*.9f)) {
      scene = 9.5f;
    }
    if ((time >= maxTime *.9f) && (time < maxTime*.95f)) {
      scene = 10;
    }
    if ((time >= maxTime *.95f) && (time < maxTime)) {
      scene = 10.5f;
    }
    if (time > maxTime) {
      scene = 11;
    }

    if (scene != prevScene) {
      if (second == false) {
        story.life = 500;
      }
      second = !second;
    }

    prevScene = scene;
  } 

  public void display() {
    float loc = map(time, 0, maxTime, 0, width);   
    float sin = sin(time/30);
    float sin1 = sin(time/28);
    float walkHeight = map(sin, 0, 1, height, height+2);
    float walkHeight1 = map(sin1, 0, 1, height, height+2);
    imageMode(CORNER);
    tint(255);
    image(walk[walkCnt], width - loc-1, walkHeight, 80, -100);
    tint(230);
    image(walk[walkCnt], width - loc+35, walkHeight1, 70, -90);
    tint(140);
    image(walk[walkCnt], width - loc+55, walkHeight, 80, -110);

    walkCnt++;
    if (walkCnt == 10) {
      walkCnt = 0;
    }
    if (width - loc < -110) {
      if (looping) {
        reset();
      } 
      else {
        exit();
      }
    }
    if (width - loc < -50) {
      float opacity = (loc - width - 50)*6;

      fill(255, opacity);
      textSize(24);
      textAlign(LEFT);
      text("Music was made by Oneohtrix Point Never and used without permission. ", 20, height-20);
      fill(0, opacity);
      rect(0, 0, width, height);
    }
    if (width - loc < -80) {
      textAlign(RIGHT);
      fill(255, 255);
      text("Mark Fingerhut 2013", width-20, height-20);
    }
  }
}

//Tree_Trunk(float baseX , float baseY);
class Trunk_Maker {
  PImage[] textures;
  float spawnRate;
  ArrayList <Tree_Trunk> trees;
  int count;

  Trunk_Maker() {
    trees = new ArrayList<Tree_Trunk>();
    textures = new PImage[4];
    for (int x = 0; x < 4; x++) {
      String filename = "bark" + x +".jpg";
      textures[x] = loadImage(filename);
    }
  } 

  public void manageSpawn() {
    float rand = random(0, 1);  
    if (count > 100) {
      if (rand < spawnRate) {
        trees.add(new Tree_Trunk(random(width*.1f, width*.9f), height));
      }
      count = 0;
    }
    count ++;
  }

  public void render() {
    manageSpawn();
    display();
  }

  public void display() {
    for (int i = trees.size()-1; i >= 0; i--) {
      Tree_Trunk t = trees.get(i);
      t.render();
      if (t.finished() == true) {
        trees.remove(i);
      }
    }
  }



  class Tree_Trunk {
    ArrayList<Plane> planes;
    float baseX, baseY;
    int cnt;

    int age, lifespan;

    Tree_Trunk(float _x, float _y) {
      baseX = _x;
      baseY = _y;
      planes = new ArrayList<Plane>();
      lifespan =(int) random(200, 400);
    }

    public void manage() {
      baseX+=.1f;
      if (cnt%5 == 0) {
        planes.add(new Plane(textures[(int)random(0, 4)]));
      }
      cnt++;
    }

    public void render() {
      manage();
      display();
      age++;
    }

    public void display() {
      for (int i = planes.size()-1; i >= 0; i--) {
        Plane plane = planes.get(i);
        plane.render();
        if (plane.finished() == true) {
          planes.remove(i);
        }
      }
    }

    public boolean finished() {
      if (age < lifespan) {
        return false ;
      }
      else {
        return true;
      }
    }


    class Plane {
      float offsetX, offsetY;
      int lifeSpan, age;
      PImage tex;
      PVector size;
      Plane(PImage t) {
        tex = t;
        lifeSpan = (int) random(10, 30);
        age = 0;
        offsetX = random(-10, 10);
        offsetY = random(-10, 20);
        size = new PVector(-random(80, 100), -random(400, 1200));
      }
      public void render() {
        colorMode(RGB);
        tint(random(100, 140), random(150, 180), random(120, 160), 140);
        image(tex, baseX + offsetX, baseY + offsetY, size.x, size.y );
        noTint();
        age++;
      }

      public boolean finished() {
        if (age < lifeSpan) {
          return false ;
        }
        else {
          return true;
        }
      }
    }
  }
}

class ZipLine_Gen {
  float spawnRate;
  ArrayList <Line> lines;
  int density;
  String theme;
  boolean startup, shutdown;
  ZipLine_Gen() {
    startup = false;
    shutdown = false;
    theme = "rgb";
    lines = new ArrayList<Line>();
    density = 5;
  } 

  public void manageSpawn() {
    float rand = random(0, 1);  
    if (rand < spawnRate) {

      for (int x = 0; x< density; x++) {
        lines.add(new Line(theme));
      }
    }
  }

  public void display() {
    for (int i = lines.size()-1; i >= 0; i--) {
      Line l = lines.get(i);
      l.render();
      if (l.finished() == true) {
        lines.remove(i);
      }
    }
  }

  public void transitions() {
    if (startup) {
      if (spawnRate < 1) {
        if(theme == "rain"){
          spawnRate += .001f;
        } else{
        spawnRate += .01f;
        }
      }
      else if (spawnRate >= 1) {
        spawnRate = 1;
        startup = false;
      }
    }

    if (shutdown) {
      if (spawnRate > 0) {
        spawnRate -= .01f;
      }
      else if (spawnRate <= 0) {
        spawnRate = 0;
        shutdown = false;
      }
    }
  }

  public void render() {
    transitions();
    manageSpawn();
    display();
  }
}
///////////////////////END OF ZIPLINE_GEN


class Line {
  PVector loc1, loc2, vel;
  float size;
  int age, lifespan;
  String theme;


  Line(String _theme) {
    theme = _theme;
    lifespan =(int) random(50, 200);
    size = random(50, 120);

    float startX = 0;
    float startY = random(0, height-random(50));

    vel = new PVector(100, 0);

    loc1 = new PVector(startX, startY);
    loc2 = new PVector(startX + size, startY);
  }

  public void step() {
    loc1.add(vel);
    loc2.add(vel);
  }

  public void colorize() {
    if (theme == "rgb") {
      colorMode(HSB, 255);
      strokeWeight(4);
      stroke(random(255), 255, 255);
    }

    if (theme == "rain") {
      colorMode(HSB, 255);
      strokeWeight(2);
      stroke(random(222, 252), 100, random(60, 80));
    }
  }

  public void display() {
    line(loc1.x, loc1.y, loc2.x, loc2.y);
  }

  public void render() {
    colorize();
    display();
    step();

    age++;
  }

  public boolean finished() {
    if (age < lifespan) {
      return false ;
    }
    else {
      return true;
    }
  }
}

  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "--full-screen", "--bgcolor=#000000", "--hide-stop", "NORTHWEST" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
