class GROUND {
  float t = 0.0;
  float baseY = 750;
  float offset = 900;
  boolean startup, shutdown;
  GROUND() {
    startup = false;
    shutdown = false;
    smooth();
  }

  void transitions() {
    if (startup) {
      if (offset > baseY) {
        offset -=.1;
      }
      else {
        offset = baseY;
        startup = false;
      }
    }

    if (shutdown) {
      if (offset >= baseY) {
        offset +=.1;
      }
      else if (offset > 1200) {
        shutdown = false;
      }
    }
  }

  void display() {
    noStroke();
    colorMode(RGB);
    fill(0, 15, 15);      
    float xoff = t;
    pushMatrix();
    translate(0, offset);
    beginShape();
    for (int i = 0; i < width; i++) {
      float y = noise(xoff)*(height/5);
      vertex(i, y);
      xoff += 0.001;
    }
    vertex(width, height);
    vertex(0, height);
    endShape(CLOSE);
    t+= -0.0005;
    popMatrix();
  }

  void render() {
    transitions();
    display();
  }
}

