class Galaxy {
  ArrayList <Circle> circles;
  int numC, count;
  int MaxAmount = 6;

  boolean spawn = false;
  boolean fractalSpawn = false;
  Fractal fractal;
  Galaxy() {
    circles = new ArrayList<Circle>();
    fractal = new Fractal();
  }

  void manageSpawn() {
    if (count%200 == 0) {
      circles.add(new Circle());
      numC++;
      count = 0;
    }
    count++;
  }

  void display() {
    for (int i = circles.size()-1; i >= 0; i--) {
      Circle c = circles.get(i);
      c.render();
      if (c.finished() == true) {
        circles.remove(i);
        numC --;
      }
    }
  }
  void render() {
    if (spawn) {
      manageSpawn();
      display();
      if (fractalSpawn) {
        fractal.render();
      }
    }
  }

  class Circle {
    float size, rot, alph;
    PVector loc;

    Circle() {
      loc = new PVector(width/2, height/2);
      rot = radians(random(360));
      alph = 255;
    }
    void step() {
      size++;
      translate(loc.x, loc.y);
      rotate(rot);
    }
    void display() {
      ellipseMode(CENTER);
      noFill();
      colorMode(HSB);
      stroke(0, 0, 255,alph);
      if (size > 700) {
        alph -= 2;
      }
      ellipse(0, 0, size, size);
    }
    void render() {
      if (spawn) {
        pushMatrix();
        step();
        display();
        popMatrix();
      }
    }
    boolean finished() {
      if (alph < 0) {
        return true;
      }
      else {
        return false;
      }
    }
  }
}  

/*

 FRACTAL CLASS
 
 
 */

class Fractal {
  int _numChildren =3;
  int _maxLevels = 4;
  Branch _trunk;
  float tx, ty;
  PVector baseloc;

  Fractal() {
    newTree();
    baseloc = new PVector(width/2, height/2);
    tx = random(1000);
    ty = random(1000);
  }

  void newTree() {
    _trunk = new Branch(1, 0, width/2, height/2, 0);
    _trunk.drawMe();
  }


  class Branch {
    float level, index;
    float x, y;
    float endx, endy;
    float strokeW, alph;
    float len, lenChange;
    float rot, rotChange;

    Branch[] children = new Branch[0];

    Branch(float lev, float ind, float ex, float why, float a) {
      level = lev;
      index = ind;
      strokeW = (1/level)*100;
      alph = (255/level)*a;
      len = (1/level)*random(200);
      rot = random(360);
      lenChange = random(10)-5;
      rotChange = random(2)-1;
      updateMe(ex, why);
      if (level < _maxLevels) {
        children = new Branch[_numChildren];
        for (int x = 0; x<_numChildren; x++) {
          children[x] = new Branch(level+1, x, endx, endy, 1);
        }
      }
    }
    void updateMe( float ex, float why) {
      PVector loc = new PVector(ex, why);
      PVector grav = new PVector (0, 40);

      x = loc.x;
      y = loc.y;
      rot +=rotChange;
      if (rot>360) {
        rot = 0;
      }
      else if (rot < 0) {
        rot = 360;
      }

      len -= lenChange;
      if (len<0) {
        lenChange*=-1;
      }
      else if (len > 500) {
        lenChange*=-1;
      }

      float radian = radians(rot);

      endx =  x+(len*cos(radian));
      endy = y+(len*sin(radian));

      for (int x = 0; x< children.length; x++) {
        children[x].updateMe(endx, endy);
      }
    }
    void drawMe() {
      strokeWeight(_maxLevels - level+1);
      colorMode(HSB);
      stroke(0, 0, 255,alph);
      line(x, y, endx, endy);
      ellipse(x, y, 3, 3);
      for (int x=0; x< children.length; x++) {
        children[x].drawMe();
      }
    }
  }
  void updateLoc() {
    baseloc.x = width/2;
    baseloc.y = height/2;
    tx+= .001;
    ty+=.001;
  }

  void render() {
    updateLoc();
    _trunk.updateMe(width/2, height/2);
    _trunk.drawMe();
  }
}

