class Firefly_Gen {
  AudioPlayer buzz;
  boolean spawn= false;
  Swarm[] swarms;
  int amount;
  Random generator;
  boolean first;

  Firefly_Gen(int amt) {
    //buzz = minim.loadFile("whitenoise.aiff",512);
    first = true;
    amount = amt;
    swarms = new Swarm[amount];
    generator = new Random();
    for (int x=0;x<amount;x++) {
      swarms[x] = new Swarm(random(0, width), height-30);
    }
  }
  void render() {
    if (spawn) {
      //buzz.loop();
      if (first) {
        first = false;
      }
      for (int x=0;x<amount;x++) {
        swarms[x].render();
      }
    }
  } 

  class Swarm {
    ArrayList<Fly> flies;
    PVector base;
    float spawnRate = .05;
    float count, thickness;

    Swarm(float _x, float _y) {
      flies = new ArrayList<Fly>();
      base = new PVector(_x, _y);
      thickness = 3;
    }

    void manageSpawn() {
      float rand = random(0, 1);  
      if (rand < spawnRate) {
        for (int x = 0; x< thickness; x++) {
          flies.add(new Fly(base));
        }
      }
    }

    void display() {
      for (int i = flies.size()-1; i >= 0; i--) {
        Fly f = flies.get(i);
        f.render();
        if (f.finished() == true) {
          flies.remove(i);
        }
      }
    }
    void render() {
      manageSpawn();
      display();
    } 

    class Fly {
      PVector loc, vel;
      int age, lifespan;

      Fly(PVector base) {
        age = 0;
        lifespan =(int) random(10, 30);
        loc = new PVector(random(base.x-200, base.x+200), random(base.y-30, base.y+30));
      } 

      void render() {
        step();
        display();
        age++;
      }
      void step() {
        vel = new PVector(random(-6, 6), random(-6, 6));
        loc.add(vel);
      }
      void display() {
        noStroke();
        colorMode(HSB);
        fill(random(60, 70), 125, 255);
        ellipse(loc.x, loc.y, age*.2, age*.2);
      }
      boolean finished() {
        if (age < lifespan) {
          return false ;
        }
        else {
          return true;
        }
      }
    }// end of fly
  }//end of fly swarm
}// end of fireFly_Gen

