/*
 * Decompiled with CFR 0.152.
 */
import ddf.minim.AudioOutput;
import ddf.minim.AudioPlayer;
import ddf.minim.AudioSample;
import ddf.minim.Minim;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Random;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PImage;
import processing.core.PVector;
import processing.video.Movie;

public class NORTHWEST
extends PApplet {
    AudioOutput out;
    Minim minim;
    PImage[] titlePics;
    GROUND ground;
    Title title;
    Cloud_Gen cloud;
    Line_Gen line;
    Rain_Producer rain;
    Night_Scene night;
    Time_Keeper time;
    Firefly_Gen fly;
    Trunk_Maker tree;
    RGB_Chaos rgbchaos;
    Arrow_Gen arrow;
    ZipLine_Gen zipline;
    Text_Gen text;
    Galaxy galaxy;
    Texture texture;
    PrintWriter output;
    AudioSample gong;
    boolean okToRun;
    boolean looping = false;

    public void setup() {
        this.load();
    }

    public void draw() {
        this.noStroke();
        this.background(0);
        if (!this.okToRun) {
            this.fill(255);
            this.textSize(24.0f);
            this.textAlign(37);
            this.text("Click to Embark", 20.0f, this.height - 20);
        }
        if (this.okToRun) {
            this.spawnCheck();
            this.renderAll();
        }
    }

    public void spawnCheck() {
        if (this.time.scene == 1.0f) {
            this.ground.startup = true;
            this.rgbchaos.spawnRate = 0.01f;
        }
        if (this.time.scene == 1.5f) {
            this.rgbchaos.spawnRate = 0.05f;
        }
        if (this.time.scene == 2.0f) {
            this.rgbchaos.spawnRate = 0.05f;
        }
        if (this.time.scene == 2.5f) {
            this.line.spawn = true;
            this.rgbchaos.spawnRate = 0.2f;
        }
        if (this.time.scene == 3.0f) {
            this.rgbchaos.spawnRate = 0.4f;
        }
        if (this.time.scene == 3.5f) {
            this.line.shutdown = true;
            this.arrow.spawnRate = 0.1f;
            this.rgbchaos.spawnRate = 0.7f;
        }
        if (this.time.scene == 4.0f) {
            this.zipline.shutdown = true;
            this.arrow.spawnRate = 0.2f;
            this.cloud.spawn = true;
            this.rgbchaos.spawnRate = 0.05f;
            this.tree.spawnRate = 0.05f;
        }
        if (this.time.scene == 4.5f) {
            this.rgbchaos.spawnRate = 0.0f;
            this.rain.spawn = true;
            this.arrow.spawnRate = 0.3f;
            this.tree.spawnRate = 0.1f;
        }
        if (this.time.scene == 5.0f) {
            this.tree.spawnRate = 0.2f;
        }
        if (this.time.scene == 5.5f) {
            this.tree.spawnRate = 0.25f;
        }
        if (this.time.scene == 6.0f) {
            this.tree.spawnRate = 0.5f;
            this.texture.spawn = true;
        }
        if (this.time.scene == 6.5f) {
            this.arrow.spawnRate = 0.0f;
            this.tree.spawnRate = 0.7f;
        }
        if (this.time.scene == 7.0f) {
            this.tree.spawnRate = 0.2f;
            this.texture.shutdown = true;
            this.night.spawn = true;
            this.rain.shutdown = true;
            this.night.starfield.startup = true;
        }
        if (this.time.scene == 7.5f) {
            this.cloud.shutdown = true;
            this.tree.spawnRate = 0.05f;
        }
        if (this.time.scene == 8.0f) {
            this.tree.spawnRate = 0.0f;
            this.night.moon.startup = true;
        }
        if (this.time.scene == 8.5f) {
            this.text.spawnRate = 0.1f;
        }
        if (this.time.scene == 9.0f) {
            this.fly.spawn = true;
            this.galaxy.spawn = true;
        }
        if (this.time.scene == 9.5f) {
            this.galaxy.fractalSpawn = true;
        }
        float cfr_ignored_0 = this.time.scene;
        float cfr_ignored_1 = this.time.scene;
        if (this.time.scene == 11.0f) {
            this.text.spawnRate = 0.0f;
        }
    }

    public void loadObjects() {
        this.ground = new GROUND();
        this.time = new Time_Keeper();
        this.fly = new Firefly_Gen(3);
        this.rain = new Rain_Producer();
        this.line = new Line_Gen(10);
        this.tree = new Trunk_Maker();
        this.rgbchaos = new RGB_Chaos();
        this.arrow = new Arrow_Gen();
        this.night = new Night_Scene();
        this.cloud = new Cloud_Gen(3);
        this.zipline = new ZipLine_Gen();
        this.text = new Text_Gen();
        this.galaxy = new Galaxy();
        this.texture = new Texture();
    }

    public void renderAll() {
        this.renderTexture();
        this.renderZipLine();
        this.renderNight();
        this.renderGalaxy();
        this.renderRGBChaos();
        this.renderArrow();
        this.renderTree();
        this.renderLines();
        this.renderTitle();
        this.renderGround();
        this.renderTime();
        this.renderFly();
        this.renderText();
        this.renderRain();
        this.renderCloud();
    }

    public void renderGround() {
        this.ground.render();
    }

    public void renderLines() {
        this.line.render();
    }

    public void renderRain() {
        this.rain.render();
    }

    public void renderFly() {
        this.fly.render();
    }

    public void renderTime() {
        this.time.render();
    }

    public void renderTree() {
        this.tree.render();
    }

    public void renderRGBChaos() {
        this.rgbchaos.render();
    }

    public void renderArrow() {
        this.arrow.render();
    }

    public void renderNight() {
        this.night.render();
    }

    public void renderCloud() {
        this.cloud.render();
    }

    public void renderZipLine() {
        this.zipline.render();
    }

    public void renderText() {
        this.text.render();
    }

    public void renderGalaxy() {
        this.galaxy.render();
    }

    public void renderTexture() {
        this.texture.render();
    }

    public void movieEvent(Movie movie) {
        movie.read();
    }

    public void captureTime() {
        NORTHWEST.println((String)("This game started at " + NORTHWEST.minute() + ":" + NORTHWEST.second()));
    }

    public void renderTitle() {
        this.title.render();
    }

    public void stop() {
        this.minim.stop();
        super.stop();
        this.output.println("You wil never go to Northwest.");
        this.output.flush();
        this.output.close();
    }

    public void reset() {
        this.load();
    }

    public void mousePressed() {
        this.okToRun = true;
    }

    public void keyPressed() {
        if (this.key == 'r') {
            this.fill(0);
            this.rect(0.0f, 0.0f, this.width, this.height);
            this.textAlign(3);
            this.text("Resetting", this.width / 2, this.height / 2);
            this.reset();
        }
        if (!this.okToRun && this.key == 'l') {
            if (!this.looping) {
                this.text("Looping", 20.0f, 40.0f);
                this.looping = true;
            } else if (this.looping) {
                this.text("Not Looping", 20.0f, 40.0f);
                this.looping = false;
            }
        }
    }

    public void load() {
        this.output = this.createWriter("travelLog.txt");
        this.minim = new Minim((Object)this);
        this.title = new Title();
        this.gong = this.minim.loadSample("gong.aif");
        this.titlePics = new PImage[30];
        int n = 0;
        while (n < 30) {
            String string = "title" + n + ".png";
            this.titlePics[n] = this.loadImage(string);
            ++n;
        }
        this.size(1440, 900, "processing.opengl.PGraphics2D");
        this.noCursor();
        this.loadObjects();
        this.okToRun = false;
        this.captureTime();
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"--full-screen", "--bgcolor=#000000", "--hide-stop", "NORTHWEST"};
        if (stringArray != null) {
            PApplet.main((String[])NORTHWEST.concat((String[])stringArray2, (String[])stringArray));
        } else {
            PApplet.main((String[])stringArray2);
        }
    }

    class Arrow_Gen {
        AudioPlayer clicking;
        float spawnRate;
        ArrayList<Arrow> arrows;
        int count;

        Arrow_Gen() {
            this.clicking = NORTHWEST.this.minim.loadFile("clicking.wav", 2048);
            this.arrows = new ArrayList();
        }

        public void manageSpawn() {
            float f = NORTHWEST.this.random(0.0f, 1.0f);
            if (this.count > 30) {
                if (f < this.spawnRate) {
                    this.arrows.add(new Arrow());
                }
                this.count = 0;
            }
            ++this.count;
        }

        public void render() {
            this.manageSpawn();
            this.display();
        }

        public void display() {
            int n = this.arrows.size() - 1;
            while (n >= 0) {
                Arrow arrow = this.arrows.get(n);
                arrow.render();
                if (arrow.finished()) {
                    this.arrows.remove(n);
                }
                --n;
            }
        }

        class Arrow {
            PVector loc;
            PVector ploc;
            PImage arrow;
            float tx;
            float ty;
            int age;
            int lifespan;

            Arrow() {
                this.loc = new PVector((float)((Arrow_Gen)Arrow_Gen.this).NORTHWEST.this.width, (float)((Arrow_Gen)Arrow_Gen.this).NORTHWEST.this.height);
                this.ploc = new PVector((float)((Arrow_Gen)Arrow_Gen.this).NORTHWEST.this.width, (float)((Arrow_Gen)Arrow_Gen.this).NORTHWEST.this.height);
                this.tx = NORTHWEST.this.random(0.0f, 100000.0f);
                this.ty = NORTHWEST.this.random(0.0f, 100000.0f);
                this.arrow = NORTHWEST.this.loadImage("mac-cursor.png");
                this.lifespan = (int)NORTHWEST.this.random(300.0f, 400.0f);
            }

            public void render() {
                Arrow_Gen.this.clicking.loop();
                this.step();
                this.display();
                ++this.age;
            }

            public void display() {
                NORTHWEST.this.stroke(255);
                NORTHWEST.this.strokeWeight(4.0f);
                NORTHWEST.this.image(this.arrow, this.loc.x, this.loc.y);
            }

            public void step() {
                this.ploc.x = this.loc.x;
                this.ploc.y = this.loc.y;
                this.loc.x = NORTHWEST.map((float)NORTHWEST.this.noise(this.tx), (float)0.0f, (float)1.0f, (float)-200.0f, (float)(((Arrow_Gen)Arrow_Gen.this).NORTHWEST.this.width + 200));
                this.loc.y = NORTHWEST.map((float)NORTHWEST.this.noise(this.ty), (float)0.0f, (float)1.0f, (float)-200.0f, (float)(((Arrow_Gen)Arrow_Gen.this).NORTHWEST.this.height + 200));
                this.tx += 0.01f;
                this.ty += 0.01f;
            }

            public boolean finished() {
                return this.age >= this.lifespan;
            }
        }
    }

    class Cloud_Gen {
        AudioPlayer whitenoise;
        boolean spawn = false;
        Cloud[] clouds;
        int amount;
        Random generator;
        boolean startup;
        boolean shutdown;
        boolean first;

        Cloud_Gen(int n) {
            this.whitenoise = NORTHWEST.this.minim.loadFile("whitenoise.aiff", 512);
            this.first = true;
            this.amount = n;
            this.clouds = new Cloud[this.amount];
            this.generator = new Random();
            int n2 = 0;
            while (n2 < this.amount) {
                this.clouds[n2] = new Cloud(n2 * (NORTHWEST.this.width / 3) + 250, NORTHWEST.this.random(0.0f, (float)NORTHWEST.this.height * 0.005f));
                ++n2;
            }
        }

        public void render() {
            if (this.spawn) {
                this.whitenoise.loop();
                if (this.first) {
                    this.startup = true;
                    this.first = false;
                }
                int n = 0;
                while (n < this.amount) {
                    this.clouds[n].render();
                    ++n;
                }
            }
        }

        class Cloud {
            ArrayList<Line> lines = new ArrayList();
            PVector base;
            float spawnRate = 0.9f;
            float count;
            float thickness;

            Cloud(float f, float f2) {
                this.base = new PVector(f, f2);
                this.base.x = f;
                this.base.y = f2;
            }

            public void manageSpawn() {
                float f = NORTHWEST.this.random(0.0f, 1.0f);
                if (f < this.spawnRate) {
                    int n = 0;
                    while ((float)n < this.thickness) {
                        this.lines.add(new Line());
                        ++n;
                    }
                }
            }

            public void display() {
                int n = this.lines.size() - 1;
                while (n >= 0) {
                    Line line = this.lines.get(n);
                    line.render();
                    if (line.finished()) {
                        this.lines.remove(n);
                    }
                    --n;
                }
            }

            public void render() {
                this.changeParams();
                this.manageSpawn();
                this.display();
            }

            public void changeParams() {
                float f;
                new PVector(NORTHWEST.this.random(0.0f, 10.0f), NORTHWEST.this.random(0.0f, 5.0f));
                int n = 20;
                if (Cloud_Gen.this.startup) {
                    f = 0.1f;
                    if (this.thickness < (float)n) {
                        this.thickness += f;
                    } else {
                        Cloud_Gen.this.startup = false;
                    }
                }
                if (Cloud_Gen.this.shutdown) {
                    f = 0.1f;
                    if (this.thickness <= (float)n) {
                        this.thickness -= f;
                    }
                    if (this.thickness < 0.0f) {
                        Cloud_Gen.this.shutdown = false;
                        Cloud_Gen.this.spawn = false;
                    }
                }
                if (!Cloud_Gen.this.shutdown && !Cloud_Gen.this.startup) {
                    this.thickness = n;
                }
            }

            class Line {
                PVector loc1;
                PVector loc2;
                int lineFill;
                int age;
                int lifespan;

                Line() {
                    this.loc1 = new PVector(this.gaus(Cloud.this.base.x, 200), this.gaus(Cloud.this.base.y, 50));
                    this.loc2 = new PVector(this.gaus(Cloud.this.base.x, 200), this.gaus(Cloud.this.base.y, 50));
                    this.lifespan = (int)NORTHWEST.this.random(3.0f, 10.0f);
                }

                public void step() {
                }

                public void display() {
                    NORTHWEST.this.colorMode(3);
                    this.lineFill = NORTHWEST.this.color(0.0f, 0.0f, NORTHWEST.this.random(0.0f, 255.0f), NORTHWEST.this.random(0.0f, 255.0f));
                    NORTHWEST.this.strokeWeight(1.0f);
                    NORTHWEST.this.stroke(this.lineFill);
                    NORTHWEST.this.line(this.loc1.x, this.loc1.y, this.loc2.x, this.loc2.y);
                }

                public void render() {
                    this.step();
                    this.display();
                    ++this.age;
                }

                public boolean finished() {
                    return this.age >= this.lifespan;
                }

                public float gaus(float f, int n) {
                    float f2 = (float)((Cloud)Cloud.this).Cloud_Gen.this.generator.nextGaussian();
                    float f3 = n;
                    float f4 = f;
                    float f5 = f3 * f2 + f4;
                    return f5;
                }
            }
        }
    }

    class Firefly_Gen {
        AudioPlayer buzz;
        boolean spawn = false;
        Swarm[] swarms;
        int amount;
        Random generator;
        boolean first = true;

        Firefly_Gen(int n) {
            this.amount = n;
            this.swarms = new Swarm[this.amount];
            this.generator = new Random();
            int n2 = 0;
            while (n2 < this.amount) {
                this.swarms[n2] = new Swarm(NORTHWEST.this.random(0.0f, NORTHWEST.this.width), NORTHWEST.this.height - 30);
                ++n2;
            }
        }

        public void render() {
            if (this.spawn) {
                if (this.first) {
                    this.first = false;
                }
                int n = 0;
                while (n < this.amount) {
                    this.swarms[n].render();
                    ++n;
                }
            }
        }

        class Swarm {
            ArrayList<Fly> flies = new ArrayList();
            PVector base;
            float spawnRate = 0.05f;
            float count;
            float thickness;

            Swarm(float f, float f2) {
                this.base = new PVector(f, f2);
                this.thickness = 3.0f;
            }

            public void manageSpawn() {
                float f = NORTHWEST.this.random(0.0f, 1.0f);
                if (f < this.spawnRate) {
                    int n = 0;
                    while ((float)n < this.thickness) {
                        this.flies.add(new Fly(this.base));
                        ++n;
                    }
                }
            }

            public void display() {
                int n = this.flies.size() - 1;
                while (n >= 0) {
                    Fly fly = this.flies.get(n);
                    fly.render();
                    if (fly.finished()) {
                        this.flies.remove(n);
                    }
                    --n;
                }
            }

            public void render() {
                this.manageSpawn();
                this.display();
            }

            class Fly {
                PVector loc;
                PVector vel;
                int age = 0;
                int lifespan;

                Fly(PVector pVector) {
                    this.lifespan = (int)NORTHWEST.this.random(10.0f, 30.0f);
                    this.loc = new PVector(NORTHWEST.this.random(pVector.x - 200.0f, pVector.x + 200.0f), NORTHWEST.this.random(pVector.y - 30.0f, pVector.y + 30.0f));
                }

                public void render() {
                    this.step();
                    this.display();
                    ++this.age;
                }

                public void step() {
                    this.vel = new PVector(NORTHWEST.this.random(-6.0f, 6.0f), NORTHWEST.this.random(-6.0f, 6.0f));
                    this.loc.add(this.vel);
                }

                public void display() {
                    NORTHWEST.this.noStroke();
                    NORTHWEST.this.colorMode(3);
                    NORTHWEST.this.fill(NORTHWEST.this.random(60.0f, 70.0f), 125.0f, 255.0f);
                    NORTHWEST.this.ellipse(this.loc.x, this.loc.y, (float)this.age * 0.2f, (float)this.age * 0.2f);
                }

                public boolean finished() {
                    return this.age >= this.lifespan;
                }
            }
        }
    }

    class Fractal {
        int _numChildren = 3;
        int _maxLevels = 4;
        Branch _trunk;
        float tx;
        float ty;
        PVector baseloc;

        Fractal() {
            this.newTree();
            this.baseloc = new PVector((float)(NORTHWEST.this.width / 2), (float)(NORTHWEST.this.height / 2));
            this.tx = NORTHWEST.this.random(1000.0f);
            this.ty = NORTHWEST.this.random(1000.0f);
        }

        public void newTree() {
            this._trunk = new Branch(1.0f, 0.0f, NORTHWEST.this.width / 2, NORTHWEST.this.height / 2, 0.0f);
            this._trunk.drawMe();
        }

        public void updateLoc() {
            this.baseloc.x = NORTHWEST.this.width / 2;
            this.baseloc.y = NORTHWEST.this.height / 2;
            this.tx += 0.001f;
            this.ty += 0.001f;
        }

        public void render() {
            this.updateLoc();
            this._trunk.updateMe(NORTHWEST.this.width / 2, NORTHWEST.this.height / 2);
            this._trunk.drawMe();
        }

        class Branch {
            float level;
            float index;
            float x;
            float y;
            float endx;
            float endy;
            float strokeW;
            float alph;
            float len;
            float lenChange;
            float rot;
            float rotChange;
            Branch[] children = new Branch[0];

            Branch(float f, float f2, float f3, float f4, float f5) {
                this.level = f;
                this.index = f2;
                this.strokeW = 1.0f / this.level * 100.0f;
                this.alph = 255.0f / this.level * f5;
                this.len = 1.0f / this.level * NORTHWEST.this.random(200.0f);
                this.rot = NORTHWEST.this.random(360.0f);
                this.lenChange = NORTHWEST.this.random(10.0f) - 5.0f;
                this.rotChange = NORTHWEST.this.random(2.0f) - 1.0f;
                this.updateMe(f3, f4);
                if (this.level < (float)Fractal.this._maxLevels) {
                    this.children = new Branch[Fractal.this._numChildren];
                    int n = 0;
                    while (n < Fractal.this._numChildren) {
                        this.children[n] = new Branch(this.level + 1.0f, n, this.endx, this.endy, 1.0f);
                        ++n;
                    }
                }
            }

            public void updateMe(float f, float f2) {
                PVector pVector = new PVector(f, f2);
                new PVector(0.0f, 40.0f);
                this.x = pVector.x;
                this.y = pVector.y;
                this.rot += this.rotChange;
                if (this.rot > 360.0f) {
                    this.rot = 0.0f;
                } else if (this.rot < 0.0f) {
                    this.rot = 360.0f;
                }
                this.len -= this.lenChange;
                if (this.len < 0.0f) {
                    this.lenChange *= -1.0f;
                } else if (this.len > 500.0f) {
                    this.lenChange *= -1.0f;
                }
                float f3 = NORTHWEST.radians((float)this.rot);
                this.endx = this.x + this.len * NORTHWEST.cos((float)f3);
                this.endy = this.y + this.len * NORTHWEST.sin((float)f3);
                int n = 0;
                while (n < this.children.length) {
                    this.children[n].updateMe(this.endx, this.endy);
                    ++n;
                }
            }

            public void drawMe() {
                NORTHWEST.this.strokeWeight((float)Fractal.this._maxLevels - this.level + 1.0f);
                NORTHWEST.this.colorMode(3);
                NORTHWEST.this.stroke(0.0f, 0.0f, 255.0f, this.alph);
                NORTHWEST.this.line(this.x, this.y, this.endx, this.endy);
                NORTHWEST.this.ellipse(this.x, this.y, 3.0f, 3.0f);
                int n = 0;
                while (n < this.children.length) {
                    this.children[n].drawMe();
                    ++n;
                }
            }
        }
    }

    class GROUND {
        float t = 0.0f;
        float baseY = 750.0f;
        float offset = 900.0f;
        boolean startup = false;
        boolean shutdown = false;

        GROUND() {
            NORTHWEST.this.smooth();
        }

        public void transitions() {
            if (this.startup) {
                if (this.offset > this.baseY) {
                    this.offset -= 0.1f;
                } else {
                    this.offset = this.baseY;
                    this.startup = false;
                }
            }
            if (this.shutdown) {
                if (this.offset >= this.baseY) {
                    this.offset += 0.1f;
                } else if (this.offset > 1200.0f) {
                    this.shutdown = false;
                }
            }
        }

        public void display() {
            NORTHWEST.this.noStroke();
            NORTHWEST.this.colorMode(1);
            NORTHWEST.this.fill(0.0f, 15.0f, 15.0f);
            float f = this.t;
            NORTHWEST.this.pushMatrix();
            NORTHWEST.this.translate(0.0f, this.offset);
            NORTHWEST.this.beginShape();
            int n = 0;
            while (n < NORTHWEST.this.width) {
                float f2 = NORTHWEST.this.noise(f) * (float)(NORTHWEST.this.height / 5);
                NORTHWEST.this.vertex(n, f2);
                f += 0.001f;
                ++n;
            }
            NORTHWEST.this.vertex(NORTHWEST.this.width, NORTHWEST.this.height);
            NORTHWEST.this.vertex(0.0f, NORTHWEST.this.height);
            NORTHWEST.this.endShape(2);
            this.t += -5.0E-4f;
            NORTHWEST.this.popMatrix();
        }

        public void render() {
            this.transitions();
            this.display();
        }
    }

    class Galaxy {
        ArrayList<Circle> circles = new ArrayList();
        int numC;
        int count;
        int MaxAmount = 6;
        boolean spawn = false;
        boolean fractalSpawn = false;
        Fractal fractal;

        Galaxy() {
            this.fractal = new Fractal();
        }

        public void manageSpawn() {
            if (this.count % 200 == 0) {
                this.circles.add(new Circle());
                ++this.numC;
                this.count = 0;
            }
            ++this.count;
        }

        public void display() {
            int n = this.circles.size() - 1;
            while (n >= 0) {
                Circle circle = this.circles.get(n);
                circle.render();
                if (circle.finished()) {
                    this.circles.remove(n);
                    --this.numC;
                }
                --n;
            }
        }

        public void render() {
            if (this.spawn) {
                this.manageSpawn();
                this.display();
                if (this.fractalSpawn) {
                    this.fractal.render();
                }
            }
        }

        class Circle {
            float size;
            float rot;
            float alph;
            PVector loc;

            Circle() {
                this.loc = new PVector((float)(((Galaxy)Galaxy.this).NORTHWEST.this.width / 2), (float)(((Galaxy)Galaxy.this).NORTHWEST.this.height / 2));
                this.rot = NORTHWEST.radians((float)NORTHWEST.this.random(360.0f));
                this.alph = 255.0f;
            }

            public void step() {
                this.size += 1.0f;
                NORTHWEST.this.translate(this.loc.x, this.loc.y);
                NORTHWEST.this.rotate(this.rot);
            }

            public void display() {
                NORTHWEST.this.ellipseMode(3);
                NORTHWEST.this.noFill();
                NORTHWEST.this.colorMode(3);
                NORTHWEST.this.stroke(0.0f, 0.0f, 255.0f, this.alph);
                if (this.size > 700.0f) {
                    this.alph -= 2.0f;
                }
                NORTHWEST.this.ellipse(0.0f, 0.0f, this.size, this.size);
            }

            public void render() {
                if (Galaxy.this.spawn) {
                    NORTHWEST.this.pushMatrix();
                    this.step();
                    this.display();
                    NORTHWEST.this.popMatrix();
                }
            }

            public boolean finished() {
                return this.alph < 0.0f;
            }
        }
    }

    class Line {
        PVector loc1;
        PVector loc2;
        PVector vel;
        float size;
        int age;
        int lifespan;
        String theme;

        Line(String string) {
            this.theme = string;
            this.lifespan = (int)NORTHWEST.this.random(50.0f, 200.0f);
            this.size = NORTHWEST.this.random(50.0f, 120.0f);
            float f = 0.0f;
            float f2 = NORTHWEST.this.random(0.0f, (float)NORTHWEST.this.height - NORTHWEST.this.random(50.0f));
            this.vel = new PVector(100.0f, 0.0f);
            this.loc1 = new PVector(f, f2);
            this.loc2 = new PVector(f + this.size, f2);
        }

        public void step() {
            this.loc1.add(this.vel);
            this.loc2.add(this.vel);
        }

        public void colorize() {
            if (this.theme == "rgb") {
                NORTHWEST.this.colorMode(3, 255.0f);
                NORTHWEST.this.strokeWeight(4.0f);
                NORTHWEST.this.stroke(NORTHWEST.this.random(255.0f), 255.0f, 255.0f);
            }
            if (this.theme == "rain") {
                NORTHWEST.this.colorMode(3, 255.0f);
                NORTHWEST.this.strokeWeight(2.0f);
                NORTHWEST.this.stroke(NORTHWEST.this.random(222.0f, 252.0f), 100.0f, NORTHWEST.this.random(60.0f, 80.0f));
            }
        }

        public void display() {
            NORTHWEST.this.line(this.loc1.x, this.loc1.y, this.loc2.x, this.loc2.y);
        }

        public void render() {
            this.colorize();
            this.display();
            this.step();
            ++this.age;
        }

        public boolean finished() {
            return this.age >= this.lifespan;
        }
    }

    class Line_Gen {
        AudioPlayer wave1;
        int MaxAmount;
        ArrayList<Line> lines;
        int age;
        int lifespan;
        int lncnt;
        int count;
        boolean startup = true;
        boolean shutdown;
        boolean first = true;
        boolean spawn = false;

        Line_Gen(int n) {
            this.wave1 = NORTHWEST.this.minim.loadFile("wave1.aif", 2048);
            this.MaxAmount = n;
            this.lines = new ArrayList();
            this.lifespan = (int)NORTHWEST.this.random(400.0f, 600.0f);
        }

        public void render() {
            if (this.spawn) {
                this.wave1.play();
                this.transition();
                this.display();
            }
            if (!this.spawn) {
                this.wave1.pause();
            }
        }

        public void transition() {
            if (this.startup && this.lncnt != this.MaxAmount && this.count % 200 == 0) {
                this.lines.add(new Line());
                ++this.lncnt;
            }
            if (this.shutdown) {
                this.startup = false;
                if (this.lncnt <= this.MaxAmount && this.lncnt > 0 && this.count % 100 == 0) {
                    this.lines.remove(0);
                    --this.lncnt;
                }
            }
            ++this.count;
        }

        public void display() {
            int n = this.lines.size() - 1;
            while (n >= 0) {
                Line line = this.lines.get(n);
                line.render();
                --n;
            }
        }

        public boolean finished() {
            return this.age >= this.lifespan;
        }

        class Line {
            PVector aloc1;
            PVector aloc2;
            PVector bloc1;
            PVector bloc2;
            float ax;
            float ay;
            float bx;
            float by;
            float tx;
            float ty;
            float tx1;
            float ty1;

            Line() {
                this.tx = NORTHWEST.this.random(0.0f, 100000.0f);
                this.ty = NORTHWEST.this.random(0.0f, 100000.0f);
                this.tx1 = NORTHWEST.this.random(0.0f, 100000.0f);
                this.ty1 = NORTHWEST.this.random(0.0f, 100000.0f);
            }

            public void render() {
                this.step();
                NORTHWEST.this.colorMode(3);
                NORTHWEST.this.stroke(NORTHWEST.this.random(360.0f), 360.0f, 360.0f);
                NORTHWEST.this.strokeWeight(2.0f);
                NORTHWEST.this.line(this.ax, this.ay, this.bx, this.by);
            }

            public void step() {
                this.ax = NORTHWEST.map((float)NORTHWEST.this.noise(this.tx), (float)0.0f, (float)1.0f, (float)-200.0f, (float)(((Line_Gen)Line_Gen.this).NORTHWEST.this.width + 200));
                this.ay = NORTHWEST.map((float)NORTHWEST.this.noise(this.ty), (float)0.0f, (float)1.0f, (float)-200.0f, (float)(((Line_Gen)Line_Gen.this).NORTHWEST.this.height + 200));
                this.bx = NORTHWEST.map((float)NORTHWEST.this.noise(this.tx1), (float)0.0f, (float)1.0f, (float)-200.0f, (float)(((Line_Gen)Line_Gen.this).NORTHWEST.this.width + 200));
                this.by = NORTHWEST.map((float)NORTHWEST.this.noise(this.ty1), (float)0.0f, (float)1.0f, (float)-200.0f, (float)(((Line_Gen)Line_Gen.this).NORTHWEST.this.height + 200));
                this.tx += 0.01f;
                this.ty += 0.01f;
                this.tx1 += 0.01f;
                this.ty1 += 0.01f;
            }
        }
    }

    class Night_Scene {
        Moon moon = new Moon();
        Starfield starfield;
        boolean spawn = false;
        boolean first = true;

        Night_Scene() {
            this.starfield = new Starfield(5);
        }

        public void display() {
            if (this.spawn) {
                this.starfield.render();
                this.moon.render();
            }
        }

        public void pyramidMoon() {
        }

        public void render() {
            this.display();
        }

        class Moon {
            PImage[] moonpics = new PImage[6];
            boolean startup = false;
            boolean shutdown = false;
            int count;
            PVector loc;
            float size;
            int maxsize = 200;

            Moon() {
                int n = 0;
                while (n < 6) {
                    String string = "moonImages" + n + ".png";
                    this.moonpics[n] = NORTHWEST.this.loadImage(string);
                    ++n;
                }
                this.size = 0.0f;
                this.loc = new PVector(200.0f, 200.0f);
            }

            public void transition() {
                if (this.startup) {
                    this.size += 0.05f;
                    if (this.size > (float)this.maxsize) {
                        this.size = this.maxsize;
                        this.startup = false;
                    }
                }
                if (this.shutdown) {
                    this.size = 0.0f;
                }
            }

            public void step() {
                NORTHWEST.this.translate(this.loc.x, this.loc.y);
                ++this.count;
            }

            public void display() {
                NORTHWEST.this.imageMode(3);
                NORTHWEST.this.colorMode(3);
                NORTHWEST.this.fill(0.0f, 0.0f, NORTHWEST.this.random(240.0f, 255.0f));
                NORTHWEST.this.noStroke();
                int n = (int)NORTHWEST.this.random(0.0f, 6.0f);
                NORTHWEST.this.tint(255);
                NORTHWEST.this.image(this.moonpics[n], 0.0f, 0.0f, this.size, this.size);
            }

            public void render() {
                NORTHWEST.this.pushMatrix();
                this.transition();
                this.step();
                this.display();
                NORTHWEST.this.popMatrix();
            }
        }
    }

    class RGB_Chaos {
        float spawnRate;
        ArrayList<Band> bands;
        ArrayList<Border_Lines> borders;
        ArrayList<Pixel> pixel;
        ArrayList<Hole> hole;
        AudioSample[] glitches = new AudioSample[20];
        int lineBuff;
        int it;

        RGB_Chaos() {
            int n = 0;
            while (n < 20) {
                String string = "glitch" + n + ".aif";
                this.glitches[n] = NORTHWEST.this.minim.loadSample(string, 512);
                this.bands = new ArrayList();
                this.borders = new ArrayList();
                this.pixel = new ArrayList();
                this.hole = new ArrayList();
                ++n;
            }
        }

        public void override() {
            this.hole.add(new Hole());
        }

        public void manageSpawn() {
            if (this.spawnRate >= 0.7f) {
                NORTHWEST.this.zipline.startup = true;
                NORTHWEST.this.zipline.theme = "rgb";
            }
            if ((float)this.lineBuff > NORTHWEST.this.random(2.0f, 10.0f)) {
                float f = NORTHWEST.this.random(0.0f, 1.0f);
                if (f < this.spawnRate) {
                    if (this.it > 25 && this.spawnRate >= 0.7f) {
                        this.hole.add(new Hole());
                        this.it = 0;
                    }
                    if (this.spawnRate > 0.4f) {
                        this.pixel.add(new Pixel());
                    }
                    if (this.spawnRate > 0.2f) {
                        this.borders.add(new Border_Lines());
                    }
                    this.bands.add(new Band());
                    this.glitches[(int)NORTHWEST.this.random(0.0f, 20.0f)].trigger();
                }
                this.lineBuff = 0;
                ++this.it;
            }
            ++this.lineBuff;
        }

        public void render() {
            this.manageSpawn();
            this.display();
        }

        public void display() {
            Object object;
            int n = this.hole.size() - 1;
            while (n >= 0) {
                object = this.hole.get(n);
                ((Hole)object).render();
                if (((Hole)object).finished()) {
                    this.hole.remove(n);
                }
                --n;
            }
            n = this.bands.size() - 1;
            while (n >= 0) {
                object = this.bands.get(n);
                ((Band)object).render();
                if (((Band)object).finished()) {
                    this.bands.remove(n);
                }
                --n;
            }
            n = this.borders.size() - 1;
            while (n >= 0) {
                object = this.borders.get(n);
                ((Border_Lines)object).render();
                if (((Border_Lines)object).finished()) {
                    this.borders.remove(n);
                }
                --n;
            }
            n = this.pixel.size() - 1;
            while (n >= 0) {
                object = this.pixel.get(n);
                ((Pixel)object).render();
                if (((Pixel)object).finished()) {
                    this.pixel.remove(n);
                }
                --n;
            }
        }

        class Band {
            PVector loc;
            int lifespan;
            int age;
            float h;

            Band() {
                this.h = NORTHWEST.this.random(0.0f, 1.0f);
                this.loc = new PVector(NORTHWEST.this.random(0.0f, ((RGB_Chaos)RGB_Chaos.this).NORTHWEST.this.width), NORTHWEST.this.random(0.0f, ((RGB_Chaos)RGB_Chaos.this).NORTHWEST.this.height));
                this.lifespan = (int)NORTHWEST.this.random(10.0f, 15.0f);
            }

            public void display() {
                NORTHWEST.this.colorMode(3);
                NORTHWEST.this.strokeWeight(1.0f);
                NORTHWEST.this.stroke(NORTHWEST.this.random(255.0f), 255.0f, 255.0f);
                if (this.h < 0.5f) {
                    NORTHWEST.this.line(this.loc.x, ((RGB_Chaos)RGB_Chaos.this).NORTHWEST.this.height, this.loc.x, 0.0f);
                } else {
                    NORTHWEST.this.line(0.0f, this.loc.y, ((RGB_Chaos)RGB_Chaos.this).NORTHWEST.this.width, this.loc.y);
                }
            }

            public void render() {
                this.display();
                ++this.age;
            }

            public boolean finished() {
                return this.age >= this.lifespan;
            }
        }

        class Border_Lines {
            int side;
            int age;
            int lifespan;

            Border_Lines() {
                this.side = (int)NORTHWEST.this.random(0.0f, 3.0f);
                this.lifespan = (int)NORTHWEST.this.random(10.0f, 20.0f);
            }

            public void display() {
                int n;
                if (this.side == 0) {
                    n = 0;
                    while (n < this.age) {
                        NORTHWEST.this.colorMode(3);
                        NORTHWEST.this.strokeWeight(2.0f);
                        NORTHWEST.this.stroke(NORTHWEST.this.random(255.0f), 255.0f, 255.0f);
                        NORTHWEST.this.line(((RGB_Chaos)RGB_Chaos.this).NORTHWEST.this.width - n * 4, 0.0f, ((RGB_Chaos)RGB_Chaos.this).NORTHWEST.this.width - n * 4, ((RGB_Chaos)RGB_Chaos.this).NORTHWEST.this.height);
                        ++n;
                    }
                }
                if (this.side == 1) {
                    n = 0;
                    while (n < this.age) {
                        NORTHWEST.this.colorMode(3);
                        NORTHWEST.this.strokeWeight(2.0f);
                        NORTHWEST.this.stroke(NORTHWEST.this.random(255.0f), 255.0f, 255.0f);
                        NORTHWEST.this.line(0.0f, 0 + n * 4, ((RGB_Chaos)RGB_Chaos.this).NORTHWEST.this.width, 0 + n * 4);
                        ++n;
                    }
                }
                if (this.side == 2) {
                    n = 0;
                    while (n < this.age) {
                        NORTHWEST.this.colorMode(3);
                        NORTHWEST.this.strokeWeight(2.0f);
                        NORTHWEST.this.stroke(NORTHWEST.this.random(255.0f), 255.0f, 255.0f);
                        NORTHWEST.this.line(0 + n * 4, 0.0f, 0 + n * 4, ((RGB_Chaos)RGB_Chaos.this).NORTHWEST.this.height);
                        ++n;
                    }
                }
            }

            public void render() {
                this.display();
                ++this.age;
            }

            public boolean finished() {
                return this.age >= this.lifespan;
            }
        }

        class Hole {
            int age;
            int lifespan;
            int hue;

            Hole() {
                this.lifespan = (int)NORTHWEST.this.random(16.0f, 30.0f);
                this.hue = (int)NORTHWEST.this.random(0.0f, 255.0f);
            }

            public void display() {
                int n = 1;
                while (n < this.age) {
                    NORTHWEST.this.colorMode(3);
                    NORTHWEST.this.fill(NORTHWEST.this.random(255.0f), 255.0f, 255 - 10 * n);
                    int n2 = ((RGB_Chaos)RGB_Chaos.this).NORTHWEST.this.width - (25 * n - 25);
                    int n3 = ((RGB_Chaos)RGB_Chaos.this).NORTHWEST.this.height - (25 * n - 25);
                    NORTHWEST.this.rectMode(1);
                    NORTHWEST.this.rect(25 * n - 25, 25 * n - 25, n2, n3);
                    ++n;
                }
            }

            public void render() {
                this.display();
                ++this.age;
            }

            public boolean finished() {
                return this.age >= this.lifespan;
            }
        }

        class Pixel {
            int age;
            int lifespan;

            Pixel() {
                this.lifespan = (int)NORTHWEST.this.random(5.0f, 10.0f);
            }

            public void render() {
                int n = 0;
                while ((float)n < NORTHWEST.this.random(200.0f, 1000.0f)) {
                    NORTHWEST.this.point(NORTHWEST.this.random(0.0f, ((RGB_Chaos)RGB_Chaos.this).NORTHWEST.this.width), NORTHWEST.this.random(0.0f, ((RGB_Chaos)RGB_Chaos.this).NORTHWEST.this.height));
                    ++n;
                }
                ++this.age;
            }

            public boolean finished() {
                return this.age >= this.lifespan;
            }
        }
    }

    class Rain_Producer {
        boolean startup;
        boolean shutdown;
        boolean full;
        float dropRate;
        ArrayList<Drop> drops;
        AudioSample[] dropSound = new AudioSample[5];
        Window_Flash window;
        AudioSample[] t;
        boolean spawn = false;
        int dropGrp;
        PVector wind;

        Rain_Producer() {
            String string;
            int n = 0;
            while (n <= 4) {
                string = "drip" + n + ".aiff";
                this.dropSound[n] = NORTHWEST.this.minim.loadSample(string, 512);
                ++n;
            }
            this.t = new AudioSample[3];
            n = 0;
            while (n < 3) {
                string = "t" + n + ".aif";
                this.t[n] = NORTHWEST.this.minim.loadSample(string, 512);
                ++n;
            }
            this.window = new Window_Flash();
            this.startup = true;
            this.shutdown = false;
            this.dropRate = 0.0f;
            this.drops = new ArrayList();
            this.wind = new PVector(0.0f, 0.0f);
        }

        public void create() {
            float f = NORTHWEST.this.random(0.0f, 1.0f);
            if (f < this.dropRate) {
                int n = (int)NORTHWEST.this.random(1.0f, this.dropGrp);
                int n2 = 0;
                while (n2 <= n) {
                    this.drops.add(new Drop());
                    ++n2;
                }
            }
        }

        public void display() {
            int n = this.drops.size() - 1;
            while (n >= 0) {
                Drop drop = this.drops.get(n);
                if (drop.finished()) {
                    this.drops.remove(n);
                }
                drop.render();
                --n;
            }
        }

        public void render() {
            if (this.spawn) {
                this.changeRates();
                this.create();
                this.display();
                if (this.dropRate > 0.7f) {
                    this.window.render();
                }
            }
        }

        public void changeRates() {
            if (this.startup) {
                this.full = false;
                this.startup();
            }
            if (this.shutdown) {
                this.full = false;
                this.shutdown();
            }
            if (!this.startup && !this.shutdown) {
                this.full = true;
                this.dropGrp = (int)NORTHWEST.this.random(30.0f, 60.0f);
                this.dropRate = 1.0f;
                NORTHWEST.this.zipline.theme = "rain";
                NORTHWEST.this.zipline.startup = true;
                this.windChange();
            } else {
                NORTHWEST.this.zipline.shutdown = true;
            }
        }

        public void shutdown() {
            if (this.dropRate < 0.1f) {
                this.dropGrp = (int)NORTHWEST.this.random(1.0f, 3.0f);
                this.dropRate -= 5.0E-4f;
            } else {
                this.dropGrp = (int)NORTHWEST.this.random(5.0f, 15.0f);
                this.dropRate -= 0.001f;
            }
            if (this.dropRate < -0.01f) {
                this.spawn = false;
            }
            this.windChange();
        }

        public void startup() {
            if (this.dropRate < 0.1f) {
                this.dropRate += 1.0E-4f;
                this.dropGrp = (int)NORTHWEST.this.random(1.0f, 3.0f);
            } else {
                this.dropRate += 0.002f;
                this.dropGrp = (int)NORTHWEST.this.random(5.0f, 15.0f);
            }
            if (this.dropRate > 1.0f) {
                this.startup = false;
            }
        }

        public void windChange() {
            if (!this.shutdown) {
                PVector pVector = new PVector(5.0E-5f, 0.0f);
                this.wind.add(pVector);
            } else if (this.shutdown) {
                PVector pVector = new PVector(-0.001f, 0.0f);
                if (this.wind.x > 0.0f) {
                    this.wind.add(pVector);
                }
            }
        }

        class Drop {
            PVector loc;
            PVector ploc;
            PVector vel;
            PVector accel;
            float tx;

            Drop() {
                int n = -41;
                if (Rain_Producer.this.full) {
                    n = -500;
                }
                this.loc = new PVector(NORTHWEST.this.random(n, ((Rain_Producer)Rain_Producer.this).NORTHWEST.this.width), NORTHWEST.this.random(-1000.0f, -40.0f));
                this.ploc = new PVector(this.loc.x, this.loc.y);
                this.vel = new PVector(0.0f, 0.4f);
                this.accel = new PVector(0.009f, 3.0f);
            }

            public void math() {
                this.ploc.x = this.loc.x;
                this.ploc.y = this.loc.y;
                this.accel.add(Rain_Producer.this.wind);
                this.vel.add(this.accel);
                this.loc.add(this.vel);
                this.tx += 1.0f;
            }

            public void render() {
                this.math();
                NORTHWEST.this.strokeWeight(2.0f);
                NORTHWEST.this.colorMode(1, 255.0f);
                NORTHWEST.this.stroke(46.0f, 93.0f, 142.0f);
                NORTHWEST.this.line(this.ploc.x, this.ploc.y, this.loc.x, this.loc.y);
            }

            public boolean finished() {
                if (this.loc.y > (float)((Rain_Producer)Rain_Producer.this).NORTHWEST.this.height) {
                    NORTHWEST.this.noStroke();
                    NORTHWEST.this.colorMode(1);
                    NORTHWEST.this.fill(255.0f, 255.0f, 255.0f);
                    NORTHWEST.this.arc(this.loc.x, ((Rain_Producer)Rain_Producer.this).NORTHWEST.this.height, NORTHWEST.this.random(6.0f, 13.0f), NORTHWEST.this.random(6.0f, 13.0f), (float)Math.PI, (float)Math.PI * 2, 1);
                    NORTHWEST.this.random(0.0f, 4.0f);
                    return true;
                }
                return false;
            }
        }

        class Window_Flash {
            int count;
            int delay = 100;
            ArrayList<Flash> flashes = new ArrayList();
            PImage[] img = new PImage[10];

            Window_Flash() {
                int n = 0;
                while (n < 10) {
                    String string = "g" + n + ".png";
                    this.img[n] = NORTHWEST.this.loadImage(string);
                    ++n;
                }
            }

            public void manageSpawn() {
                if (this.count == this.delay) {
                    float f = NORTHWEST.this.random(0.0f, 1.0f);
                    if (f < 0.15f) {
                        Rain_Producer.this.t[(int)NORTHWEST.this.random(0.0f, 3.0f)].trigger();
                        this.flashes.add(new Flash());
                    }
                    this.count = 0;
                }
            }

            public void display() {
                int n = this.flashes.size() - 1;
                while (n >= 0) {
                    Flash flash = this.flashes.get(n);
                    flash.render();
                    if (flash.finished()) {
                        this.flashes.remove(n);
                    }
                    --n;
                }
            }

            public void render() {
                this.manageSpawn();
                this.display();
                ++this.count;
            }

            class Flash {
                int age;
                int lifespan;

                Flash() {
                    this.lifespan = (int)NORTHWEST.this.random(30.0f, 45.0f);
                }

                public void render() {
                    this.display();
                    ++this.age;
                }

                public void display() {
                    NORTHWEST.this.image(Window_Flash.this.img[(int)NORTHWEST.this.random(0.0f, 9.0f)], NORTHWEST.this.random(0.0f, 200.0f), NORTHWEST.this.random(0.0f, 200.0f), NORTHWEST.this.random(((Rain_Producer)((Window_Flash)Window_Flash.this).Rain_Producer.this).NORTHWEST.this.width - 200, ((Rain_Producer)((Window_Flash)Window_Flash.this).Rain_Producer.this).NORTHWEST.this.width - 200), NORTHWEST.this.random(((Rain_Producer)((Window_Flash)Window_Flash.this).Rain_Producer.this).NORTHWEST.this.height - 200, ((Rain_Producer)((Window_Flash)Window_Flash.this).Rain_Producer.this).NORTHWEST.this.height - 200));
                }

                public boolean finished() {
                    return this.age >= this.lifespan;
                }
            }
        }
    }

    class Starfield {
        Layer[] layers;
        boolean startup;
        boolean shutdown;
        int amount;
        int count;
        int countC;

        Starfield(int n) {
            this.amount = n;
            this.startup = true;
            this.layers = new Layer[n];
            int n2 = 0;
            while (n2 < n) {
                this.layers[n2] = new Layer(NORTHWEST.this.random(0.05f, 0.4f));
                ++n2;
            }
        }

        public void render() {
            int n = 0;
            while (n < this.amount) {
                this.layers[n].render();
                ++n;
            }
        }

        class Layer {
            PVector drift;
            float msize;
            ArrayList<Star> stars;
            float maxDensity = 70.0f;
            float density;

            Layer(float f) {
                this.msize = NORTHWEST.map((float)f, (float)0.05f, (float)0.4f, (float)0.8f, (float)4.0f);
                this.stars = new ArrayList();
                this.drift = new PVector(f, 0.0f);
            }

            public void transitions() {
                if (Starfield.this.startup) {
                    if (this.density < this.maxDensity) {
                        if (this.density < 15.0f) {
                            this.density += 0.005f;
                        } else if (this.density >= 15.0f) {
                            this.density += 0.05f;
                        }
                    }
                    if (this.density >= this.maxDensity) {
                        Starfield.this.startup = false;
                    }
                }
                if (Starfield.this.shutdown) {
                    this.density = 0.0f;
                    int n = this.stars.size() - 2;
                    while (n >= 0) {
                        this.stars.get(n);
                        this.stars.remove(n);
                        --n;
                    }
                }
            }

            public void manageSpawn() {
                if (Starfield.this.count > 30) {
                    int n = (int)NORTHWEST.this.random(this.density - 30.0f, this.density);
                    int n2 = 0;
                    while (n2 < n) {
                        this.stars.add(new Star(this.msize));
                        ++n2;
                    }
                    Starfield.this.count = 0;
                }
                ++Starfield.this.count;
            }

            public void display() {
                int n = this.stars.size() - 2;
                while (n >= 0) {
                    Star star = this.stars.get(n);
                    star.render();
                    if (this.stars.size() > 10 && n == 9) {
                        Star star2 = this.stars.get(8);
                        NORTHWEST.this.colorMode(3);
                        NORTHWEST.this.stroke(NORTHWEST.this.random(255.0f), 255.0f, 255.0f);
                        NORTHWEST.this.strokeWeight(1.0f);
                        float f = NORTHWEST.this.random(0.0f, 1.0f);
                        if (f < 0.01f) {
                            NORTHWEST.this.line(star.loc.x, star.loc.y, star2.loc.x, star2.loc.y);
                        }
                    }
                    if (star.finished()) {
                        this.stars.remove(n);
                    }
                    --n;
                }
            }

            public void render() {
                this.transitions();
                this.manageSpawn();
                this.display();
            }

            class Star {
                int lifespan;
                int age;
                float size;
                PVector loc;

                Star(float f) {
                    this.size = f;
                    this.loc = new PVector(NORTHWEST.this.random(0.0f, ((Starfield)((Layer)Layer.this).Starfield.this).NORTHWEST.this.width), NORTHWEST.this.random(0.0f, ((Starfield)((Layer)Layer.this).Starfield.this).NORTHWEST.this.height));
                    this.lifespan = (int)NORTHWEST.this.random(60.0f, 140.0f);
                }

                public void step() {
                    this.loc.add(Layer.this.drift);
                }

                public void display() {
                    NORTHWEST.this.noStroke();
                    NORTHWEST.this.fill(255);
                    NORTHWEST.this.ellipse(this.loc.x, this.loc.y, this.size, this.size);
                }

                public void render() {
                    this.step();
                    this.display();
                    ++this.age;
                }

                public boolean finished() {
                    return this.age >= this.lifespan;
                }
            }
        }
    }

    class Story {
        int part;
        ArrayList<String> words;
        int life = 0;
        int tCnt = 22;
        int opac;
        PFont font;
        String chapter;

        Story() {
            this.font = NORTHWEST.this.loadFont("story.vlw");
            this.words = new ArrayList();
            this.words.add(new String("Rainy forests, we can hike there."));
            this.words.add(new String("I want to go to Northwest."));
            this.words.add(new String("We don't need to stay in the city."));
            this.words.add(new String("There's real nature there. Mud to stick on boots."));
            this.words.add(new String("We can find a great view to make a habit."));
            this.words.add(new String("We will feel less alone in the forest."));
            this.words.add(new String("I imagine it is a lot like home."));
            this.words.add(new String("When will we get there? It's a long way."));
            this.words.add(new String("I'm sorry, I forgot you."));
            this.words.add(new String("It rains there a lot."));
            this.words.add(new String("I heard it is green."));
            this.words.add(new String("My childhood neighbor, I forgot."));
            this.words.add(new String("My work, I forgot."));
            this.words.add(new String("A small enough city to make a home."));
            this.words.add(new String("My home, I forgot."));
            this.words.add(new String("It does not exist."));
            this.words.add(new String("But look at the sky!"));
            this.words.add(new String("Will we be creative there?"));
            this.words.add(new String("You told me to enter it for myself."));
            this.words.add(new String("A self similar pattern of recursion."));
            this.words.add(new String("The air was too clear for comfort."));
            this.words.add(new String("We walked across a screen."));
            this.words.add(new String("We."));
        }

        public void render() {
            if (this.life == 500) {
                int n = (int)NORTHWEST.this.random(0.0f, this.tCnt);
                this.chapter = this.words.get(n);
                this.words.remove(n);
                --this.tCnt;
                NORTHWEST.this.output.println(this.chapter);
                NORTHWEST.this.output.flush();
                this.opac = 0;
            }
            this.changeOpacity();
            if (this.life != 0) {
                this.display();
            }
            --this.life;
        }

        public void changeOpacity() {
            if (this.life <= 500 && this.life > 350) {
                ++this.opac;
            }
            if (this.life < 250) {
                --this.opac;
            }
        }

        public void display() {
            NORTHWEST.this.fill(255, this.opac);
            NORTHWEST.this.textAlign(3);
            NORTHWEST.this.textFont(this.font, 36.0f);
            NORTHWEST.this.text(this.chapter, NORTHWEST.this.width / 2, 215.0f);
        }

        public void reset() {
            int n = this.words.size() - 1;
            while (n >= 0) {
                this.words.remove(n);
                --n;
            }
            this.words.add(new String("Rainy forests, we can hike there."));
            this.words.add(new String("I want to go to Northwest."));
            this.words.add(new String("We don't need to stay in the city."));
            this.words.add(new String("There's real nature there. Mud to stick on boots."));
            this.words.add(new String("We can find a great view to make a habit."));
            this.words.add(new String("We will feel less alone in the forest."));
            this.words.add(new String("I imagine it is a lot like home."));
            this.words.add(new String("When will we get there? It's a long way."));
            this.words.add(new String("I'm sorry, I forgot you."));
            this.words.add(new String("It rains there a lot."));
            this.words.add(new String("I heard it is green."));
            this.words.add(new String("My childhood neighbor, I forgot."));
            this.words.add(new String("My work, I forgot."));
            this.words.add(new String("A small enough city to make a home."));
            this.words.add(new String("My home, I forgot."));
            this.words.add(new String("It does not exist."));
            this.words.add(new String("But look at the sky!"));
            this.words.add(new String("Will we be creative there?"));
            this.words.add(new String("You told me to enter it for myself."));
            this.words.add(new String("A self similar pattern of recursion."));
            this.words.add(new String("The air was too clear for comfort."));
            this.words.add(new String("We walked across a screen."));
            this.words.add(new String("We."));
            this.tCnt = 22;
        }
    }

    static class TextToSpeech {
        static final String ALEX = "Alex";
        static final String BRUCE = "Bruce";
        static final String FRED = "Fred";
        static final String JUNIOR = "Junior";
        static final String RALPH = "Ralph";
        static final String AGNES = "Agnes";
        static final String KATHY = "Kathy";
        static final String PRINCESS = "Princess";
        static final String VICKI = "Vicki";
        static final String VICTORIA = "Victoria";
        static String[] voices = new String[]{"Alex", "Bruce", "Fred", "Ralph", "Agnes", "Kathy", "Princess", "Vicki", "Victoria"};

        TextToSpeech() {
        }

        public static void say(String string, String string2, int n) {
            try {
                Runtime.getRuntime().exec(new String[]{"say", "-v", string2, "[[rate " + n + "]]" + string});
            }
            catch (IOException iOException) {
                System.err.println("IOException");
            }
        }

        public static void say(String string) {
            TextToSpeech.say(string, ALEX, 200);
        }
    }

    class Text_Gen {
        float spawnRate;
        String sourceText;
        String[] splitText;
        ArrayList<Text> words;
        int count;
        PFont font;

        Text_Gen() {
            this.font = NORTHWEST.this.loadFont("starFont.vlw");
            this.loadText();
            this.words = new ArrayList();
        }

        public void manageSpawn() {
            float f;
            if (this.count > 300 && (f = NORTHWEST.this.random(0.0f, 1.0f)) < this.spawnRate) {
                this.words.add(new Text());
                this.count = 0;
            }
            ++this.count;
        }

        public void display() {
            int n = this.words.size() - 1;
            while (n >= 0) {
                Text text = this.words.get(n);
                text.render();
                if (text.finished()) {
                    this.words.remove(n);
                }
                --n;
            }
        }

        public void render() {
            this.manageSpawn();
            this.display();
        }

        public void loadText() {
            this.sourceText = "rain forests hike feel alone Northwest stay city nature boots great sky trees forgotten left clouds storm inside use useful recall feel alone Northwest stay city nature boots great sky trees forgotten left clouds storm inside use useful recall";
            this.splitText = NORTHWEST.split((String)this.sourceText, (String)" ");
        }

        class Text {
            String script = "";
            int age;
            int lifespan;
            int rand;
            int opac;
            int voiceIndex;
            PVector loc;
            PVector vel;
            String word;
            boolean first = true;

            Text() {
                this.voiceIndex = (int)NORTHWEST.this.random(TextToSpeech.voices.length - 1);
                this.lifespan = (int)NORTHWEST.this.random(200.0f, 300.0f);
                this.rand = (int)NORTHWEST.this.random(0.0f, 24.0f);
                this.script = this.word = Text_Gen.this.splitText[this.rand];
                this.loc = new PVector(NORTHWEST.this.random(0.0f, ((Text_Gen)Text_Gen.this).NORTHWEST.this.width - 50), NORTHWEST.this.random(0.0f, ((Text_Gen)Text_Gen.this).NORTHWEST.this.height - 50));
                this.vel = new PVector(NORTHWEST.this.random(0.4f, 1.0f), 0.0f);
            }

            public void fadeIn() {
                this.loc.add(this.vel);
                if (this.opac != 255) {
                    ++this.opac;
                }
            }

            public void display() {
                if (this.opac == 10) {
                    TextToSpeech.say(this.script, TextToSpeech.voices[this.voiceIndex], 90);
                    this.first = false;
                }
                NORTHWEST.this.fill(255, this.opac);
                NORTHWEST.this.textFont(Text_Gen.this.font, 32.0f);
                NORTHWEST.this.text(this.word, this.loc.x, this.loc.y);
            }

            public void render() {
                this.fadeIn();
                this.display();
                ++this.age;
            }

            public boolean finished() {
                return this.age >= this.lifespan;
            }
        }
    }

    class Texture {
        boolean spawn;
        boolean startup;
        boolean shutdown;
        PImage[] imgs = new PImage[20];
        PImage[] circs = new PImage[10];
        float alph;
        float maxAlph;
        PVector loc;
        float cx;
        float cy;

        Texture() {
            String string;
            int n = 0;
            while (n < this.imgs.length) {
                string = "tex" + n + ".png";
                this.imgs[n] = NORTHWEST.this.loadImage(string);
                ++n;
            }
            n = 0;
            while (n < this.circs.length) {
                string = "c" + n + ".png";
                this.circs[n] = NORTHWEST.this.loadImage(string);
                ++n;
            }
            this.startup = true;
            this.maxAlph = 50.0f;
            this.loc = new PVector(NORTHWEST.this.random(250.0f, NORTHWEST.this.width - 250), NORTHWEST.this.random(250.0f, NORTHWEST.this.height - 250));
            this.cx = NORTHWEST.this.random(1000000.0f);
            this.cy = NORTHWEST.this.random(1000000.0f);
        }

        public void transitions() {
            if (this.startup) {
                if (this.alph < this.maxAlph) {
                    this.alph += 1.0f;
                } else if (this.alph > this.maxAlph) {
                    this.alph = this.maxAlph;
                    this.startup = false;
                }
            }
            if (this.shutdown) {
                this.startup = false;
                if (this.alph > 0.0f) {
                    this.alph -= 1.0f;
                } else if (this.alph < 0.0f) {
                    this.alph = 0.0f;
                    this.shutdown = false;
                    this.spawn = false;
                }
            }
        }

        public void display() {
            this.loc.x = NORTHWEST.map((float)NORTHWEST.this.noise(this.cx), (float)0.0f, (float)1.0f, (float)250.0f, (float)(NORTHWEST.this.width - 250));
            this.loc.y = NORTHWEST.map((float)NORTHWEST.this.noise(this.cy), (float)0.0f, (float)1.0f, (float)250.0f, (float)(NORTHWEST.this.height - 250));
            int n = (int)NORTHWEST.this.random(this.imgs.length);
            int n2 = (int)NORTHWEST.this.random(this.circs.length);
            NORTHWEST.this.tint(255, this.alph * 5.0f);
            NORTHWEST.this.imageMode(3);
            NORTHWEST.this.image(this.circs[n2], this.loc.x, this.loc.y);
            NORTHWEST.this.tint(255, this.alph);
            NORTHWEST.this.imageMode(0);
            NORTHWEST.this.image(this.imgs[n], 0.0f, 0.0f, NORTHWEST.this.width, NORTHWEST.this.height);
            this.cx += 0.1f;
            this.cy += 0.1f;
        }

        public void render() {
            if (this.spawn) {
                this.transitions();
                this.display();
            }
        }
    }

    class Time_Keeper {
        AudioSample soundtrack;
        float time;
        float scene;
        float prevScene;
        int maxTime;
        int startTime;
        PImage[] walk = new PImage[10];
        int walkCnt;
        Story story;
        boolean second;

        Time_Keeper() {
            int n = 0;
            while (n < 10) {
                String string = "walk" + n + ".png";
                this.walk[n] = NORTHWEST.this.loadImage(string);
                ++n;
            }
            this.soundtrack = NORTHWEST.this.minim.loadSample("soundtrack.aif");
            this.time = 0.0f;
            this.maxTime = 16000;
            this.story = new Story();
        }

        public void render() {
            this.checkTime();
            this.display();
            this.story.render();
            this.time += 1.0f;
        }

        public void checkTime() {
            if (this.time >= 0.0f && this.time < (float)this.maxTime * 0.05f) {
                this.scene = 1.0f;
            }
            if (this.time >= (float)this.maxTime * 0.05f && this.time < (float)this.maxTime * 0.1f) {
                this.scene = 1.5f;
            }
            if (this.time >= (float)this.maxTime * 0.1f && this.time < (float)this.maxTime * 0.15f) {
                this.scene = 2.0f;
            }
            if (this.time >= (float)this.maxTime * 0.15f && this.time < (float)this.maxTime * 0.2f) {
                this.scene = 2.5f;
            }
            if (this.time >= (float)this.maxTime * 0.2f && this.time < (float)this.maxTime * 0.25f) {
                this.scene = 3.0f;
            }
            if (this.time >= (float)this.maxTime * 0.25f && this.time < (float)this.maxTime * 0.3f) {
                this.scene = 3.5f;
            }
            if (this.time >= (float)this.maxTime * 0.3f && this.time < (float)this.maxTime * 0.35f) {
                this.scene = 4.0f;
            }
            if (this.time >= (float)this.maxTime * 0.35f && this.time < (float)this.maxTime * 0.4f) {
                this.scene = 4.5f;
            }
            if (this.time >= (float)this.maxTime * 0.4f && this.time < (float)this.maxTime * 0.45f) {
                this.scene = 5.0f;
            }
            if (this.time >= (float)this.maxTime * 0.45f && this.time < (float)this.maxTime * 0.5f) {
                this.scene = 5.5f;
            }
            if (this.time >= (float)this.maxTime * 0.5f && this.time < (float)this.maxTime * 0.55f) {
                this.scene = 6.0f;
            }
            if (this.time >= (float)this.maxTime * 0.55f && this.time < (float)this.maxTime * 0.6f) {
                this.scene = 6.5f;
            }
            if (this.time >= (float)this.maxTime * 0.6f && this.time < (float)this.maxTime * 0.65f) {
                this.scene = 7.0f;
            }
            if (this.time >= (float)this.maxTime * 0.65f && this.time < (float)this.maxTime * 0.7f) {
                this.scene = 7.5f;
            }
            if (this.time >= (float)this.maxTime * 0.7f && this.time < (float)this.maxTime * 0.75f) {
                this.scene = 8.0f;
            }
            if (this.time >= (float)this.maxTime * 0.75f && this.time < (float)this.maxTime * 0.8f) {
                this.scene = 8.5f;
            }
            if (this.time >= (float)this.maxTime * 0.8f && this.time < (float)this.maxTime * 0.85f) {
                this.scene = 9.0f;
            }
            if (this.time >= (float)this.maxTime * 0.85f && this.time < (float)this.maxTime * 0.9f) {
                this.scene = 9.5f;
            }
            if (this.time >= (float)this.maxTime * 0.9f && this.time < (float)this.maxTime * 0.95f) {
                this.scene = 10.0f;
            }
            if (this.time >= (float)this.maxTime * 0.95f && this.time < (float)this.maxTime) {
                this.scene = 10.5f;
            }
            if (this.time > (float)this.maxTime) {
                this.scene = 11.0f;
            }
            if (this.scene != this.prevScene) {
                if (!this.second) {
                    this.story.life = 500;
                }
                this.second = !this.second;
            }
            this.prevScene = this.scene;
        }

        public void display() {
            float f = NORTHWEST.map((float)this.time, (float)0.0f, (float)this.maxTime, (float)0.0f, (float)NORTHWEST.this.width);
            float f2 = NORTHWEST.sin((float)(this.time / 30.0f));
            float f3 = NORTHWEST.sin((float)(this.time / 28.0f));
            float f4 = NORTHWEST.map((float)f2, (float)0.0f, (float)1.0f, (float)NORTHWEST.this.height, (float)(NORTHWEST.this.height + 2));
            float f5 = NORTHWEST.map((float)f3, (float)0.0f, (float)1.0f, (float)NORTHWEST.this.height, (float)(NORTHWEST.this.height + 2));
            NORTHWEST.this.imageMode(0);
            NORTHWEST.this.tint(255);
            NORTHWEST.this.image(this.walk[this.walkCnt], (float)NORTHWEST.this.width - f - 1.0f, f4, 80.0f, -100.0f);
            NORTHWEST.this.tint(230);
            NORTHWEST.this.image(this.walk[this.walkCnt], (float)NORTHWEST.this.width - f + 35.0f, f5, 70.0f, -90.0f);
            NORTHWEST.this.tint(140);
            NORTHWEST.this.image(this.walk[this.walkCnt], (float)NORTHWEST.this.width - f + 55.0f, f4, 80.0f, -110.0f);
            ++this.walkCnt;
            if (this.walkCnt == 10) {
                this.walkCnt = 0;
            }
            if ((float)NORTHWEST.this.width - f < -110.0f) {
                if (NORTHWEST.this.looping) {
                    NORTHWEST.this.reset();
                } else {
                    NORTHWEST.this.exit();
                }
            }
            if ((float)NORTHWEST.this.width - f < -50.0f) {
                float f6 = (f - (float)NORTHWEST.this.width - 50.0f) * 6.0f;
                NORTHWEST.this.fill(255, f6);
                NORTHWEST.this.textSize(24.0f);
                NORTHWEST.this.textAlign(37);
                NORTHWEST.this.text("Music was made by Oneohtrix Point Never and used without permission. ", 20.0f, NORTHWEST.this.height - 20);
                NORTHWEST.this.fill(0, f6);
                NORTHWEST.this.rect(0.0f, 0.0f, NORTHWEST.this.width, NORTHWEST.this.height);
            }
            if ((float)NORTHWEST.this.width - f < -80.0f) {
                NORTHWEST.this.textAlign(39);
                NORTHWEST.this.fill(255, 255.0f);
                NORTHWEST.this.text("Mark Fingerhut 2013", NORTHWEST.this.width - 20, NORTHWEST.this.height - 20);
            }
        }
    }

    class Title {
        boolean first = true;

        Title() {
        }

        public void render() {
            if (NORTHWEST.this.time.time > 400.0f && NORTHWEST.this.time.scene == 1.0f) {
                if (this.first) {
                    NORTHWEST.this.gong.trigger();
                    NORTHWEST.this.time.soundtrack.trigger();
                    NORTHWEST.this.night.moon.shutdown = false;
                    NORTHWEST.this.night.starfield.shutdown = false;
                    this.first = false;
                }
                NORTHWEST.this.pushMatrix();
                NORTHWEST.this.imageMode(3);
                NORTHWEST.this.translate(NORTHWEST.this.width / 2, NORTHWEST.this.height / 2);
                NORTHWEST.this.rotate(-NORTHWEST.radians((float)(NORTHWEST.this.time.time / 22.0f)) + 45.0f);
                NORTHWEST.this.tint(255);
                NORTHWEST.this.image(NORTHWEST.this.titlePics[(int)NORTHWEST.this.random(0.0f, 30.0f)], 0.0f, 0.0f);
                NORTHWEST.this.popMatrix();
            }
        }
    }

    class Trunk_Maker {
        PImage[] textures;
        float spawnRate;
        ArrayList<Tree_Trunk> trees = new ArrayList();
        int count;

        Trunk_Maker() {
            this.textures = new PImage[4];
            int n = 0;
            while (n < 4) {
                String string = "bark" + n + ".jpg";
                this.textures[n] = NORTHWEST.this.loadImage(string);
                ++n;
            }
        }

        public void manageSpawn() {
            float f = NORTHWEST.this.random(0.0f, 1.0f);
            if (this.count > 100) {
                if (f < this.spawnRate) {
                    this.trees.add(new Tree_Trunk(NORTHWEST.this.random((float)NORTHWEST.this.width * 0.1f, (float)NORTHWEST.this.width * 0.9f), NORTHWEST.this.height));
                }
                this.count = 0;
            }
            ++this.count;
        }

        public void render() {
            this.manageSpawn();
            this.display();
        }

        public void display() {
            int n = this.trees.size() - 1;
            while (n >= 0) {
                Tree_Trunk tree_Trunk = this.trees.get(n);
                tree_Trunk.render();
                if (tree_Trunk.finished()) {
                    this.trees.remove(n);
                }
                --n;
            }
        }

        class Tree_Trunk {
            ArrayList<Plane> planes;
            float baseX;
            float baseY;
            int cnt;
            int age;
            int lifespan;

            Tree_Trunk(float f, float f2) {
                this.baseX = f;
                this.baseY = f2;
                this.planes = new ArrayList();
                this.lifespan = (int)NORTHWEST.this.random(200.0f, 400.0f);
            }

            public void manage() {
                this.baseX += 0.1f;
                if (this.cnt % 5 == 0) {
                    this.planes.add(new Plane(Trunk_Maker.this.textures[(int)NORTHWEST.this.random(0.0f, 4.0f)]));
                }
                ++this.cnt;
            }

            public void render() {
                this.manage();
                this.display();
                ++this.age;
            }

            public void display() {
                int n = this.planes.size() - 1;
                while (n >= 0) {
                    Plane plane = this.planes.get(n);
                    plane.render();
                    if (plane.finished()) {
                        this.planes.remove(n);
                    }
                    --n;
                }
            }

            public boolean finished() {
                return this.age >= this.lifespan;
            }

            class Plane {
                float offsetX;
                float offsetY;
                int lifeSpan;
                int age;
                PImage tex;
                PVector size;

                Plane(PImage pImage) {
                    this.tex = pImage;
                    this.lifeSpan = (int)NORTHWEST.this.random(10.0f, 30.0f);
                    this.age = 0;
                    this.offsetX = NORTHWEST.this.random(-10.0f, 10.0f);
                    this.offsetY = NORTHWEST.this.random(-10.0f, 20.0f);
                    this.size = new PVector(-NORTHWEST.this.random(80.0f, 100.0f), -NORTHWEST.this.random(400.0f, 1200.0f));
                }

                public void render() {
                    NORTHWEST.this.colorMode(1);
                    NORTHWEST.this.tint(NORTHWEST.this.random(100.0f, 140.0f), NORTHWEST.this.random(150.0f, 180.0f), NORTHWEST.this.random(120.0f, 160.0f), 140.0f);
                    NORTHWEST.this.image(this.tex, Tree_Trunk.this.baseX + this.offsetX, Tree_Trunk.this.baseY + this.offsetY, this.size.x, this.size.y);
                    NORTHWEST.this.noTint();
                    ++this.age;
                }

                public boolean finished() {
                    return this.age >= this.lifeSpan;
                }
            }
        }
    }

    class ZipLine_Gen {
        float spawnRate;
        ArrayList<Line> lines = new ArrayList();
        int density = 5;
        String theme = "rgb";
        boolean startup = false;
        boolean shutdown = false;

        ZipLine_Gen() {
        }

        public void manageSpawn() {
            float f = NORTHWEST.this.random(0.0f, 1.0f);
            if (f < this.spawnRate) {
                int n = 0;
                while (n < this.density) {
                    this.lines.add(new Line(this.theme));
                    ++n;
                }
            }
        }

        public void display() {
            int n = this.lines.size() - 1;
            while (n >= 0) {
                Line line = this.lines.get(n);
                line.render();
                if (line.finished()) {
                    this.lines.remove(n);
                }
                --n;
            }
        }

        public void transitions() {
            if (this.startup) {
                if (this.spawnRate < 1.0f) {
                    this.spawnRate = this.theme == "rain" ? (this.spawnRate += 0.001f) : (this.spawnRate += 0.01f);
                } else if (this.spawnRate >= 1.0f) {
                    this.spawnRate = 1.0f;
                    this.startup = false;
                }
            }
            if (this.shutdown) {
                if (this.spawnRate > 0.0f) {
                    this.spawnRate -= 0.01f;
                } else if (this.spawnRate <= 0.0f) {
                    this.spawnRate = 0.0f;
                    this.shutdown = false;
                }
            }
        }

        public void render() {
            this.transitions();
            this.manageSpawn();
            this.display();
        }
    }
}

