#version 120
varying vec2 texCoord;
uniform sampler2D colorMap;
uniform float scrollx;
uniform float scrolly;
//////////////////////////////////////////from barrel original version, keep commented out
/*
uniform float BarrelPower;

// Given a vec2 in [-1,+1], generate a texture coord in [0,+1]
vec2 Distort(vec2 p)
{
    float theta  = atan(p.y, p.x);
    float radius = length(p);
    radius = pow(radius, BarrelPower);
    p.x = radius * cos(theta);
    p.y = radius * sin(theta);
    return 0.5 * (p + 1.0);
}

// Given a vec2 in [-1,+1], generate a texture coord in [0,+1]
*/

//////////////////////////////////////////classic barrel distort
//http://github.prideout.net/barrel-distortion/
/*
vec2 Distort(vec2 p)
{
vec2 p2;

    p.x=p.x-0.5;
    p.y=p.y-0.5;
    p=-p;
    float theta  = atan(p.y, p.x);
    float radius = length(p)*2;
    radius = pow(radius, 1.5);
    p2.x = -radius * cos(theta);
    p2.y = -radius * sin(theta);
    //return 0.5 * (p + 1.0);
    //p2.x=p2.x-0.5;
    //p2.y=p2.y-0.5;
    p2= 0.5 * (p2 + 1.0);
    //if (p2.x<0) p2.x=0; if (p2.x>1.0) p2.x=1.0;
    //if (p2.y<0) p2.y=0; if (p2.y>1.0) p2.y=1.0;
    return p2;
}

void main (void)
{
vec4 pixel;


//float ox=sin(texCoord.x);
//float oy=sin(texCoord.y);
vec2 p=Distort(vec2(texCoord.x,texCoord.y));
pixel=texture2D(colorMap, p.xy);
if (p.x<0) pixel=vec4(0,0,0,0);
if (p.y<0) pixel=vec4(0,0,0,0);
if (p.x>1) pixel=vec4(0,0,0,0);
if (p.y>1) pixel=vec4(0,0,0,0);

//pixel.rgb=texture2D(colorMap, vec2(texCoord.x+ox,texCoord.y+oy)).rgb;
//pixel.g=texture2D(colorMap, vec2(texCoord.x+ox,texCoord.y+oy)).g;
//pixel.b=texture2D(colorMap, vec2(texCoord.x+ox,texCoord.y+oy)).b;


gl_FragColor = pixel;

}
*/

//////////////////////////////////////////fish eye
/*
#version 120
//uniform sampler2D tex0;
varying vec4 Vertex_UV;
const float PI = 3.1415926535;
uniform sampler2D colorMap;
varying vec2 texCoord;

void main()
{
  //float aperture = 178.0;
  float aperture = 120.0;
  float apertureHalf = 0.5 * aperture * (PI / 180.0);
  float maxFactor = sin(apertureHalf);
  vec2 Vertex_UV=texCoord;

  vec2 uv;
  vec2 xy = 2.0 * Vertex_UV.xy - 1.0;
  float d = length(xy);
  if (d < (2.0-maxFactor))
  {
    d = length(xy * maxFactor);
    float z = sqrt(1.0 - d * d);
    float r = atan(d, z) / PI;
    float phi = atan(xy.y, xy.x);

    uv.x = r * cos(phi) + 0.5;
    uv.y = r * sin(phi) + 0.5;
  }
  else
  {
    uv = Vertex_UV.xy;
  }
  vec4 c = texture2D(colorMap, uv);
  gl_FragColor = c;
}
*/


//////////////////////////////////////////anti fish eye
//http://www.geeks3d.com/20140213/glsl-shader-library-fish-eye-and-dome-and-barrel-distortion-post-processing-filters/5/
//#version 120
//uniform sampler2D colorMap;
uniform vec2 iResolution= vec2(1920,1080);
uniform vec2 iMouse=vec2(0,0);

uniform float lensfactor;

#define EPSILON 0.000011

void main(void)//Drag mouse over rendering area
{
  /*
  //normalized coords with some cheat
  vec2 p = gl_FragCoord.xy / iResolution.x;

  //screen proportion
  float prop = iResolution.x / iResolution.y;
  //center coords
  vec2 m = vec2(0.5, 0.5 / prop);
  //vector from center to current fragment
  vec2 d = p - m;
  // distance of pixel from center
  float r = sqrt(dot(d, d));
  //amount of effect
  float power = ( lensfactor * 3.141592 / (2.0 * sqrt(dot(m, m))) ) * //WAS ORIGINALLY 2.0 * 3.14... then 1.4
		(iMouse.x / iResolution.x - 0.5);
  //radius of 1:1 effect
  float bind;
  if (power > 0.0) bind = sqrt(dot(m, m));//stick to corners
  else {if (prop < 1.0) bind = m.x; else bind = m.y;}//stick to borders

  //Weird formulas
  vec2 uv;
  if (power > 0.0)//fisheye
    uv = m + normalize(d) * tan(r * power) * bind / tan( bind * power);
  else if (power < 0.0)//antifisheye
   uv = m + normalize(d) * atan(r * -power * 10.0) * bind / atan(-power * bind * 10.0);
  else
    uv = p;//no effect for power = 1.0

  //Second part of cheat
  //for round effect, not elliptical
  //vec3 col = texture2D(colorMap, vec2(uv.x, uv.y * prop)).xyz;
  
  float x_=uv.x+scrollx/iResolution.x;
  float y_=uv.y*prop+scrolly/iResolution.y;
  const float fix=8.0f;
  if (x_<=0.0f+3.0f/iResolution.x) x_=-x_+fix/iResolution.x;
  if (x_>=1.0f-3.0f/iResolution.x) x_=1.0f-(x_-1.0f)-fix/iResolution.x;
  if (y_<=0.0f+3.0f/iResolution.y) y_=-y_+fix/iResolution.y;
  if (y_>=1.0f-3.0f/iResolution.y) y_=1.0f-(y_-1.0f)-fix/iResolution.y;

  //vec3 col = texture2D(colorMap, vec2(uv.x, uv.y * prop)+vec2(scrollx_/iResolution.x,scrolly_/iResolution.y)).xyz;
  vec3 col = texture2D(colorMap, vec2(x_,y_)).xyz;
  */
  ///gl_FragColor = vec4(col, 1.0);
  gl_FragColor = texture2D(colorMap, gl_FragCoord.xy).xyzw;
}
