uniform float testvalue;
uniform float iTime;
uniform sampler2D iChannel1; //object texture (palette)
uniform sampler2D colorMap; //background texture
uniform sampler2D normalMap; //normal map for object (lighting)
///uniform sampler2D heightMap; //for water waves
uniform sampler2D noisetexturea;
uniform int moveico;

float waterheight;
int reflectionrendering=0;

float sdSphere( vec3 p, float s )
{
    return length(p)-s;
}

float sdBox( vec3 p, vec3 b )
{
    vec3 d = abs(p) - b;
    return min(max(d.x,max(d.y,d.z)),0.0) + length(max(d,0.0));
}

float sdCone( in vec3 p, in vec2 c, float h )
{
    vec2 q = h*vec2(c.x,-c.y)/c.y;
    vec2 w = vec2( length(p.xz), p.y );
    
	vec2 a = w - q*clamp( dot(w,q)/dot(q,q), 0.0, 1.0 );
    vec2 b = w - q*vec2( clamp( w.x/q.x, 0.0, 1.0 ), 1.0 );
    float k = sign( q.y );
    float d = min(dot( a, a ),dot(b, b));
    float s = max( k*(w.x*q.y-w.y*q.x),k*(w.y-q.y)  );
	return sqrt(d)*sign(s);
}
///----------------------------------------------------------------------------



uniform mat4 Rotation;
const int ddccount=12;
uniform vec3 ddccolors[ddccount];
uniform vec3 ddcvectors[ddccount];
uniform mat3 ddcanglematrices[ddccount];
uniform float ddcvectormult[ddccount];
float currentindex=0.0;
float totalindex=0.0;
float useindex=0.0;

vec2 opUsWithColor( vec2 d1, vec2 d2, float k) {
    float h = clamp( 0.5 + 0.5*(d2.x-d1.x)/k, 0.0, 1.0 );
    //usecolor=mix( currentcolor, totalcolor, h );
    //totalcolor=usecolor;
    useindex=mix( currentindex, totalindex, h );
    totalindex=useindex;
    return vec2(mix( d2.x, d1.x, h ) - k*h*(1.0-h), d1.y); 
}

float h_=0.0;
vec2 opUsc( vec2 d1, vec2 d2, float k ) {
    float h = clamp( 0.5 + 0.5*(d2.x-d1.x)/k, 0.0, 1.0 );
    //h_=clamp((d2.x-d1.x)/k, -1.0, 1.0 );
    //h_+=1.0; h_/=2.0;
float m;
if (d1.x<d2.x) m=d1.y; else m=d2.y;
return vec2(mix( d2.x, d1.x, h ) - k*h*(1.0-h), m);
//return vec2(mix( d2.x, d1.x, h ) - k*h*(1.0-h), d2.y);
}

vec2 opU( vec2 d1, vec2 d2 )
{
	return (d1.x<d2.x) ? d1 : d2;
}
vec2 opS( vec2 d2, vec2 d1 ) 
{ 
    return (-d1.x>d2.x) ? vec2(-d1.x,d1.y) : d2; 
}

float hash2(vec3 p)  // replace this by something better
{
    p  = fract( p*0.3183099+.1 );
	p *= 17.0;
    return fract( p.x*p.y*p.z*(p.x+p.y+p.z) );
}

float noisefast2( in vec3 x )
{
    vec3 i = floor(x);
    vec3 f = fract(x);
    f = f*f*(3.0-2.0*f);
	
    return mix(mix(mix( hash2(i+vec3(0,0,0)), 
                        hash2(i+vec3(1,0,0)),f.x),
                   mix( hash2(i+vec3(0,1,0)), 
                        hash2(i+vec3(1,1,0)),f.x),f.y),
               mix(mix( hash2(i+vec3(0,0,1)), 
                        hash2(i+vec3(1,0,1)),f.x),
                   mix( hash2(i+vec3(0,1,1)), 
                        hash2(i+vec3(1,1,1)),f.x),f.y),f.z);
}

#define ANIMATE
float iTime2=200123.456;
vec2 hash( vec2 p ) // replace this by something better
{
	p = vec2( dot(p,vec2(127.1,311.7)), dot(p,vec2(269.5,183.3)) );
	return -1.0 + 2.0*fract(sin(p)*43758.5453123);
}

vec3 voronoi( in vec2 x )
{
    vec2 n = floor(x);
    vec2 f = fract(x);

    //----------------------------------
    // first pass: regular voronoi
    //----------------------------------
	vec2 mg, mr;

    float md = 8.0;
    for( int j=-1; j<=1; j++ )
    for( int i=-1; i<=1; i++ )
    {
        vec2 g = vec2(float(i),float(j));
		vec2 o = hash( n + g );
		#ifdef ANIMATE
        o = 0.5 + 0.5*sin( iTime + 6.2831*o );
        ///o = vec2(iTime);
        ///o += fract(iTime/2.0);
        #endif	
        vec2 r = g + o - f;
        float d = dot(r,r);

        if( d<md )
        {
            md = d;
            mr = r;
            mg = g;
        }
    }

    //----------------------------------
    // second pass: distance to borders
    //----------------------------------
    md = 8.0*0.1;//8.0
    for( int j=-2; j<=2; j++ )
    for( int i=-2; i<=2; i++ )
    {
        vec2 g = mg + vec2(float(i),float(j));
		vec2 o = hash( n + g );
		#ifdef ANIMATE
        o = 0.5 + 0.5*sin( iTime + 6.2831*o );
        #endif	
        vec2 r = g + o - f;

        if( dot(mr-r,mr-r)>0.00001 )
        md = min( md, dot( 0.5*(mr+r), normalize(r-mr) ) );
    }

    return vec3( md, mr );
}

// The MIT License
// Copyright  2014 Inigo Quilez
// Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions: The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software. THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

// Smooth Voronoi - avoiding aliasing, by replacing the usual min() function, which is
// discontinuous, with a smooth version. That can help preventing some aliasing, and also
// provides with more artistic control of the final procedural textures/models.

// More Voronoi shaders:
//
// Exact edges:  https://www.shadertoy.com/view/ldl3W8
// Hierarchical: https://www.shadertoy.com/view/Xll3zX
// Smooth:       https://www.shadertoy.com/view/ldB3zc
// Voronoise:    https://www.shadertoy.com/view/Xd23Dh



float hash1( float n ) { return fract(sin(n)*43758.5453); }
vec2  hash2( vec2  p ) { p = vec2( dot(p,vec2(127.1,311.7)), dot(p,vec2(269.5,183.3)) ); return fract(sin(p)*43758.5453); }

// The parameter w controls the smoothness
vec4 voronoi2( in vec2 x, float w )
{
    x*=2.0;
    vec2 n = floor( x );
    vec2 f = fract( x );

	vec4 m = vec4( 8.0, 0.0, 0.0, 0.0 );
    for( int j=-2; j<=2; j++ )
    for( int i=-2; i<=2; i++ )
    {
        vec2 g = vec2( float(i),float(j) );
        vec2 o = hash2( n + g );
		
		// animate
        float iTime3=iTime*1.2;
        o = 0.5 + 0.5*sin( iTime3*1.33 + 6.2831*o );

        // distance to cell		
		float d = length(g - f + o);
		
        // cell color
		vec3 col = 0.5 + 0.5*sin( hash1(dot(n+g,vec2(7.0,113.0)))*2.5 + 3.5 + vec3(2.0,3.0,0.0));
        // in linear space
        col = col*col;
        
        // do the smooth min for colors and distances		
		float h = smoothstep( 0.0, 1.0, 0.5 + 0.5*(m.x-d)/w );
	    m.x   = mix( m.x,     d, h ) - h*(1.0-h)*w/(1.0+3.0*w); // distance
		//m.yzw = mix( m.yzw, col, h ) - h*(1.0-h)*w/(1.0+3.0*w); // color
		m.yzw = mix( m.yzw, vec3(0.5), h ) - h*(1.0-h)*w/(1.0+3.0*w); // color
    }
	
	return m;
}
/*
void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2  p = fragCoord/iResolution.y;
    float c = 0.5*iResolution.x/iResolution.y;
	
    vec4 v = voronoi( p*6.0, 0.0 );

    // gamma
    vec3 col = sqrt(v.yzw);
	
	//col *= 1.0 - 0.8*v.x*step(p.y,0.33);
	col *= mix(v.x,1.0,step(p.y,0.0));
	
    
	//col *= smoothstep( 0.003, 0.005, abs(p.y-0.33) );
	//col *= smoothstep( 0.003, 0.005, abs(p.y-0.66) );
    //col *= smoothstep( 0.003, 0.005, abs(p.x-c) );
	
    fragColor = vec4( col, 1.0 );
}
*/
vec3 texpos;
vec2 res,resres;
vec3 pos,pospos;
vec3 nor;
vec3 ref;

float fbm(vec3 x){
    //return 0.5+0.5*simplex3d_fractal(x/32.0*8.0+8.0);
    //float res= 0.5+0.5*snoise(vec4(x,time));

    //float res= 0.5+0.5*simplex3d(x/16.0*8.0+8.0);
    //float res=noisefast(x/4.0);
    float res=noisefast2(x/5.0);
    //float res=noiseValue(x/5.0);
    
    return res;
}

vec2 map4( in vec3 pos_ ) /// ddc
{
waterheight=pos_.y;

vec3 p1=vec3(0.7*sin(iTime/1.5),0.25*sin(iTime/2.5)-0.2,0.7*cos(iTime/1.65));
if (moveico==0) p1=vec3(0.0,0.25,0.0);
pos=pos_;
//vec3 p=pos;
    ///res=vec2(15.0, -100.0);
    res=vec2(0.0, -100.0);
/*
float x=3.5*sin(sphereanim1);
float y=2.0*sin(sphereanim2);
pos-=vec3(x,y,0.0);
*/
/*
float f=4.0*1.6;//freq
float s=0.07*testvalue;//size
vec3 poss=vec3(
s*sin(iTime+pos.x*f),
s*cos(iTime*0.2+pos.y*f*1.2),
s*sin(iTime*0.3+pos.z*f*1.35)
);
pos+=poss;
//pos.x+=s*noisefast2(pos+poss);
//pos.y+=s*noisefast2(pos);
//pos.z+=s*noisefast2(poss);
*/
vec3 p=pos;
pospos=pos;
pos+=p1;
vec4 pb2=vec4(pos,1.0);
pb2 = Rotation * pb2;
pos=vec3(pb2.xyz);


const float logoscale=3.0;
const float k=0.7;//0.375;///0.025 0.175 0.275
const float k2=0.25;
///const float zd=0.215;
const float r=2.0;
const float disp=0.75;
const float boxsize=0.3;
vec3 center;
center=vec3(0.0,0.0,0.0);
///vec2 res2=vec2(-15.0, 17.0);
vec2 res2=vec2(sdBox(vec3(0.0,-1000.0,0.0),vec3(0.1,0.1,0.1)),-1000.0);
///center=twistCenter(vec3(0.0,0.0,0.0));

/*
    glm::vec3 ddcvectors[ddccount];
    glm::mat3 ddcanglematrices[ddccount];
    float ddcvectormult[ddccount];
    glm::mat4 ddcscalingmatrices[ddccount];
*/
const float rddc=3.25;
const float d2r=3.14159265359*2.0/360.0;
const float masterscale=1.0;
///vec3 m1=vec3(rddc*sin(t1.x*d2r),rddc*sin(t1.y*d2r),rddc*sin(t1.z*d2r));

//totalindex=0.0;
float testvalue2=1.9*1.7;
//if (pos_.x>p1.x-testvalue2&&pos_.x<p1.x+testvalue2&&pos_.z>p1.z-testvalue2&&pos_.z<p1.z+testvalue2)
if (pos_.x>p1.x-testvalue2&&pos_.x<p1.x+testvalue2&&pos_.y>p1.y-testvalue2&&pos_.y<p1.y+testvalue2)
for (int i=0;i<12;i++){
    ///vec3 rot1=(pos+m1+ddcvectors[i]*ddcvectormult[i])*ddcanglematrices[i];
    ///vec3 rot1=(pos+ddcvectors[i]*ddcvectormult[i])*ddcanglematrices[i];
    vec3 rot1=(pos+ddcvectors[i]);// *ddcanglematrices[i];
    
    ///vec4 rot1sc=vec4(rot1.xyz,1.0)*ddcscalingmatrices[i]; vec3 rot1_=rot1sc.xyz;
    //float elsize=6.0*ddcvectormult[i]*masterscale;///we turned displace factor (vectormult) to scale factor
    ///float ydist=abs(p.y-ddcscroll); ydist=clamp(pow(clamp(ydist,0.0,2.0)*1.0/2.0,0.5)+0.5,0.0,1.0); /// y-dependent scale effect
    ///float elsize=6.0f*ydist;
    

//currentindex=float(i);
    ///res2 = opUsWithColor(res2, vec2(sdCone(rot1,vec2(0.05,0.25),0.45),17.0),k);\

    //res2 = opU(res2, vec2(sdCone(rot1,vec2(0.05,0.25),0.45),120.0));
    //const float testvalue2=0.25;
    ///if (rot1.y<2.0*testvalue2&&rot1.y>-2.0*testvalue2&&rot1.x>-2.0*testvalue2&&rot1.x<2.0*testvalue2)
        res2 = opUsc(res2, vec2(sdSphere(rot1,0.15),120.0),0.0075);
    //res2 = opU(res2, vec2(sdBox(rot1,vec3(0.07,0.07,0.25)),120.0));

    ///res2 = opU(res2, vec2(sdCone(pos+vec3(0.0,float(i)*0.2,0.0),vec2(0.05,0.25),0.45),120.0));
    ////res2 = opUsWithColor(res2, vec2(sdEllipsoid(rot1,vec3(0.1f*elsize,0.1f*elsize,0.2f*elsize)),17.0),k);
    ///res2 = opUs(res2, vec2(sdEllipsoid(rot1,vec3(0.1f*elsize,0.1f*elsize,0.2f*elsize)),17.0),k);
}
//else res2 = vec2(res2.x,120.0);

texpos=pos;
    ///res2 = opU(res2, vec2(sdBox(p+vec3(0.0,0.75,0.0),vec3(2.15,0.15,2.15)),2071.0));

    //if (p.y<-0.45&&p.y>-0.825)//-1.5*testvalue){
    const float t=-0.07;
    if (p.y<-0.45+t&&p.y>-0.825-t&&reflectionrendering!=1)//-1.5*testvalue){
    //if (p.y<-0.0&&p.y>-1.825)//-1.5*testvalue){
    {
        //const float scale=1.0/5.0*2.0*5.0;
        //const float wiggle=1.5;
        //float skrol=iTime/10.0;
        /*
        float height=texture2D(heightMap,vec2(p.x*scale+skrol/2.0,p.z*scale+skrol/2.3))/2.0;
        height+=texture2D(heightMap,vec2(p.x*scale+skrol/2.45,p.z*scale-skrol/2.75))/2.0;
        */
        /*
        float height=pow(noisefast2(vec3(p.x*scale+skrol/2.0,p.z*scale+skrol/2.3,skrol/2.5*wiggle)*2.4),6.2)/2.0;
        height+=pow(noisefast2(vec3(p.x*scale+skrol/2.3,p.z*scale+skrol/2.5,skrol/4.0*wiggle)*2.7),6.2)/2.0;
        height+=pow(noisefast2(vec3(p.x*scale+skrol/2.3,p.z*scale+skrol/2.5,skrol/2.0*wiggle)*3.0),6.2*testvalue)/2.0*5.0;
        height*=2.0;
        */

        //vec3 c = voronoi(vec2(p.x*scale+skrol/2.3,p.z*scale+skrol/2.5));
        vec2 uv_2=p.xz;
        vec4 c = voronoi2(uv_2*5.4*0.3*0.3*1.5,0.95);


        vec3 uv;
        uv=p.xyz*40.0/2.5*2.0;// *testvalue;
		float f,a;
        //const float m=2.5*1.4*1.1;///1.1 added recently
		//f  = 0.5000*fbm( uv ); uv = m*uv; 
		//f *= 0.4+fbm( uv ); uv = m*uv; 
		//f = 0.4*0.75*fbm( uv*3.5*0.05);

		f = 0.250*fbm( uv)*-0.01; //uv = m*uv; 
        //f += 0.125*fbm( uv ); uv = m*uv; //anim*=1.01;

	    //f -= 0.0625*fbm( uv ); ///uv = m*uv; //anim*=1.01;
	    //f += 0.0625*fbm( uv/2.5 );




        ///vec3 c = voronoi(vec2(p.x*scale+skrol/2.3,p.z*scale+skrol/2.5));
        float height=pow(c.x+f,2.0);// /1.6;
        //float height=c.x;
        //height=texture2D(heightMap,vec2(height,0.5)).r;
        res2 = opU(res2, vec2(sdBox(p+vec3(0.0,0.75,0.0),vec3(6.0,0.15*height,6.0)),2071.0));
        if (res2.y==2071.0) pos=p+vec3(0.0,0.75,0.0)+vec3(0,0.15*height/2.0,0);
        //waterheight=height;
    } else {
        const float height=0;
        if (reflectionrendering!=1){
            res2 = opU(res2, vec2(sdBox(p+vec3(0.0,0.75,0.0),vec3(6.0,0.15*height,6.0)),2071.0));
            if (res2.y==2071.0) pos=p+vec3(0.0,0.75,0.0)+vec3(0,0.15*height/2.0,0);
        }
        //waterheight=height;
    }
///res2 = opUs( res2, vec2( udRoundBox(opTwist2(pos)+center, vec3(r/3,r/3,r/3),k2), 17.0),k); /// this is required for sphere to appear???

///res2 = opUs( res2, vec2(sdSphere(opTwist2(pos)+center,r/1.1), 17.0),k);
/*
center=twistCenter(vec3(-r*disp,0.0,0.0));
res2 = opUs( res2, vec2( udRoundBox(opTwist2(pos)+center, vec3(boxsize,boxsize,boxsize),k2), 17.0),k);
center=twistCenter(vec3(r*disp,0.0,0.0));
res2 = opUs( res2, vec2( udRoundBox(opTwist2(pos)+center, vec3(boxsize,boxsize,boxsize),k2), 17.0),k);
center=twistCenter(vec3(0.0,r*disp,0.0));
res2 = opUs( res2, vec2( udRoundBox(opTwist2(pos)+center, vec3(boxsize,boxsize,boxsize),k2), 17.0),k);
center=twistCenter(vec3(0.0,-r*disp,0.0));
res2 = opUs( res2, vec2( udRoundBox(opTwist2(pos)+center, vec3(boxsize,boxsize,boxsize),k2), 17.0),k);
center=twistCenter(vec3(0.0,0.0,-r*disp));
res2 = opUs( res2, vec2( udRoundBox(opTwist2(pos)+center, vec3(boxsize,boxsize,boxsize),k2), 17.0),k);
center=twistCenter(vec3(0.0,0.0,r*disp));
res2 = opUs( res2, vec2( udRoundBox(opTwist2(pos)+center, vec3(boxsize,boxsize,boxsize),k2), 17.0),k);
*/
/*
vec2 resnoise=vec2(simplex3d(pos+iTime/10.0),1.0);
float a=resnoise.x; a=a+noisefade; a=clamp(a,-1.0,1.0); resnoise.x=a; ///noisefade -1.0,1.0

if (noisefade<=-2.0)
    res=res2;
else
    res=opI(resnoise,res2);
res.y=1.0;
*/
///res2.y=120.0;
res=res2;
return res2;

///return res;
}

///-----------------------------------------------------------------------------------------------------
///-----------------------------------------------------------------------------------------------------
///-----------------------------------------------------------------------------------------------------








uniform vec3 rayorigin;
uniform vec3 raydirection;
uniform vec3 upvector;
mat3 ca;

uniform float fov;

vec2 iResolution=vec2(1920.0,1080.0);
vec4 iMouse=vec4(1920.0/2.0,1080.0/2.0,1.0,1.0);

const float pi=3.1415926535897932384626433832795;

vec2 simplerot(vec2 v, float angle){
//float s = sin( angle );
//float c = cos( angle );
//return vec2(c*v.x-s*v.y,s*v.x+c*v.y);
    float co = cos(angle);
    float si = sin(angle);
    v.xy = mat2(co,-si,si,co)*v.xy;
    return v;
}
vec2 rot(vec2 v, float angle, vec2 origin){
v=v-origin;
v=simplerot(v,angle);
v=v+origin;
return v;
}
vec2 benddm(vec2 v, float xmax, float angle){
vec2 v2;
v2.x=0.0;
v2.y=v.y;
float factor=v.x/xmax;
vec2 origin;
origin.x=0.0; origin.y=xmax/2.0/pi/(angle/2.0/pi);
v2=rot(v2,angle*factor,origin);
return v2;
}
//...
//bend(pos.xz, 2.0, 3.14*2.0*fract(iTime/1000.0/2.0));
//bending by dm
//align bottom left of the object with 0,0 and find out xmax



//===============================================================================================
//===============================================================================================
//===============================================================================================
//===============================================================================================
//===============================================================================================

// The MIT License
// Copyright  2013 Inigo Quilez
// Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions: The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software. THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

// A list of useful distance function to simple primitives. All
// these functions (except for ellipsoid) return an exact
// euclidean distance, meaning they produce a better SDF than
// what you'd get if you were constructing them from boolean
// operations.

// List of other 3D SDFs: https://www.shadertoy.com/playlist/43cXRl
//
// and http://iquilezles.org/www/articles/distfunctions/distfunctions.htm


#if HW_PERFORMANCE==0
#define AA 1
#else
#define AA 2   // make this 2 or 3 for antialiasing
#endif

//------------------------------------------------------------------
float dot2( in vec2 v ) { return dot(v,v); }
float dot2( in vec3 v ) { return dot(v,v); }
float ndot( in vec2 a, in vec2 b ) { return a.x*b.x - a.y*b.y; }

float sdPlane( vec3 p )
{
	return p.y;
}


float sdBoundingBox( vec3 p, vec3 b, float e )
{
       p = abs(p  )-b;
  vec3 q = abs(p+e)-e;

  return min(min(
      length(max(vec3(p.x,q.y,q.z),0.0))+min(max(p.x,max(q.y,q.z)),0.0),
      length(max(vec3(q.x,p.y,q.z),0.0))+min(max(q.x,max(p.y,q.z)),0.0)),
      length(max(vec3(q.x,q.y,p.z),0.0))+min(max(q.x,max(q.y,p.z)),0.0));
}
float sdEllipsoid( in vec3 p, in vec3 r ) // approximated
{
    float k0 = length(p/r);
    float k1 = length(p/(r*r));
    return k0*(k0-1.0)/k1;
}

float sdTorus( vec3 p, vec2 t )
{
    return length( vec2(length(p.xz)-t.x,p.y) )-t.y;
}

float sdCappedTorus(in vec3 p, in vec2 sc, in float ra, in float rb)
{
    p.x = abs(p.x);
    float k = (sc.y*p.x>sc.x*p.y) ? dot(p.xy,sc) : length(p.xy);
    return sqrt( dot(p,p) + ra*ra - 2.0*ra*k ) - rb;
}

float sdHexPrism( vec3 p, vec2 h )
{
    vec3 q = abs(p);

    const vec3 k = vec3(-0.8660254, 0.5, 0.57735);
    p = abs(p);
    p.xy -= 2.0*min(dot(k.xy, p.xy), 0.0)*k.xy;
    vec2 d = vec2(
       length(p.xy - vec2(clamp(p.x, -k.z*h.x, k.z*h.x), h.x))*sign(p.y - h.x),
       p.z-h.y );
    return min(max(d.x,d.y),0.0) + length(max(d,0.0));
}

float sdOctogonPrism( in vec3 p, in float r, float h )
{
  const vec3 k = vec3(-0.9238795325,   // sqrt(2+sqrt(2))/2 
                       0.3826834323,   // sqrt(2-sqrt(2))/2
                       0.4142135623 ); // sqrt(2)-1 
  // reflections
  p = abs(p);
  p.xy -= 2.0*min(dot(vec2( k.x,k.y),p.xy),0.0)*vec2( k.x,k.y);
  p.xy -= 2.0*min(dot(vec2(-k.x,k.y),p.xy),0.0)*vec2(-k.x,k.y);
  // polygon side
  p.xy -= vec2(clamp(p.x, -k.z*r, k.z*r), r);
  vec2 d = vec2( length(p.xy)*sign(p.y), p.z-h );
  return min(max(d.x,d.y),0.0) + length(max(d,0.0));
}

float sdCapsule( vec3 p, vec3 a, vec3 b, float r )
{
	vec3 pa = p-a, ba = b-a;
	float h = clamp( dot(pa,ba)/dot(ba,ba), 0.0, 1.0 );
	return length( pa - ba*h ) - r;
}

float sdRoundCone( in vec3 p, in float r1, float r2, float h )
{
    vec2 q = vec2( length(p.xz), p.y );
    
    float b = (r1-r2)/h;
    float a = sqrt(1.0-b*b);
    float k = dot(q,vec2(-b,a));
    
    if( k < 0.0 ) return length(q) - r1;
    if( k > a*h ) return length(q-vec2(0.0,h)) - r2;
        
    return dot(q, vec2(a,b) ) - r1;
}

float sdRoundCone(vec3 p, vec3 a, vec3 b, float r1, float r2)
{
    // sampling independent computations (only depend on shape)
    vec3  ba = b - a;
    float l2 = dot(ba,ba);
    float rr = r1 - r2;
    float a2 = l2 - rr*rr;
    float il2 = 1.0/l2;
    
    // sampling dependant computations
    vec3 pa = p - a;
    float y = dot(pa,ba);
    float z = y - l2;
    float x2 = dot2( pa*l2 - ba*y );
    float y2 = y*y*l2;
    float z2 = z*z*l2;

    // single square root!
    float k = sign(rr)*rr*rr*x2;
    if( sign(z)*a2*z2 > k ) return  sqrt(x2 + z2)        *il2 - r2;
    if( sign(y)*a2*y2 < k ) return  sqrt(x2 + y2)        *il2 - r1;
                            return (sqrt(x2*a2*il2)+y*rr)*il2 - r1;
}

float sdTriPrism( vec3 p, vec2 h )
{
    const float k = sqrt(3.0);
    h.x *= 0.5*k;
    p.xy /= h.x;
    p.x = abs(p.x) - 1.0;
    p.y = p.y + 1.0/k;
    if( p.x+k*p.y>0.0 ) p.xy=vec2(p.x-k*p.y,-k*p.x-p.y)/2.0;
    p.x -= clamp( p.x, -2.0, 0.0 );
    float d1 = length(p.xy)*sign(-p.y)*h.x;
    float d2 = abs(p.z)-h.y;
    return length(max(vec2(d1,d2),0.0)) + min(max(d1,d2), 0.);
}

// vertical
float sdCylinder( vec3 p, vec2 h )
{
    vec2 d = abs(vec2(length(p.xz),p.y)) - h;
    return min(max(d.x,d.y),0.0) + length(max(d,0.0));
}

// arbitrary orientation
float sdCylinder(vec3 p, vec3 a, vec3 b, float r)
{
    vec3 pa = p - a;
    vec3 ba = b - a;
    float baba = dot(ba,ba);
    float paba = dot(pa,ba);

    float x = length(pa*baba-ba*paba) - r*baba;
    float y = abs(paba-baba*0.5)-baba*0.5;
    float x2 = x*x;
    float y2 = y*y*baba;
    float d = (max(x,y)<0.0)?-min(x2,y2):(((x>0.0)?x2:0.0)+((y>0.0)?y2:0.0));
    return sign(d)*sqrt(abs(d))/baba;
}

// vertical

float sdCappedCone( in vec3 p, in float h, in float r1, in float r2 )
{
    vec2 q = vec2( length(p.xz), p.y );
    
    vec2 k1 = vec2(r2,h);
    vec2 k2 = vec2(r2-r1,2.0*h);
    vec2 ca = vec2(q.x-min(q.x,(q.y < 0.0)?r1:r2), abs(q.y)-h);
    vec2 cb = q - k1 + k2*clamp( dot(k1-q,k2)/dot2(k2), 0.0, 1.0 );
    float s = (cb.x < 0.0 && ca.y < 0.0) ? -1.0 : 1.0;
    return s*sqrt( min(dot2(ca),dot2(cb)) );
}

float sdCappedCone(vec3 p, vec3 a, vec3 b, float ra, float rb)
{
    float rba  = rb-ra;
    float baba = dot(b-a,b-a);
    float papa = dot(p-a,p-a);
    float paba = dot(p-a,b-a)/baba;

    float x = sqrt( papa - paba*paba*baba );

    float cax = max(0.0,x-((paba<0.5)?ra:rb));
    float cay = abs(paba-0.5)-0.5;

    float k = rba*rba + baba;
    float f = clamp( (rba*(x-ra)+paba*baba)/k, 0.0, 1.0 );

    float cbx = x-ra - f*rba;
    float cby = paba - f;
    
    float s = (cbx < 0.0 && cay < 0.0) ? -1.0 : 1.0;
    
    return s*sqrt( min(cax*cax + cay*cay*baba,
                       cbx*cbx + cby*cby*baba) );
}

// c is the sin/cos of the desired cone angle
float sdSolidAngle(vec3 pos, vec2 c, float ra)
{
    vec2 p = vec2( length(pos.xz), pos.y );
    float l = length(p) - ra;
	float m = length(p - c*clamp(dot(p,c),0.0,ra) );
    return max(l,m*sign(c.y*p.x-c.x*p.y));
}

float sdOctahedron(vec3 p, float s)
{
    p = abs(p);
    float m = p.x + p.y + p.z - s;

    // exact distance
    #if 0
    vec3 o = min(3.0*p - m, 0.0);
    o = max(6.0*p - m*2.0 - o*3.0 + (o.x+o.y+o.z), 0.0);
    return length(p - s*o/(o.x+o.y+o.z));
    #endif
    
    // exact distance
    #if 1
 	vec3 q;
         if( 3.0*p.x < m ) q = p.xyz;
    else if( 3.0*p.y < m ) q = p.yzx;
    else if( 3.0*p.z < m ) q = p.zxy;
    else return m*0.57735027;
    float k = clamp(0.5*(q.z-q.y+s),0.0,s); 
    return length(vec3(q.x,q.y-s+k,q.z-k)); 
    #endif
    
    // bound, not exact
    #if 0
	return m*0.57735027;
    #endif
}

float sdPyramid( in vec3 p, in float h )
{
    float m2 = h*h + 0.25;
    
    // symmetry
    p.xz = abs(p.xz);
    p.xz = (p.z>p.x) ? p.zx : p.xz;
    p.xz -= 0.5;
	
    // project into face plane (2D)
    vec3 q = vec3( p.z, h*p.y - 0.5*p.x, h*p.x + 0.5*p.y);
   
    float s = max(-q.x,0.0);
    float t = clamp( (q.y-0.5*p.z)/(m2+0.25), 0.0, 1.0 );
    
    float a = m2*(q.x+s)*(q.x+s) + q.y*q.y;
	float b = m2*(q.x+0.5*t)*(q.x+0.5*t) + (q.y-m2*t)*(q.y-m2*t);
    
    float d2 = min(q.y,-q.x*m2-q.y*0.5) > 0.0 ? 0.0 : min(a,b);
    
    // recover 3D and scale, and add sign
    return sqrt( (d2+q.z*q.z)/m2 ) * sign(max(q.z,-p.y));;
}

// la,lb=semi axis, h=height, ra=corner
float sdRhombus(vec3 p, float la, float lb, float h, float ra)
{
    p = abs(p);
    vec2 b = vec2(la,lb);
    float f = clamp( (ndot(b,b-2.0*p.xz))/dot(b,b), -1.0, 1.0 );
	vec2 q = vec2(length(p.xz-0.5*b*vec2(1.0-f,1.0+f))*sign(p.x*b.y+p.z*b.x-b.x*b.y)-ra, p.y-h);
    return min(max(q.x,q.y),0.0) + length(max(q,0.0));
}

//------------------------------------------------------------------


float opUnion( float d1, float d2 ) { return min(d1,d2); }

float opSubtraction( float d1, float d2 ) { return max(-d1,d2); }

float opIntersection( float d1, float d2 ) { return max(d1,d2); }
//------------------------------------------------------------------

#define ZERO 0

//------------------------------------------------------------------


vec2 map_bkgnd(in vec3 pos){
   vec2 res;
    res = vec2( sdBox(    pos-vec3(0.0,-0.25, 0.0), vec3(5,0.25,5)), 1.0 );
    return res;
}

mat4 rotateY(float theta) {
    float c = cos(theta);
    float s = sin(theta);

    return mat4(
        vec4(c, 0, s, 0),
        vec4(0, 1, 0, 0),
        vec4(-s, 0, c, 0),
        vec4(0, 0, 0, 1)
    );
}

mat4 rotateX(float theta) {
    float c = cos(theta);
    float s = sin(theta);

    return mat4(
        vec4(1, 0, 0, 0),
        vec4(0, c, -s, 0),
        vec4(0, s, c, 0),
        vec4(0, 0, 0, 1)
    );
}

mat4 rotateZ(float theta) { ///not tested
    float c = cos(theta);
    float s = sin(theta);

    return mat4(
        vec4(c, -s, 0, 0),
        vec4(s, c, 0, 0),
        vec4(0, 0, 1, 0),
        vec4(0, 0, 0, 1)
    );
}
    //float d=sin(iTime/2.0+p.z/3.0)*3.14*2.0;
    //float co = cos(d);
    //float si = sin(d);
    //p.xy = mat2(co,-si,si,co)*p.xy;
    
vec2 bend( in vec2 p, in float l, in float a)//, float w)
{
    a=a/2.0;
    float w=0.5;
    
    // if perfectly straight
    if( abs(a)<0.001 )
    {
        float v = p.y;
        p.y -= clamp(p.y,0.0,l);
		return vec2(p.x, v );
    }
    
    // parameters
    vec2  sc = vec2(sin(a),cos(a));
    float ra = 0.5*l/a;
    
    // recenter
    p.x -= ra;
    
    // reflect
    vec2 q = p - 2.0*sc*max(0.0,dot(sc,p));

	// distance
    float u = abs(ra)-length(q);
    float d = (q.y<0.0) ? length( q+vec2(ra,0.0) ) : abs(u);

    // parametrization (optional)
    float s = sign(a);
    float v = ra*atan(s*p.y,-s*p.x);
    u = u*s;
    if( v<0.0 )
    {
        //if( s*p.x>0.0 ) 
        //{ v = abs(ra)*6.283185 + v; }
        { v = abs(ra)*2.0*pi + v; }
        //else { v = p.y; u = q.x + ra; }
    }
    
    return vec2( u, v );
}
    
vec2 bend_old( in vec2 p, in float l, in float a )
{
    a=a/2.0;

    if( abs(a)<0.001 ) return p;  // if perfectly straight
    
    float ra = 0.5*l/a;
    p.x -= ra;

    vec2 sc = vec2(sin(a),cos(a));
    vec2 q = p - 2.0*sc*max(0.0,dot(sc,p));

    float s = sign(a);

    //return vec2( (p.y>0.0) ? ra-s*length(q)        : sign(-s*p.x)*(q.x+ra),
    //             (p.y>0.0) ? ra*atan(s*p.y,-s*p.x) : (s*p.x<0.0)?p.y:l-p.y );
         
    //p.y=abs(p.y);
    
    if (p.y<=0.0)
        return vec2(sign(-s*p.x)*(q.x+ra), (s*p.x<0.0)?p.y:l-p.y);
        //return vec2(ra-s*length(q),        ra*atan(s*p.y,-s*p.x));
    else
        return vec2(ra-s*length(q),        ra*atan(s*p.y,-s*p.x));
}

vec2 bend_( in vec2 p, in float l, in float a )
{
    if( abs(a)<0.001 ) return p;  // if perfectly straight
    
    float ra = 0.5*l/a;
    p.x -= ra;
    
    vec2 sc = vec2(sin(a),cos(a));
    vec2 q = p - 2.0*sc*max(0.0,dot(sc,p));
    
    float s = sign(a);
    return vec2( (p.y>0.0) ? ra-s*length(q)        : sign(-s*p.x)*(q.x+ra),
                 (p.y>0.0) ? ra*atan(s*p.y,-s*p.x) : (s*p.x<0.0)?p.y:l-p.y );
}

float h_factor=0.7;
float r_factor=1.1;
vec3 uv;
vec2 map( in vec3 pos )
{
    return map4(pos);

    vec2 res;
    const float scale=0.5;
    {
      //pos*=scale;
      //pos.xz=bend(pos.xz,2.0*scale,-3.14*2.0*fract(iTime/20.0));
      //pos=(vec4(pos,1.0)*rotateY(pos.y*4.0)).xyz;
//pos=(vec4(pos,1.0)*rotateZ(3.14/2.0/5.0)*rotateY(iTime/1.33)).xyz;
      float time_=clamp(iTime/5.0,0.0,0.999);
      //pos+=vec3(-3.2*(1.0-time_),0.0,-0.12); //-0.7 to 0.0
      pos+=vec3(0.0 ,0.0,-0.12); //-0.7 to 0.0
      pos=(vec4(pos,1.0)*rotateY(iTime/2.9)).xyz;
      pos=(vec4(pos,1.0)*rotateZ(-3.14/2.0/3.3)).xyz;
      vec3 pos3=pos;
      pos.xz=bend(pos.xz,2.0*scale,-pi*2.0*time_);
      uv=pos*4.0; uv.y-=0.3;

float rmax=2.0/2.0/pi; // first 2.0 is z dimension of the box
rmax=rmax+0.04-0.0015; //0.04 is half x dimension of the box
uv.z=uv.z*(rmax/2.0)*4.0; // 2.0 is z dimension of the box, 4.0 is uv stretch
      
      uv.x=uv.z;
      uv.xz=bend(uv.xz,2.0*scale,-pi*2.0);
      uv.x=-uv.x+0.0+iTime/2.0;
      
//pos=(vec4(pos,1.0)*rotateY(-3.14/2.0)).xyz;
      vec3 pos2=(vec4(pos,1.0)*rotateX(3.14/2.0)*rotateZ(3.14/2.0)).xyz;
      res = vec2(100.0,120.0);
      const float spikeoff=0.05;
      
      res = opU( res, vec2( sdCone(        pos2-vec3( 0.1+spikeoff,0.45,0.4)*scale, vec2(0.05,0.25)*scale,0.45*scale ), 120.0 ) );
      res = opU( res, vec2( sdCone(        pos2-vec3( 0.6+spikeoff,0.45,0.4)*scale, vec2(0.05,0.25)*scale,0.45*scale ), 120.0 ) );
      res = opU( res, vec2( sdCone(        pos2-vec3( 0.6+spikeoff,0.45,0.4)*scale, vec2(0.05,0.25)*scale,0.45*scale ), 120.0 ) );
      res = opU( res, vec2( sdCone(        pos2-vec3( 1.1+spikeoff,0.45,0.4)*scale, vec2(0.05,0.25)*scale,0.45*scale ), 120.0 ) );
      res = opU( res, vec2( sdCone(        pos2-vec3( 1.6+spikeoff,0.45,0.4)*scale, vec2(0.05,0.25)*scale,0.45*scale ), 120.0 ) );
      
      //res = opU( res, vec2(sdBox(pos-vec3(0.0,0.4,1.0)*scale, vec3(0.04,0.15,1.0)*scale),120));
      if (time_>=0.99)
      //if (false)
      {
          //float sdCylinder( vec3 p, vec2 h )
          res = opUsc( res, vec2(sdCylinder(pos3-vec3(-0.314,0.4,0.0)*scale, vec2(2.0/2.0/pi+0.04,0.15)*scale),120),0.02);
          //res = opU( res, vec2(sdCylinder(pos3-vec3(-0.314,0.4,0.0)*scale, vec2(2.0/2.0/pi+0.04,0.15)*scale),120));
          res = opS( res, vec2(sdCylinder(pos3-vec3(-0.314,0.4,0.0)*scale, vec2(2.0/2.0/pi-0.04,0.175)*scale),120));
      }
      else
          res = opUsc( res, vec2(sdBox(pos-vec3(0.0,0.4,1.0)*scale, vec3(0.04,0.15,1.0)*scale),120),0.02);

      //res = vec2(sdBox(pos-vec3(0.0,0.4,1.0)*scale, vec3(0.04,0.15,1.0)*scale),120);
      //res = vec2(sdBox(pos-vec3(1.0,0.4,0.0)*scale, vec3(1.0,0.15,0.04)*scale),120);
    }
/*
    {
      pos.xz=bend(pos.xz,0.22,-3.14/24.0);
      uv=pos;
      uv.xz=bend(uv.xz,0.22,-3.14/24.0);
      vec3 pos2=(vec4(pos,1.0)*rotateX(3.14/2.0)*rotateZ(3.14/2.0)).xyz;
      //vec3 pos3;
      //pos3.y=0.0;
      //pos2=pos3;
      //res = vec2( sdEllipsoid(pos-vec3(0.0,0.25, 0.0), vec3(0.25,0.15,0.45 )*2.0),126.9);
      //res = opUsc( res, vec2(sdEllipsoid(pos-vec3(0.0,0.25, 0.0), vec3(0.25,0.15,0.45)*(1.0+0.3)),126.9),1.0); //tweak last number to get onion layers
      res = vec2(100.0,0.0);
      res = opU( res, vec2( sdCone(        pos2-vec3( 0.0,0.45,0.4), vec2(0.05,0.25),0.45 ), 120.0 ) );
      res = opU( res, vec2( sdCone(        pos2-vec3( 0.3,0.45,0.4), vec2(0.05,0.25),0.45 ), 120.0 ) );
      res = opU( res, vec2( sdCone(        pos2-vec3( 0.6,0.45,0.4), vec2(0.05,0.25),0.45 ), 120.0 ) );
      res = opU( res, vec2( sdCone(        pos2-vec3( 0.9,0.45,0.4), vec2(0.05,0.25),0.45 ), 120.0 ) );
      res = opU( res, vec2(sdBox(pos-vec3(0.0,0.4, 0.6), vec3(0.04,0.15,0.6 )),120));

      //res = opU( res, vec2( sdSolidAngle(  pos-vec3( 0.0,0.0,0.0), vec2(3.0,5.0), 1.1 ), 120.0 ) );
    }
*/
/*
    // bounding box
    if( sdBox( pos-vec3(0.0,0.3,-1.0),vec3(0.35,0.3,2.5) )<res.x )
    {
    // more primitives
    res = opU( res, vec2( sdBoundingBox( pos-vec3( 0.0,0.25, 0.0), vec3(0.3,0.25,0.2), 0.025 ), 16.9 ) );
	res = opU( res, vec2( sdTorus(      (pos-vec3( 0.0,0.30, 1.0)).xzy, vec2(0.25,0.05) ), 25.0 ) );
	res = opU( res, vec2( sdCone(        pos-vec3( 0.0,0.45,-1.0), vec2(0.6,0.8),0.45 ), 55.0 ) );
    res = opU( res, vec2( sdCappedCone(  pos-vec3( 0.0,0.25,-2.0), 0.25, 0.25, 0.1 ), 13.67 ) );
    res = opU( res, vec2( sdSolidAngle(  pos-vec3( 0.0,0.00,-3.0), vec2(3,4)/5.0, 0.4 ), 49.13 ) );
    }

    // bounding box
    if( sdBox( pos-vec3(1.0,0.3,-1.0),vec3(0.35,0.3,2.5) )<res.x )
    {
    // more primitives
	res = opU( res, vec2( sdCappedTorus((pos-vec3( 1.0,0.30, 1.0))*vec3(1,-1,1), vec2(0.866025,-0.5), 0.25, 0.05), 8.5) );
    res = opU( res, vec2( sdBox(         pos-vec3( 1.0,0.25, 0.0), vec3(0.3,0.25,0.1) ), 3.0 ) );
    res = opU( res, vec2( sdCapsule(     pos-vec3( 1.0,0.00,-1.0),vec3(-0.1,0.1,-0.1), vec3(0.2,0.4,0.2), 0.1  ), 31.9 ) );
	res = opU( res, vec2( sdCylinder(    pos-vec3( 1.0,0.25,-2.0), vec2(0.15,0.25) ), 8.0 ) );
    res = opU( res, vec2( sdHexPrism(    pos-vec3( 1.0,0.2,-3.0), vec2(0.2,0.05) ), 18.4 ) );
    }

    // bounding box
    if( sdBox( pos-vec3(-1.0,0.35,-1.0),vec3(0.35,0.35,2.5))<res.x )
    {
    // more primitives
	res = opU( res, vec2( sdPyramid(    pos-vec3(-1.0,-0.6,-3.0), 1.0 ), 13.56 ) );
	res = opU( res, vec2( sdOctahedron( pos-vec3(-1.0,0.15,-2.0), 0.35 ), 23.56 ) );
    res = opU( res, vec2( sdTriPrism(   pos-vec3(-1.0,0.15,-1.0), vec2(0.3,0.05) ),43.5 ) );
    res = opU( res, vec2( sdEllipsoid(  pos-vec3(-1.0,0.25, 0.0), vec3(0.2, 0.25, 0.05) ), 43.17 ) );
	res = opU( res, vec2( sdRhombus(   (pos-vec3(-1.0,0.34, 1.0)).xzy, 0.15, 0.25, 0.04, 0.08 ),17.0 ) );
    }

    // bounding box
    if( sdBox( pos-vec3(2.0,0.3,-1.0),vec3(0.35,0.3,2.5) )<res.x )
    {
    // more primitives
    res = opU( res, vec2( sdOctogonPrism(pos-vec3( 2.0,0.2,-3.0), 0.2, 0.05), 51.8 ) );
    res = opU( res, vec2( sdCylinder(    pos-vec3( 2.0,0.15,-2.0), vec3(0.1,-0.1,0.0), vec3(-0.2,0.35,0.1), 0.08), 31.2 ) );
	res = opU( res, vec2( sdCappedCone(  pos-vec3( 2.0,0.10,-1.0), vec3(0.1,0.0,0.0), vec3(-0.2,0.40,0.1), 0.15, 0.05), 46.1 ) );
    res = opU( res, vec2( sdRoundCone(   pos-vec3( 2.0,0.15, 0.0), vec3(0.1,0.0,0.0), vec3(-0.1,0.35,0.1), 0.15, 0.05), 51.7 ) );
    res = opU( res, vec2( sdRoundCone(   pos-vec3( 2.0,0.20, 1.0), 0.2, 0.1, 0.3 ), 37.0 ) );
    }
*/    
    return res;
}

// http://iquilezles.org/www/articles/boxfunctions/boxfunctions.htm
vec2 iBox( in vec3 ro, in vec3 rd, in vec3 rad ) 
{
    vec3 m = 1.0/rd;
    vec3 n = m*ro;
    vec3 k = abs(m)*rad;
    vec3 t1 = -n - k;
    vec3 t2 = -n + k;
	return vec2( max( max( t1.x, t1.y ), t1.z ),
	             min( min( t2.x, t2.y ), t2.z ) );
}

float cloud_a=0.0;
vec2 res_bkgnd=vec2(0.0);
vec3 pos_bkgnd;
vec3 ro_bkgnd;
vec3 rd_bkgnd;

vec2 raycast_bkgnd( in vec3 ro, in vec3 rd )
{
    vec2 res = vec2(-1.0,-1.0);

    float tmin = 1.0;
    float tmax = 20.0;

    
    // raymarch primitives   
    vec2 tb = iBox( ro-vec3(0.0,0.4,-0.5), rd, vec3(2.5,0.41,3.0) );
    if( tb.x<tb.y && tb.y>0.0 && tb.x<tmax)
    {
        //return vec2(tb.x,2.0);
        tmin = max(tb.x,tmin);
        tmax = min(tb.y,tmax);

        float t = tmin;
        for( int i=0; i<70 && t<tmax; i++ )
        {
            vec2 h = map_bkgnd( ro+rd*t );
            if( abs(h.x)<(0.0001*t) )
            { 
                res = vec2(t,h.y);
                break;
            }
            //t += h.x;
            t += h.x;
        }
    }
    
    return res;
}

vec2 castRay( const vec3 ro, vec3 rd )
 {
    res=vec2(100,100);
    float tmin = 0.0000001;
    float t = tmin;
    float factor;
    if (reflectionrendering==1) factor=3.0/0.7*1.1; else factor=1.0/1.4;
    //int steps_=int(60.0*1.75);
    //float precision_=0.001/64.0; //consider reverting to above for performance gain
    int steps_=150*0.5*0.8*factor;//150*3;
    const float precision_=0.001/64.0*200.0/2.0/100.0*300.0*0.1;//          *20.0;
    float stepper=0.85*0.7*1.2*0.74*1.5/factor; //0.85

 
    //if (rd.y>0.55) return vec2(0.0,0.0);


    {
        ///tmin = max(tb.x,tmin);
        ///tmax = min(tb.y,tmax);

        float t = tmin;
        for( int i=0; i<steps_; i++ )
        {
            ///float a = noiseValue(ro+rd*t);
            vec2 a = map(ro+rd*t);

            vec2 h = a;
            ///vec2 h = vec2(noiseValue(p.xyz),1.0);
            if( abs(h.x)<(precision_*t) )
            {
                res = vec2(t,h.y);
                pos=ro+rd*t;
                break;
            }
            t += h.x*stepper;
        }
    }
    ///t = res.x;
    //float m = res.y;
    return res;

    //vec3 pos = ro + t*rd;
    //vec3 nor = calcNormal( pos );

    //vec3 col;
    //col = texture2D(terraincolor, pos.xz).xyz;
    //return col;
}

vec2 raycast( in vec3 ro, in vec3 rd )
{
    res = vec2(-1.0,-1.0);

    float tmin = 1.0;
    float tmax = 20.0;
/*
    // raytrace floor plane
    float tp1 = (0.0-ro.y)/rd.y;
    if( tp1>0.0 )
    {
        tmax = min( tmax, tp1 );
        res_bkgnd=res = vec2( tp1, 1.0 );
        pos_bkgnd=ro+rd;
        ro_bkgnd=ro;
        rd_bkgnd=rd;
    }
    */
    //else return res;
    
    // raymarch primitives   
    //vec2 tb = iBox( ro-vec3(0.0,0.4,-0.5), rd, vec3(2.5,0.41,3.0) );
    //if( tb.x<tb.y && tb.y>0.0 && tb.x<tmax)
    {
        //return vec2(tb.x,2.0);
      //  tmin = max(tb.x,tmin);
//        tmax = min(tb.y,tmax);

        float t = tmin;
        for( int i=0; i<70 && t<tmax; i++ )
        {
            vec2 h;
            h = map( ro+rd*t );

            if( abs(h.x)<(0.0001*t) )
            { 
                res = vec2(t,h.y);
                break;
            }
            //t += h.x;
            t += h.x;
        }
    }
    
    return res;
}

// http://iquilezles.org/www/articles/rmshadows/rmshadows.htm
float calcSoftshadow( in vec3 ro, in vec3 rd, in float mint, in float tmax )
{
    // bounding volume
    float tp = (0.8-ro.y)/rd.y; if( tp>0.0 ) tmax = min( tmax, tp );

    float res = 1.0;
    float t = mint;
    for( int i=ZERO; i<24; i++ )
    {
		float h = map( ro + rd*t ).x;
        float s = clamp(8.0*h/t,0.0,1.0);
        res = min( res, s*s*(3.0-2.0*s) );
        t += clamp( h, 0.02, 0.2 );
        if( res<0.004 || t>tmax ) break;
    }
    return clamp( res, 0.0, 1.0 );
}

// http://iquilezles.org/www/articles/normalsSDF/normalsSDF.htm
vec3 calcNormal( in vec3 pos )
{
#if 0
    vec2 e = vec2(1.0,-1.0)*0.5773*0.0005;
    return normalize( e.xyy*map( pos + e.xyy ).x + 
					  e.yyx*map( pos + e.yyx ).x + 
					  e.yxy*map( pos + e.yxy ).x + 
					  e.xxx*map( pos + e.xxx ).x );
#else
    // inspired by tdhooper and klems - a way to prevent the compiler from inlining map() 4 times
    vec3 n = vec3(0.0);
    for( int i=ZERO; i<4; i++ )
    {
        vec3 e = 0.5773*(2.0*vec3((((i+3)>>1)&1),((i>>1)&1),(i&1))-1.0);
        n += e*map(pos+0.0005*e).x;
      //if( n.x+n.y+n.z>100.0 ) break;
    }
    return normalize(n);
#endif    
}

float calcAO( in vec3 pos, in vec3 nor )
{
	float occ = 0.0;
    float sca = 1.0;
    for( int i=ZERO; i<5; i++ )
    {
        float h = 0.01 + 0.12*float(i)/4.0;
        float d = map( pos + h*nor ).x;
        occ += (h-d)*sca;
        sca *= 0.95;
        if( occ>0.35 ) break;
    }
    return clamp( 1.0 - 3.0*occ, 0.0, 1.0 ) * (0.5+0.5*nor.y);
}

// http://iquilezles.org/www/articles/checkerfiltering/checkerfiltering.htm
float checkersGradBox( in vec2 p, in vec2 dpdx, in vec2 dpdy )
{
    // filter kernel
    vec2 w = abs(dpdx)+abs(dpdy) + 0.001;
    // analytical integral (box filter)
    vec2 i = 2.0*(abs(fract((p-0.5*w)*0.5)-0.5)-abs(fract((p+0.5*w)*0.5)-0.5))/w;
    // xor pattern
    return 0.5 - 0.5*i.x*i.y;                  
}


vec3 render( in vec3 ro, in vec3 rd, in vec3 rdx, in vec3 rdy )
{ 
    ///vec3 pos;
    
    // background
    vec3 col = vec3(0.2, 0.2, 0.2);// - max(rd.y,0.0)*0.3;
    
    // raycast scene
    vec3 col2=vec3(0.0); 
    float a=0.0;
    int layers=0;
    cloud_a=0.0;
/*
    for (layer=0;layer<totallayers;layer++){
        r_factor=1.1+float(layer)*0.2;
        h_factor=0.1+float(layer)*0.1;
        
        vec2 res = raycast(ro,rd);
        float t = res.x;
        pos = ro + t*rd;
        if (res.y==26.9)
        {
            layers++;
            vec3 q = 10.0*pos;
            float f  = 0.5000*noise( q +vec3(layer*10)); //q = m*q*2.01;
            //f += 0.2500*noise( q ); q = m*q*2.02;
            //f += 0.1250*noise( q ); q = m*q*2.03;
            //f += 0.0625*noise( q ); q = m*q*2.01;

            f = smoothstep( -0.3, 2.0, f );
            col = vec3(f*1.2)*5.0;
            //col = vec3(1.2);
            col2+=col;
            cloud_a+=(float(totallayers-layer)*(1.0/float(totallayers)))*(f*mix(35.0,1.0,float(layer)/float(totallayers)))*1.4;
        }else{
        }
    }
    col2/=float(layers);
    cloud_a/=500.0;//float(layers);

    h_factor=0.6;
    r_factor=1.5;
    vec2 temp=map(pos);
    float h=smoothstep(-1.0,1.0,h_);
    //h=0.5-h;
    h*=4.0; //use this value as alpha
    
    r_factor=1.1;
    cloud_a*=h;
    cloud_a*=2.3;
    */
    
    vec3 pos_cloud=vec3(0.0);
    //vec2 res = raycast(ro,rd);
    res = castRay(ro,rd);
    resres=res;
    float t = res.x;
	float m = res.y;

float c;
float cspec;
if (resres.y!=2071.0)
{
c=noisefast2(texpos*10.0);
c+=noisefast2(texpos*20.0);
c+=noisefast2(texpos*30.0);
c+=noisefast2(texpos*40.0);
c+=noisefast2(texpos*60.0);
c+=noisefast2(texpos*80.0);
c/=6.0;
cspec=noisefast2(texpos*14.0);
cspec+=noisefast2(texpos*41.0);
cspec+=noisefast2(texpos*71.0);
cspec/=3.0;
}
else
{
c=0.0;
/*
c=noisefast2(texpos*10.0);
c+=noisefast2(texpos*20.0);
c/=2.0;
*/
}

    if( m>-0.5 )
    {
        //vec3 pos = ro + t*rd;
        //pos_cloud=pos;
        ///nor = (m==2071.0) ? vec3(0.0,1.0,0.0) : calcNormal( pos );
        nor = calcNormal( pos );
        if (m!=2071.0){
            nor+=texture2D(normalMap,vec2(noisefast2(texpos*10.0),noisefast2(texpos*10.0)))*-0.7;
            }
        if (m==2071.0){
            float scale=0.7*1.2*1.2;
            //float distort=(-2.0*3.0*-2.4)/1.15;
            //float distort=testvalue;
            const float speed=0.5*2.0;
            //vec3 anor=texture2D(normalMap,vec2((pospos.x*scale)+iTime/5.0*speed,pospos.z*scale))/25.0*distort;
            //anor+=texture2D(normalMap,vec2((pospos.x*scale)-iTime/1.35/5.0*speed+0.4,pospos.z*scale+0.4))/20.0*distort;
            #define waternormal normalMap
               const float spd=2.0;
               const float res=2048.0*3.0/70.0;
               vec2 mov1=vec2(-10.0,-0.05)*iTime*spd/res;
               vec2 mov2=vec2(7.1,0.05)*iTime*spd/res;

            vec3 anor=vec3(0.0);
            const float a=3.0*0.2*2.0/0.5;
            const float b=3.8*2.0;
            vec2 p1,p2;
    float sc=iTime/2.0;
    const float ss=0.4;
    const float sa=2.0*0.6;
    float xss=sin(sc*5.0+pospos.x*8.0*ss)/30.0*sa;
    float yss=cos(sc*4.0+pospos.z*8.0*ss)/30.0*sa;
    float sc2=sc*1.15;
    float xss2=sin(sc2*5.3+pospos.x*8.0*ss)/30.0*sa;
    float yss2=cos(sc2*4.3+pospos.z*8.0*ss)/30.0*sa;
    p1=pospos.xz+vec2(xss,yss)*1.3*1.3;
    p2=pospos.xz+vec2(xss2,yss2)*1.3*1.3;
            anor=texture2D(waternormal,pospos.xz*scale+mov1).xyz/2.75+texture2D(waternormal, pospos.xz*scale+mov2).xyz/2.75;
            anor=texture2D(waternormal,pospos.xz*scale+mov1).xyz/2.75+texture2D(waternormal, pospos.xz*scale+mov2).xyz/2.75;
            anor+=texture2D(noisetexturea,p1*scale/1.7/5.5+mov1/b).xyz/a;
            anor+=texture2D(noisetexturea,p2*scale/1.7/5.5+mov2/b).xyz/a;
            anor=anor/2.0/1.1/1.2/2.4*1.8*2.0;
            /*
            float anp=testvalue;
            anor.x=pow(anor.x,anp);
            anor.y=pow(anor.y,anp);
            anor.z=pow(anor.z,anp);
            */
            nor+=anor;

            //nor=vec3(0,1,0);
            }
        ref = reflect( rd, nor );
        
        // material
        col = 0.2 + 0.2*sin( m*2.0 + vec3(0.0,1.0,2.0) );
        float ks = 1.0;
        
        
        
        
col=col2;
vec3 col_bkgnd;//=vec3(0.0);        
        
        /*
        if( m<1.5 )
        {
            // project pixel footprint into the plane
            vec3 dpdx = ro_bkgnd.y*(rd/rd.y-rdx/rdx.y);
            vec3 dpdy = ro_bkgnd.y*(rd/rd.y-rdy/rdy.y);

            float f = checkersGradBox( 3.0*pos.xz, 3.0*dpdx.xz, 3.0*dpdy.xz );
            col_bkgnd = 0.05 + f*vec3(0.15);
            ks = 0.4;
        } else
        {
            vec3 dpdx = ro.y*(rd/rd.y-rdx/rdx.y);
            vec3 dpdy = ro.y*(rd/rd.y-rdy/rdy.y);
            float f = checkersGradBox( 3.0*pos.xz, 3.0*dpdx.xz, 3.0*dpdy.xz );
            col_bkgnd = 0.05 + f*vec3(0.15);
        }
        */
    if (false)
    {
    res = raycast_bkgnd(ro,rd);
    float t = res.x;
	float m = res.y;
        vec3 pos = ro + t*rd;
        //pos+=pos_cloud/4.0;
//#define LIGHTING
#ifdef LIGHTING
        pos+=nor/4.0;
#endif
        //vec3 nor = (m<1.5) ? vec3(0.0,1.0,0.0) : calcNormal( pos );
        //vec3 ref = reflect( rd, nor );
        
        // material
        col_bkgnd=texture2D(iChannel1,pos.xz/2.0).xyz;
     }


/*
        if (m<1.5) col=col_bkgnd; 
        else// col=vec3(cloud_a,0,0);
        //col=mix(col_bkgnd,vec3(1.0),cloud_a);
        col=mix(col_bkgnd,col2,cloud_a);
*/
col=col2;

//-------------------------------------------------------
//if (res.y!=2071.0){
//col=vec3(c,c,c);//texture2D(iChannel1,vec2(uv.x,uv.y)).rgb;
col=texture2D(iChannel1,vec2(c,0.0)).rgb;
//} else col=vec3(1,0,0);
//-------------------------------------------------------


        // lighting
        float specular;
        float occ = calcAO( pos, nor );
        
		vec3 lin = vec3(0.0);
        float dim=1.1*4.2*0.8*1.35;
        // sun
        //if (false)
        //{
            vec3 lig = normalize( vec3(-0.5, 0.4, -0.6) );
            if (m!=2071.0) {
                if (moveico==0) {lig=vec3(sin(4.0)*-2.0*5.0,-1.0*0.3,-cos(4.0)*-30.0); lig=normalize(lig)*10.0; dim*=0.7*1.5*0.3*0.3*2.1;}
                else {lig=vec3(sin(4.0)*-2.0,-1.0*0.3,-cos(4.0)*-5.0); lig=normalize(lig)*10.0;dim*=1.3*1.5*0.9*0.31;}
            }
            

            vec3 hal = normalize( lig-rd );
            float dif = clamp( dot( nor, lig ), 0.0, 1.0 );
                  dif /= dim;
          //if( dif>0.0001 )
              //float h=smoothstep(-1.0,1.0,h_);

        	      //dif *= smoothstep(0.3,1.0,calcSoftshadow( pos, lig, 0.02, 2.5 ));
			float spe = pow( clamp( dot( nor, hal ), 0.0, 1.0 ),16.0*0.2); //if (spe<0.0) spe/=testvalue;
                  spe *= dif;
                  spe *= 0.04+0.96*pow(clamp(1.0-dot(hal,lig),0.0,1.0),5.0);

                  spe /= dim*testvalue;
//spe*=cspec;
                  specular=spe;
            lin += col*2.20*dif*vec3(1.30,1.00,1.70);
            lin +=     5.00*spe*vec3(1.30,1.00,1.70)*ks;
        //}
        // sky
        ///if (false)
        ///if (testvalue>1.0)
        {
            float dif = sqrt(clamp( 0.5+0.5*nor.y, 0.0, 1.0 ));
                  dif *= occ;
                  dif /= dim;
            float spe = smoothstep( -0.2, 0.2, ref.y );
                  spe *= dif;
                  spe *= 0.04+0.96*pow(clamp(1.0+dot(nor,rd),0.0,1.0), 5.0 );
                  spe /= dim;
          //if( spe>0.001 )
                  //spe *= smoothstep(0.3,1.0,calcSoftshadow( pos, ref, 0.02, 2.5 ));
//spe*=cspec;
            lin += col*0.60*dif*vec3(0.40,0.60,1.15);
            lin +=     2.00*spe*vec3(0.40,0.60,1.30)*ks;
        }
        // back
        if (false)
        if (testvalue>2.0)
        {
        	float dif = clamp( dot( nor, normalize(vec3(0.5,0.0,0.6))), 0.0, 1.0 )*clamp( 1.0-pos.y,0.0,1.0);
                  dif *= occ;
        	lin += col*0.55*dif*vec3(0.25,0.25,0.25);
        }
        // sss
        ///if (false)
        ///if (testvalue>3.0)
        {
            float dif = pow(clamp(1.0+dot(nor,rd),0.0,1.0),2.0);
                  dif *= occ;
        	lin += col*0.25*dif*vec3(1.00,1.00,1.00);
        }
     
		//col = lin;
//#ifdef LIGHTING
        //if (false)
//-------------------------------------------------------
        //col=mix(col_bkgnd,lin,-dot(normalize(nor),normalize(rd-ro)));
        //const vec3 watercolor=vec3(25.0/255.0, 75.0/255.0, 128.0/255.0);
        //const vec3 watercolor=vec3(50.0/255.0, 65.0/255.0, 240.0/255.0);
        //const vec3 watercolor=vec3(56.0/255.0, 68.0/255.0, 208.0/255.0);
        const vec3 watercolor=vec3(69.0/255.0, 77.0/255.0, 184.0/255.0)*0.9;
        if (m==2071.0){
            col=mix(watercolor,lin,-dot(normalize(nor),normalize(rd-ro)));
            col*=1.15;
            ///col=watercolor+specular*100.0*3.5*0.5*0.66;
            }
        else {
            specular*=5.33*(0.75-cspec);
            specular*=100.0*2.3*0.4;
            //if (dot( nor, hal )<0.0) specular=-0.09;
            if (reflectionrendering==0)
                col+=specular;
            }
        //col*=occ*4.0;
//-------------------------------------------------------
//#endif
        //if (m==1.0) col=lin; else
        //col=mix(col,lin,smoothstep(0.0,0.4,dot(normalize(nor),normalize(rd-ro))/4.0)); //dot is 0 when angle is 90
        //col=mix(col_bkgnd,col_bkgnd+col*5.0,smoothstep(0.0,0.5,-dot(normalize(nor),normalize(rd-ro))/4.0)); //dot is 0 when angle is 90
        //col=mix(col,col_bkgnd+col*5.0,smoothstep(0.0,0.5,dot(normalize(nor),normalize(rd-ro))/4.0)); //dot is 0 when angle is 90
        //col=smoothstep(0.1,0.4,col_bkgnd+col*1.5);

        //col = mix( col, vec3(0.7,0.7,0.9), 1.0-exp( -0.0001*t*t*t ) );
    }

	//return vec3( clamp(col,0.0,1.0) );

        ///float m=(col.r+col.g+col.b)/3.0;
        ///m=clamp(m,0.0,1.0-2.0/256.0);
        ///col=texture2D(palette, vec2(m,useindex/12.0)).rgb;
        //col=vec4(useindex/12.0);
    






























if (m==2071.0) {
        nor=normalize(nor);

        //refrd = reflect(rd, nor);
///vec3 refrd = reflect(rd, nor);
        ///refro=pos+nor*0.003;
///vec3 refro = pos+nor*-0.01;
        ///if (plasmafx>0) refro=pos+nor*0.03;

            //col=vec4(1.2,0.19,0.25,1.0).xyz;
            //col=textureCube(env,normalize(ro+rd)).xyz; ///background
            //col=textureCube(env,RotateY(rd,3.14)).xyz; ///background

        //vec3 ref;
        //ref = reflect( rd, nor );

        if (m>0.0){
        // lighting
        ///-float occ = calcAO( pos, nor );
        //vec3  lig = normalize( vec3(-4.4, 0.7, 0.0) )*100.0;
        vec3 lig;
        lig = normalize(vec3((-4.4*-1.7), (0.7*-1.18), (-0.5)) )*500.0*1.1/250.0;
        ///if (m!=2071.0) lig.z*=-1.0;

/*
        float amb = clamp( 0.5+0.5*nor.y, 0.0, 1.0 );
        float dif = clamp( (1.0+dot( nor, lig ))/2.0, 0.0, 1.0 );
        float spe = pow(clamp((1.0+dot(rd-ro,ref))/2.0,0.0,1.0),1.2);
        */

        // sun
        float amb = 0.2;
        
            ///vec3  lig = normalize( vec3(-0.5, 0.4, -0.6) );
            vec3  hal = normalize( lig-rd );
            float dif = clamp( dot( nor, lig ), 0.0, 1.0 );
          //if( dif>0.0001 )
        	      ///dif *= calcSoftshadow( pos, lig, 0.02, 2.5 );
			float spe = pow( clamp( dot( nor, hal ), 0.0, 1.0 ),16.0);
                  spe *= dif;
                  spe *= 0.04+0.96*pow(clamp(1.0-dot(hal,lig),0.0,1.0),5.0);
            //lin += col*2.20*dif*vec3(1.30,1.00,0.70);
            //lin +=     5.00*spe*vec3(1.30,1.00,0.70)*ks;

        vec3 lin = vec3(0.0);

float boost=1.2;//1.65

float material=m;
        ///lin += 2.00*spe*vec3(1.00,0.90,0.70)*dif*boost;
        if (material==2071.0){ //water or water foam or ice
            //col=vec4(0.2,0.19,0.25,1.0).xyz;
//col=texture2D(iChannel1,vec2(c,0.0)).rgb;
            lin += (1.33*spe*vec3(0.9,0.9,1.1)*(dif/4.0)*boost)/6.5;
            lin += (1.30*dif*vec3(0.9,0.9,1.0)*boost)/3.0;
        } else if (material==5.0){ //background
            //col=vec4(1.2,0.19,0.25,1.0).xyz;
            //col=textureCube(env,normalize(ro+rd)).xyz*vec3(10.0,1.0,1.0); ///background
            ///lin = vec3(1,1,1);
        } else {
            lin += 1.30*dif*vec3(1.00,1.00,1.00)*boost;
        }

        amb=1.0;
        lin += 0.75*amb*vec3(0.70,0.70,0.70)*boost;
        ///if (material==3.0||material==4.0||material==6.0) lin*=testvalue;
        ///-lin += 0.50*dom*vec3(0.70,0.70,0.70)*occ;
        ///-lin += 0.50*bac*vec3(0.25,0.25,0.25)*occ;
        ///-lin += 0.25*fre*vec3(1.00,1.00,1.00)*occ;
        lin=clamp(lin,0.1,1.0);

            col=col*lin*1.75;
            float x=pow(lin.b,2.6);
            col+=vec3(x*1.2,x*1.175,x*1.1)*0.4;
    float testvalue3=33.0*0.4;
    #define const_1 ( (16.0+testvalue3) / 255.0)
    #define const_2 (255.0 / (219.0-testvalue3))
    //#define const_1 (boostlow / 255.0)
    //#define const_2 (255.0 / boosthigh)
    col.rgb = ((col.rgb - vec3(const_1)) * vec3(const_2));
    col.b*=1.5;
    col.rgb=mix(col.rgb,vec3(75.0/256.0,78.0/256.0,159.0/256.0),0.5);
//        return vec3(clamp(col,0.0,1.0));

//height dependent color change:
col.rgb+=waterheight/2.4;
//some more gamma fiddling:
col.rgb*=1.0-0.9*(1.0-(col.r+col.g+col.b)/3.0);

if (m==1000.0) col=vec4(0.0,0.0,0.0,1.0);
}
}
































if (m==2071.0){
    float i=(col.r+col.g+col.b)/3.0;
    if (i>0.84){
    //float t=testvalue;
    col=clamp(col,0.0,0.4)*1.5*1.4;
    float e=1.4;
    col.r=pow(col.r,e);
    col.g=pow(col.g,e);
    col.b=pow(col.b,e);
    const vec3 watercolor=vec3(69.0/255.0, 77.0/255.0, 184.0/255.0)*0.9;
    col=mix(col,watercolor,1.0-0.65);
    }
	return vec3( clamp(col.rgb,0.0,1.0) );
}
if(res.y>100)
	return vec3( clamp(col,0.0,1.0) );
else
   {
    vec2 coos=gl_FragCoord.xy;
    float xc=coos.x/iResolution.x;
    float yc=coos.y/iResolution.y;
    return texture2D(colorMap,vec2(xc,yc)).rgb;
   }
}

mat3 setCamera( in vec3 ro, in vec3 ta, float cr )
{
//return mat3cam;
    vec3 cw = normalize(ta-ro);

    //vec3 cp = vec3(sin(cr), cos(cr),0.0);
    vec3 cp = upvector;
    ///vec3 cp = vec3(0,1,0);

    vec3 cu = normalize( cross(cw,cp) );
    vec3 cv = normalize( cross(cu,cw) );
    return mat3( cu, cv, cw );
}
/*
	vec3 cw = normalize(ta-ro);
	vec3 cp = vec3(sin(cr), cos(cr),0.0);
	vec3 cu = normalize( cross(cw,cp) );
	vec3 cv =          ( cross(cu,cw) );
    return mat3( cu, cv, cw );
}
*/

void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 mo = vec2(0.0);
	float time = 0.0;//32.0 + iTime*1.5*2.5;

    // camera	
    //vec3 ta = vec3( 0.5, -0.5, -0.6 );
    vec3 ta = vec3( 0.0, -0.5, -0.0 );
    //vec3 ro = ta + vec3( 1.0*cos(0.1*time + 7.0*mo.x), 0.5 + 2.0*mo.y, 1.0*sin(0.1*time + 7.0*mo.x) );
    vec3 ro = ta + vec3( 0.0, 0.5, 0.0 );
    // camera-to-world transformation
    mat3 ca = setCamera( ro, ta, 0.0 );

    vec3 tot = vec3(0.0);
#if AA>1
    for( int m=ZERO; m<AA; m++ )
    for( int n=ZERO; n<AA; n++ )
    {
        // pixel coordinates
        vec2 o = vec2(float(m),float(n)) / float(AA) - 0.5;
        vec2 p = (2.0*(fragCoord+o)-iResolution.xy)/iResolution.y;
#else    
        vec2 p = (2.0*fragCoord-iResolution.xy)/iResolution.y;
#endif

        // focal length
        const float fl = 2.5;
        
        // ray direction
        vec3 rd = ca * normalize( vec3(p,fl) );

         // ray differentials
        vec2 px = (2.0*(fragCoord+vec2(1.0,0.0))-iResolution.xy)/iResolution.y;
        vec2 py = (2.0*(fragCoord+vec2(0.0,1.0))-iResolution.xy)/iResolution.y;
        vec3 rdx = ca * normalize( vec3(px,fl) );
        vec3 rdy = ca * normalize( vec3(py,fl) );
        
        // render	
        vec3 col = render( ro, rd, rdx, rdy );

        // gain
        // col = col*3.0/(2.5+col);
        
		// gamma
       // col = pow( col, vec3(0.4545) );

        tot += col;
#if AA>1
    }
    tot /= float(AA*AA);
#endif
    
    fragColor = vec4( tot, 1.0 );
}

void mainImage2( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 mo = iMouse.xy/iResolution.xy;
    float time = 15.0 + iTime;


    vec2 p = (-iResolution.xy + 2.0*fragCoord)/iResolution.y;

            // camera
            vec3 ro = vec3( -0.5+3.5*cos(0.1*time + 6.0*mo.x), 3.0 + 2.0*mo.y, 0.5 + 4.0*sin(0.1*time + 6.0*mo.x) );
            vec3 ta = vec3( -0.5, -0.4, 0.5 );

//dm installed camera control:
            ro=rayorigin;// /vec3(20.0);
            ta=raydirection;// /vec3(20.0);
            
 //ta = vec3( 0.0, 0.0, -0.0 );
 //ro=ta+vec3(1.0,1.3,1.0);

                                                    //ro = vec3(-1.5,0.2,0.0);
                                                    //ta = vec3( 17.0, 0.0, 0.7 );

            // camera-to-world transformation
            ca = setCamera( ro, ta, 0.0 );
            //mat3 ca = mat3cam;


            // ray direction
            //vec3 rd = ca * normalize( vec3(p.x,p.y+1.0,2.0) );
    //vec3 rd = ca * normalize( vec3(p.x,p.y,2.0) );
      vec3 rd = ca * normalize( vec3(p.x,p.y,fov ) );


        // focal length
        const float fl = 2.5;
        
        // ray direction
        rd = ca * normalize( vec3(p,fl) );

         // ray differentials
        vec2 px = (2.0*(fragCoord+vec2(1.0,0.0))-iResolution.xy)/iResolution.y;
        vec2 py = (2.0*(fragCoord+vec2(0.0,1.0))-iResolution.xy)/iResolution.y;
        vec3 rdx = ca * normalize( vec3(px,fl) );
        vec3 rdy = ca * normalize( vec3(py,fl) );
        
        // render	
        vec3 col = render( ro, rd, rdx, rdy );

        float ca=1.0;
        if (resres.y==2071.0){
            vec3 refrd = ref;
            ///nor=vec3(0,1,0);
            ///nor=texture2D(normalMap,vec2(pospos.x,pospos.z));
            vec3 refro = pospos+nor*-0.5;
            ca=pow(clamp(length(pospos.xz)/2.0*0.3*1.13,0.0,1.0),1.5);
            reflectionrendering=1;
            vec3 colref=render(refro,refrd,rdx,rdy);
            reflectionrendering=0;
            col+=colref/2.0*0.66;
            col=mix(col,texture2D(colorMap,vec2(fragCoord.x/1920.0,fragCoord.y/1080.0)).rgb,ca);
            //col=colref;
        }


        fragColor = vec4( col, 1.0);
}


void main()
{
    //skrul=vec2(0,-scrollTime/1.05)*speed;// *testvalue;

    //stime=skrul.y/3.0;
    ///totalcolor=vec3(0,0,0);
    ///totalindex=0.0;

    ///if (rendertoshadowmap==1) iResolution=vec3(1024,1024,0);

    vec4 color=vec4(0.0, 0.0, 0.0, 1.0);
    vec2 coos=gl_FragCoord.xy;
    /*
    coos.x/=iResolution.x;
    coos.y/=iResolution.y;
    coos=Distort(coos);
    coos.x*=iResolution.x;
    coos.y*=iResolution.y;
    */
    //coos.x=(coos.x-400*(sin(coos.x/iResolution.x*PI+PI/2.0)+1.0));
    //coos.y=(coos.y-200*(sin(coos.y/iResolution.x*PI+PI/2.0)+1.0));
    //coos.x/=iResolution.x;
    float xc=coos.x/iResolution.x;
    float yc=coos.y/iResolution.y;
    //coos.x+=sin(((coos.x-0.5)*2.0)*PI/2)*0.26;
    //fishdx=sin(((coos.x-0.5)*2.0)*PI/2)*0.5;
    //fishdx=(1.0-pow((xc-0.5+pioffset),2.0))*10.0;
    float dim=0.9*2.0;
    //dim=testvalue;

    mainImage2(color,coos);

    //color=vec4(debug,0,0,1);

    gl_FragColor = color;
    //gl_FragColor =vec4(debug,1.0);
}


