//MIT licensed
//Copyright (C) 2014 Jaume Sanchez Elias
//https://github.com/spite/Wagner/blob/master/fragment-shaders/chromatic-aberration-fs.glsl

uniform sampler2D tInput;
uniform float testfactor;
//uniform vec2 resolution;

//const vec2 resolution=vec2(1920.0f/zoom,1080.0f/zoom);
const vec2 resolution=vec2(1920.0f,1080.0f);

float max_distort = 1.15/4.65;//2.2

vec2 barrelDistortion(vec2 coord, float amt) {
float zoom=1.35/1.25;

    vec2 coord2=coord;

	vec2 cc = coord2 - vec2(0.5);
	float dist = dot(cc, cc);

	//vec2 res=coord2 + dist * amt;
	vec2 res=coord2 + cc * dist * amt;
	///res.x=clamp(res.x,0.0,1.0);
	///res.y=clamp(res.y,0.0,1.0);
	
	
	res=(res-vec2(0.5))/zoom+vec2(0.5);
	///res-=vec2((zoom-1.0));//+vec2(testfactor)
	///res=(res-vec2(0.5))/zoom+vec2(0.5)+vec2(testfactor);
	//res.x=clamp(res.x,0.0f,1.0f-1.0f/1920.0f);
	//res.y=clamp(res.y,0.0f,1.0f-1.0f/1080.0f);
	return res;

	//return coord;
}

float sat( float t )
{
	return clamp( t, 0.0, 1.0 );
}

float linterp( float t ) {
	return sat( 1.0 - abs( 2.0*t - 1.0 ) );
}

float remap( float t, float a, float b ) {
	return sat( (t - a) / (b - a) );
}

vec4 spectrum_offset( float t ) {
	vec4 ret;
	float lo = step(t,0.5);
	float hi = 1.0-lo;
	float w = linterp( remap( t, 1.0/6.0, 5.0/6.0 ) );
	///float w = linterp( remap( t, 1.0/6.0, 10.0/6.0 ) );
	ret = vec4(lo,1.0,hi, 1.) * vec4(1.0-w, w, 1.0-w, 1.);

	return pow( ret, vec4(1.0/2.2) );
}

const int num_iter = 6;//12;
const float reci_num_iter_f = 1.0 / float(num_iter);

void main()
{
/*
    //resolution.x=resolutionx; resolution.y=resolutiony;

	//vec2 uv=(gl_FragCoord.xy/resolution.xy*.5)+.25;
	//vec2 uv=(gl_FragCoord.xy/resolution.xy);//-.25/64.0;//.25/8.0
	///vec2 uv=(gl_FragCoord.xy/resolution.xy)+.25/12.5*2.0f;//.25/8.0
	vec2 uv=(gl_FragCoord.xy/resolution.xy);//.25/8.0
	
	vec4 sumcol = vec4(0.0);
	vec4 sumw = vec4(0.0);
	for ( int i=0; i<num_iter; i++ )
	{
		float t = float(i) * reci_num_iter_f/2.0;
		vec4 w = spectrum_offset( t *2.0);
		sumw += w;
		sumcol += w * texture2D( tInput, barrelDistortion(uv, .6 * max_distort*t ) );
	}

	vec4 col=sumcol / sumw;
*/
/*
	int y=int(gl_FragCoord.y)%6;
	const float a=0.925;
	const float b=1.1;
	const float scanlines[6]={a,a,a-0.175,b,b,b+0.2};

	gl_FragColor = col*scanlines[y];
*/
	
	vec2 uv=(gl_FragCoord.xy/resolution.xy);//.25/8.0
	gl_FragColor = texture2D( tInput, uv);

	///gl_FragColor = col;
	/*
	vec2 distort=barrelDistortion(uv, .6 * max_distort );
	vec4 w = spectrum_offset((distort.x+distort.y)/2.0f);
	gl_FragColor = w*texture2D( tInput, distort );
	*/
}
