/// dusk clouds

#version 130
#define PI 3.1415926535897932384626433832795
//#version 130
//#define texture2D texture

uniform float selectrender;
uniform int plasmafx;
vec3 plasmacol;

vec3 fadepos, fadecol;
float debug;
//float stime;
uniform float speed;

bool leftside=false;
float fishdx,fishdy;
bool renderingreflection=false;
vec2 skrul=vec2(0,0);
vec2 uv_;
vec2 uvice;

float h_; // for smooth union result
float h_ice,h_ice_g;
float material=0.0;

vec3 refro;
vec3 refrd;
vec3 refno;

mat3 ca;
const float depthmult=20.0;
const float depthmax=19.3872;
/*
float testvalue=1.0;
int flavor=1;
float roughsize=0.0080;
float pioffset=1.0;

vec3 rayorigin=vec3(0.0116,3.7571,17.31);
vec3 raydirection=vec3(-0.0635,-8.3669,2.3102);
vec3 upvector=vec3(0.0,1.0,0.0);

float fov=1.2;
*/
/*
mat4 mat4cam=mat4(
1.7840, -0.0100, -0.0039, -0.0039,
0.0000, 2.4666, -0.6289, -0.6286,
-0.0089, -1.9937, -0.7780, -0.7777,
0.1339, 25.2431, 15.6303, 15.8240
);
*/
/*
mat4 mat4cam=mat4(
vec4(1.7840,0.0,-0.0089,0.1339),
vec4(-0.01,2.4666,-1.9937,25.2431),
vec4(-0.0039,-0.6289,-0.7780,15.6303),
vec4(-0.0039,-0.6286,-0.7777,15.8240)
);
*/

uniform float testvalue;
uniform int flavor; //0 - standard  1 - snow
uniform float roughsize;
uniform float pioffset;

uniform vec3 rayorigin;
uniform vec3 raydirection;
uniform vec3 upvector;

uniform float fov;

uniform mat4 mat4cam;

#define noisetexturea noisetexture2
uniform sampler2D noisetexture2;
uniform sampler2D iChannel1;
uniform sampler2D cloudcolor;
uniform samplerCube env;

#define iChannel0 noisetexture2
//#define iChannel1 noisetexture2
#define iChannel2 noisetexture2
/*
#define noisetexture iChannel0
#define terraincolor iChannel1
#define waternormal iChannel2
#define noisetexture2 iChannel3
*/
///important

uniform float iTime;
uniform float scrollTime;
vec3 iResolution=vec3(1920.0,1080.0,1.0);
vec4 iMouse=vec4(1920.0/2.0,1080.0/2.0,1.0,1.0);
float iFrame=0.0;


float localTime = 0.0;
float marchCount;

















///uniform float animate;
float animate=1.0;

//clouds 21 0.996

//
// Description : Array and textureless GLSL 2D/3D/4D simplex 
//               noise functions.
//      Author : Ian McEwan, Ashima Arts.
//  Maintainer : stegu
//     Lastmod : 20110822 (ijm)
//     License : Copyright (C) 2011 Ashima Arts. All rights reserved.
//               Distributed under the MIT License. See LICENSE file.
//               https://github.com/ashima/webgl-noise
//               https://github.com/stegu/webgl-noise
// 

vec4 mod289(vec4 x) {
  return x - floor(x * (1.0 / 289.0)) * 289.0; }

float mod289(float x) {
  return x - floor(x * (1.0 / 289.0)) * 289.0; }

vec4 permute(vec4 x) {
     return mod289(((x*34.0)+10.0)*x);
}

float permute(float x) {
     return mod289(((x*34.0)+10.0)*x);
}

vec4 taylorInvSqrt(vec4 r)
{
  return 1.79284291400159 - 0.85373472095314 * r;
}

float taylorInvSqrt(float r)
{
  return 1.79284291400159 - 0.85373472095314 * r;
}

vec4 grad4(float j, vec4 ip)
  {
  const vec4 ones = vec4(1.0, 1.0, 1.0, -1.0);
  vec4 p,s;

  p.xyz = floor( fract (vec3(j) * ip.xyz) * 7.0) * ip.z - 1.0;
  p.w = 1.5 - dot(abs(p.xyz), ones.xyz);
  s = vec4(lessThan(p, vec4(0.0)));
  p.xyz = p.xyz + (s.xyz*2.0 - 1.0) * s.www; 

  return p;
  }
						
// (sqrt(5) - 1)/4 = F4, used once below
#define F4 0.309016994374947451

float snoise(vec4 v)
  {
  const vec4  C = vec4( 0.138196601125011,  // (5 - sqrt(5))/20  G4
                        0.276393202250021,  // 2 * G4
                        0.414589803375032,  // 3 * G4
                       -0.447213595499958); // -1 + 4 * G4

// First corner
  vec4 i  = floor(v + dot(v, vec4(F4)) );
  vec4 x0 = v -   i + dot(i, C.xxxx);

// Other corners

// Rank sorting originally contributed by Bill Licea-Kane, AMD (formerly ATI)
  vec4 i0;
  vec3 isX = step( x0.yzw, x0.xxx );
  vec3 isYZ = step( x0.zww, x0.yyz );
//  i0.x = dot( isX, vec3( 1.0 ) );
  i0.x = isX.x + isX.y + isX.z;
  i0.yzw = 1.0 - isX;
//  i0.y += dot( isYZ.xy, vec2( 1.0 ) );
  i0.y += isYZ.x + isYZ.y;
  i0.zw += 1.0 - isYZ.xy;
  i0.z += isYZ.z;
  i0.w += 1.0 - isYZ.z;

  // i0 now contains the unique values 0,1,2,3 in each channel
  vec4 i3 = clamp( i0, 0.0, 1.0 );
  vec4 i2 = clamp( i0-1.0, 0.0, 1.0 );
  vec4 i1 = clamp( i0-2.0, 0.0, 1.0 );

  //  x0 = x0 - 0.0 + 0.0 * C.xxxx
  //  x1 = x0 - i1  + 1.0 * C.xxxx
  //  x2 = x0 - i2  + 2.0 * C.xxxx
  //  x3 = x0 - i3  + 3.0 * C.xxxx
  //  x4 = x0 - 1.0 + 4.0 * C.xxxx
  vec4 x1 = x0 - i1 + C.xxxx;
  vec4 x2 = x0 - i2 + C.yyyy;
  vec4 x3 = x0 - i3 + C.zzzz;
  vec4 x4 = x0 + C.wwww;

// Permutations
  i = mod289(i); 
  float j0 = permute( permute( permute( permute(i.w) + i.z) + i.y) + i.x);
  vec4 j1 = permute( permute( permute( permute (
             i.w + vec4(i1.w, i2.w, i3.w, 1.0 ))
           + i.z + vec4(i1.z, i2.z, i3.z, 1.0 ))
           + i.y + vec4(i1.y, i2.y, i3.y, 1.0 ))
           + i.x + vec4(i1.x, i2.x, i3.x, 1.0 ));

// Gradients: 7x7x6 points over a cube, mapped onto a 4-cross polytope
// 7*7*6 = 294, which is close to the ring size 17*17 = 289.
  vec4 ip = vec4(1.0/294.0, 1.0/49.0, 1.0/7.0, 0.0) ;

  vec4 p0 = grad4(j0,   ip);
  vec4 p1 = grad4(j1.x, ip);
  vec4 p2 = grad4(j1.y, ip);
  vec4 p3 = grad4(j1.z, ip);
  vec4 p4 = grad4(j1.w, ip);

// Normalise gradients
  vec4 norm = taylorInvSqrt(vec4(dot(p0,p0), dot(p1,p1), dot(p2, p2), dot(p3,p3)));
  p0 *= norm.x;
  p1 *= norm.y;
  p2 *= norm.z;
  p3 *= norm.w;
  p4 *= taylorInvSqrt(dot(p4,p4));

// Mix contributions from the five corners
  vec3 m0 = max(0.6 - vec3(dot(x0,x0), dot(x1,x1), dot(x2,x2)), 0.0);
  vec2 m1 = max(0.6 - vec2(dot(x3,x3), dot(x4,x4)            ), 0.0);
  m0 = m0 * m0;
  m1 = m1 * m1;
  return 49.0 * ( dot(m0*m0, vec3( dot( p0, x0 ), dot( p1, x1 ), dot( p2, x2 )))
               + dot(m1*m1, vec2( dot( p3, x3 ), dot( p4, x4 ) ) ) ) ;

  }


#define AA 0


//Original 2015 version.

vec2 Hash(vec2 P)
{
vec2 val1=texture(iChannel0,P/1000.0+iTime/500.0).xy;
vec2 val2=texture(iChannel0,P/1000.0).xy;
vec2 val=vec2(val1.x,val2.x);
val-=0.5;
val/=1.1;
return val;
 	return fract(cos(P*mat2(-64.2,71.3,81.4,-29.8))*8321.3); 
}


float Hash3d(vec3 uv)
{

    if (uv.x<0.0) uv.x=1.0+uv.x;
    if (uv.y<0.0) uv.y=1.0+uv.y;
    if (uv.z<0.0) uv.z=1.0+uv.z;
    if (uv.x>1.0) uv.x=uv.x-1.0;
    if (uv.y>1.0) uv.y=uv.y-1.0;
    if (uv.z>1.0) uv.z=uv.z-1.0;
    
    //uv=clamp(uv,0.0,1.0);

    float f = uv.x + uv.y * 37.0 + uv.z * 521.0;
    //return fract(sin(f)*110003.9);
    return fract(cos(f)*110003.9);
}

const vec2 zeroOne = vec2(0.0, 1.0);
float mixP(float f0, float f1, float a)
{
    return mix(f0, f1, a);
    return mix(f0, f1, a*a*(3.0-2.0*a));
}
float noiseValue(vec3 uv)
{
    vec3 fr = fract(uv.xyz);
    vec3 fl = floor(uv.xyz);
    float h000 = Hash3d(fl);
    float h100 = Hash3d(fl + zeroOne.yxx);
    float h010 = Hash3d(fl + zeroOne.xyx);
    float h110 = Hash3d(fl + zeroOne.yyx);
    float h001 = Hash3d(fl + zeroOne.xxy);
    float h101 = Hash3d(fl + zeroOne.yxy);
    float h011 = Hash3d(fl + zeroOne.xyy);
    float h111 = Hash3d(fl + zeroOne.yyy);
    return mixP(
        mixP(mixP(h000, h100, fr.x),
             mixP(h010, h110, fr.x), fr.y),
        mixP(mixP(h001, h101, fr.x),
             mixP(h011, h111, fr.x), fr.y)
        , fr.z);
}

float r(float n)
{
 	return fract(cos(n*89.42)*343.42);
}

vec2 r(vec2 n)
{
 	vec2 result=vec2(r(n.x*23.62-300.0+n.y*34.35),r(n.x*45.13+256.0+n.y*38.89)); 
    ///return result;
    return vec2(noiseValue(vec3(n,iTime/4.0)));//+result;
}

float fade(vec2 n){
    return fract(noiseValue(vec3(n,0.0)));
}

float worley(vec2 n,float s) 
{
    float dis = 1.0;
    for(int x = -1;x<=1;x++)
    {
        for(int y = -1;y<=1;y++)
        {
            vec2 p = floor(n/s)+vec2(x,y);
            float d = length(r(p)+vec2(x,y)-fract(n/s));
            if (dis>d)
            {
             	dis = d;
            }
        }
    }
    return dis;
	
}


vec3 gammaCorrect(vec3 color, float gamma){
    return pow(color, vec3(1.0/gamma));
}

vec3 levelRange(vec3 color, float minInput, float maxInput){
    return min(max(color - vec3(minInput), vec3(0.0)) / (vec3(maxInput) - vec3(minInput)), vec3(1.0));
}

float flevelRange(float color, float minInput, float maxInput){
    return min(max(color - minInput, 0.0) / (maxInput - minInput), 1.0);
}

vec3 finalLevels(vec3 color, float minInput, float gamma, float maxInput){
    return gammaCorrect(levelRange(color, minInput, maxInput), gamma);
}

//use like: vec3 col = finalLevels(someTex.rgb, 34.0/255.0, 1.5, 235.0/255.0);

// The MIT License
// Copyright  2013 Inigo Quilez
// Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions: The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software. THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


// Simplex Noise (http://en.wikipedia.org/wiki/Simplex_noise), a type of gradient noise
// that uses N+1 vertices for random gradient interpolation instead of 2^N as in regular
// latice based Gradient Noise.


// Value    Noise 2D, Derivatives: https://www.shadertoy.com/view/4dXBRH
// Gradient Noise 2D, Derivatives: https://www.shadertoy.com/view/XdXBRH
// Value    Noise 3D, Derivatives: https://www.shadertoy.com/view/XsXfRH
// Gradient Noise 3D, Derivatives: https://www.shadertoy.com/view/4dffRH
// Value    Noise 2D             : https://www.shadertoy.com/view/lsf3WH
// Value    Noise 3D             : https://www.shadertoy.com/view/4sfGzS
// Gradient Noise 2D             : https://www.shadertoy.com/view/XdXGW8
// Gradient Noise 3D             : https://www.shadertoy.com/view/Xsl3Dl
// Simplex  Noise 2D             : https://www.shadertoy.com/view/Msf3WH
// Wave     Noise 2D             : https://www.shadertoy.com/view/tldSRj


vec2 hash( vec2 p ) // replace this by something better
{
	p = vec2( dot(p,vec2(127.1,311.7)), dot(p,vec2(269.5,183.3)) );
	return -1.0 + 2.0*fract(sin(p)*43758.5453123);
}

float noise( in vec2 p )
{
    const float K1 = 0.366025404; // (sqrt(3)-1)/2;
    const float K2 = 0.211324865; // (3-sqrt(3))/6;

	vec2  i = floor( p + (p.x+p.y)*K1 );
    vec2  a = p - i + (i.x+i.y)*K2;
    float m = step(a.y,a.x); 
    vec2  o = vec2(m,1.0-m);
    vec2  b = a - o + K2;
	vec2  c = a - 1.0 + 2.0*K2;
    vec3  h = max( 0.5-vec3(dot(a,a), dot(b,b), dot(c,c) ), 0.0 );
	vec3  n = h*h*h*h*vec3( dot(a,hash(i+0.0)), dot(b,hash(i+o)), dot(c,hash(i+1.0)));
    return dot( n, vec3(70.0) );
}

// -----------------------------------------------

vec3 noise_(in vec2 fragCoord )
{
    vec2 p = fragCoord.xy / iResolution.xy;

	vec2 uv = p*vec2(iResolution.x/iResolution.y,1.0) + iTime*0.25;
	
	float f = 0.0;
	
    // left: value noise	
	if( p.x<0.6 )
	{
		f = noise( 16.0*uv );
	}
    // right: fractal noise (4 octaves)
    else	
	{
		uv *= 5.0;
        mat2 m = mat2( 1.6,  1.2, -1.2,  1.6 );
		f  = 0.5000*noise( uv ); uv = m*uv;
		f += 0.2500*noise( uv ); uv = m*uv;
		f += 0.1250*noise( uv ); uv = m*uv;
		f += 0.0625*noise( uv ); uv = m*uv;
	}

	f = 0.5 + 0.5*f;
	
    f *= smoothstep( 0.0, 0.005, abs(p.x-0.6) );	
	
	return vec3( f );
}

vec3 random3(vec3 c) {
	float j = 4096.0*sin(dot(c,vec3(17.0, 59.4, 15.0)));
	vec3 r;
	r.z = fract(512.0*j);
	j *= .125;
	r.x = fract(512.0*j);
	j *= .125;
	r.y = fract(512.0*j);
	return r-0.5;
}

const float F3 =  0.3333333;
const float G3 =  0.1666667;

float simplex3d(vec3 p) {
	 vec3 s = floor(p + dot(p, vec3(F3)));
	 vec3 x = p - s + dot(s, vec3(G3));
	 
	 vec3 e = step(vec3(0.0), x - x.yzx);
	 vec3 i1 = e*(1.0 - e.zxy);
	 vec3 i2 = 1.0 - e.zxy*(1.0 - e);
	 	
	 vec3 x1 = x - i1 + G3;
	 vec3 x2 = x - i2 + 2.0*G3;
	 vec3 x3 = x - 1.0 + 3.0*G3;
	 
	 vec4 w, d;
	 
	 w.x = dot(x, x);
	 w.y = dot(x1, x1);
	 w.z = dot(x2, x2);
	 w.w = dot(x3, x3);
	 
	 w = max(0.6 - w, 0.0);
	 
	 d.x = dot(random3(s), x);
	 d.y = dot(random3(s + i1), x1);
	 d.z = dot(random3(s + i2), x2);
	 d.w = dot(random3(s + 1.0), x3);
	 
	 w *= w;
	 w *= w;
	 d *= w;
	 
	 return dot(d, vec4(52.0));
}

const mat3 rot1 = mat3(-0.37, 0.36, 0.85,-0.14,-0.93, 0.34,0.92, 0.01,0.4);
const mat3 rot2 = mat3(-0.55,-0.39, 0.74, 0.33,-0.91,-0.24,0.77, 0.12,0.63);
const mat3 rot3 = mat3(-0.71, 0.52,-0.47,-0.08,-0.72,-0.68,-0.7,-0.45,0.56);

float simplex3d_fractal(vec3 m) {
    return   0.5333333*simplex3d(m*rot1)
			+0.2666667*simplex3d(2.0*m*rot2)
			+0.1333333*simplex3d(4.0*m*rot3)
			+0.0666667*simplex3d(8.0*m);
}

void mainImage_simplex3d( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 p = fragCoord.xy/iResolution.x;
	vec3 p3 = vec3(p, iTime*0.025);
	
	float value;
	
	if (p.x <= 0.6) {
		value = simplex3d(p3*32.0);
	} else {
		value = simplex3d_fractal(p3*8.0+8.0);
	}
	
	value = 0.5 + 0.5*value;
	value *= smoothstep(0.0, 0.005, abs(0.6-p.x)); // hello, iq :)
	
	fragColor = vec4(
			vec3(value),
			1.0);
	return;
}
float hash2(vec3 p)  // replace this by something better
{
    p  = fract( p*0.3183099+.1 );
	p *= 17.0;
    return fract( p.x*p.y*p.z*(p.x+p.y+p.z) );
}

float noisefast2( in vec3 x )
{
    vec3 i = floor(x);
    vec3 f = fract(x);
    f = f*f*(3.0-2.0*f);
	
    return mix(mix(mix( hash2(i+vec3(0,0,0)), 
                        hash2(i+vec3(1,0,0)),f.x),
                   mix( hash2(i+vec3(0,1,0)), 
                        hash2(i+vec3(1,1,0)),f.x),f.y),
               mix(mix( hash2(i+vec3(0,0,1)), 
                        hash2(i+vec3(1,0,1)),f.x),
                   mix( hash2(i+vec3(0,1,1)), 
                        hash2(i+vec3(1,1,1)),f.x),f.y),f.z);
}

float fbm(vec3 x){
    //float res= 0.5+0.5*simplex3d(x/16.0*8.0+8.0);
    float res=noisefast2(x/5.0);
    return res;
}
float fbm2(vec3 x){
    return noisefast2(x/5.0);
}

float worley3d(vec3 n,float s) 
{
    return simplex3d(n);
}

vec3 v3(float x){return vec3(x,x,0);}

float noisefast( in vec3 x )
{
    ivec3 i = ivec3(floor(x));
    vec3 f = fract(x);
	f = f*f*(3.0-2.0*f);
	ivec2 uv = i.xy + ivec2(37,17)*i.z;
	vec2 rgA = texelFetch( iChannel1, (uv+ivec2(0,0))&255, 0 ).yx;
    vec2 rgB = texelFetch( iChannel1, (uv+ivec2(1,0))&255, 0 ).yx;
    vec2 rgC = texelFetch( iChannel1, (uv+ivec2(0,1))&255, 0 ).yx;
    vec2 rgD = texelFetch( iChannel1, (uv+ivec2(1,1))&255, 0 ).yx;
    vec2 rg = mix( mix( rgA, rgB, f.x ),
                   mix( rgC, rgD, f.x ), f.y );
    return mix( rg.x, rg.y, f.z );
}

float fbmold(vec3 x){
    float res=noisefast(x/4.0);
    return res;
}

vec4 map_cloud2(vec3 pos){
    const float slowdown=0.5;
    float time=2.0*iTime*2.5*slowdown*1.5;//+5.0*1000.0;
    float time2=0.0;//-iTime*10.0;
    //time=mod(time,100.0);
    //time/=200.0;
    //time=0.0;
    //clouduv=vec2(0.0);

    
    const float scale=0.025/2.0;
    const float ylimit=5.7*scale;
    const float ylimit2=-7.3*scale;
    const float border=4.7*scale*2.0*3.5; ///0.7
    /*
    float scale=0.025/testvalue;
    float ylimit=5.7*scale;
    float ylimit2=-7.3*scale;
    float border=4.7*scale; ///0.7
    */
    if (pos.y>ylimit+border) return vec4(0.0);
    if (pos.y<ylimit2-border) return vec4(0.0);

    vec3 uv;
    if (animate==0.0)
        uv=pos.xyz*40.0/2.5+vec3(0,0,time);
    else
        uv=pos.xyz*40.0/2.5+vec3(0,0,time/3.0);
    //uv.y*=4.2;
    //clouduv=uv.xz*testvalue;
    //clouduv=uv.xz/2000.0/10.0;
    //clouduv.x=-clouduv.x;
    //clouduv.xy*=34.0;
    //clouduv.x-=0.35;

    if (pos.y>ylimit+border) return vec4(0.0);
    if (pos.y<ylimit2-border) return vec4(0.0);

		float f,a;
        //mat2 m = mat2( 1.6,  1.2, -1.2,  1.6 );
        float m=2.5*1.4;
		float fbig = fbmold( uv/200.0*3.5*3.5*3.5*0.25);
        if (fbig<0.25) return vec4(0.0);

        //vec3 anim;
        //if (animate==0.0) anim=vec3(0.0); else 
        vec3 anim=vec3(0.0,0.0,time*2.2*slowdown/2.0); 
        uv/=2.0;
        float anim1=1.0+0.01*0.09;//testvalue;
		f  = 0.5000*fbm( uv +anim); uv = m*uv; anim*=anim1;
		f *= 0.4+fbm( uv +anim); uv = m*uv; anim*=anim1;
		f -= 0.4*-0.75*fbm( uv*3.5*0.05+anim); anim*=anim1;
		f += 0.1250*fbm( uv+anim); uv = m*uv; anim*=anim1;
#define octaves
#ifdef octaves
        //if (animate==0.0){
		    f += 0.0625*fbm( uv+anim ); uv = m*uv; anim*=anim1;//anim*=1.01;
		    f -= 0.0625*fbm( uv+anim ); uv = m*uv; anim*=anim1;//anim*=1.01;
		    //f += 0.0112*fbm( uv );
        //} else {
		    //f += 0.0625*fbm( uv +anim);
        //}
#else
		f += 0.0625*fbm( uv );
#endif        
        a=f*fbig;
    
    /*
    float w1 = fbm(uv+vec3(0,time2,time));
    float w2 = fbm(uv*2.0+vec3(0,time2,time)*2.0);
    float w3 = fbm(uv*4.0+vec3(0,time2,time)*4.0)/2.0;
    a=(w1+w2+w3)/2.0/1.2;
    */
    if (pos.y>ylimit) a*=1.0-smoothstep(ylimit,ylimit+border,pos.y);//((pos.y/ylimit))/0.7;
    if (pos.y<ylimit2) a*=1.0-smoothstep(ylimit2,ylimit2-border,pos.y);//(1.0-(pos.y/ylimit2))/0.7;
    a=flevelRange(a,0.25,0.7);

    return vec4(a);
    return vec4(1.0,1.0,1.0,a);
}

vec4 map_cloud2_(vec3 pos){
    const float slowdown=0.5;
    float time=iTime*2.5*slowdown;
    float time2=0.0;//-iTime*10.0;
    //time=mod(time,100.0);
    //time/=200.0;
    //time=0.0;
    const float scale=0.025;
    const float ylimit=5.7*scale;
    const float ylimit2=-7.3*scale;
    const float border=4.7*scale; ///0.7
    if (pos.y>ylimit+border) return vec4(0.0);
    if (pos.y<ylimit2-border) return vec4(0.0);
    
    vec3 uv;
    if (animate==0)
        uv=pos.xyz*40.0/2.5+vec3(0,0,time);
    else
        uv=pos.xyz*40.0/2.5+vec3(0,0,time/5.0);
    //uv.y*=4.2;
    
    
		float f,a;
        //mat2 m = mat2( 1.6,  1.2, -1.2,  1.6 );
        float m=2.5;
		float fbig = fbm( uv/200.0*3.5*3.5*3.5);
        if (fbig<0.45) return vec4(0.0);

        vec3 anim;
        if (animate==0) anim=vec3(0.0); else anim=vec3(0.0,0.0,time*2.2*slowdown/3.0); 
        uv/=2.0;
		f  = 0.5000*fbm( uv +anim); uv = m*uv; anim*=1.01;

		f *= 0.4*2.3*0.7+fbm2( uv +anim); uv = m*uv; anim*=1.01;
		///f += 0.2500*fbm( uv +anim); uv = m*uv; anim*=1.01;

		f += 0.1250*fbm( uv +anim); uv = m*uv; anim*=1.01;
		f += 0.1550*fbm2( uv +anim); //0.0625
        a=f*fbig;
    
    /*
    float w1 = fbm(uv+vec3(0,time2,time));
    float w2 = fbm(uv*2.0+vec3(0,time2,time)*2.0);
    float w3 = fbm(uv*4.0+vec3(0,time2,time)*4.0)/2.0;
    a=(w1+w2+w3)/2.0/1.2;
    */
    
    if (pos.y>ylimit) a*=1.0-smoothstep(ylimit,ylimit+border,pos.y);//((pos.y/ylimit))/0.7;
    if (pos.y<ylimit2) a*=1.0-smoothstep(ylimit2,ylimit2-border,pos.y);//(1.0-(pos.y/ylimit2))/0.7;
    //a=smoothstep(0.4,0.6,a);
    //a=finalLevels(vec3(a),130.0/255.0,1.5,190.0/255.0).x;
    a=flevelRange(a,0.25,0.7);
    return vec4(a);
    return vec4(1.0,1.0,1.0,a);
}


vec4 map_cloud(vec3 pos){
    float time=iTime*2.3;
    float time2=iTime*2.1;
    time=mod(time,100.0);
    time2=mod(time,100.0);
    time/=200.0;
    time2/=200.0;
    //time=0.0; time2=100.0;
    
    vec3 uv=pos*48.0;//32.0
    
    vec3 uv2=uv*2.25;
    vec3 uv3=uv*10.0;
    //float dis = worley(uv+iTime*32.0,32.0);
    //float dis = (worley(uv+iTime*32.0,332.0));
    float w1 = (worley3d(uv+time*v3(102.0),332.0));
    vec3 w1_=finalLevels(vec3(w1),32.0/255.0,1.5,240.0/255.0);
    //vec3 dis3=vec3(dis);
    float w2 = (worley3d(uv+time*v3(112.0),232.0));
    vec3 w2_=finalLevels(vec3(w2),32.0/255.0,1.5,240.0/255.0);
    
    ///float p1 = noise_(vec2(uv*2.0+iTime*3.0)).x;
    ///float p1 = noiseValue(vec3(uv/6.0+iTime*3.0,iTime));
    float p1 = fbm(vec3(time2/2.0,uv3/600.0+time*v3(1.0/1.5)));
    vec3 p1_=vec3(p1);
    p1_=finalLevels(p1_,64.0/255.0,1.5,190.0/255.0);
    float p2 = fbm(vec3(time2/2.0,uv3/2000.0+time*v3(1.0/1.5)));
    vec3 p2_=vec3(p2);

    //vec3 result=p2_;
    
    //tiniest detail:
    
    float p3 = fbm(vec3(time2/2.0,uv3/200.0+time*v3(1.0/1.5)));
    vec3 p3_=vec3(p3);
    float w3 = (1.0-(worley3d(uv+time*v3(32.0),134.0)))/1.2;
    vec3 w3_=finalLevels(vec3(w3),62.0/255.0,0.5,230.0/255.0);
    
    float m = 1.0-fbm(vec3(time2/5.5,uv2/300.0+time/10.0));
    vec3 m_=finalLevels(vec3(m),130.0/255.0,1.5,190.0/255.0);

    vec3 fin=w1_*w2_/2.0;
	vec3 result = (((vec3(1.0)-fin)*p1_+p2_/2.0+w3_)*p3_*m_+(1.0-w1_)/16.0);
    result=finalLevels(result,40.0/255.0,1.5,255.0/255.0);
    
	///fragColor = vec4(m_,1.0);

    //vec4 col_res = vec4(vec3(1.0),result.x);
    vec4 col_res = vec4(result.xyz,result.x);
    
    return col_res;
}

const float normaleps=0.005;
vec3 calcNormal( in vec3 pos )
{
    vec3 eps = vec3( normaleps, 0.0, 0.0 );

    vec3 nor = vec3(
        fbm(pos+eps.xyy) - fbm(pos-eps.xyy),
        fbm(pos+eps.yxy) - fbm(pos-eps.yxy),
        fbm(pos+eps.yyx) - fbm(pos-eps.yyx) );
    return normalize(nor);

}

vec4 render( in vec3 ro, in vec3 rd, in vec2 fragCoord){
vec4 col=vec4(0.0);
    //--------------------------------------
    // raymarch
    //--------------------------------------
    vec4 sum = vec4( 0.0 );
    // dithering
    //float t = 0.1*(texture(iChannel0, fragCoord.xy/iChannelResolution[0].x).r);
    float t = 0.1*(texture2D(noisetexture2, fragCoord.xy/1024.0).r)/4.0;
    //float t=0.01;
    
    vec3 pos;
    float lighting;
    for( int i=0; i<1000; i++ )
    {
        if( sum.a > 0.95 ) break;
        pos = ro + t*rd;
        col = map_cloud2( pos.xyz )/1.2;

        // lighting:
        //const vec3 sundir=normalize(vec3(-0.5,-0.5,0.0));
        //const vec3 sundir = normalize( vec3(-1.0,0.0,-1.0) );
        const vec3 sundir = normalize( vec3(-1.5,2.0,-1.0) );
        //const float ldist=0.0075;
        const float dim=1.85;

        if (col.a<0.15) lighting=0.0; else
        lighting = clamp((col.a - map_cloud2(pos+0.25*sundir).a)/0.3, -0.2, 1.0 )/30.0/dim;
        //lighting = clamp(0.01, -0.2, 1.0 )/30.0/dim;
        col.a*=0.05;
        
        //col.a *= 0.5;
        //col.rgb = mix( vec3(0.0), col.rgb, exp(-0.002*t*t*t) )/40.0/dim;
        col.rgb = col.rgb/40.0/dim;
        col.rgb+=vec3(0.1,0.1,0.1)*(lighting)*12.0;
        //col.rgb+=vec3(1.0,1.0,1.0)*(lighting);
        //col.rgb+=vec3(0.0,0.0,1.0)*(lighting);
        sum = sum + col*(1.0 - sum.a);
        t += 0.002;
    }
    /*
    vec3 bg = mix(vec3(90.0/255.0,120.0/255.0,191.0/255.0),
    vec3(110.0/255.0,150.0/255.0,220.0/255.0)*1.6/1.4*1.1,clamp(-pos.y,0.0,1.0));
    */
    ///vec3 bg=textureCube(envMap,vec3(rd.x,-rd.y,rd.z)).xyz; ///background

    vec3 cloudcol = mix(vec3(80.0/255.0,105.0/255.0,209.0/255.0)/0.85,
    vec3(100.0/255.0,105.0/255.0,200.0/255.0)*2.4,(sum.r-0.2)/1.75);
    
    ///col=vec4(cloudcol,1.0)*sum.a+vec4(bg,1.0)*(1.0-sum.a);
    col=vec4(cloudcol,sum.a);

    //col=sum+vec4(1.2,0.9,0.3,1.0)*lsum*sum.a;
    //vec3 col = clamp( mix( bg, sum.xyz/(0.001+sum.w), sum.w ), 0.0, 1.0 );
    //col=col*vec4(smoothstep(0.1,0.7,sum.x));
    return col.rgba;
}

mat3 setCamera( in vec3 ro, in vec3 ta, float cr )
{
	vec3 cw = normalize(ta-ro);
	vec3 cp = vec3(sin(cr), cos(cr),0.0);
	vec3 cu = normalize( cross(cw,cp) );
	vec3 cv =          ( cross(cu,cw) );
    return mat3( cu, cv, cw );
}

void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec3 pos;

    vec2 uv = fragCoord.xy/iResolution.xy;
	vec2 p = uv*2.0-1.0;
	p.x*=(iResolution.x/iResolution.y);
	vec3 col = vec3(0.05);
    vec3 ro = vec3(0.0,0.0,-2.0);
    vec3 rd = normalize(vec3(p,0.0)-ro);

float fov=1.2;

            //ro=rayorigin;// /vec3(20.0);
            vec3 ta=vec3(0.0,0.0,1.0);//raydirection;// /vec3(20.0);
            mat3 ca = setCamera( ro, ta, 0.0 );
            rd = ca * normalize( vec3(p.x,p.y,fov ) );

     col = render( ro, rd, fragCoord).rgb;

    fragColor = vec4( col, 1.0 );
            
}

void mainImage_c21( out vec4 fragColor, in vec2 fragCoord )
{
    vec3 pos;

    vec2 uv = fragCoord.xy/iResolution.xy;
	vec2 p = uv*4.0-1.0;
	p.x*=(iResolution.x/iResolution.y);
	vec3 col = vec3(0.05);
    vec3 ro = vec3(0.0,0.0,-2.0);
    vec3 rd = normalize(vec3(p,0.0)-ro);

            ro=rayorigin;// /vec3(20.0);
            vec3 ta=raydirection;// /vec3(20.0);
            mat3 ca = setCamera( ro, ta, 0.0 );
            rd = ca * normalize( vec3(p.x,p.y,fov ) );

//float fov=1.2;

            //ro=rayorigin;// /vec3(20.0);
  //          vec3 ta=vec3(0.0,0.0,1.0);//raydirection;// /vec3(20.0);
//            mat3 ca = setCamera( ro, ta, 0.0 );
            rd = ca * normalize( vec3(p.x,p.y,fov ) );

     vec4 col2 = render( ro, rd, fragCoord);

    fragColor = vec4( col2 );
}

void main()
{
    skrul=vec2(0,-scrollTime/1.05)*speed;// *testvalue;

    //stime=skrul.y/3.0;
    ///totalcolor=vec3(0,0,0);
    ///totalindex=0.0;

    ///if (rendertoshadowmap==1) iResolution=vec3(1024,1024,0);

    vec4 color=vec4(0.0, 0.0, 0.0, 1.0);
    vec2 coos=gl_FragCoord.xy*2.0;
    //coos.x=(coos.x-400*(sin(coos.x/iResolution.x*PI+PI/2.0)+1.0));
    //coos.y=(coos.y-200*(sin(coos.y/iResolution.x*PI+PI/2.0)+1.0));
    //coos.x/=iResolution.x;
    float xc=coos.x/iResolution.x;
    //coos.x+=sin(((coos.x-0.5)*2.0)*PI/2)*0.26;
    //fishdx=sin(((coos.x-0.5)*2.0)*PI/2)*0.5;
    //fishdx=(1.0-pow((xc-0.5+pioffset),2.0))*10.0;
    float dim=0.9;
    //dim=testvalue;
    if (xc<0.40) { //0,0.5
        fishdx=sin(xc*PI*pioffset+PI/2.0); //1,0
        fishdx=mix(fishdx/dim,0.0,xc*(1.0/0.40));
        leftside=true;
    } else if (xc>0.60){
        xc-=0.5;
        xc=0.5-xc; //0.5,0
        //fishdx=sin(xc*PI+PI/2+pioffset); //0,1
        fishdx=sin(xc*PI*pioffset+PI/2.0); //1,0
        fishdx=mix(fishdx/dim,0.0,xc*(1.0/0.40));
        leftside=false;
    } else { 
        fishdx=0.0;
    }
    float yc=coos.y/iResolution.y;
    if (yc>0.5) {
        yc=1.0-yc;
        yc=0.5-yc; 
        yc=yc*2.0; yc*=-1;
    } else {
        yc=0.5-yc; 
        yc=yc*2.0;
    }
    // 0 -- 0.5 -- 0
    // 1 -- 0 -- -1
    fishdx*=yc;

    //mainImage2(color,coos);
    //mainImage_c(color,coos);
    mainImage_c21(color,coos);

    gl_FragColor = color;
}
