#version 120
// It was expressed that some drivers required this next line to function properly
precision highp float;
#define MAX_LIGHTS 8
in vec3 alightVec[MAX_LIGHTS];
in vec3 aeyeVec[MAX_LIGHTS];
in vec2 texCoord;

//in vec3 vNormal;

uniform float lightsEnabled[MAX_LIGHTS];
uniform float lightsinvRadius[MAX_LIGHTS];
uniform float lightMapSelect[MAX_LIGHTS];
uniform sampler2D colorMap;
uniform sampler2D normalMap;
uniform sampler2D lightMap;
uniform sampler2D specularMap;
//uniform float invRadius;
//out vec4 gl_FragColor;

void main (void)
{

vec3 lightVec;
vec3 eyeVec;
vec4 accvDiffuse = vec4(0.0);
vec4 accvSpecular = vec4(0.0);
float distSqr;
vec3 lVec;
vec3 vVec;
float att;
vec4 base;
vec4 vAmbient;
vec3 bump;
float diffuse;
vec4 vDiffuse;
vec4 vSpecular;
float specular;
vec3 nrmltexture;

	base = texture2D(colorMap, texCoord);
	vAmbient = gl_LightSource[0].ambient * gl_FrontMaterial.ambient;
for (int i=0; i<MAX_LIGHTS; i++)
   {
	if (lightsEnabled[i]>0.0)
	{
        lightVec=alightVec[i];
        eyeVec=aeyeVec[i];
	distSqr = dot(lightVec, lightVec);
	att = clamp(1.0 - lightsinvRadius[i] * sqrt(distSqr), 0.0, 1.0);
	lVec = lightVec * inversesqrt(distSqr);
	vVec = normalize(eyeVec);

    //nrmltexture= texture2D(normalMap, texCoord).xyz;
    //nrmltexture.z=nrmltexture.z*-1.0f;
	//bump = normalize(nrmltexture * 2.0f - 1.0);
	bump = normalize( texture2D(normalMap, texCoord).xyz * 2.0f - 1.0);
	//bump = vec3(0.0,0.0,1.0);

	//diffuse = max( dot(lVec, bump), 0.0 );
	diffuse = clamp( dot(lVec, bump), 0.0, 1.0 );
//	vDiffuse = gl_LightSource[i].diffuse * gl_FrontMaterial.diffuse * diffuse *
	vDiffuse = gl_LightSource[i].diffuse * diffuse *
		texture2D(lightMap, vec2(diffuse-0.01,lightMapSelect[i]));
	accvDiffuse = accvDiffuse + vDiffuse;

	//specular = pow(clamp(dot(reflect(-lVec, bump), vVec), 0.0, 1.0),
	           //gl_FrontMaterial.shininess );

	//specular = pow(clamp(dot(reflect(-lVec, bump), vVec), 0.0, 1.0), gl_FrontMaterial.shininess ) * texture2D(specularMap, texCoord).r;
	specular = pow(clamp(dot(reflect(-lVec, bump), vVec), 0.0, 1.0), 32.0 ) * texture2D(specularMap, texCoord).r; //here shiness is replaced with 1.0, should introduce material functionality in obj loader //16.0

	//vec4 vSpecular = gl_LightSource[0].specular * gl_FrontMaterial.specular * specular;
//	vSpecular = gl_LightSource[i].specular * gl_FrontMaterial.specular * specular *
	vSpecular = gl_LightSource[i].specular * specular * texture2D(lightMap, vec2(specular-0.01,lightMapSelect[i]));
	accvSpecular = accvSpecular + vSpecular;
	}
   }
	//gl_FragColor = ( vAmbient*base + accvDiffuse*base + accvSpecular) * att;

	gl_FragColor = ( vAmbient*base + accvDiffuse*base + accvSpecular);
	//gl_FragColor = vec4(( vAmbient*base + accvDiffuse*base + accvSpecular).rgba);
	gl_FragColor = vec4(( vAmbient*base + accvDiffuse*base + accvSpecular).rgb,base.a);

	//gl_FragColor = vec4(vNormal.x,vNormal.y,vNormal.z,1.0);
	//gl_FragColor = ( vAmbient*base + vDiffuse*base + vSpecular) * att;
	//gl_FragColor = ( vAmbient*base + vDiffuse*base + texture2D(lightMap, vec2(1.0-specular,0))) * att;
}


/*
uniform sampler2D color_texture;
uniform sampler2D normal_texture;

void main() {

// Extract the normal from the normal map
vec3 normal = normalize(texture2D(normal_texture, gl_TexCoord[0].st).rgb * 2.0 - 1.0);

// Determine where the light is positioned (this can be set however you like)
vec3 light_pos = normalize(vec3(1.0, 1.0, 1.5));

// Calculate the lighting diffuse value
float diffuse = max(dot(normal, light_pos), 0.0);

vec3 color = diffuse * texture2D(color_texture, gl_TexCoord[0].st).rgb;

// Set the output color of our current pixel
gl_FragColor = vec4(color, 1.0);
}
*/

/*
in  vec3 ex_Color;
out vec4 gl_FragColor;

uniform sampler2D colorMap;
in vec2 fragtextureCoord;

void main(void) {
vec4 base;

    // Pass through our original color with full opacity.
    //gl_FragColor = vec4(ex_Color,1.0);

	base = texture2D(colorMap, fragtextureCoord);
	gl_FragColor = base;
}
*/
