
#define MAX_LIGHTS 8
varying vec3 alightVec[MAX_LIGHTS];
varying vec3 aeyeVec[MAX_LIGHTS];
varying vec2 texCoord;
uniform float lightsEnabled[MAX_LIGHTS];
//uniform float lightsinvRadius[MAX_LIGHTS];
//uniform float lightMapSelect[MAX_LIGHTS];
attribute vec3 vTangent;
vec3 tmpVec;

//in mat4 MVP;
varying mat4 DepthBiasMVP;
varying vec4 ShadowCoord;

void main(){

	gl_Position = ftransform();
	gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;
	texCoord = gl_MultiTexCoord0.xy;

	vec3 n = normalize(gl_NormalMatrix * gl_Normal);
	vec3 t = normalize(gl_NormalMatrix * vTangent);
	vec3 b = cross(t, n);

	vec3 vVertex = vec3(gl_ModelViewMatrix * gl_Vertex);

for (int i=0; i<MAX_LIGHTS; i++)
   {
	if (lightsEnabled[i]>0.0)
	{
	tmpVec = gl_LightSource[i].position.xyz - vVertex;

	alightVec[i].x = dot(tmpVec, t);
	alightVec[i].y = dot(tmpVec, b);
	alightVec[i].z = dot(tmpVec, n);

	tmpVec = -vVertex;
	aeyeVec[i].x = dot(tmpVec, t);
	aeyeVec[i].y = dot(tmpVec, b);
	aeyeVec[i].z = dot(tmpVec, n);
	}
   }

// Output position of the vertex, in clip space : MVP * position
//gl_Position =  MVP * vec4(gl_Vertex);

// Same, but with the light's view matrix
ShadowCoord = DepthBiasMVP * vec4(gl_Vertex);
}

