#version 150
#define MAX_LIGHTS 8
varying vec3 alightVec[MAX_LIGHTS]; 
varying vec3 aeyeVec[MAX_LIGHTS];
uniform float lightsEnabled[MAX_LIGHTS];
//uniform float lightsinvRadius[MAX_LIGHTS];
//uniform float lightMapSelect[MAX_LIGHTS];
//varying vec3 vertexPos;
//varying vec3 vertexNormal;
//varying vec2 texCoord;
in vec3 vertexPos;
in vec3 vertexNormal;
in vec2 texCoord;
attribute vec3 vTangent; 
vec3 tmpVec;

void main(void)
{
	gl_Position = ftransform();
	//gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;
	//gl_Position = gl_ModelViewProjectionMatrix * vertexPos;
	gl_Position = vec4(vertexPos.x, vertexPos.y, vertexPos.z, 1.0);
	//texCoord = gl_MultiTexCoord0.xy;
	
	vec3 n = normalize(gl_NormalMatrix * vertexNormal);
	vec3 t = normalize(gl_NormalMatrix * vTangent);
	vec3 b = cross(t, n);
	
	vec3 vVertex = vec3(gl_ModelViewMatrix * gl_Vertex);

for (int i=0; i<MAX_LIGHTS; i++)
   {
	if (lightsEnabled[i]>0.0)
	{
	tmpVec = gl_LightSource[i].position.xyz - vVertex;

	alightVec[i].x = dot(tmpVec, t);
	alightVec[i].y = dot(tmpVec, b);
	alightVec[i].z = dot(tmpVec, n);

	tmpVec = -vVertex;
	aeyeVec[i].x = dot(tmpVec, t);
	aeyeVec[i].y = dot(tmpVec, b);
	aeyeVec[i].z = dot(tmpVec, n);
	}
   }
}

/*
void main() {
gl_TexCoord[0] = gl_MultiTexCoord0;

// Set the position of the current vertex
gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;
}
*/